<div x-data="{
    show: true,
    currentStep: @entangle('currentStep'),
    projectCode: @entangle('new.project_code'),
    newName: '',
    names: @entangle('newNames'),
    pairs: @entangle('newPairs'),
    async addName() {
        const n = this.newName.trim();
        if (!n) return;
        if (this.names.includes(n)) {
            this.dispatch('notify', { type: 'error', message: __('backend.duplicate_name') });
            return;
        }
        const exists = await this.$wire.checkNameExists(n);
        if (exists) {
            return;
        }
        this.names.push(n);
        this.newName = '';
    },
    removeName(i) {
        this.names.splice(i, 1);
    }
}" x-cloak x-show="show" x-transition:enter="transition ease-out duration-300"
    x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100"
    x-transition:leave="transition ease-in duration-200" x-transition:leave-start="opacity-100 scale-100"
    x-transition:leave-end="opacity-0 scale-90" @keydown.escape.window="show = false; $wire.closeModal()"
    @click.away="show = false; $wire.closeModal()"
    class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 px-4 sm:px-6 lg:px-8">
    <div
        class="bg-white dark:bg-zinc-900 rounded-xl shadow-2xl border border-zinc-200 dark:border-zinc-700
           w-full max-w-2xl p-6 space-y-6 transition-all duration-300 overflow-y-auto max-h-[90vh]">

        <!-- Header with Stepper -->
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-2xl font-bold text-zinc-800 dark:text-white">
                {{ __('backend.generate_cv_codes') }}
            </h3>
            <button @click="show = false; $wire.closeModal()"
                class="text-zinc-500 hover:text-zinc-800 dark:hover:text-white text-2xl leading-none">&times;</button>
        </div>
        <div class="flex items-center mb-4 space-x-2 rtl:space-x-reverse">
            <div :class="{ 'bg-green-600 text-white': currentStep === 1, 'bg-gray-300 text-gray-600': currentStep !== 1 }"
                class="w-6 h-6 rounded-full flex items-center justify-center">1</div>
            <div class="flex-1 border-t"
                :class="{ 'border-green-600': currentStep > 1, 'border-gray-300': currentStep <= 1 }"></div>
            <div :class="{ 'bg-green-600 text-white': currentStep === 2, 'bg-gray-300 text-gray-600': currentStep !== 2 }"
                class="w-6 h-6 rounded-full flex items-center justify-center">2</div>
        </div>

        <!-- Body -->
        <div class="space-y-6">
            <!-- Step 1: إدخال الأسماء -->
            <div x-show="currentStep === 1" x-cloak>


                <!-- اختيار المشروع -->
                <div class="mb-4">
                    <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        {{ __('backend.project_name') }}
                    </label>

                    @if ($canViewAll)
                        <select x-model="projectCode" wire:model.defer="new.project_code"
                            class="w-full rounded-lg bg-white dark:bg-zinc-800 border
                             border-zinc-300 dark:border-zinc-700 px-3 py-2 text-sm">
                            <option value="">{{ __('backend.select_project') }}</option>
                            @foreach ($projects as $p)
                                <option value="{{ $p['code'] }}">{{ $p['name'] }}</option>
                            @endforeach
                        </select>
                    @else
                        <!-- مخفى للمستخدم الذى لا يملك صلاحية -->
                        <input type="hidden" x-model="projectCode" wire:model="new.project_code">
                        <span class="text-sm text-zinc-600 dark:text-zinc-400">
                            {{ optional(\App\Models\User\UserProject::where('code', $new['project_code'])->first())->name }}
                        </span>
                    @endif

                    @error('new.project_code')
                        <span class="text-red-600 text-xs">{{ $message }}</span>
                    @enderror
                </div>
                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                    {{ __('backend.enter_employee_names') }}
                </label>
                <div class="flex gap-2">
                    <input type="text" x-model="newName"
                        class="flex-1 px-3 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500"
                        :class="{ 'border-red-500': newName && names.includes(newName.trim()) }"
                        placeholder="{{ __('backend.name_placeholder') }}" @keydown.enter.prevent="addName" />
                    <button @click="addName" :disabled="!newName.trim()"
                        class="px-4 py-2 bg-indigo-600 text-white rounded-lg disabled:opacity-50">
                        + {{ __('backend.add') }}
                    </button>
                </div>
                <div class="flex flex-wrap gap-2 mt-2">
                    <template x-for="(n,i) in names" :key="i">
                        <span
                            class="inline-flex items-center bg-indigo-100 text-indigo-800 px-3 py-1 rounded-full text-sm">
                            <span x-text="n"></span>
                            <button @click="removeName(i)" class="ml-1 text-red-600"
                                aria-label="Remove">&times;</button>
                        </span>
                    </template>
                </div>
                <div class="flex justify-end mt-4">
                    <button wire:click="nextStep"
                        class="px-5 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700">
                        {{ __('backend.next') }} →
                    </button>
                </div>
            </div>

            <!-- Step 2: عرض الأكواد -->
            <div x-show="currentStep === 2" x-cloak>
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 mt-4">
                    <template x-for="(p,i) in pairs" :key="i">
                        <div
                            class="p-6 bg-white dark:bg-zinc-800 rounded-2xl shadow-lg flex flex-col items-center text-center space-y-4">
                            <img src="{{ asset('assets/img/logo.png') }}"
                                class="w-32 h-12 border-4 border-indigo-500 bg-white p-1 rounded-full" alt="Logo" />
                            @php
                                $cvUrl = rtrim(env('APP_URL', url('/')), '/') . '/cv';
                            @endphp
                            <a href="{{ $cvUrl }}" target="_blank"
                                class="text-blue-600 underline text-xs">{{ $cvUrl }}</a>
                            <div class="text-lg font-semibold text-zinc-800 dark:text-zinc-100">
                                {{ __('backend.name') }}: <span x-text="p.name"></span>
                            </div>
                            <div class="text-sm text-zinc-600 dark:text-zinc-400">
                                {{ __('backend.cv_code_code') }}: <span x-text="p.code" class="font-mono"></span>
                            </div>
                        </div>
                    </template>
                </div>
                <div class="flex justify-end space-x-2 rtl:space-x-reverse mt-6">
                    <button @click="show = false; $wire.closeModal()"
                        class="px-4 py-2 rounded-lg text-sm bg-zinc-200 dark:bg-zinc-700 hover:bg-zinc-300 dark:hover:bg-zinc-600 text-zinc-800 dark:text-white">
                        {{ __('backend.close') }}
                    </button>
                    <button wire:click="downloadCvCodes"
                        class="px-4 py-2 rounded-lg text-sm bg-blue-600 text-white hover:bg-blue-700">
                        {{ __('backend.download_word') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
