<?php

use App\Models\System\SystemParent;
use App\Models\System\SystemRoute;
use App\Helpers\AppSettings;
use Illuminate\Support\Facades\Auth;
use Livewire\Volt\Component;
use Livewire\Attributes\On;

new class extends Component {
    // public $menu = [];
    public array $menu = [];
    public string $sidebarFullText = '';
    public string $lang;
    public string $selectedChild = '';

    public function mount()
    {
        $lang = AppSettings::language();
        $user = Auth::user();
        $userPagesRaw = $user->pages['page'] ?? [];
        $userPages = is_array($userPagesRaw) ? $userPagesRaw : [$userPagesRaw];
        $job = $lang === 'ar' ? Auth::user()->settings['job_title_ar'] ?? 'employee' : Auth::user()->settings['job_title_en'] ?? 'employee';
        $currentRouteName = request()->route()->getName();
        $selectedChildRoute = '';
        $this->sidebarFullText = '🌊 ' . $job;
        // 🧩 1. جلب الـ Routes الفعالة + اللي فيها parent_id
        // 🧩 1. جلب الـ Routes الفعالة + اللي فيها parent_id
        $routes = SystemRoute::where('is_active', true)
            ->get()
            ->filter(function ($route) use ($userPages) {

                if (!isset($route->parent_id)) {
                    return false;
                }
                if ($route->name === 'dashboard') {
                    return true;
                }
                if (in_array('[all]', $userPages)) {
                    return true;
                }

                return in_array($route->name, $userPages);
            });

        // 🧩 2. Group Routes: parent_id = 0
        $groupRoutes = $routes
            ->filter(function ($route) {
                return (int)$route->parent_id === 0;
            })
            ->map(function ($route) use ($lang, $routes, $currentRouteName, &$selectedChildRoute) {
                $props = is_array($route->route_properties) ? $route->route_properties : json_decode($route->route_properties, true);

                $groupIconName = $props['display_icon'] ?? 'folder';
                $groupIconSvg = file_exists(resource_path("icons/{$groupIconName}.svg")) ? file_get_contents(resource_path("icons/{$groupIconName}.svg")) : '<svg class="w-5 h-5 text-gray-400" fill="none"><circle cx="12" cy="12" r="10" stroke="currentColor"/></svg>';

                $children = $routes
                    ->filter(function ($child) use ($route) {
                        return (int)$route->parent_id === (int)$route->id;
                    })
                    ->sortBy(function ($c) {
                        return $route->order ?? PHP_INT_MAX;
                    })
                    ->map(function ($route) use ($lang, $currentRouteName, &$selectedChildRoute) {
                        $props = is_array($route->route_properties) ? $route->route_properties : json_decode($route->route_properties, true);
                        $iconName = $props['display_icon'] ?? 'circle';
                        $iconSvg = file_exists(resource_path("icons/{$iconName}.svg")) ? file_get_contents(resource_path("icons/{$iconName}.svg")) : '<svg class="w-5 h-5 text-gray-400" fill="none"><circle cx="12" cy="12" r="10" stroke="currentColor"/></svg>';
                        if ($route->name === $currentRouteName) {
                        $selectedChildRoute = route($route->name);
}
                        return [
                            'key' => 'r-' . $route->name,
                            'title' => $props['display_name'][$lang] ?? $route->name,
                            'route' => route($route->name),
                            'icon' => $iconSvg,
                        ];
                    })
                    ->values()
                    ->toArray();

                return [
                    'key' => 'r-' . $route->name,
                    'title' => $props['display_name'][$lang] ?? $route->name,
                    'icon' => $groupIconSvg,
                    'route' => route($route->name),
                    'children' => $children,
                    'source' => 'route',
                    'order' => $route->order ?? PHP_INT_MAX,
                    '_open' => collect($children)->contains(fn($child) => $child['route'] === route($currentRouteName)),
                ];
            });

        // 🧩 3. system_parents
        $systemParents = SystemParent::orderByRaw('ISNULL([order], ?) ASC', 2147483647)->get();

        $parentGroups = $systemParents
        ->map(function ($parent) use ($routes, $lang, $currentRouteName, &$selectedChildRoute) {
                $children = $routes
                    ->filter(function ($route) use ($parent) {
                        return (int)$route->parent_id === (int)$parent->id;
                    })
                    ->sortBy(function ($c) {
                        return $route->order ?? PHP_INT_MAX;
                    })
                    ->map(function ($route) use ($lang, $currentRouteName, &$selectedChildRoute) {
                        $props = is_array($route->route_properties) ? $route->route_properties : json_decode($route->route_properties, true);
                        $iconName = $props['display_icon'] ?? 'circle';
                        $iconSvg = file_exists(resource_path("icons/{$iconName}.svg")) ? file_get_contents(resource_path("icons/{$iconName}.svg")) : '<svg class="w-5 h-5 text-gray-400" fill="none"><circle cx="12" cy="12" r="10" stroke="currentColor"/></svg>';
                        if ($route->name === $currentRouteName) {
    $selectedChildRoute = route($route->name);
}
                        return [
                            'key' => 'r-' . $route->name,
                            'title' => $props['display_name'][$lang] ?? $route->name,
                            'route' => route($route->name),
                            'icon' => $iconSvg,
                        ];
                    })
                    ->values()
                    ->toArray();

                if (count($children) === 0) {
                    return null;
                }

                $groupIconName = $parent->icon ?? 'folder';
                $groupIconSvg = file_exists(resource_path("icons/{$groupIconName}.svg")) ? file_get_contents(resource_path("icons/{$groupIconName}.svg")) : '<svg class="w-5 h-5 text-gray-400" fill="none"><circle cx="12" cy="12" r="10" stroke="currentColor"/></svg>';

                return [
                    'key' => 'p-' . $parent->id,
                    'title' => $lang === 'ar' ? $parent->name_ar : $parent->name_en,
                    'icon' => $groupIconSvg,
                    'route' => '#',
                    'children' => $children,
                    'source' => 'parent',
                    'order' => $parent->order ?? PHP_INT_MAX,
                    '_open' => collect($children)->contains(fn($child) => $child['route'] === route($currentRouteName)),
                ];
            })
            ->filter();

        // 🧩 4. دمج الكل + ترتيب موحد
        $menu = $groupRoutes->concat($parentGroups)->sortBy(fn($item) => $item['order'] ?? PHP_INT_MAX)->values();

        $this->menu = json_decode(json_encode($menu, JSON_UNESCAPED_UNICODE), true);
        $this->selectedChild = $selectedChildRoute;

    }
};
?>



<!-- القائمة الموحدة للموبايل (offcanvas menu) -->
<div x-cloak x-data="{
    locale: '{{ $lang }}',
    selectedChild: @js($selectedChild),
    menu: @js($menu),
    dir: document.dir
}">
    <!-- offcanvas menu للموبايل -->
    <div x-show="submenuMenuOpen" @click.outside="submenuMenuOpen = false"
        class="fixed inset-0 bg-black/40 z-50 flex justify-end md:hidden">
        <div class="relative w-64 bg-white dark:bg-zinc-900 p-4 space-y-4 overflow-y-auto">
            <!-- زر إغلاق offcanvas -->
            <button @click="submenuMenuOpen = false"
                class="absolute top-2 end-2 <!-- بدل right‑2 / left‑2 --> flex items-center justify-center p-2 rounded-full bg-white dark:bg-gray-800 text-gray-700 dark:text-gray-200 border border-gray-300 dark:border-gray-600 hover:bg-gray-100 dark:hover:bg-gray-700 shadow transition">
                <span class="text-xl">&times;</span></button>
            <!-- الشعار -->
            <div class="px-4 pt-4 pb-2">
                <h1 class="font-bold tracking-wide text-2xl" x-text="'{{ $sidebarFullText }}'">></h1>
            </div>
            <div class="mt-6 border-t border-gray-200 dark:border-gray-700 pt-4">
                <div class="grid grid-cols-2 gap-4">
                    <!-- زر الرسائل -->
                    {{-- <div class="flex flex-col items-center">
                        <button @click="submenuMenuOpen = false; openMsgDetail = true"
                            class="relative flex items-center justify-center w-12 h-12 rounded-full bg-indigo-100 dark:bg-indigo-800 hover:bg-indigo-200 dark:hover:bg-indigo-700 shadow transition">
                            <span class="text-2xl">📩</span>
                            <span
                                class="absolute top-0 right-0 inline-flex items-center justify-center px-2 py-1 text-xs font-bold leading-none text-white bg-red-500 rounded-full">3</span>
                        </button>
                        <span class="mt-2 text-sm text-gray-700 dark:text-gray-300">رسائل</span>
                    </div> --}}
                    <!-- زر الإشعارات -->
                    {{-- <div class="flex flex-col items-center">
                        <button @click="submenuMenuOpen = false; openNotiDetail = true"
                            class="relative flex items-center justify-center w-12 h-12 rounded-full bg-green-100 dark:bg-green-800 hover:bg-green-200 dark:hover:bg-green-700 shadow transition">
                            <span class="text-2xl">🔔</span>
                            <span
                                class="absolute top-0 right-0 inline-flex items-center justify-center px-2 py-1 text-xs font-bold leading-none text-white bg-red-500 rounded-full">5</span>
                        </button>
                        <span class="mt-2 text-sm text-gray-700 dark:text-gray-300">إشعارات</span>
                    </div> --}}
                </div>
            </div>
            <hr>
            <!-- قائمة العناصر (نسخة من Sidebar) -->
            <nav class="mt-4 space-y-2 px-2">
                <template x-for="item in menu" :key="item.key">
                    <div class="relative group">
                        <a :href="item.children.length ? '#' : item.route"
                        @click.prevent="item.children.length ? (item._open = !item._open) : window.location.href = item.route"
                        class="flex items-center gap-3 px-4 py-2 rounded-lg transition-all duration-300 justify-between"
                        :class="[
                            item._open ?
                            'bg-indigo-200/70 dark:bg-indigo-700/30 ring-1 ring-indigo-300 dark:ring-indigo-600' :
                            'hover:bg-indigo-100 dark:hover:bg-zinc-800 text-gray-800 dark:text-gray-100',

                        ]"
                        rtl:flex-row-reverse ltr:flex-row>
                        <!-- الآيقون والعنوان -->
                        <div class="flex items-center gap-3 flex-1"
                            :class="{
                                'justify-center': !sidebarOpen
                            }">
                            <span class="text-xl transition-transform duration-300"
                                :class="sidebarOpen ? 'rotate-0 scale-100' : 'rotate-6 scale-90'"
                                x-html="item.icon"></span>
                            <span x-show="sidebarOpen" x-cloak x-text="item.title"
                                class="transition-all duration-300 opacity-100 scale-100"
                                :class="!sidebarOpen ? 'opacity-0 scale-95' : 'opacity-100 scale-100'"></span>
                        </div>

                        <!-- السهم -->
                        <template x-if="item.children.length">
                            <svg class="w-4 h-4 text-gray-400 transition-transform duration-300"
                                :class="{
                                    'rotate-180': item._open
                                }"
                                fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7" />
                            </svg>
                        </template>
                    </a>
                        <div x-show="item.children.length > 0 && item._open" x-transition
                            class="overflow-hidden ps-10 mt-1 space-y-1 text-sm text-gray-600 dark:text-gray-300">
                            <template x-for="child in item.children" :key="child.route">
                                <a :href="child.route" class="block py-1 px-3 rounded transition-all"
                                :class="child.route === selectedChild ?
                                    'bg-indigo-200/60 dark:bg-indigo-700/40 text-indigo-800 dark:text-indigo-100 ring-1 ring-indigo-300 dark:ring-indigo-600' :
                                    'hover:text-indigo-600 hover:ps-3 text-gray-600 dark:text-gray-300'">
                                <span class="inline-flex items-center gap-2">
                                    <span class="text-base" x-html="child.icon"></span>
                                    <span x-text="child.title"></span>
                                </span>
                            </a>
                            </template>
                        </div>
                    </div>
                </template>
            </nav>
            <!-- شبكة الأيقونات الخاصة بالرسائل والإشعارات -->
            <div class="mt-6 border-t border-gray-200 dark:border-gray-700 pt-4">
                <div class="flex justify-around">

                    @php
                        $shouldFetchLang = Auth::check();
                    @endphp

                    <script>
                        function switchLanguage(currentDir, shouldFetch) {
                            const target = currentDir === 'rtl' ? 'en' : 'ar';
                            localStorage.setItem('lang', target);

                            if (shouldFetch === true) {
                                fetch(`/set-language/${target}`);
                            }

                            // إعادة تحميل الصفحة فقط بعد التغيير
                            setTimeout(() => {
                                window.location.reload();
                            }, 100);
                        }
                    </script>
                    <button x-data="{ isSwitchingLang: false }" :disabled="isSwitchingLang"
                    @click="isSwitchingLang = true; switchLanguage(dir, {{ Auth::check() ? 'true' : 'false' }})"
                    class="flex items-center gap-2 text-sm font-medium transition hover:underline disabled:opacity-50 disabled:cursor-not-allowed">
                    <img :src="dir === 'rtl' ? 'https://flagcdn.com/w40/gb.png' : 'https://flagcdn.com/w40/eg.png'"
                        class="w-5 h-5 rounded-sm" />

                    <template x-if="!isSwitchingLang">
                        <span x-text="dir === 'rtl' ? 'English' : 'عربي'"></span>
                    </template>

                    <template x-if="isSwitchingLang">
                        <svg class="animate-spin h-4 w-4 text-indigo-600" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10"
                                stroke="currentColor" stroke-width="4" />
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v8H4z" />
                        </svg>
                    </template>
                </button>


                <!-- زر الثيم -->
                <button @click="toggleTheme()">
                    <span x-text="darkMode ? '☀️ Light' : '🌙 Dark'"></span>
                </button>

                </div>
            </div>

        </div>
    </div>

    <!-- نافذة الرسائل التفصيلية (تظهر خارج offcanvas) -->
    <div x-show="openMsgDetail" x-transition class="fixed inset-0 z-60 flex items-center justify-center bg-black/40"
        @click.away="openMsgDetail = false">
        <div class="bg-white dark:bg-zinc-800 rounded-lg shadow-lg w-96 p-4">
            <div class="flex justify-between items-center">
                <h2 class="font-bold text-xl">الرسائل</h2>
                <button @click="openMsgDetail = false" class="text-xl">&times;</button>
            </div>
            <div class="mt-4 space-y-2">
                <template x-for="msg in messages" :key="msg.id">
                    <div class="flex items-start space-x-3 p-2 hover:bg-gray-100 dark:hover:bg-gray-700 rounded">
                        <img :src="msg.avatar" class="w-10 h-10 rounded-full" />
                        <div>
                            <h3 class="font-bold text-sm" x-text="msg.name"></h3>
                            <p class="text-xs text-gray-600 dark:text-gray-300" x-text="msg.subject"></p>
                            <p class="text-xs text-gray-500 dark:text-gray-400" x-text="msg.text"></p>
                        </div>
                    </div>
                </template>
            </div>
        </div>
    </div>

    <!-- نافذة الإشعارات التفصيلية (تظهر خارج offcanvas) -->
    <div x-show="openNotiDetail" x-transition class="fixed inset-0 z-60 flex items-center justify-center bg-black/40"
        @click.away="openNotiDetail = false">
        <div class="bg-white dark:bg-zinc-800 rounded-lg shadow-lg w-80 p-4">
            <div class="flex justify-between items-center">
                <h2 class="font-bold text-xl">الإشعارات</h2>
                <button @click="openNotiDetail = false" class="text-xl">&times;</button>
            </div>
            <div class="mt-4 space-y-2">
                <template x-for="noti in notifications" :key="noti.id">
                    <div class="flex items-center space-x-3 p-2 hover:bg-gray-100 dark:hover:bg-gray-700 rounded">
                        <!-- أيقونة التنبيه مع تلوين حسب النوع -->
                        <div class="w-8 h-8 flex items-center justify-center rounded-full"
                            :class="{
                                'bg-blue-200 text-blue-800': noti.type === 'info',
                                'bg-yellow-200 text-yellow-800': noti.type === 'warning',
                                'bg-red-200 text-red-800': noti.type === 'error'
                            }">
                            <span x-text="noti.icon"></span>
                        </div>
                        <div>
                            <h3 class="font-bold text-sm" x-text="noti.title"></h3>
                            <p class="text-xs text-gray-600 dark:text-gray-300" x-text="noti.text"></p>
                        </div>
                    </div>
                </template>
            </div>
        </div>
    </div>
</div>
