<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Livewire\Attributes\Layout;
use Livewire\Volt\Component;
use Illuminate\View\View;

new #[Layout('components.frontend.layouts.struct')] class extends Component {
    public function rendering(View $view): void
    {
        $view->title(__('frontend.tittlewelcomepage') .' | '.__('frontend.login'));
    }
    public string $password = '';

    /**
     * Confirm the current user's password.
     */
    public function confirmPassword(): void
    {
        $this->validate([
            'password' => ['required', 'string'],
        ]);

        if (! Auth::guard('web')->validate([
            'email' => Auth::user()->email,
            'password' => $this->password,
        ])) {
            throw ValidationException::withMessages([
                'password' => __('auth.password'),
            ]);
        }

        session(['auth.password_confirmed_at' => time()]);

        $this->redirectIntended(default: route('dashboard', absolute: false), navigate: true);
    }
}; ?>


<div class="min-h-screen flex items-center justify-center bg-transparent transition duration-700 overflow-hidden relative">

    <div class="z-10 max-w-md w-full space-y-6 bg-white/80 dark:bg-zinc-900/80 backdrop-blur-md p-8 rounded-xl shadow-2xl border border-zinc-300 dark:border-zinc-700">
        <!-- 🔒 العنوان والوصف -->
        <div class="flex flex-col items-center gap-2 animate-fade-in-down">
            <img src="/assets/img/logo.png" alt="Logo" class="w-[300px] h-auto mb-3 drop-shadow-lg" />
            <h2 class="text-2xl font-semibold text-zinc-800 dark:text-white">
                {{ __('frontend.confirm_title') }}
            </h2>
            <p class="text-sm text-zinc-500 dark:text-zinc-400 text-center">
                {{ __('frontend.confirm_desc') }}
            </p>
        </div>

        <!-- 🟢 حالة الجلسة -->
        <x-auth-session-status class="text-center" :status="session('status')" />

        <!-- 🔐 النموذج -->
        <form wire:submit="confirmPassword" class="space-y-4 animate-fade-in-down">
            <div>
                <label for="password" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300">
                    {{ __('frontend.password') }}
                </label>
                <input type="password" id="password" wire:model="password" required
                       autocomplete="new-password"
                       placeholder="{{ __('frontend.password') }}"
                       class="mt-1 block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 ring-accent outline-none transition" />
            </div>

            <button type="submit" class="neon-btn neon-blue w-full delay-[500ms]">
                <span class="btn-text">{{ __('frontend.confirm') }}</span>
                <span class="glow"></span>
            </button>
        </form>
    </div>
</div>
