<?php



use Livewire\Attributes\Layout;
use Livewire\Volt\Component;
use Illuminate\View\View;

new #[Layout('components.frontend.layouts.struct')] class extends Component {
    public function rendering(View $view): void
    {
        $view->title(__('frontend.tittlewelcomepage') .' | '.__('frontend.account_suspended_title'));
    }

    public function boot()
    {

    }

};
?>

<div class="min-h-screen flex items-center justify-center overflow-hidden relative
            bg-gradient-to-br from-zinc-100 via-white to-zinc-200
            dark:from-zinc-900 dark:via-zinc-800 dark:to-zinc-900
            transition-all duration-700 px-4">

    <!-- توهج خلفي -->
    <div class="absolute w-[300px] h-[300px] rounded-full blur-[120px] opacity-20
        bg-gradient-to-br from-orange-400 via-amber-500 to-red-400
        dark:from-orange-300 dark:via-amber-400 dark:to-red-500 animate-pulse
        -translate-x-1/2 -translate-y-1/2 top-1/2 left-1/2 z-0">
    </div>

    <!-- الكارت الرئيسي -->
    <div class="z-10 max-w-md w-full bg-white/80 dark:bg-zinc-900/80 backdrop-blur-md
        p-8 rounded-2xl shadow-lg dark:shadow-md
        border border-zinc-300 dark:border-zinc-700 text-center space-y-6">

        <!-- 🚫 أيقونة التعطيل -->
        <div class="relative flex justify-center items-center">
            <div class="absolute w-[200px] h-[200px] rounded-full blur-[90px] opacity-30
                bg-gradient-to-br from-orange-400 via-amber-500 to-red-400
                dark:from-orange-300 dark:via-amber-400 dark:to-red-500 animate-pulse">
            </div>

            <div class="relative p-4 rounded-full border border-orange-500 dark:border-red-400
                bg-white/20 dark:bg-black/20 backdrop-blur-sm
                shadow-[0_0_20px_#fb923c] dark:shadow-[0_0_25px_#f87171] animate-neon-glow">
                <svg class="w-24 h-24 text-orange-500 dark:text-red-400" fill="none" stroke="currentColor"
                     stroke-width="1.8" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                    <circle cx="12" cy="12" r="10" />
                    <path d="M12 8v4" />
                    <circle cx="12" cy="16" r="1" />
                </svg>
            </div>
        </div>

        <!-- 📝 العنوان -->
        <h2 class="text-2xl font-bold text-zinc-800 dark:text-white">
            {{ __('frontend.account_suspended_title') }}
        </h2>

        <!-- 💬 الرسالة -->
        <p class="text-sm text-zinc-600 dark:text-zinc-300 leading-relaxed">
            {{ __('frontend.account_suspended_msg') }}
        </p>



        <!-- 🚪 زر تسجيل الخروج -->
        <form method="POST" action="{{ route('logout') }}">
            @csrf
            <button type="submit"
                class="w-full py-2 rounded-lg font-semibold transition-all duration-300
                       bg-orange-500 hover:bg-orange-600 text-white
                       dark:bg-orange-400 dark:hover:bg-orange-500 dark:text-black
                       shadow-[0_0_12px_rgba(251,146,60,0.5)] dark:shadow-[0_0_12px_rgba(248,113,113,0.5)]">
                {{ __('frontend.logout') }}
            </button>
        </form>
    </div>
</div>
