@php
    use Illuminate\Support\Facades\Request;

    $empIdEncrypted = Request::get('emp');

    try {
        $empId = decrypt($empIdEncrypted);
    } catch (\Exception $e) {
        abort(403, 'Invalid Employee ID');
    }

    $locale = 'ar';
    app()->setLocale('ar');

    function convertToArabicNumbers($string)
    {
        $western = range(0, 9);
        $eastern = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];
        return str_replace($western, $eastern, $string);
    }

    $dateAr = convertToArabicNumbers(\Carbon\Carbon::now()->locale('ar')->translatedFormat('d F Y - h:i A'));
    $website = env('APP_URL', 'https://orascom.com');
    $documentId = 'DOC-' . now()->format('Ymd-His') . '-' . Str::upper(Str::random(4));

    $employee = \App\Models\User\UserEmployee::with('user')->findOrFail($empId);
    $cv = is_array($employee->cv) ? $employee->cv : json_decode($employee->cv, true);

    $full_name_ar = $employee->full_name['ar'] ?? '';
    $email = $employee->user?->email ?? '';
    $profile_picture_path = $cv['profile_picture'] ?? null;
    $experience_roads = $cv['work_experience']['roads'] ?? [];
    $experience_airports = $cv['work_experience']['airports'] ?? [];
    $skills = $cv['skills'] ?? [];
    $phone = $employee->phone ? json_decode($employee->phone, true)[0] ?? '' : '';
    $job = $locale === 'ar' ? optional($employee->jobTitle)->title_ar : optional($employee->jobTitle)->title_en;
    $job_title = $job ?? ($locale === 'ar' ? 'موظف' : 'Employee');
    $languages = $cv['languages'] ?? [];
    $certificates = $cv['certificates'] ?? [];
    $graduation_project = $cv['graduation_project'] ?? '';
@endphp

<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $locale === 'ar' ? 'rtl' : 'ltr' }}">

<head>
    <meta charset="UTF-8">
    <title>{{ __('frontend.cv') }}</title>
    @vite('resources/css/app.css')
    <style>
        .email-text,
        .description-text {
            word-wrap: break-word;
            word-break: break-word;
            white-space: pre-line;
            /* عشان يحتفظ بالشكل الطبيعي */
        }

        @page {
            size: A4 portrait;
            margin: 10mm 10mm 20mm 10mm;
            /* تخلي فيها footer */
        }

        @media print {

            html,
            body {
                width: 210mm;
                height: 297mm;
                margin: 0;
                padding: 0;
                background: white;
            }

            .page {
                width: 190mm;
                min-height: 277mm;
                padding: 10mm;
                margin: auto;
                background: white;
                box-shadow: none;
                page-break-after: avoid;
                page-break-inside: avoid;
                position: relative;
                display: flex;
                flex-direction: row;
            }

            /* Fix columns */
            .page>div:first-child {
                width: 30% !important;
                max-width: 30% !important;
            }

            .page>div:last-child {
                width: 70% !important;
                max-width: 70% !important;
            }

            /* Prevent image scaling */
            img {
                transform: none !important;
                scale: 1 !important;
            }

            /* Optional: Remove background on print if needed */
            .bg-zinc-800 {
                background-color: #000 !important;
            }

            .bg-white {
                background-color: #fff !important;
            }

            footer {
                position: fixed;
                bottom: 0;
                left: 0;
                right: 0;
                background: white;
                padding: 5px;
                font-size: 10px;
            }

            .no-print {
                display: none !important;
            }

            .email-text,
            .description-text {
                word-wrap: break-word;
                word-break: break-word;
                white-space: pre-line;
                /* عشان يحتفظ بالشكل الطبيعي */
            }

        }
    </style>

</head>

<body class="bg-white text-zinc-800 font-sans">
    <div class="page flex min-h-screen flex-row">

        <!-- Left Column -->
        <div class="w-1/3 bg-zinc-800 text-white rounded-2xl p-6 flex flex-col items-center space-y-6 shadow-lg">

            <!-- Profile Picture -->
            @if (!empty($profile_picture_path) && file_exists(public_path('storage/' . $profile_picture_path)))
                <img src="{{ asset('storage/' . $profile_picture_path) }}" alt="Profile Picture"
                    class="w-32 h-32 rounded-full object-cover border-4 border-white shadow-lg">
            @else
                <img src="{{ asset('assets/img/default-avatar.png') }}" alt="Profile Picture"
                    class="w-32 h-32 rounded-full object-cover border-4 border-white shadow-lg">
            @endif


            <!-- Contact Info -->
            <div class="w-full">
                <h2 class="text-lg font-bold border-b border-white pb-1 mb-2">
                    {{ __('frontend.information') }}</h2>
                <p class="mb-1">{{ __('frontend.governorate') . ': ' . $employee->governorate_name }}</p>
                @if ($employee->birth_date)
                    <p class="mb-1">
                        {{ __('frontend.birth_date') . ': ' }}
                        {{ $employee->birth_date->translatedFormat('d F Y') }}
                        ({{ $employee->birth_date->age }}   {{ __('frontend.years') }} )

                    </p>
                @endif
            </div>

            <!-- Contact Info -->
            <div class="w-full">
                <h2 class="text-lg font-bold border-b border-white pb-1 mb-2">
                    {{ __('frontend.contact_information') }}</h2>
                <p class="mb-1">📱 +20{{ $phone }}</p>
                <p class="email-text">📧 {{ $email }}</p>
            </div>

            <!-- Skills -->
            <div class="w-full">
                <h2 class="text-lg font-bold border-b border-white pb-1 mb-2">{{ __('frontend.skills') }}</h2>
                @if (!empty($skills))
                    <ul class="flex flex-wrap gap-2">
                        @foreach ($skills as $skill)
                            <li class="bg-white text-zinc-800 px-3 py-1 rounded-full text-sm font-semibold">
                                {{ $skill }}</li>
                        @endforeach
                    </ul>
                @else
                    <p>{{ __('frontend.no_skills') }}</p>
                @endif
            </div>

            <!-- Languages -->
            <div class="w-full">
                <h2 class="text-lg font-bold border-b border-white pb-1 mb-2">{{ __('frontend.languages') }}</h2>
                @if (!empty($languages))
                    <ul class="flex flex-wrap gap-2">
                        @foreach ($languages as $lang)
                            <li class="bg-white text-zinc-800 px-3 py-1 rounded-full text-sm font-semibold">
                                {{ $lang }}</li>
                        @endforeach
                    </ul>
                @else
                    <p>{{ __('frontend.no_languages') }}</p>
                @endif
            </div>

            <!-- Certificates -->
            <div class="w-full">
                <h2 class="text-lg font-bold border-b border-white pb-1 mb-2">{{ __('frontend.certificates') }}
                </h2>
                @if (!empty($certificates))
                    <ul class="flex flex-wrap gap-2">
                        @foreach ($certificates as $cert)
                            <li class="bg-white text-zinc-800 px-3 py-1 rounded-full text-sm font-semibold">
                                {{ $cert }}</li>
                        @endforeach
                    </ul>
                @else
                    <p>{{ __('frontend.no_certificates') }}</p>
                @endif
            </div>

        </div>

        <!-- Right Column -->
        <div class="w-2/3 flex flex-col space-y-6">

            <!-- Header -->
            <div class="bg-zinc-100 rounded-2xl p-6 shadow-lg text-center">
                <h1 class="text-3xl font-bold text-zinc-800 mb-2">{{ $full_name_ar }}</h1>
                <div class="text-zinc-500 font-semibold text-lg">{{ $job_title }}</div>
            </div>

            <div class="bg-white rounded-2xl p-6 shadow-lg">
                <h2 class="text-xl font-bold border-b border-zinc-200 pb-2 mb-4">{{ __('frontend.work_experience') }}
                </h2>

                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">

                    <!-- خبرات الطرق -->
                    <div>
                        <h3 class="text-lg font-bold mb-2">{{ __('frontend.roads_experience') }}</h3>
                        @forelse($experience_roads as $exp)
                            <div class="mb-3 p-3 bg-zinc-50 rounded border border-zinc-200 avoid-break">
                                <strong class="block mb-1">{{ $exp['name'] }}</strong>
                                <p class="text-sm mb-1">📅 {{ __('frontend.start_date') }}: {{ $exp['start_date'] }} -
                                    {{ __('frontend.end_date') }}: {{ $exp['end_date'] }}</p>
                                <p class="text-sm description-text">📝 <em>{{ $exp['description'] }}</em></p>
                            </div>
                        @empty
                            <p>{{ __('frontend.no_experience') }}</p>
                        @endforelse
                    </div>

                    <!-- خبرات المطارات -->
                    <div>
                        <h3 class="text-lg font-bold mb-2">{{ __('frontend.airports_experience') }}</h3>
                        @forelse($experience_airports as $exp)
                            <div class="mb-3 p-3 bg-zinc-50 rounded border border-zinc-200 avoid-break">
                                <strong class="block mb-1">{{ $exp['name'] }}</strong>
                                <p class="text-sm mb-1">📅 {{ __('frontend.start_date') }}: {{ $exp['start_date'] }} -
                                    {{ __('frontend.end_date') }}: {{ $exp['end_date'] }}</p>
                                <p class="text-sm description-text">📝 <em>{{ $exp['description'] }}</em></p>
                            </div>
                        @empty
                            <p>{{ __('frontend.no_experience') }}</p>
                        @endforelse
                    </div>

                </div>
            </div>


            <!-- Graduation Project -->
            <div class="bg-white rounded-2xl p-6 shadow-lg">
                <h2 class="text-xl font-bold border-b border-zinc-200 pb-2 mb-4">
                    {{ __('frontend.graduation_project') }}</h2>
                @if (!empty($graduation_project))
                    <p class="text-sm">📝 <em>{{ $graduation_project }}</em></p>
                @else
                    <p>{{ __('frontend.no_graduation_project') }}</p>
                @endif
            </div>

        </div>

    </div>
    <!-- Footer -->
    <footer
        class="bg-zinc-100 text-center text-sm text-zinc-600 py-3 border-t border-zinc-300 print:fixed print:bottom-0 print:left-0 print:right-0">
        {{ __('frontend.hrmanager') }} - {{ __('backend.eng_name') }} |
        {{ __('frontend.document_id') }} {{ $documentId }} |
        🌐 {{ $website }} |
        📄 1/1
    </footer>

    <!-- Print Button -->
    <div class="no-print fixed bottom-6 right-6">
        <button onclick="window.print()"
            class="bg-blue-600 text-white px-5 py-2 rounded-full shadow-lg hover:bg-blue-700 transition">
            🖨️ {{ __('frontend.printpage') }}
        </button>
    </div>


</body>

</html>
