@php
    use App\Helpers\AppSettings;

    $lang = AppSettings::language();
    $darkMode = AppSettings::darkMode();
    $jobTitle = AppSettings::jobTitle();
    $avatar = AppSettings::avatar();

    $settings = [
        'language' => $lang,
        'dark_mode' => $darkMode,
        'job_title' => $jobTitle,
        'avatar' => $avatar,
    ];
@endphp

<!-- ✅ Injected JS Global Settings -->
<script>
    window.appSettings = @json($settings);

    // ✅ fallback to localStorage
    window.appSettings.language = window.appSettings.language ?? localStorage.getItem('lang') ?? 'ar';
    window.appSettings.dark_mode =
        window.appSettings.dark_mode === null
            ? (localStorage.getItem('theme') === 'dark')
            : window.appSettings.dark_mode;
</script>

<!-- ✅ Meta tags for Blade usage or SEO -->
<meta name="app:language" content="{{ $lang }}">
<meta name="app:dark_mode" content="{{ $darkMode ? 'dark' : 'light' }}">
<meta name="app:job_title" content="{{ $jobTitle }}">
<meta name="app:avatar" content="{{ $avatar }}">
