<!DOCTYPE html>
@php
    use Illuminate\Support\Str;
    $settings = Auth::user()?->settings ?? [];
    $dark = array_key_exists('dark_mode', $settings)
        ? json_encode($settings['dark_mode'])
        : 'localStorage.getItem("theme") === "dark"';

    $lang = array_key_exists('language', $settings) ? "'{$settings['language']}'" : "'" . app()->getLocale() . "'";

    // New meta variables and sensible fallbacks
    $siteUrl   = rtrim(config('app.url', url('/')), '/');
    $metaUrl   = url()->current();
    $metaTitle = $title ?? config('app.name', 'Orascom');
    $metaDesc  = $description ?? 'أوراسكوم قسم مساحة - منصة إدارة الموظفين.';
    $metaKeywords = $keywords ?? 'survey, orascom, surveys, data, analytics';
    $siteName     = config('app.name', 'Orascom');
    $twitterHandle = config('services.twitter.handle') ?? '@Orascom';

    // default images (ensure these exist in public/assets/img)
    $defaultOg1 = "https://sur.4tressro.com/assets/img/og-1200x630.jpg";
    $defaultOg2 = "https://sur.4tressro.com/assets/img/og-1200x1200.jpg";

    // image values may be provided per-page (controller/view)
    $ogImages = [
        ['url' => ($image ?? $defaultOg1), 'w' => ($imageWidth ?? 1200), 'h' => ($imageHeight ?? 630), 'alt' => ($imageAlt ?? $metaTitle)],
        ['url' => $defaultOg2, 'w' => 1200, 'h' => 1200, 'alt' => ($imageAlt ?? $metaTitle)],
    ];

    // optional verification / integration keys (set in config/services.php or .env)
    $fbAppId = config('services.facebook.app_id') ?? null;
    $googleVerification = config('services.google.site_verification') ?? null;
@endphp
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" x-data="{
    darkMode: {{ $dark }},

    toggleTheme() {
        this.darkMode = !this.darkMode;
        localStorage.setItem('theme', this.darkMode ? 'dark' : 'light');
        @if (Auth::check()) fetch('{{ route('update.darkmode', ['id' => Auth::id()]) }}'); @endif
    },
    locale: {{ $lang }},
    switchLang() {
        const target = this.locale === 'ar' ? 'en' : 'ar';
        this.locale = target;
        document.documentElement.setAttribute('dir', target === 'ar' ? 'rtl' : 'ltr');
        window.location.href = '{{ url('set-language') }}/' + target;
    }
}" x-init="$watch('darkMode', val => localStorage.setItem('theme', val ? 'dark' : 'light'));
document.documentElement.setAttribute('dir', locale === 'ar' ? 'rtl' : 'ltr');"
    x-bind:class="{ 'dark': darkMode }" class="transition duration-500">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <title>{{ $metaTitle }}</title>

    <!-- Primary SEO -->
    <meta name="description" content="{{ $metaDesc }}">
    <meta name="keywords" content="{{ $metaKeywords }}">
    <meta name="author" content="{{ $siteName }}">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="{{ $metaUrl }}">

    <!-- Open Graph / Facebook -->
    <meta property="og:title" content="{{ $metaTitle }}">
    <meta property="og:description" content="{{ $metaDesc }}">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ $metaUrl }}">
    <meta property="og:site_name" content="{{ $siteName }}">
    <meta property="og:locale" content="{{ app()->getLocale() === 'ar' ? 'ar_AR' : 'en_US' }}">

    <!-- Multiple images with explicit sizes -->
@foreach($ogImages as $img)
  <meta property="og:image" content="{{ $img['url'] }}">
  <meta property="og:image:secure_url" content="{{ preg_replace('#^http://#','https://',$img['url']) }}">
  <meta property="og:image:width" content="{{ $img['w'] }}">
  <meta property="og:image:height" content="{{ $img['h'] }}">
  <meta property="og:image:type" content="image/jpeg">
@endforeach
    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:site" content="{{ $twitterHandle }}">
    <meta name="twitter:creator" content="{{ $twitterHandle }}">
    <meta name="twitter:title" content="{{ $metaTitle }}">
    <meta name="twitter:description" content="{{ $metaDesc }}">
    <meta name="twitter:image" content="{{ $ogImages[0]['url'] }}">
    <meta name="twitter:image:alt" content="{{ $ogImages[0]['alt'] }}">

    <!-- Mobile / PWA theming -->
    <meta name="theme-color" content="#0f172a">
    <meta name="msapplication-TileColor" content="#0f172a">
    <meta name="apple-mobile-web-app-capable" content="yes">

    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />

    <!-- hreflang / alternates for multilingual sites -->
    <link rel="alternate" href="{{ $metaUrl }}" hreflang="{{ app()->getLocale() }}" />
    <link rel="alternate" href="{{ $siteUrl }}" hreflang="x-default" />
    <link rel="alternate" href="{{ $siteUrl }}/ar" hreflang="ar" />
    <link rel="alternate" href="{{ $siteUrl }}/en" hreflang="en" />

    @if($googleVerification)
        <meta name="google-site-verification" content="{{ $googleVerification }}">
    @endif

    @if($fbAppId)
        <meta property="fb:app_id" content="{{ $fbAppId }}">
    @endif

    @vite(['resources/css/frontend/app.css', 'resources/js/app.js'])


    <!-- JSON-LD structured data (WebSite + Organization + WebPage) -->
    <script type="application/ld+json">
        {!! json_encode([
            "@context" => "https://schema.org",
            "@type" => "WebSite",
            "url" => $siteUrl,
            "name" => $siteName,
            "potentialAction" => [
                "@type" => "SearchAction",
                "target" => $siteUrl . "/?s={search_term_string}",
                "query-input" => "required name=search_term_string"
            ]
        ], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE) !!}
    </script>

    <script type="application/ld+json">
        {!! json_encode([
            "@context" => "https://schema.org",
            "@type" => "Organization",
            "url" => $siteUrl,
            "name" => $siteName,
            "logo" => [
                "@type" => "ImageObject",
                "url" => $ogImages[0]['url'],
                "width" => $ogImages[0]['w'],
                "height" => $ogImages[0]['h']
            ]
        ], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE) !!}
    </script>

    <script type="application/ld+json">
        {!! json_encode([
            "@context" => "https://schema.org",
            "@type" => "WebPage",
            "url" => $metaUrl,
            "name" => $metaTitle,
            "description" => $metaDesc,
            "inLanguage" => app()->getLocale(),
            "mainEntityOfPage" => [
                "@type" => "WebSite",
                "@id" => $siteUrl
            ],
            "image" => [
                [
                    "@type" => "ImageObject",
                    "url" => $ogImages[0]['url'],
                    "width" => $ogImages[0]['w'],
                    "height" => $ogImages[0]['h']
                ]
            ]
        ], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE) !!}
    </script>


    @if (Auth::check())
        <script>
            localStorage.setItem('theme', {{ $dark }});
            // localStorage.setItem('lang', {{ $lang !== 'null' ? $lang : '"' . app()->getLocale() . '"' }});
            localStorage.setItem('lang', "{{ $lang !== 'null' ? $lang : app()->getLocale() }}");
        </script>
    @endif
</head>

