<body
    class="transition-colors duration-700 ease-in-out relative min-h-screen text-gray-900 dark:text-white overflow-y-auto">
    @if (session('toast'))
        <div x-data="{ show: true }" x-show="show" x-init="setTimeout(() => show = false, {{ session('toast.duration') }})"
            class="fixed top-5 right-5 bg-green-500 text-white p-3 rounded shadow">
            {{ session('toast.msg') }}
        </div>
    @endif
    {{-- إشعارات النظام --}}
    <livewire:core.advanced-toast />

    {{-- 🌊 الخلفية المتدرجة --}}
    <div class="fixed inset-0 z-[-1] overflow-hidden">
        <div class="absolute inset-0 transition-all duration-[2000ms] ease-in-out"
            :class="darkMode ? 'wave-background-dark' : 'wave-background'"></div>

        <div class="absolute top-[10%] left-[20%] w-[280px] h-[280px] bg-indigo-400 rounded-full blur-[100px]"
            :class="darkMode ? 'opacity-20' : 'opacity-10'"></div>

        <div class="absolute bottom-[10%] right-[20%] w-[300px] h-[300px] bg-pink-300 rounded-full blur-[120px]"
            :class="darkMode ? 'opacity-20' : 'opacity-10'"></div>

        <div class="absolute top-[50%] left-[50%] -translate-x-1/2 -translate-y-1/2 w-[200px] h-[200px] bg-blue-500 rounded-full blur-[90px]"
            :class="darkMode ? 'opacity-15' : 'opacity-5'"></div>
    </div>

    <div class="flex h-screen">
        {{-- Sidebar --}}
        <div class="print:hidden ">
            <livewire:backend.body.sidebar />
        </div>
        <div class="flex-1 flex flex-col">
            {{-- Navbar --}}
            <div class="print:hidden ">
                <livewire:backend.body.header />
            </div>

            {{-- Main content --}}
            <main :class="[hidden ? 'mt-6' : 'mt-24', sidebarOpen ? 'md:ms-64' : 'md:ms-20']"
                class="flex-1 p-6 transition-all duration-700">
                {{ $slot }}
            </main>

            {{-- القائمة المنبثقة للموبايل --}}
            <div class="print:hidden ">
                <livewire:backend.body.offcanvas />
            </div>
        </div>
    </div>

    {{-- دوال الجافاسكريبت العامة --}}
    <script>
        function navbar() {
            return {
                sidebarOpen: true,
                hidden: false,
                navbarMenuOpen: false,
                selectedChild: "",
                menu: [{
                        title: "الرئيسية",
                        icon: "🏠",
                        children: [],
                        _open: false
                    },
                    {
                        title: "المستخدمين",
                        icon: "👥",
                        _open: false,
                        children: ["كل المستخدمين", "صلاحيات", "أدوار"],
                    },
                    {
                        title: "الإعدادات",
                        icon: "⚙️",
                        children: [],
                        _open: false
                    },
                ],
            };
        }

        function submenuData() {
            return {
                submenuMenuOpen: false,
                openMsgDetail: false,
                openNotiDetail: false,
                messages: [{
                        id: 1,
                        avatar: 'https://i.pravatar.cc/40?img=1',
                        name: 'أحمد',
                        subject: 'عنوان الرسالة',
                        text: 'هذه بعض تفاصيل الرسالة المختصرة...'
                    },
                    {
                        id: 2,
                        avatar: 'https://i.pravatar.cc/40?img=2',
                        name: 'سامي',
                        subject: 'عنوان آخر',
                        text: 'تفاصيل الرسالة هنا بشكل مختصر...'
                    },
                ],
                notifications: [{
                        id: 1,
                        type: 'info',
                        icon: 'ℹ️',
                        title: 'تنبيه معلوماتي',
                        text: 'تفاصيل التنبيه المعلوماتي هنا...'
                    },
                    {
                        id: 2,
                        type: 'warning',
                        icon: '⚠️',
                        title: 'تنبيه هام',
                        text: 'تفاصيل التنبيه الهام هنا...'
                    },
                ]
            }
        }
    </script>
</body>

</html>
