<!DOCTYPE html>
<html
  lang="{{ $lang }}"
  dir="{{ $lang === 'ar' ? 'rtl' : 'ltr' }}"
  x-data="{
      ...Object.assign(navbar(), submenuData()),

      // 🌙 الثيم
      darkMode: window.appSettings?.dark_mode ?? false,
      toggleTheme() {
          this.darkMode = !this.darkMode;
          localStorage.setItem('theme', this.darkMode ? 'dark' : 'light');
          @if (Auth::check()) fetch('{{ route('update.darkmode', ['id' => Auth::id()]) }}'); @endif
      },

      // 📚 اللغة والاتجاه
      dir: '{{ $lang === 'ar' ? 'rtl' : 'ltr' }}',
      switchLang() {
          const target = this.dir === 'rtl' ? 'en' : 'ar';
          localStorage.setItem('lang', target);
          this.dir = target === 'ar' ? 'rtl' : 'ltr';
          @if (Auth::check()) fetch(`{{ url('set-language') }}/${target}`); @endif
          setTimeout(() => window.location.reload(), 100);
      },

      // 📚 sidebar & navbar
      sidebarOpen: localStorage.getItem('sidebarOpen') === 'true',
      hidden: localStorage.getItem('navbarHidden') === 'true',
      toggleSidebar() {
          this.sidebarOpen = !this.sidebarOpen;
          localStorage.setItem('sidebarOpen', this.sidebarOpen);
      },
      toggleNavbar() {
          this.hidden = !this.hidden;
          localStorage.setItem('navbarHidden', this.hidden);
      }
  }"
  x-init="
      $el.setAttribute('dir', dir);
      $watch('dir', val => $el.setAttribute('dir', val));
      $watch('darkMode', val => localStorage.setItem('theme', val ? 'dark' : 'light'));
      $watch('sidebarOpen', val => localStorage.setItem('sidebarOpen', val));
      $watch('hidden', val => localStorage.setItem('navbarHidden', val));
  "
  x-bind:class="{ 'dark': darkMode }"
  x-bind:dir="dir"
>

<head>
    {{-- إعدادات عامة خاصة بالتطبيق --}}
    @include('components.global.settings')

    {{-- ضبط وضع الثيم الداكن فورًا --}}
    <script>

        document.documentElement.classList.toggle('dark', localStorage.getItem('theme') === 'dark');
    </script>

    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <title>{{ $title ?? 'Orascom' }}</title>

    {{-- خطوط --}}
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />

    {{-- ملفات Vite --}}
    @vite(['resources/css/backend/app.css', 'resources/js/app.js'])
</head>

<body class="transition-colors duration-700 ease-in-out relative min-h-screen text-gray-900 dark:text-white overflow-y-auto">

    {{-- إشعارات النظام --}}
    <livewire:core.advanced-toast />

    {{-- 🌊 الخلفية المتدرجة --}}
    <div class="fixed inset-0 z-[-1] overflow-hidden">
        <div class="absolute inset-0 transition-all duration-[2000ms] ease-in-out"
            :class="darkMode ? 'wave-background-dark' : 'wave-background'"></div>

        <div class="absolute top-[10%] left-[20%] w-[280px] h-[280px] bg-indigo-400 rounded-full blur-[100px]"
            :class="darkMode ? 'opacity-20' : 'opacity-10'"></div>

        <div class="absolute bottom-[10%] right-[20%] w-[300px] h-[300px] bg-pink-300 rounded-full blur-[120px]"
            :class="darkMode ? 'opacity-20' : 'opacity-10'"></div>

        <div class="absolute top-[50%] left-[50%] -translate-x-1/2 -translate-y-1/2 w-[200px] h-[200px] bg-blue-500 rounded-full blur-[90px]"
            :class="darkMode ? 'opacity-15' : 'opacity-5'"></div>
    </div>


            {{-- Main content --}}
            <main
                :class="[hidden ? 'mt-6' : 'mt-24', sidebarOpen ? 'md:ms-64' : 'md:ms-20']"
                class="flex-1 p-6 transition-all duration-700">
                {{ $slot }}
            </main>


</body>
</html>

