<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" x-data="{
    darkMode: localStorage.getItem('theme') === 'dark',
    toggleTheme() {
        this.darkMode = !this.darkMode;
        localStorage.setItem('theme', this.darkMode ? 'dark' : 'light');
    },
    locale: '{{ app()->getLocale() }}',
    switchLang() {
        const target = this.locale === 'ar' ? 'en' : 'ar';
        this.locale = target;
        document.documentElement.setAttribute('dir', target === 'ar' ? 'rtl' : 'ltr');
        window.location.href = '{{ url('set-language') }}/' + target;
    }
}" x-init="$watch('darkMode', val => localStorage.setItem('theme', val ? 'dark' : 'light'));
document.documentElement.setAttribute('dir', locale === 'ar' ? 'rtl' : 'ltr');" x-bind:class="{ 'dark': darkMode }"
    class="transition duration-500">


<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome to Orascom HR‑Portal</title>

    @vite(['resources/css/frontend/app.css', 'resources/js/app.js'])
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>


</head>

<body class="min-h-screen relative flex items-center justify-center overflow-hidden transition duration-700">

    <!-- ⛑️ Preload -->
    <div class="hidden">
        translate-x-0 translate-x-7 opacity-40 opacity-100
        hover:scale-110 hover:rotate-12
    </div>

    <!-- ░░░ أزرار الثيم + اللغة ░░░ -->
    <!-- ░░░ أزرار الثيم + اللغة ░░░ -->
    <div x-ref="buttonsContainer" class="absolute top-5 z-50 flex flex-row gap-3 transition-all duration-500"
        :class="locale === 'ar' ? 'left-5' : 'right-5'">

        <!-- زر الثيم -->
        <button @click="toggleTheme()"
            class="w-10 h-10 flex items-center justify-center rounded-full shadow-md transition-all duration-300
                     bg-zinc-800 text-white dark:bg-white dark:text-black hover:scale-110 hover:rotate-12">
            <template x-if="!darkMode">
                <svg class="w-7 h-7 text-yellow-400" viewBox="0 0 24 24" fill="currentColor">
                    <circle cx="12" cy="12" r="5" />
                    <path
                        d="M12 1v2M12 21v2M4.22 4.22l1.42 1.42M18.36 18.36l1.42 1.42M1 12h2M21 12h2M4.22 19.78l1.42-1.42M18.36 5.64l1.42-1.42" />
                </svg>
            </template>
            <template x-if="darkMode">
                <svg class="w-7 h-7 text-indigo-300" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M21 12.79A9 9 0 1111.21 3 7 7 0 0021 12.79z" />
                </svg>
            </template>
        </button>




    </div>

    <!-- 🌌 خلفية ناعمة أنيقة متناسقة مع ألوان اللوجو -->
    <div class="absolute inset-0 -z-20 overflow-hidden">
        <!-- خلفية متدرجة -->
        <div
            class="absolute inset-0 bg-gradient-to-br from-[#f1f5f9] via-[#e0e7ff] to-[#fef9c3] dark:from-[#0f172a] dark:via-[#1e293b] dark:to-[#0a0a0a] transition-all duration-[3000ms]">
        </div>

        <!-- توهج داخلي ناعم -->
        <div
            class="absolute top-[10%] left-[20%] w-[280px] h-[280px] bg-indigo-400 opacity-10 dark:opacity-20 rounded-full blur-[100px] animate-glow1">
        </div>
        <div
            class="absolute bottom-[10%] right-[20%] w-[300px] h-[300px] bg-pink-300 opacity-10 dark:opacity-20 rounded-full blur-[120px] animate-glow2">
        </div>
        <div
            class="absolute top-[50%] left-[50%] -translate-x-1/2 -translate-y-1/2 w-[200px] h-[200px] bg-blue-500 opacity-5 dark:opacity-15 rounded-full blur-[90px] animate-glow3">
        </div>
    </div>



    <div x-data="{
        text: 'we will back soon',
        displayedText: '',
        charIndex: 0,
        typingSpeed: 80,
        showLogo: false,
        showDesc: false,
        showButtons: false,
        showCursor: true,
         }" x-init="const typingInterval = setInterval(() => {
        if (charIndex < text.length) {
            displayedText += text[charIndex++];
        } else {
            clearInterval(typingInterval);
            setTimeout(() => showLogo = true, 400);
            setTimeout(() => showDesc = true, 1000);
            setTimeout(() => showButtons = true, 1600);
            setTimeout(() => showCursor = false, 2200);
        }
          }, typingSpeed);" class="z-10 text-center p-6 space-y-6">

        <!-- 👋 Text Animation -->
        <div class="relative inline-block">
            <h2 class="text-4xl sm:text-5xl font-bold text-zinc-800 dark:text-white inline-block relative">
                <span x-text="displayedText"></span>

                <!-- ✨ Cursor Glow Effect -->
                <template x-if="showCursor">
                    <span x-transition:leave="transition ease-in duration-500"
                        x-transition:leave-start="opacity-100 scale-100"
                        x-transition:leave-end="opacity-0 scale-95 blur-sm"
                        class="inline-block animate-glow-cursor text-indigo-400 text-6xl font-bold animate-pulse-fast">
                        |
                    </span>
                </template>

            </h2>
        </div>

        <!-- 🌐 Logo -->
        <div x-show="showLogo" x-transition.scale.duration.1000ms>
            <img src="/assets/img/logo.png" alt="Logo"
                class="mx-auto w-full max-w-[500px] h-auto rounded-xl shadow-2xl border-4 dark:border-white border-zinc-300 bg-white/30 backdrop-blur-lg p-4">
        </div>

        <!-- 💬 Description -->
        <div x-show="showDesc" x-transition.opacity.duration.800ms>
            <p class="text-lg sm:text-xl text-zinc-600 dark:text-zinc-300">
                {{ __('frontend.desc') }}
            </p>
        </div>
    </div>







</body>

</html>
