document.addEventListener("livewire:init", () => {
    // [الجزء الخاص بـ Livewire والتعامل مع Toasts والإشعارات]
    Livewire.hook("message.failed", ({ response }) => {
        if (response.status === 422 && response?.body?.errors) {
            Object.values(response.body.errors)
                .flat()
                .forEach((msg) => {
                    Livewire.dispatch("notify", {
                        type: "error",
                        message: msg,
                        duration: 5000,
                    });
                });
        }
    });

    Livewire.on("toast-added", ({ type }) => {
        if (type === "rate-limit") return;
        new Audio(`/assets/sounds/${type}.mp3`).play().catch(() => {});
    });

    Livewire.on("notify", ({ type, message, countdown }) => {
        if (type === "rate-limit") {
            document
                .getElementById("login-btn")
                ?.setAttribute("disabled", "disabled");
            new Audio("/assets/sounds/errorlimit.mp3").play().catch(() => {});
            return;
        }
        Livewire.dispatch("toast-added", { type, message });
    });

    Livewire.on("rate-finished", () => {
        document.getElementById("login-btn")?.removeAttribute("disabled");
        Livewire.find(
            document
                .getElementById("login-btn")
                .closest("[wire\\:id]")
                ?.getAttribute("wire:id")
        )?.set("loginDisabled", false);
    });











    function setupOtpInputs() {
        const hiddenInput = document.getElementById('otp-code');
        const inputs = document.querySelectorAll('.otp-input');
        const container = document.getElementById('otp-container');

        if (!inputs.length || !hiddenInput || !container) return;

        function updateOtpValue() {
            hiddenInput.value = [...inputs].map(i => i.value).join('');
            hiddenInput.dispatchEvent(new Event('input'));
        }

        inputs[0].focus();
        inputs[0].classList.add("pop");
        setTimeout(() => inputs[0].classList.remove("pop"), 300);

        inputs.forEach((input, index) => {
            input.addEventListener('input', (event) => {
                let value = event.target.value.slice(0,1);
                event.target.value = value;
                updateOtpValue();

                if (value && index < inputs.length - 1) {
                    inputs[index + 1].focus();
                }

                input.classList.add('pop');
                setTimeout(() => input.classList.remove('pop'), 300);

                if (index === inputs.length - 1 && hiddenInput.value.length === inputs.length) {
                    setTimeout(() => {
                        document.getElementById('login-btn')?.click();
                    }, 300);
                }
            });

            input.addEventListener('keydown', (event) => {
                if (event.key === "Backspace" && !input.value && index > 0) {
                    event.preventDefault();
                    inputs[index - 1].focus();
                }
            });

            input.addEventListener('paste', (event) => {
                event.preventDefault();
                const pasteData = event.clipboardData.getData('text').trim().replace(/\D/g, '');
                if (!pasteData) return;

                inputs.forEach(inp => inp.value = "");
                [...pasteData].forEach((char, idx) => {
                    if (inputs[idx]) inputs[idx].value = char;
                });

                updateOtpValue();
                const nextFocus = pasteData.length < inputs.length ? pasteData.length : inputs.length - 1;
                inputs[nextFocus].focus();

                if (pasteData.length === inputs.length) {
                    setTimeout(() => {
                        document.getElementById('login-btn')?.click();
                    }, 300);
                }
            });
        });
    }

    // الطريقة الأفضل للتحميل المضمون
    document.addEventListener('livewire:navigated', setupOtpInputs);

    // لما يحصل shake بعد الكود الغلط
    window.addEventListener('otp-invalid', () => {
        const container = document.getElementById('otp-container');
        const inputs = document.querySelectorAll('.otp-input');
        const hiddenInput = document.getElementById('otp-code');

        if (!container || inputs.length === 0) return;

        container.classList.remove('shake');
        void container.offsetWidth;
        container.classList.add('shake');

        inputs.forEach(input => input.value = "");
        hiddenInput.value = "";
        inputs[0].focus();

        setTimeout(() => container.classList.remove('shake'), 500);
    });

    Livewire.on('fireworks', () => {
        confetti({
            particleCount: 180,
            startVelocity: 30,
            spread: 360,
            origin: { y: 0.6 }
        });
    });


});


document.addEventListener('alpine:init', () => {
    Alpine.data('sidebarHandler', () => ({
        open: false,
        collapsed: false,
        init() {
            window.addEventListener('toggle-sidebar', () => {
                this.open = !this.open;
            });
        }
    }));
});

