<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class  extends Migration
{
    public function up()
    {
        Schema::create('system_mail_settings', function (Blueprint $table) {
            $table->id();
            $table->boolean('status')->default(1); // Active or Inactive
            $table->string('mail_from_address');
            $table->string('mail_from_name');
            $table->string('smtp_host');
            $table->integer('smtp_port');
            $table->string('username');
            $table->text('password');
            $table->string('encryption')->nullable(); // ssl, tls, or null
            $table->integer('attachment_size_limit')->nullable(); // Limit in MB
            $table->timestamps();
        });

        Schema::create('system_operation_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('operation');
            $table->text('details')->nullable();
            $table->string('table_name')->nullable();
            $table->bigInteger('record_id')->nullable();
            $table->string('controller')->nullable();
            $table->string('ip_address')->nullable();
            $table->text('user_agent')->nullable();
            $table->timestamps();
        });

        Schema::create('system_operation_login', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('operation');
            $table->text('details')->nullable();
            $table->string('table_name')->nullable();
            $table->bigInteger('record_id')->nullable();
            $table->string('controller')->nullable();
            $table->string('ip_address')->nullable();
            $table->text('user_agent')->nullable();
            $table->timestamps();
        });

        Schema::create('system_routes', function (Blueprint $table) {
            $table->id();

            // 🟢 أساسية للتحكم في route
            $table->boolean('is_active')->default(true);
            $table->string('prefix')->nullable();          // admin, hr, reports
            $table->string('name')->unique();              // route name: users.index
            $table->string('url');                         // /users/{id}
            $table->string('method')->default('GET');      // GET/POST/PUT/DELETE
            $table->string('type')->default('controller'); // controller | blade | volt | pdf | excel | word

        //     {
        //   "use": "use App\\Http\\Controllers\\PdfController;",
        //   "class": "PdfController",
        //   "method": "generateMonthly",
        //   "as": "Pdf"
        // }
            $table->json('controller')->nullable();        // ["main" : "use Barryvdh\DomPDF\Facade\Pdf;", "name" : "Pdf" , Class "::Class"]
            $table->string('view_name')->nullable();       // for blade/volt/pdf


            // 🟠 middleware كـ JSON بدل string لتعددهم
            $table->json('middleware')->nullable();        // ["auth", "verified"]

            // 🟣 شروط (اختيارية)
            $table->json('constraints')->nullable();       // { "id": "[0-9]+" }

            $table->json('route_properties')->nullable();  // display_name, icon, color, etc

            // 🧱 إعدادات تحكم
            $table->boolean('auth')->default(true);
            $table->string('main_group')->nullable(); // للفرز داخل واجهة النظام
            $table->unsignedBigInteger('parent_id')->nullable(); // من جدول system_parents
            $table->unsignedInteger('order')->nullable();

            $table->timestamps();
        });

            Schema::create('system_parents', function (Blueprint $table) {
                $table->id();
                $table->unsignedInteger('order')->nullable()->comment('ترتيب الظهور في القائمة');
                $table->string('name_en')->comment('اسم المجموعة باللغة الإنجليزية');
                $table->string('name_ar')->comment('اسم المجموعة باللغة العربية');
                $table->string('icon')->nullable()->comment('اسم ملف SVG للآيقونة');
                $table->string('color_name')->nullable()->comment('لون الخلفية (مثل indigo, blue...)');
                $table->string('color_icon')->nullable()->comment('لون الآيقونة (مثل white, gray...)');
            });

    }

    public function down()
    {
        Schema::dropIfExists('system_mail_settings');
        Schema::dropIfExists('system_operation_logs');
        Schema::dropIfExists('system_routes');
        Schema::dropIfExists('system_parents');
    }
};
