<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {



        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('user_state')->default('inactive');
            $table->unsignedBigInteger('employee_id');
            $table->string('project_code')->nullable();
            $table->string('name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->json('settings')->nullable(); //photo is_locked mode lang
            $table->json('pages')->nullable();
            $table->text('two_factor_secret')->after('password')->nullable();
            $table->text('two_factor_recovery_codes')->after('two_factor_secret')->nullable();
            $table->timestamp('two_factor_confirmed_at')->after('two_factor_recovery_codes')->nullable();
            $table->string('activation_token')->nullable();
            $table->rememberToken();
            $table->timestamps();

            // علاقة المشروع
            $table->foreign('project_code')->references('code')->on('users_projects');
            $table->foreign('employee_id')->references('id')->on('users_employees')->onDelete('cascade');
        });









        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });





        Schema::create('users_employee_movements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('created_by')  ->nullable()->constrained('users') ->onDelete('set null') ->comment('ID المستخدم الذي أضاف الحركة');
            $table->enum('status', ['pending', 'activated', 'applied', 'cancelled'])->default('pending')->comment('حالة الحركة');
            $table->enum('type', ['mission', 'transfer', 'termination'])->comment('نوع الحركة');
            $table->foreignId('employee_id')->constrained('users_employees');
            $table->date('start_date')->comment('تاريخ بداية الحركة');
            $table->date('end_date')->nullable()->comment('تاريخ نهاية المأمورية إذا لم تكن مفتوحة');
            $table->foreignId('from_project')->constrained('users_projects')->cascadeOnDelete();
            $table->foreignId('to_project')->nullable()->constrained('users_projects')->comment('المشروع الوجهة للحركات');
            $table->string('job_uuid', 36)->nullable()->comment('UUID للـ Job في الجدول jobs');
            $table->foreignId('cancelled_by')->nullable()->constrained('users') ->comment('ID المستخدم الذي ألغى الحركة');
            $table->timestamp('cancelled_at')->nullable()->comment('وقت إلغاء الحركة');
            $table->text('cancelled_reason')->nullable()->comment('سبب الإلغاء أو الرفض');
            $table->text('notes')->nullable()->comment('ملاحظات عامة');
            $table->timestamps();
        });

        Schema::create('users_employee_leaves', function (Blueprint $table) {
            $table->id();
            $table->foreignId('created_by') ->nullable() ->constrained('users') ->onDelete('set null') ->comment('ID المستخدم الذي أضاف الحركة');
            $table->enum('status', ['pending', 'activated', 'applied', 'cancelled'])->default('pending')->comment('حالة الحركة');
            $table->enum('leave_type', ['regular', 'project'])->comment('نوع الإجازة: عادية أو مرتبطة بمشروع');
            $table->foreignId('employee_id')->constrained('users_employees')->comment('الموظف');
            $table->date('start_date')->comment('تاريخ بدء الإجازة');
            $table->date('end_date')->nullable()->comment('تاريخ انتهاء الإجازة (إن وُجد)');
            $table->string('job_uuid', 36)->nullable()->comment('UUID للـ Job في الجدول jobs');
            $table->foreignId('cancelled_by')->nullable()->constrained('users') ->comment('ID المستخدم الذي ألغى الحركة');
            $table->timestamp('cancelled_at')->nullable()->comment('وقت إلغاء الحركة');
            $table->text('cancelled_reason')->nullable()->comment('سبب الإلغاء أو الرفض');
            $table->text('note')->nullable()->comment('ملاحظات إضافية');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sessions');
        Schema::dropIfExists('password_reset_tokens');

        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['project_code']);
            $table->dropForeign(['employee_id']);
        });

        Schema::dropIfExists('users');
        Schema::dropIfExists('users_employee_movements');
        Schema::dropIfExists('users_employee_leaves');
    }

};
