<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class   extends Migration
{
    public function up()
    {


        // 1. جدول المشاريع Projects
        Schema::create('users_projects', function (Blueprint $table) {
            $table->id(); // مفتاح أساسي إضافي
            $table->enum('status', ['active', 'archived', 'pending'])->default('active'); // حالة المشروع
            $table->string('code')->unique(); // مثال: PRJ-001
            $table->string('name');
            $table->unsignedBigInteger('manager_id')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
        });

        Schema::create('users_job_titles', function (Blueprint $table) {
            $table->id();
            $table->string('title_en');
            $table->string('title_ar')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
        });

        // 2. جدول الموظفين Employees
        Schema::create('users_employees', function (Blueprint $table) {
            $table->id();
            $table->string('project_code');
            $table->string('employee_code')->unique()->nullable();
            $table->json('full_name');
            $table->json('phone')->nullable();
            $table->unsignedBigInteger('job_title_id')->nullable();
            $table->string('national_id', 14)->unique();
            $table->date('birth_date')->nullable();
            $table->json('governorate')->nullable();
            $table->enum('gender', ['male', 'female'])->nullable();
            $table->json('id_card_image')->nullable();
            $table->date('hiring_date')->nullable();      // تاريخ التوظيف
            $table->date('contract_date')->nullable();      // تاريخ التوظيف
            $table->date('termination_date')->nullable(); // تاريخ انتهاء الخدمة (لو applicable)
            $table->json('cv')->nullable();
            $table->timestamps();
            // علاقات
            $table->foreign('project_code')->references('code')->on('users_projects');
            $table->foreign('job_title_id')->references('id')->on('users_job_titles')->nullOnDelete();
            // Indexes
            $table->index('project_code');
            $table->index('job_title_id');
        });

        // 🔁 تحديث جدول المشاريع الآن بربط مدير المشروع (بعد ما اتعمل جدول الموظفين)
        Schema::table('users_projects', function (Blueprint $table) {
            $table->foreign('manager_id')->references('id')->on('users_employees')->onDelete('set null');
        });


        Schema::create('users_employees_review', function (Blueprint $table) {
            $table->id();
            $table->string('project_code')->nullable();
            $table->string('employee_code')->nullable();
            $table->json('full_name')->nullable();
            $table->string('phone')->nullable();
            $table->unsignedBigInteger('job_title_id')->nullable();
            $table->string('national_id', 14)->nullable();
            $table->date('birth_date')->nullable();
            $table->json('governorate')->nullable();
            $table->enum('gender', ['male', 'female'])->nullable();
            $table->string('id_card_image')->nullable();
            $table->json('cv')->nullable();
            $table->enum('status', ['new', 'matched', 'updated', 'not_found'])->default('new');
            $table->json('differences')->nullable(); // 🆕 الفروقات بين النسخة القديمة والجديدة
            $table->unsignedBigInteger('reviewed_by')->nullable(); // من راجعها
            $table->timestamp('reviewed_at')->nullable();          // متى تمت المراجعة
            $table->timestamps();
        });

        Schema::create('users_employees_cv_codes', function (Blueprint $table) {
            $table->id();
            $table->string('project_code');
            $table->string('code')->unique();
            $table->string('name'); // الوصف او اسم الشخص اللي الكود اتولد له
            $table->boolean('used')->default(false);
            $table->unsignedBigInteger('created_by');
            $table->timestamps();
        });



    }

    public function down()
    {

        Schema::dropIfExists('users_employees_cv_codes');
        Schema::dropIfExists('users_employees_review');


        // لازم نحذف ال foreign key manager_id قبل حذف الجدول
        Schema::table('users_projects', function (Blueprint $table) {
            $table->dropForeign(['manager_id']);
        });

        Schema::dropIfExists('users_employees'); // ده لازم ييجي بعد ما نفك ال FK من projects
        Schema::dropIfExists('users_job_titles');
        Schema::dropIfExists('users_projects');
    }
};
