<?php

use App\Http\Middleware\HasTwoFactorSecret;
use App\Http\Middleware\TwoFactorAuthenticator;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;


return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->alias([
            'two-factor' => TwoFactorAuthenticator::class,
            'has-two-factor' => HasTwoFactorSecret::class,

        ]);

        $middleware->web(append: [
            App\Http\Middleware\SettingsMiddleware::class,
            // 'check.access' => \App\Http\Middleware\CheckUserPermission::class,

        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
