<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\Auth;
use App\Helpers\AppSettings;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        App::setLocale(session('locale', config('app.locale')));
        View::composer('*', function ($view) {
            $view->with('lang', AppSettings::language());
            $view->with('dark', AppSettings::darkMode());
            $view->with('jobTitle', AppSettings::jobTitle());
            $view->with('avatar', AppSettings::avatar());
            $view->with('settings', AppSettings::all());
        });




        Blade::if('access', function (string $page, string $element = null) {
            $user = Auth::user();
            if (! $user) return false;

            $pages    = $user->pages['page']    ?? [];
            $elements = $user->pages['element'] ?? [];

            // لا بدّ من صلاحية الصفحة
            if (! (in_array('[all]', $pages, true) || in_array($page, $pages, true))) {
                return false;
            }

            // إذا طلبت عنصرًا محدّدًا، تحقّق منه أيضًا
            if ($element) {
                $pageEls = $elements[$page] ?? [];
                if (! (in_array('[all]', $pages, true) || in_array($element, $pageEls, true))) {
                    return false;
                }
            }
            return true;
        });
    }
}
