<?php

namespace App\Models\TimeKeeper;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\User;
use App\Models\UserEmployee;

class AttendanceException extends Model
{
    protected $table = 'employees_tk_attendance_exceptions';

    protected $fillable = [
        'employee_id',
        'exception_date',
        'type',
        'reason',
        'approved_by',
    ];

    protected $casts = [
        'exception_date' => 'date',
    ];

    public function employee(): BelongsTo
    {
        return $this->belongsTo(UserEmployee::class, 'employee_id');
    }

    public function approvedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'approved_by');
    }
}
