<?php

namespace App\Models\System;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class SystemParent extends Model
{
    protected $table = 'system_parents';

    public $timestamps = false;

    protected $fillable = [
        'name_en',
        'name_ar',
        'icon',
        'color_name',
        'color_icon',
        'order',
    ];


    public function routes(): HasMany
    {
        return $this->hasMany(SystemRoute::class, 'parent_id');
    }
}
