<?php

namespace App\Models\System;

use Illuminate\Database\Eloquent\Model;

class SystemMailSetting extends Model
{
    protected $table = 'system_mail_settings';

    protected $fillable = [
        'status',
        'mail_from_address',
        'mail_from_name',
        'smtp_host',
        'smtp_port',
        'username',
        'password',
        'encryption',
        'attachment_size_limit',
    ];

    protected $casts = [
        'status' => 'boolean',
        'attachment_size_limit' => 'integer',
    ];
}
