<?php

namespace App\Models\Emp;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\User\UserProject;

class UserEmployeeCvCode extends Model
{
    protected $table = 'users_employees_cv_codes';

    protected $fillable = [
        'project_code',
        'code',
        'name',
        'used',
        'created_by',
    ];

    protected $casts = [
        'used' => 'boolean',
    ];


    public function project(): BelongsTo
    {
        // العمود المحلّى = project_code، العمود فى جدول المشاريع = code
        return $this->belongsTo(UserProject::class, 'project_code', 'code');
    }
}
