<?php

namespace App\Models\Emp;

use App\Models\User\UserEmployee;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class EmployeeDepartment extends Model
{
    protected $table = 'employees_departments';

    protected $fillable = [
        'name_en',
        'name_ar',
        'description',
        'order',
    ];

    public function employees(): HasMany
    {
        return $this->hasMany(UserEmployee::class, 'department_id');
    }
}
