<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class SettingsMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        //language system
        $locale = Session::get('locale', 'en');
        Session::put('locale', $locale);
        App::setLocale($locale);





        // Check if the user is authenticated
        if (Auth::check()) {
            $user = Auth::user();
            $routeName = $request->route()->getName();
            $SettingsRoutes = [ 'livewire.update', 'livewire.upload-file', 'livewire.preview-file', 'livewire.message', 'storage.local','logout', 'set.language', 'update.darkmode', 'lock.screen', 'user-profile', 'two-factor-verify'];

            $allowedRoutes = [
                'inactive' => ['activate.inactive', ...$SettingsRoutes],
                'block' => ['activate.block', ...$SettingsRoutes],
                'rejected' => ['activate.rejected', ...$SettingsRoutes],
                'suspended' => ['activate.suspended', ...$SettingsRoutes],
            ];
            $restrictedPagesForActive = [
                'active' => ['activate.inactive', 'activate.block', 'activate.rejected', 'activate.suspended']

            ];

            // // If the user is active and not already on the dashboard route

            if (array_key_exists($user->user_state, $restrictedPagesForActive) && in_array($routeName, $restrictedPagesForActive[$user->user_state])) {
                return redirect()->route('dashboard');
            }

            if (array_key_exists($user->user_state, $allowedRoutes) && !in_array($routeName, $allowedRoutes[$user->user_state])) {
                return redirect()->route('activate.' . strtolower($user->user_state));
            }

            if (!in_array($user->user_state, ['active', 'inactive', 'block', 'rejected', 'suspended'])) {
                abort(403, __('frontend.account_review_msg'));
            }

            if (
                $user->user_state === 'active' &&
                is_null($user->two_factor_secret) &&
                !in_array($routeName, array_merge(['activate-two-factor'], $SettingsRoutes))
            ) {
                return redirect()->route('activate-two-factor');
            }

            // ///Lock system
            $settings = $user->settings ?? [];
            $isLocked = is_array($settings) ? ($settings['is_locked'] ?? false) : false;

            // لو الحساب مقفول، ومش داخل واحدة من الصفحات المسموح بيها
            if ($isLocked && !in_array($routeName, $SettingsRoutes)) {
                return redirect()->route('lock.screen');
            }

            // لو الحساب مش مقفول، والمستخدم بيحاول يفتح صفحة القفل
            if (!$isLocked && $routeName === 'lock.screen') {
                return redirect()->route('dashboard');
            }

// ✅ الحالة الخاصة: المستخدم مفعل 2FA فعلاً، وبيحاول يدخل صفحة تفعيلها مرة تانية
if (
    $routeName === 'activate-two-factor' &&
    $user->two_factor_secret !== null
) {
    return redirect()->route('dashboard');
}

            // // Pages permission check
// المستخدم مفعل فعليًا 2FA وبيحاول يزور صفحة التفعيل من غير داعي
if (
    $user->user_state === 'active' &&
    $routeName !== 'dashboard' &&
    !$user->hasAccessToRoute($routeName) &&
    !in_array($routeName, $SettingsRoutes)
) {
    return redirect()->route('dashboard');
}

        }



        return $next($request);
    }
}
