<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User; // تأكد من استيراد نموذج User

class LocaleController extends Controller
{
    public function setLocale($lang)
    {
        // تحقق من أن اللغة المدخلة مدعومة
        if (in_array($lang, ['en', 'ar'])) {
            // ضبط اللغة العامة للتطبيق
            App::setLocale($lang);

            // حفظ اللغة في الجلسة
            Session::put('locale', $lang);

            // إذا كان المستخدم مسجل دخولًا، احفظ اللغة في قاعدة البيانات
            if (Auth::check()) {
                /** @var User $user */
                $user = Auth::user();

                $settings = $user->settings ?? []; // لو null نخليها array فاضي

                // نحول لـ array لو كانت string (أحيانًا ممكن تكون string json)
                if (is_string($settings)) {
                    $settings = json_decode($settings, true) ?? [];
                }

                $settings['language'] = $lang; // نحط أو نعدل اللغة

                $user->settings = $settings;
                $user->save();
            }
        }

        return back();
    }
    public function updateDarkMode($id)
    {
        if (Auth::check()) {
            /** @var User $user */
            $user = Auth::user();

            $settings = $user->settings ?? [];

            if (is_string($settings)) {
                $settings = json_decode($settings, true) ?? [];
            }

            // عكس الحالة الحالية
            $settings['dark_mode'] = !($settings['dark_mode'] ?? false);

            $user->settings = $settings;
            $user->save();
        }

        return back();
    }

    // public function updatelock($id)
    // {
    //     if (Auth::check()) {
    //         /** @var User $user */
    //         $user = Auth::user(); // وضّح أن Auth::user() يعيد نموذج User
    //         $user->is_locked = !$user->is_locked; // تبديل الحالة
    //         $user->save();
    //     }
    //     return back();
    // }

    // public function unlock(Request $request)
    // {
    //     // التحقق من كلمة المرور
    //     $request->validate([
    //         'password' => 'required',
    //     ]);

    //     if (!Hash::check($request->password, Auth::user()->password)) {
    //         return back()->withErrors(['password' => 'The provided password is incorrect.']);
    //     }

    //     // فك القفل
    //     $user = Auth::user();
    //     $user->is_locked = false;
    //     $user->save();

    //     // إعادة التوجيه إلى الصفحة الرئيسية أو أي مكان آخر
    //     return redirect()->route('dashboard')->with('success', 'Your account has been unlocked.');
    // }

}
