<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Str;



class AppSettings
{
    public static function all(): array
    {
        $user = Auth::user();
        $settings = $user?->settings ?? [];

        $lang = $settings['language'] ?? config('app.locale', 'ar');
        $dark = $settings['dark_mode'] ?? false;
        $jobTitle = $settings["job_title_{$lang}"] ?? 'موظف';
        $avatar = $settings['avatar'] ?? strtoupper(Str::substr($user->name ?? '??', 0, 2));

        return [
            'language' => $lang,
            'dark_mode' => $dark,
            'job_title' => $jobTitle,
            'avatar' => $avatar,
        ];
    }

    public static function language()
    {
        return self::all()['language'];
    }

    public static function darkMode()
    {
        return self::all()['dark_mode'];
    }

    public static function jobTitle()
    {
        return self::all()['job_title'];
    }

    public static function avatar()
    {
        return self::all()['avatar'];
    }
}
