<?php
// Test JSON validity
$jsonFile = 'public/assets/languages/en.json';
$json = file_get_contents($jsonFile);
$data = json_decode($json, true);

if ($data === null) {
    echo "JSON Error in $jsonFile: " . json_last_error_msg() . PHP_EOL;
} else {
    echo "✅ JSON is valid!" . PHP_EOL;
    echo "nav.ranking: " . $data['nav']['ranking'] . PHP_EOL;
    echo "welcome.rankings exists: " . (isset($data['welcome']['rankings']) ? 'Yes' : 'No') . PHP_EOL;

    if (isset($data['welcome']['rankings'])) {
        echo "welcome.rankings.character: " . $data['welcome']['rankings']['character'] . PHP_EOL;
    }
}

// Test Arabic file too
$jsonFileAr = 'public/assets/languages/ar.json';
$jsonAr = file_get_contents($jsonFileAr);
$dataAr = json_decode($jsonAr, true);

if ($dataAr === null) {
    echo "JSON Error in $jsonFileAr: " . json_last_error_msg() . PHP_EOL;
} else {
    echo "✅ Arabic JSON is valid!" . PHP_EOL;
    echo "nav.ranking (AR): " . $dataAr['nav']['ranking'] . PHP_EOL;
    echo "rankings exists (AR): " . (isset($dataAr['rankings']) ? 'Yes' : 'No') . PHP_EOL;
}
?>
