<!-- Tablet Header Content -->
<!-- Navigation data is loaded from resources/data/navigation.json via get_navigation_data() function -->

<?php
    $navigation = get_navigation_data();
?>
<div class="header-tablet">
    <!-- Row 1: Logo and Navigation -->
    <div class="header-row-1-tablet">
        <!-- Logo Section -->
        <div class="logo-section-tablet">
            <div class="logo-container-tablet">
                <div class="logo-wrapper-tablet">
                    <div class="logo-inner-tablet">
                        <?php if($navigation['logo']['type'] === 'image'): ?>
                            <?php
                                $isRTL = in_array(app()->getLocale(), ['ar', 'he', 'fa', 'ur']);
                                $logoImage = $isRTL
                                    ? $navigation['logo']['image_rtl'] ?? $navigation['logo']['image_ltr']
                                    : $navigation['logo']['image_ltr'];
                            ?>
                            <a
                                href="<?php echo e($navigation['logo']['is_route'] ? route($navigation['logo']['link']) : $navigation['logo']['link']); ?>">
                                <img src="<?php echo e($logoImage); ?>" alt="<?php echo e($navigation['logo']['alt']); ?>" />
                            </a>
                        <?php else: ?>
                            <?php
                                $isRTL = in_array(app()->getLocale(), ['ar', 'he', 'fa', 'ur']);
                                $logoText = $isRTL
                                    ? $navigation['logo']['text_rtl'] ?? $navigation['logo']['text_ltr']
                                    : $navigation['logo']['text_ltr'];
                            ?>
                            <a href="<?php echo e($navigation['logo']['is_route'] ? route($navigation['logo']['link']) : $navigation['logo']['link']); ?>"
                                class="logo-text-link">
                                <span class="logo-title-tablet" data-translate="hero.title"><?php echo e($logoText); ?></span>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php if($navigation['logo']['type'] === 'image'): ?>
                <div class="logo-text-tablet">
                    <span class="logo-title-tablet" data-translate="hero.title">4TresSro</span>
                    <span class="logo-subtitle-tablet" data-translate="hero.subtitle">Epic RPG Adventure</span>
                </div>
            <?php endif; ?>
        </div>

        <!-- Tablet Navigation Menu -->
        <div class="nav-section-tablet">
            <div class="nav-links-container-tablet">
                <!-- Primary Navigation Items -->
                <?php $__currentLoopData = $navigation['navigation']['primary']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(
                        $item['visibility'] === 'all' ||
                            ($item['visibility'] === 'guest' && !Auth::check()) ||
                            ($item['visibility'] === 'auth' && Auth::check())
                    ): ?>
                        <a href="<?php echo e($item['is_route'] ?? false ? route($item['route']) : $item['route']); ?>"
                            class="nav-item-tablet primary <?php echo e(active_class($item['active'] ?: '')); ?>">
                            <i class="<?php echo e($item['icon']); ?>"></i>
                            <span data-translate="<?php echo e($item['label']); ?>"><?php echo e($item['title']); ?></span>
                        </a>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <!-- Dropdown Menu for Other Items -->
                <div class="dropdown-tablet">
                    <a href="#"
                        class="nav-item-tablet dropdown-trigger-tablet <?php echo e(collect($navigation['navigation']['dropdown'])->contains(function ($item) {return active_class($item['active'] ?: '');})? 'active': ''); ?>">
                        <i class="<?php echo e($navigation['dropdown_trigger']['icon']); ?>"></i>
                        <span
                            data-translate="<?php echo e($navigation['dropdown_trigger']['label']); ?>"><?php echo e($navigation['dropdown_trigger']['title']); ?></span>
                        <i class="fas fa-chevron-down dropdown-arrow-tablet"></i>
                    </a>
                    <div class="dropdown-content-tablet">
                        <?php $__currentLoopData = $navigation['navigation']['dropdown']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(
                                $item['visibility'] === 'all' ||
                                    ($item['visibility'] === 'guest' && !Auth::check()) ||
                                    ($item['visibility'] === 'auth' && Auth::check())
                            ): ?>
                                <a href="<?php echo e($item['is_route'] ?? false ? route($item['route']) : $item['route']); ?>"
                                    class="dropdown-item-tablet <?php echo e(active_class($item['active'] ?: '')); ?>">
                                    <i class="<?php echo e($item['icon']); ?>"></i>
                                    <span data-translate="<?php echo e($item['label']); ?>"><?php echo e($item['title']); ?></span>
                                </a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Row 2: Action Items -->
    <div class="header-row-2-tablet">
        <!-- Tablet Action Section -->
        <div class="action-section-tablet">
            <!-- Language Switcher - Will be populated by MultiLanguageManager -->
            <div class="language-switcher"></div>
            <!-- Balance Display for Tablet -->

            <?php if(Auth::check()): ?>
                <div class="balance-display-tablet">
                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('balance-head', ['type' => 'tablet']);

$__html = app('livewire')->mount($__name, $__params, 'lw-118194304-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                </div>
                            <!-- Elegant Divider -->
            <div class="action-divider-tablet"></div>
            <?php endif; ?>


            <!-- Auth Buttons Group -->
            <div class="auth-buttons-group-tablet">
                <?php if(Auth::check()): ?>
                    <!-- Notification Icons -->
                   <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('notifications', ['type' => 'tablet']);

$__html = app('livewire')->mount($__name, $__params, 'lw-118194304-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>



                    <!-- User Dropdown Menu -->
                    <div class="user-dropdown-container-tablet">
                        <button class="user-dropdown-trigger-tablet">
                            <div class="user-avatar-tablet">
                                <i class="fas fa-user-circle"></i>
                            </div>
                            <div class="user-info-tablet">
                                <span class="user-greeting-tablet" data-translate="user.welcome">Welcome</span>
                                <span class="user-name-tablet"><?php echo e(Auth::user()->username); ?></span>
                            </div>
                            <i class="fas fa-chevron-down dropdown-arrow-tablet"></i>
                        </button>

                        <div class="user-dropdown-menu-tablet">
                            <!-- User Header -->
                            <div class="user-dropdown-header-tablet">
                                <div class="user-avatar-large-tablet">
                                    <i class="fas fa-user-circle"></i>
                                </div>
                                <div class="user-details-tablet">
                                    <h4 class="user-fullname-tablet"><?php echo e(Auth::user()->username); ?></h4>
                                    <p class="user-status-tablet">Premium Player</p>
                                </div>
                            </div>

                            <!-- Balance Section -->
                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('balance-head', ['type' => 'menu']);

$__html = app('livewire')->mount($__name, $__params, 'lw-118194304-2', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

                            <!-- Menu Items -->
                            <div class="dropdown-menu-items-tablet">
                                <?php $__currentLoopData = $navigation['navigation']['user_menu']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(
                                        $item['visibility'] === 'all' ||
                                            ($item['visibility'] === 'guest' && !Auth::check()) ||
                                            ($item['visibility'] === 'auth' && Auth::check())
                                    ): ?>
                                        <a href="<?php echo e($item['is_route'] ?? false ? route($item['route']) : $item['route']); ?>"
                                            class="dropdown-menu-item-tablet <?php echo e(active_class($item['active'] ?: '')); ?>">
                                            <i class="<?php echo e($item['icon']); ?>"></i>
                                            <span data-translate="<?php echo e($item['label']); ?>"><?php echo e($item['title']); ?></span>
                                        </a>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <?php if(Auth::user()->hasRoleLevel(3)): ?>
                                    <a href="<?php echo e(route('team-dashboard')); ?>" class="dropdown-menu-item-tablet team-dashboard-link">
                                        <i class="fas fa-users-cog"></i>
                                        <span data-translate="team.dashboard.title">Team Dashboard</span>
                                    </a>
                                <?php endif; ?>
                            </div>

                            <!-- Logout Section -->
                            <div class="dropdown-divider-tablet"></div>
                            <form method="POST" action="<?php echo e(route('logout')); ?>" class="dropdown-logout-form-tablet">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="dropdown-menu-item-tablet logout-btn-tablet">
                                    <i class="fas fa-sign-out-alt"></i>
                                    <span data-translate="user.logout">Logout</span>
                                </button>
                            </form>
                        </div>
                    </div>
                <?php else: ?>
                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('auth.register', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-118194304-3', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('auth.login', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-118194304-4', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views/components/layouts/struct/partials/main/header-tablet.blade.php ENDPATH**/ ?>