<?php

use Livewire\Volt\Component;
use App\Models\Z_Website\Download;
use App\Models\Z_Website\SiteSettings;
use App\Helpers\SiteSettingsHelper;
use Illuminate\Support\Facades\Cache;
use Carbon\Carbon;

?>

<div class="min-h-screen bg-gradient-to-br from-slate-900 via-purple-900 to-slate-900">

    <!-- Hero Section -->
    <div class="relative overflow-hidden">
        <!-- Background Effects -->
        <div class="absolute inset-0 bg-gradient-to-br from-purple-900/20 to-cyan-900/20"></div>
        <div class="absolute inset-0 bg-[url('/assets/silkroad-bg.jpg')] bg-cover bg-center opacity-10"></div>

        <!-- Animated Background Elements -->
        <div class="absolute inset-0 overflow-hidden pointer-events-none">
            <div class="absolute top-20 left-10 w-64 h-64 bg-purple-500/10 rounded-full blur-3xl animate-pulse"></div>
            <div class="absolute bottom-20 right-10 w-96 h-96 bg-cyan-500/10 rounded-full blur-3xl animate-pulse delay-1000"></div>
            <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-128 h-128 bg-purple-600/5 rounded-full blur-3xl animate-pulse delay-500"></div>
        </div>

        <div class="relative container mx-auto px-6 py-24">
            <div class="text-center">
                <!-- Download Icon -->
                <div class="inline-flex items-center justify-center w-32 h-32 mb-8 bg-gradient-to-br from-purple-500 to-cyan-500 rounded-full shadow-2xl">
                    <svg class="w-16 h-16 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3M3 17V7a2 2 0 012-2h6l2 2h6a2 2 0 012 2v10a2 2 0 01-2 2H5a2 2 0 01-2-2z"></path>
                    </svg>
                </div>

                <h1 class="text-6xl font-bold mb-6 bg-gradient-to-r from-purple-400 to-cyan-400 bg-clip-text text-transparent">
                    <span data-translate="download.title">Download Game</span>
                </h1>
                <p class="text-xl text-purple-100 mb-8 max-w-3xl mx-auto leading-relaxed">
                    <span data-translate="download.subtitle">Download the complete 4TresSRO Online client and start your epic adventure in the ancient 4TresSro world</span>
                </p>

                <!-- Quick Stats -->
                <div class="flex flex-wrap justify-center gap-8 text-white/80 mb-8">
                    <div class="flex items-center gap-2">
                        <span class="w-2 h-2 bg-green-400 rounded-full animate-pulse"></span>
                        <span data-translate="download.serverOnline">Server Online</span>
                    </div>
                    <div class="flex items-center gap-2">
                        <span>📦</span>
                        <span><?php echo e($downloadStats['client_size']); ?></span>
                    </div>
                    <div class="flex items-center gap-2">
                        <span>🔄</span>
                        <span data-translate="download.lastUpdated">Last Updated</span>: <?php echo e($downloadStats['last_update']); ?>

                    </div>
                </div>

                <!-- Server Information -->
                <div class="bg-slate-800/50 backdrop-blur-lg border border-purple-500/30 rounded-2xl p-6 max-w-4xl mx-auto">
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-center">
                        <div class="bg-gradient-to-br from-purple-600/20 to-cyan-600/20 rounded-xl p-4">
                            <div class="text-2xl font-bold text-white"><?php echo e($downloadStats['level_cap']); ?></div>
                            <div class="text-sm text-purple-300" data-translate="welcome.levelCap">Level Cap</div>
                        </div>
                        <div class="bg-gradient-to-br from-purple-600/20 to-cyan-600/20 rounded-xl p-4">
                            <div class="text-2xl font-bold text-white"><?php echo e($downloadStats['exp_rate']); ?>x</div>
                            <div class="text-sm text-purple-300" data-translate="welcome.expRate">EXP Rate</div>
                        </div>
                        <div class="bg-gradient-to-br from-purple-600/20 to-cyan-600/20 rounded-xl p-4">
                            <div class="text-2xl font-bold text-white"><?php echo e($downloadStats['drop_rate']); ?>x</div>
                            <div class="text-sm text-purple-300" data-translate="welcome.dropRate">Drop Rate</div>
                        </div>
                        <div class="bg-gradient-to-br from-purple-600/20 to-cyan-600/20 rounded-xl p-4">
                            <div class="text-2xl font-bold text-white"><?php echo e($downloadStats['max_server']); ?></div>
                            <div class="text-sm text-purple-300" data-translate="download.maxPlayers">Max Players</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Download Tabs Section -->
    <div class="container mx-auto px-6 py-16">
        <!-- Tab Navigation -->
        <div class="flex flex-wrap justify-center gap-4 mb-12">
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = [
                ['key' => 'client', 'label' => 'Game Client', 'icon' => '🎮'],
                ['key' => 'tools', 'label' => 'Tools & Utilities', 'icon' => '🔧'],
                ['key' => 'requirements', 'label' => 'System Requirements', 'icon' => '💻']
            ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <button
                    wire:click="setActiveTab('<?php echo e($tab['key']); ?>')"
                    class="flex items-center gap-3 px-6 py-3 rounded-xl transition-all duration-300 <?php echo e($activeTab === $tab['key'] ? 'bg-gradient-to-r from-purple-500 to-cyan-500 text-white shadow-lg' : 'bg-slate-700/50 text-purple-200 hover:bg-slate-600/50'); ?>">
                    <span class="text-xl"><?php echo e($tab['icon']); ?></span>
                    <span data-translate="download.<?php echo e($tab['key']); ?>"><?php echo e($tab['label']); ?></span>
                </button>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
        </div>

        <!-- Tab Content -->
        <div class="transition-all duration-500">

            <!-- Game Client Tab -->
            <!--[if BLOCK]><![endif]--><?php if($activeTab === 'client'): ?>
                <div class="space-y-8">
                    <!-- Main Download Card -->
                    <div class="bg-gradient-to-br from-slate-800/50 to-purple-900/30 backdrop-blur-lg border border-purple-500/30 rounded-2xl p-8 shadow-2xl">
                        <div class="flex flex-col lg:flex-row items-center gap-8">
                            <!-- Game Logo/Image -->
                            <div class="flex-shrink-0">
                                <div class="w-32 h-32 bg-gradient-to-br from-purple-500 to-cyan-500 rounded-2xl flex items-center justify-center shadow-xl p-4">
                                    <img src="/assets/logo-small.png" alt="4TresSRO Logo" class="w-full h-full object-contain">
                                </div>
                            </div>

                            <!-- Download Info -->
                            <div class="flex-grow text-center lg:text-left">
                                <h3 class="text-3xl font-bold text-white mb-4">
                                    <span data-translate="download.fullClient">4TresSRO Online - Full Client</span>
                                </h3>
                                <p class="text-purple-200 mb-6 text-lg">
                                    <span data-translate="download.clientDescription">Complete game client with all latest updates and features</span>
                                </p>

                                <!-- Download Stats -->
                                <div class="flex flex-wrap justify-center lg:justify-start gap-6 text-sm text-purple-300 mb-6">
                                    <div class="flex items-center gap-2">
                                        <span>📊</span>
                                        <span data-translate="download.version">Version</span>: <?php echo e($downloadStats['server_version']); ?>

                                    </div>
                                    <div class="flex items-center gap-2">
                                        <span>💾</span>
                                        <span data-translate="download.size">Size</span>: <?php echo e($downloadStats['client_size']); ?>

                                    </div>
                                    <div class="flex items-center gap-2">
                                        <span>⬇️</span>
                                        <span data-translate="download.downloads">Downloads</span>: <?php echo e($downloadStats['total_downloads']); ?>

                                    </div>
                                </div>

                                <!-- Download Options -->
                    <?php
                        $clientDownloads = collect($downloads)->where('category', 'client');
                    ?>

                    <!--[if BLOCK]><![endif]--><?php if($clientDownloads->count() > 0): ?>
                        <!-- All Download Options Grid -->
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $clientDownloads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $download): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="bg-slate-700/50 backdrop-blur-lg border border-purple-500/20 rounded-xl p-6 hover:border-purple-400/40 transition-all duration-300 hover:transform hover:scale-105 group">
                                    <!-- Platform Logo -->
                                    <div class="text-center mb-4">
                                        <!--[if BLOCK]><![endif]--><?php if($download['icon']): ?>
                                            <!-- عرض الأيقونة من قاعدة البيانات -->
                                            <!--[if BLOCK]><![endif]--><?php if(str_starts_with($download['icon'], '<svg')): ?>
                                                <!-- SVG Icon من قاعدة البيانات -->
                                                <div class="w-16 h-16 mx-auto bg-white rounded-full flex items-center justify-center shadow-lg">
                                                    <?php echo $download['icon']; ?>

                                                </div>
                                            <?php else: ?>
                                                <!-- مسار صورة من قاعدة البيانات -->
                                                <div class="w-16 h-16 mx-auto rounded-full flex items-center justify-center shadow-lg overflow-hidden">
                                                    <img src="<?php echo e($download['icon']); ?>" alt="<?php echo e($download['name']); ?>" class="w-full h-full object-cover">
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            <h4 class="text-lg font-bold text-white mt-2"><?php echo e($download['name']); ?></h4>
                                        <?php else: ?>
                                            <!-- أيقونة افتراضية -->
                                            <div class="w-16 h-16 mx-auto bg-purple-600 rounded-full flex items-center justify-center shadow-lg">
                                                <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3"></path>
                                                </svg>
                                            </div>
                                            <h4 class="text-lg font-bold text-white mt-2"><?php echo e($download['name']); ?></h4>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>

                                    <!-- Download Info -->
                                    <div class="text-center mb-4">
                                        <!--[if BLOCK]><![endif]--><?php if($download['description']): ?>
                                            <p class="text-purple-200 text-sm mb-3"><?php echo e(\Str::limit($download['description'], 60)); ?></p>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                        <div class="flex justify-between items-center text-xs text-purple-300 mb-4">
                                            <span><?php echo e($download['file_size']); ?></span>
                                            <!--[if BLOCK]><![endif]--><?php if($download['version']): ?>
                                                <span class="bg-purple-600 text-white px-2 py-1 rounded">
                                                    <span data-translate="download.versionPrefix">v</span><?php echo e($download['version']); ?>

                                                </span>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>

                                    <!-- Download Button -->
                                    <a href="<?php echo e($download['link']); ?>"
                                       target="_blank"
                                       wire:click="trackDownload(<?php echo e($download['id']); ?>, '<?php echo e($download['name']); ?>')"
                                       class="block w-full text-center px-4 py-3 bg-gradient-to-r from-purple-600 to-cyan-600 hover:from-purple-700 hover:to-cyan-700 text-white rounded-lg font-bold transition-all duration-300 group-hover:shadow-xl">
                                        <div class="flex items-center justify-center gap-2">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3"></path>
                                            </svg>
                                            <span data-translate="download.download">Download</span>
                                        </div>
                                    </a>

                                    <!-- Download Count -->
                                    <div class="text-center mt-3 text-xs text-purple-400">
                                        <span>⬇️ <?php echo e(number_format($download['download_count'])); ?> <span data-translate="download.downloads">downloads</span></span>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    <?php else: ?>
                        <div class="text-center">
                            <div class="inline-flex items-center gap-3 px-8 py-4 bg-slate-600 text-slate-300 rounded-xl font-bold text-lg cursor-not-allowed">
                                <span data-translate="download.comingSoon">Coming Soon</span>
                            </div>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        </div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <!-- Tools & Utilities Tab -->
            <?php if($activeTab === 'tools'): ?>
                <?php
                    $toolDownloads = collect($downloads)->where('category', 'tool');
                ?>

                <!--[if BLOCK]><![endif]--><?php if($toolDownloads->count() > 0): ?>
                    <div class="space-y-4">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $toolDownloads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tool): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="bg-slate-700/50 backdrop-blur-lg border border-purple-500/20 rounded-xl p-6 hover:border-purple-400/40 transition-all duration-300 hover:transform hover:scale-[1.02]">
                                <div class="flex items-center gap-6">
                                    <!-- Icon Column -->
                                    <div class="flex-shrink-0">
                                        <!--[if BLOCK]><![endif]--><?php if($tool['icon']): ?>
                                            <!-- عرض الأيقونة من قاعدة البيانات -->
                                            <!--[if BLOCK]><![endif]--><?php if(str_starts_with($tool['icon'], '<svg')): ?>
                                                <!-- SVG Icon من قاعدة البيانات -->
                                                <div class="w-16 h-16 bg-gradient-to-br from-purple-500 to-pink-500 rounded-xl flex items-center justify-center shadow-lg">
                                                    <?php echo $tool['icon']; ?>

                                                </div>
                                            <?php else: ?>
                                                <!-- مسار صورة من قاعدة البيانات -->
                                                <div class="w-16 h-16 rounded-xl flex items-center justify-center shadow-lg overflow-hidden">
                                                    <img src="<?php echo e($tool['icon']); ?>" alt="<?php echo e($tool['name']); ?>" class="w-full h-full object-cover">
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        <?php else: ?>
                                            <!-- أيقونة افتراضية -->
                                            <div class="w-16 h-16 bg-gradient-to-br from-gray-500 to-slate-500 rounded-xl flex items-center justify-center shadow-lg">
                                                <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3"></path>
                                                </svg>
                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>

                                    <!-- Content Column -->
                                    <div class="flex-grow">
                                        <div class="flex justify-between items-start mb-2">
                                            <h4 class="text-xl font-bold text-white"><?php echo e($tool['name']); ?></h4>
                                            <!--[if BLOCK]><![endif]--><?php if($tool['version']): ?>
                                                <span class="text-xs bg-purple-600 text-white px-2 py-1 rounded ml-2">
                                                    <span data-translate="download.versionPrefix">v</span><?php echo e($tool['version']); ?>

                                                </span>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <!--[if BLOCK]><![endif]--><?php if($tool['description']): ?>
                                            <p class="text-purple-200 text-sm mb-3"><?php echo e($tool['description']); ?></p>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                        <div class="flex items-center justify-between">
                                            <div class="flex items-center gap-4 text-sm text-purple-300">
                                                <span class="flex items-center gap-1">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12"></path>
                                                    </svg>
                                                    <?php echo e($tool['file_size']); ?>

                                                </span>
                                                <span class="flex items-center gap-1">
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3"></path>
                                                    </svg>
                                                    <?php echo e(number_format($tool['download_count'])); ?> <span data-translate="download.downloads">downloads</span>
                                                </span>
                                            </div>

                                            <a href="<?php echo e($tool['link']); ?>"
                                               target="_blank"
                                               wire:click="trackDownload(<?php echo e($tool['id']); ?>, '<?php echo e($tool['name']); ?>')"
                                               class="inline-flex items-center gap-2 px-6 py-2 bg-gradient-to-r from-purple-600 to-cyan-600 hover:from-purple-700 hover:to-cyan-700 text-white rounded-lg font-medium transition-all duration-300 shadow-md hover:shadow-lg">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3"></path>
                                                </svg>
                                                <span data-translate="download.download">Download</span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                <?php else: ?>
                    <!-- Default Tools when no database tools exist -->
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = [
                            ['name' => '.NET Framework 4.8', 'name_key' => 'download.netFramework', 'description' => 'Required runtime for the game', 'desc_key' => 'download.netFrameworkDesc', 'icon' => '⚙️', 'url' => 'https://dotnet.microsoft.com/download/dotnet-framework/net48'],
                            ['name' => 'Visual C++ Redistributable', 'name_key' => 'download.visualCpp', 'description' => 'Microsoft Visual C++ runtime libraries', 'desc_key' => 'download.visualCppDesc', 'icon' => '🔧', 'url' => 'https://support.microsoft.com/help/2977003/the-latest-supported-visual-c-downloads'],
                            ['name' => 'DirectX End-User Runtime', 'name_key' => 'download.directx', 'description' => 'DirectX runtime for enhanced graphics', 'desc_key' => 'download.directxDesc', 'icon' => '🎮', 'url' => 'https://www.microsoft.com/download/details.aspx?id=35'],
                            ['name' => 'Game Guide PDF', 'name_key' => 'download.gameGuidePdf', 'description' => 'Complete beginner guide', 'desc_key' => 'download.gameGuideDesc', 'icon' => '📖', 'url' => '#'],
                            ['name' => 'Character Creation Tool', 'name_key' => 'download.characterCreationTool', 'description' => 'Plan your character build', 'desc_key' => 'download.characterToolDesc', 'icon' => '👤', 'url' => '#'],
                            ['name' => 'Trade Calculator', 'name_key' => 'download.tradeCalculator', 'description' => 'Calculate trade profits', 'desc_key' => 'download.tradeCalcDesc', 'icon' => '💰', 'url' => '#']
                        ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tool): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="bg-slate-700/50 backdrop-blur-lg border border-purple-500/20 rounded-xl p-6 hover:border-purple-400/40 transition-all duration-300 hover:transform hover:scale-105">
                                <div class="text-4xl mb-4"><?php echo e($tool['icon']); ?></div>
                                <h4 class="text-xl font-bold text-white mb-2">
                                    <span data-translate="<?php echo e($tool['name_key']); ?>"><?php echo e($tool['name']); ?></span>
                                </h4>
                                <p class="text-purple-200 text-sm mb-4">
                                    <span data-translate="<?php echo e($tool['desc_key']); ?>"><?php echo e($tool['description']); ?></span>
                                </p>
                                <a href="<?php echo e($tool['url']); ?>"
                                   target="_blank"
                                   class="inline-flex items-center gap-2 px-4 py-2 bg-purple-600 hover:bg-purple-700 text-white rounded-lg transition-colors text-sm">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3"></path>
                                    </svg>
                                    <span data-translate="download.download">Download</span>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <!-- System Requirements Tab -->
            <!--[if BLOCK]><![endif]--><?php if($activeTab === 'requirements'): ?>
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                    <!-- Minimum Requirements -->
                    <div class="bg-gradient-to-br from-slate-800/50 to-orange-900/30 backdrop-blur-lg border border-orange-500/30 rounded-2xl p-8 shadow-2xl">
                        <div class="flex items-center gap-3 mb-6">
                            <div class="w-12 h-12 bg-orange-500 rounded-xl flex items-center justify-center">
                                <span class="text-2xl">⚠️</span>
                            </div>
                            <h3 class="text-2xl font-bold text-white">
                                <span data-translate="download.minimumRequirements">Minimum Requirements</span>
                            </h3>
                        </div>

                        <div class="space-y-4">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $systemRequirements['minimum']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex justify-between items-center py-2 border-b border-orange-500/20">
                                    <span class="text-orange-200 font-medium" data-translate="requirements.<?php echo e($key); ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $key))); ?>:
                                    </span>
                                    <span class="text-white text-sm"><?php echo e($value); ?></span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>

                    <!-- Recommended Requirements -->
                    <div class="bg-gradient-to-br from-slate-800/50 to-green-900/30 backdrop-blur-lg border border-green-500/30 rounded-2xl p-8 shadow-2xl">
                        <div class="flex items-center gap-3 mb-6">
                            <div class="w-12 h-12 bg-green-500 rounded-xl flex items-center justify-center">
                                <span class="text-2xl">✅</span>
                            </div>
                            <h3 class="text-2xl font-bold text-white">
                                <span data-translate="download.recommendedRequirements">Recommended Requirements</span>
                            </h3>
                        </div>

                        <div class="space-y-4">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $systemRequirements['recommended']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex justify-between items-center py-2 border-b border-green-500/20">
                                    <span class="text-green-200 font-medium" data-translate="requirements.<?php echo e($key); ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $key))); ?>:
                                    </span>
                                    <span class="text-white text-sm"><?php echo e($value); ?></span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                </div>

                <!-- Installation Instructions -->
                <div class="mt-12 bg-slate-700/50 backdrop-blur-lg border border-purple-500/20 rounded-2xl p-8">
                    <h3 class="text-2xl font-bold text-white mb-6 flex items-center gap-3">
                        <span class="text-3xl">📋</span>
                        <span data-translate="download.installationGuide">Installation Guide</span>
                    </h3>

                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = [
                            ['step' => '1', 'title' => 'Download Prerequisites', 'desc' => 'Install .NET Framework 4.8 and Visual C++ Redistributable'],
                            ['step' => '2', 'title' => 'Download Client', 'desc' => 'Download the full game client using the link above'],
                            ['step' => '3', 'title' => 'Extract & Install', 'desc' => 'Extract the downloaded file and run the installer'],
                            ['step' => '4', 'title' => 'Create Account', 'desc' => 'Register an account and start playing']
                        ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instruction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="text-center">
                                <div class="w-16 h-16 bg-gradient-to-br from-purple-500 to-cyan-500 rounded-full flex items-center justify-center text-white text-2xl font-bold mx-auto mb-4">
                                    <?php echo e($instruction['step']); ?>

                                </div>
                                <h4 class="text-lg font-bold text-white mb-2" data-translate="install.step<?php echo e($instruction['step']); ?>Title">
                                    <?php echo e($instruction['title']); ?>

                                </h4>
                                <p class="text-purple-200 text-sm" data-translate="install.step<?php echo e($instruction['step']); ?>Desc">
                                    <?php echo e($instruction['desc']); ?>

                                </p>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>

    <!-- Support Section -->
    <div class="container mx-auto px-6 py-16">
        <div class="bg-gradient-to-br from-slate-800/50 to-cyan-900/30 backdrop-blur-lg border border-cyan-500/30 rounded-2xl p-8 shadow-2xl">
            <div class="text-center">
                <h3 class="text-3xl font-bold text-white mb-4">
                    <span data-translate="download.needHelp">Need Help?</span>
                </h3>
                <p class="text-cyan-200 mb-8 max-w-2xl mx-auto">
                    <span data-translate="download.supportDescription">Having trouble downloading or installing? Our support team is here to help you get started on your adventure.</span>
                </p>

                <div class="flex flex-wrap justify-center gap-4">
                    <!-- Discord Live Chat -->
                    <!--[if BLOCK]><![endif]--><?php if($downloadStats['discord_invite']): ?>
                        <a href="<?php echo e($downloadStats['discord_invite']); ?>"
                           target="_blank"
                           class="flex items-center gap-2 px-6 py-3 bg-cyan-600 hover:bg-cyan-700 text-white rounded-xl transition-colors">
                            <span>💬</span>
                            <span data-translate="download.liveChat">Live Chat</span>
                        </a>
                    <?php else: ?>
                        <a href="#" class="flex items-center gap-2 px-6 py-3 bg-cyan-600 hover:bg-cyan-700 text-white rounded-xl transition-colors">
                            <span>💬</span>
                            <span data-translate="download.liveChat">Live Chat</span>
                        </a>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    <!-- Email Support -->
                    <a href="mailto:<?php echo e($downloadStats['contact_email']); ?>"
                       class="flex items-center gap-2 px-6 py-3 bg-purple-600 hover:bg-purple-700 text-white rounded-xl transition-colors">
                        <span>📧</span>
                        <span data-translate="download.emailSupport">Email Support</span>
                    </a>

                    <!-- Facebook Page -->
                    <!--[if BLOCK]><![endif]--><?php if($downloadStats['facebook_url'] !== '#'): ?>
                        <a href="<?php echo e($downloadStats['facebook_url']); ?>"
                           target="_blank"
                           class="flex items-center gap-2 px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white rounded-xl transition-colors">
                            <span>📘</span>
                            <span data-translate="social.facebook">Facebook</span>
                        </a>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    <!-- YouTube Channel -->
                    <!--[if BLOCK]><![endif]--><?php if($downloadStats['youtube_url'] !== '#'): ?>
                        <a href="<?php echo e($downloadStats['youtube_url']); ?>"
                           target="_blank"
                           class="flex items-center gap-2 px-6 py-3 bg-red-600 hover:bg-red-700 text-white rounded-xl transition-colors">
                            <span>📺</span>
                            <span data-translate="social.youtube">YouTube</span>
                        </a>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    <!-- FAQ -->
                    <a href="#" class="flex items-center gap-2 px-6 py-3 bg-slate-600 hover:bg-slate-700 text-white rounded-xl transition-colors">
                        <span>❓</span>
                        <span data-translate="download.faq">FAQ</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Refresh Button -->
    <div class="fixed bottom-6 left-6 z-50">
        <button wire:click="refreshDownloads"
                class="flex items-center gap-2 px-4 py-2 bg-purple-600 hover:bg-purple-700 text-white rounded-lg shadow-lg transition-colors">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
            </svg>
            <span data-translate="download.refresh">Refresh</span>
        </button>
    </div>
</div><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/frontend/download.blade.php ENDPATH**/ ?>