
    <!-- Enhanced Professional Footer -->
<footer class="footer-container">
    <!-- Animated background particles -->
    <div class="footer-particles">
        <div class="footer-particle" style="left: 10%; animation-delay: 0s;"></div>
        <div class="footer-particle" style="left: 20%; animation-delay: 2s;"></div>
        <div class="footer-particle" style="left: 30%; animation-delay: 4s;"></div>
        <div class="footer-particle" style="left: 40%; animation-delay: 6s;"></div>
        <div class="footer-particle" style="left: 50%; animation-delay: 8s;"></div>
        <div class="footer-particle" style="left: 60%; animation-delay: 10s;"></div>
        <div class="footer-particle" style="left: 70%; animation-delay: 12s;"></div>
        <div class="footer-particle" style="left: 80%; animation-delay: 14s;"></div>
        <div class="footer-particle" style="left: 90%; animation-delay: 16s;"></div>
    </div>

    <div class="footer-content">
        <div class="container mx-auto px-6">
            <div class="grid md:grid-cols-4 gap-8 mb-8">
                <!-- Logo & Description -->
                <div class="md:col-span-2 footer-section">
                    <div class="footer-logo">
                        <div class="footer-logo-icon">
                            <img
                                src="/assets/logo.png"
                                alt="4TresSro Logo"
                                class="w-8 h-8 object-contain relative z-10"
                            />
                        </div>
                        <span class="footer-logo-text" data-translate="footer.gameTitle">4TresSro</span>
                    </div>
                    <p class="footer-description" data-translate="footer.description">
                        Step into a world where every battle writes your legend. Join warriors worldwide and forge your destiny in the ultimate RPG adventure.
                    </p>
                    <div class="footer-social-links">
                        <a href="https://facebook.com/4TresSro" target="_blank" class="footer-social-btn facebook"
                           aria-label="Facebook">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                            </svg>
                        </a>
                        <a href="https://web.facebook.com/groups/4tressro/" target="_blank" class="footer-social-btn facebook-group"
                           aria-label="Facebook Group">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                                <circle cx="16" cy="8" r="3" fill="#fff"/>
                                <circle cx="18" cy="6" r="2" fill="currentColor"/>
                            </svg>
                        </a>
                        <a href="https://discord.com/invite/hQNdpz8QXq" target="_blank" class="footer-social-btn discord"
                           aria-label="Discord">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M20.317 4.37a19.791 19.791 0 0 0-4.885-1.515.074.074 0 0 0-.079.037c-.21.375-.444.864-.608 1.25a18.27 18.27 0 0 0-5.487 0 12.64 12.64 0 0 0-.617-1.25.077.077 0 0 0-.079-.037A19.736 19.736 0 0 0 3.677 4.37a.07.07 0 0 0-.032.027C.533 9.046-.32 13.58.099 18.057a.082.082 0 0 0 .031.057 19.9 19.9 0 0 0 5.993 3.03.078.078 0 0 0 .084-.028c.462-.63.874-1.295 1.226-1.994a.076.076 0 0 0-.041-.106 13.107 13.107 0 0 1-1.872-.892.077.077 0 0 1-.008-.128 10.2 10.2 0 0 0 .372-.292.074.074 0 0 1 .077-.01c3.928 1.793 8.18 1.793 12.062 0a.074.074 0 0 1 .078.01c.12.098.246.198.373.292a.077.077 0 0 1-.006.127 12.299 12.299 0 0 1-1.873.892.077.077 0 0 0-.041.107c.36.698.772 1.362 1.225 1.993a.076.076 0 0 0 .084.028 19.839 19.839 0 0 0 6.002-3.03.077.077 0 0 0 .032-.054c.5-5.177-.838-9.674-3.549-13.66a.061.061 0 0 0-.031-.03zM8.02 15.33c-1.183 0-2.157-1.085-2.157-2.419 0-1.333.956-2.419 2.157-2.419 1.21 0 2.176 1.096 2.157 2.42 0 1.333-.956 2.418-2.157 2.418zm7.975 0c-1.183 0-2.157-1.085-2.157-2.419 0-1.333.955-2.419 2.157-2.419 1.21 0 2.176 1.096 2.157 2.42 0 1.333-.946 2.418-2.157 2.418z"/>
                            </svg>
                        </a>
                        <a href="https://youtube.com/@4TresSro" target="_blank" class="footer-social-btn youtube"
                           aria-label="YouTube">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>
                            </svg>
                        </a>
                    </div>
                </div>

                <!-- Quick Links -->
                <div class="footer-section">
                    <h4 class="footer-section-title" data-translate="footer.quickLinks">Quick Links</h4>
                    <ul class="footer-links">
                        <li>
                            <a href="#home" class="footer-link" data-translate="nav.home">Home</a>
                        </li>
                        <li>
                            <a href="#about" class="footer-link" data-translate="footer.about">About</a>
                        </li>
                        <li>
                            <a href="#download" class="footer-link" data-translate="footer.download">Download</a>
                        </li>
                        <li>
                            <a href="#news" class="footer-link" data-translate="footer.news">News</a>
                        </li>
                        <li>
                            <a href="#community" class="footer-link" data-translate="footer.community">Community</a>
                        </li>
                    </ul>
                </div>

                <!-- Support -->
                <div class="footer-section">
                    <h4 class="footer-section-title" data-translate="footer.support">Support</h4>
                    <ul class="footer-links">
                        <li>
                            <a href="#support" class="footer-link" data-translate="footer.helpCenter">Help Center</a>
                        </li>
                        <li>
                            <a href="#contact" class="footer-link" data-translate="footer.contactUs">Contact Us</a>
                        </li>
                        <li>
                            <a href="#privacy" class="footer-link" data-translate="footer.privacyPolicy">Privacy Policy</a>
                        </li>
                        <li>
                            <a href="#terms" class="footer-link" data-translate="footer.termsOfService">Terms of Service</a>
                        </li>
                        <li>
                            <a href="#dmca" class="footer-link" data-translate="footer.dmca">DMCA</a>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Copyright -->
            <div class="footer-copyright">
                <p class="footer-copyright-text" data-translate="footer.copyright">
                    © 2024 4TresSro. All rights reserved. Made with ❤️ for gamers worldwide.
                </p>
            </div>
        </div>
    </div>
</footer>

<script>
// Enhanced Footer Animation and Interaction
document.addEventListener('DOMContentLoaded', function() {
    const footer = document.querySelector('.footer-container');
    const sections = document.querySelectorAll('.footer-section');

    // Intersection Observer for footer entrance animation
    const footerObserver = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('animate-in');

                // Animate sections with stagger effect
                sections.forEach((section, index) => {
                    setTimeout(() => {
                        section.style.opacity = '1';
                        section.style.transform = 'translateY(0)';
                    }, index * 150);
                });
            }
        });
    }, {
        threshold: 0.1,
        rootMargin: '0px 0px -100px 0px'
    });

    if (footer) {
        footerObserver.observe(footer);
    }

    // Create dynamic particles
    function createFooterParticles() {
        const particlesContainer = document.querySelector('.footer-particles');
        if (!particlesContainer) return;

        // Clear existing particles
        particlesContainer.innerHTML = '';

        const particleCount = window.innerWidth < 768 ? 5 : 10;

        for (let i = 0; i < particleCount; i++) {
            const particle = document.createElement('div');
            particle.className = 'footer-particle';
            particle.style.left = Math.random() * 100 + '%';
            particle.style.animationDelay = Math.random() * 15 + 's';
            particle.style.animationDuration = (12 + Math.random() * 8) + 's';

            particlesContainer.appendChild(particle);
        }
    }

    // Initialize particles
    createFooterParticles();

    // Recreate particles on window resize
    let resizeTimeout;
    window.addEventListener('resize', () => {
        clearTimeout(resizeTimeout);
        resizeTimeout = setTimeout(createFooterParticles, 250);
    });

    // Enhanced hover effects for social buttons
    const socialButtons = document.querySelectorAll('.footer-social-btn');
    socialButtons.forEach(btn => {
        btn.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-8px) scale(1.1) rotate(5deg)';
        });

        btn.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0) scale(1) rotate(0deg)';
        });

        // Add click ripple effect
        btn.addEventListener('click', function(e) {
            const ripple = document.createElement('span');
            const rect = this.getBoundingClientRect();
            const size = Math.max(rect.width, rect.height);
            const x = e.clientX - rect.left - size / 2;
            const y = e.clientY - rect.top - size / 2;

            ripple.style.cssText = `
                position: absolute;
                width: ${size}px;
                height: ${size}px;
                left: ${x}px;
                top: ${y}px;
                background: rgba(255, 255, 255, 0.3);
                border-radius: 50%;
                transform: scale(0);
                animation: footerRipple 0.6s linear;
                pointer-events: none;
                z-index: 10;
            `;

            this.appendChild(ripple);

            setTimeout(() => {
                ripple.remove();
            }, 600);
        });
    });

    // Enhanced link hover effects
    const footerLinks = document.querySelectorAll('.footer-link');
    footerLinks.forEach(link => {
        link.addEventListener('mouseenter', function() {
            this.style.paddingLeft = '10px';
        });

        link.addEventListener('mouseleave', function() {
            this.style.paddingLeft = '0px';
        });
    });

    // RTL support for link animations
    const isRTL = document.documentElement.dir === 'rtl';
    if (isRTL) {
        footerLinks.forEach(link => {
            link.addEventListener('mouseenter', function() {
                this.style.paddingRight = '10px';
                this.style.paddingLeft = '0px';
            });

            link.addEventListener('mouseleave', function() {
                this.style.paddingRight = '0px';
            });
        });
    }
});

// Add ripple animation CSS
const footerStyle = document.createElement('style');
footerStyle.textContent = `
    @keyframes footerRipple {
        to {
            transform: scale(4);
            opacity: 0;
        }
    }

    .footer-social-btn {
        position: relative;
        overflow: hidden;
    }

    .footer-link {
        transition: all 0.3s ease, padding-left 0.3s ease, padding-right 0.3s ease;
    }
`;
document.head.appendChild(footerStyle);
</script>



<?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views/components/layouts/struct/partials/main/footer.blade.php ENDPATH**/ ?>