<?php

use Livewire\Volt\Component;
use App\Models\GameInfo;
use Livewire\Attributes\Url;

?>

<div>
<div class="game-info-container">
    <div class="container mx-auto px-6 py-8">

        <!--[if BLOCK]><![endif]--><?php if(!$this->selectedGuideObject): ?>
            <!-- Header Section -->
            <div class="mb-8 text-center">
                <div class="game-info-header rounded-2xl p-8 shadow-2xl">
                    <!-- Content -->
                    <div class="relative z-10">
                        <h1 class="game-info-title mb-4" data-translate="gameInfo.title">
                            🎮 Game Info & Guides
                        </h1>
                        <p class="text-xl text-gray-300 max-w-3xl mx-auto mb-6" data-translate="gameInfo.subtitle">
                            Discover comprehensive guides, tips, and essential information to master your gaming experience
                        </p>

                        <!-- Search Bar -->
                        <div class="game-info-search">
                            <input
                                type="text"
                                wire:model.live.debounce.300ms="searchTerm"
                                placeholder="Search guides..."
                                data-translate-placeholder="gameInfo.searchPlaceholder"
                            >
                            <svg class="game-info-search-icon w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>

                            <!-- Loading indicator -->
                            <div wire:loading wire:target="searchTerm" class="absolute inset-y-0 right-12 flex items-center">
                                <div class="animate-spin h-4 w-4 border-2 border-blue-500 border-t-transparent rounded-full"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Content Grid -->
            <div class="grid grid-cols-1 lg:grid-cols-4 gap-8">

                <!-- Sidebar - Categories -->
                <div class="lg:col-span-1">
                    <div class="game-info-sidebar">
                        <h3>
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-400 inline">
                                <line x1="8" y1="6" x2="21" y2="6"/>
                                <line x1="8" y1="12" x2="21" y2="12"/>
                                <line x1="8" y1="18" x2="21" y2="18"/>
                                <line x1="3" y1="6" x2="3.01" y2="6"/>
                                <line x1="3" y1="12" x2="3.01" y2="12"/>
                                <line x1="3" y1="18" x2="3.01" y2="18"/>
                            </svg>
                            <span data-translate="gameInfo.categories">Categories</span>
                        </h3>

                        <div class="space-y-2">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button
                                    wire:click="selectCategory('<?php echo e($category); ?>')"
                                    class="game-info-category-btn <?php echo e($selectedCategory === $category ? 'active' : ''); ?>"
                                    data-category="<?php echo e($category); ?>"
                                    wire:loading.class="opacity-50"
                                    wire:target="selectCategory('<?php echo e($category); ?>')"
                                >
                                    <span>
                                        <!--[if BLOCK]><![endif]--><?php if($category === 'All'): ?>
                                            🌟 <span data-translate="gameInfo.all">All</span>
                                        <?php else: ?>
                                            <?php echo e($category); ?>

                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </span>
                                    <span class="game-info-category-count">
                                        <?php echo e($categoryCounts[$category] ?? 0); ?>

                                    </span>

                                    <!-- Loading indicator for category -->
                                    <div wire:loading wire:target="selectCategory('<?php echo e($category); ?>')" class="absolute inset-0 flex items-center justify-center bg-gray-900/50 rounded-xl">
                                        <div class="animate-spin h-4 w-4 border-2 border-blue-500 border-t-transparent rounded-full"></div>
                                    </div>
                                </button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                </div>

                <!-- Main Content - Guides List -->
                <div class="lg:col-span-3">
                    <!-- Loading overlay -->
                    <div wire:loading wire:target="selectCategory,searchTerm" class="absolute inset-0 bg-gray-900/50 backdrop-blur-sm rounded-2xl flex items-center justify-center z-50">
                        <div class="text-center">
                            <div class="animate-spin h-8 w-8 border-4 border-blue-500 border-t-transparent rounded-full mx-auto mb-3"></div>
                            <p class="text-white font-medium" data-translate="gameInfo.loading">Loading guides...</p>
                        </div>
                    </div>

                    <!--[if BLOCK]><![endif]--><?php if($gameInfos->isEmpty()): ?>
                        <!-- No Guides Found -->
                        <div class="game-info-empty">
                            <div class="game-info-empty-icon">
                                <svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="11" cy="11" r="8"/>
                                    <path d="m21 21-4.35-4.35"/>
                                </svg>
                            </div>
                            <h3 class="text-2xl font-bold mb-2" data-translate="gameInfo.noGuidesFound">No Guides Found</h3>
                            <p>
                                <!--[if BLOCK]><![endif]--><?php if($searchTerm): ?>
                                    <span data-translate="gameInfo.noSearchResults" data-translate-values='{"search": "<?php echo e($searchTerm); ?>", "category": "<?php echo e($selectedCategory === 'All' ? __('gameInfo.allCategories') : $selectedCategory); ?>"}'>
                                        No guides found for "<?php echo e($searchTerm); ?>" in <?php echo e($selectedCategory === 'All' ? 'all categories' : $selectedCategory); ?>

                                    </span>
                                <?php else: ?>
                                    <span data-translate="gameInfo.noGuidesMessage" data-translate-values='{"category": "<?php echo e($selectedCategory === 'All' ? __('gameInfo.allCategories') : $selectedCategory); ?>"}'>
                                        No guides available in <?php echo e($selectedCategory === 'All' ? 'any category' : $selectedCategory); ?>

                                    </span>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </p>

                            <!--[if BLOCK]><![endif]--><?php if($searchTerm): ?>
                                <button
                                    wire:click="$set('searchTerm', '')"
                                    class="mt-4 px-4 py-2 bg-blue-600 hover:bg-blue-500 text-white rounded-xl transition-colors duration-300"
                                    data-translate="gameInfo.clearSearch"
                                >
                                    Clear Search
                                </button>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    <?php else: ?>
                        <!-- Guides Grid -->
                        <div class="game-info-grid">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $gameInfos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $guide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="game-info-card">
                                    <!-- Guide Image -->
                                    <div class="game-info-card-image">
                                        <img
                                            src="<?php echo e($guide->image_url); ?>"
                                            alt="<?php echo e($guide->title); ?>"
                                        >
                                        <div class="game-info-card-overlay"></div>

                                        <!-- Category Badge -->
                                        <div class="game-info-card-badge">
                                            <?php echo e($guide->category_name); ?>

                                        </div>
                                    </div>

                                    <!-- Guide Content -->
                                    <div class="game-info-card-content">
                                        <h3 class="game-info-card-title">
                                            <?php echo e($guide->title); ?>

                                        </h3>

                                        <p class="game-info-card-excerpt">
                                            <?php echo e(Str::limit(strip_tags($guide->body), 120)); ?>

                                        </p>

                                        <!-- View More Button -->
                                        <button
                                            wire:click="viewGuide(<?php echo e($guide->id); ?>)"
                                            class="game-info-card-btn"
                                        >
                                            <span data-translate="gameInfo.viewGuide">View Guide</span>
                                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                <line x1="5" y1="12" x2="19" y2="12"/>
                                                <polyline points="12,5 19,12 12,19"/>
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>

        <?php else: ?>
            <!-- Single Guide View -->
            <!--[if BLOCK]><![endif]--><?php if($this->selectedGuideObject): ?>
            <div class="game-info-single">

                <!-- Back Button -->
                <button
                    wire:click="backToCategory"
                    class="game-info-back-btn"
                >
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="19" y1="12" x2="5" y2="12"/>
                        <polyline points="12,19 5,12 12,5"/>
                    </svg>
                    <span data-translate="gameInfo.backTo" data-translate-values='{"category": "<?php echo e($selectedCategory); ?>"}'>Back to <?php echo e($selectedCategory); ?></span>
                </button>

                <!-- Guide Content -->
                <article class="game-info-article">
                    <!-- Guide Header -->
                    <div class="game-info-article-header">
                        <img
                            src="<?php echo e($this->selectedGuideObject->image_url); ?>"
                            alt="<?php echo e($this->selectedGuideObject->title); ?>"
                        >
                        <div class="game-info-article-overlay"></div>

                        <!-- Title Overlay -->
                        <div class="game-info-article-meta">
                            <span class="game-info-article-category">
                                <?php echo e($this->selectedGuideObject->category_name); ?>

                            </span>
                            <h1 class="game-info-article-title">
                                <?php echo e($this->selectedGuideObject->title); ?>

                            </h1>
                        </div>
                    </div>

                    <!-- Guide Body -->
                    <div class="game-info-article-body">
                        <div class="game-content-processed">
                            <?php echo nl2br($this->processContent($this->selectedGuideObject->body)); ?>

                        </div>
                    </div>
                </article>
            </div>
            <?php else: ?>
                <!-- Guide not found -->
                <div class="text-center py-16">
                    <div class="text-red-400 text-6xl mb-4">
                        <svg width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mx-auto">
                            <path d="M10.29 3.86L1.82 18a2 2 0 001.71 3h16.94a2 2 0 001.71-3L13.71 3.86a2 2 0 00-3.42 0z"/>
                            <line x1="12" y1="9" x2="12" y2="13"/>
                            <line x1="12" y1="17" x2="12.01" y2="17"/>
                        </svg>
                    </div>
                    <h2 class="text-2xl font-bold text-white mb-4" data-translate="gameInfo.guideNotFound">Guide Not Found</h2>
                    <p class="text-gray-300 mb-6" data-translate="gameInfo.guideNotFoundMessage">The guide you're looking for doesn't exist or has been removed.</p>
                    <button
                        wire:click="backToCategory"
                        class="px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white rounded-lg transition-colors"
                    >
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2">
                            <line x1="19" y1="12" x2="5" y2="12"/>
                            <polyline points="12,19 5,12 12,5"/>
                        </svg>
                        <span data-translate="gameInfo.backToGuides">Back to Guides</span>
                    </button>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    </div>
</div>
</div><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/frontend/game-info.blade.php ENDPATH**/ ?>