<?php

use Livewire\Volt\Component;
use Illuminate\Support\Facades\Auth;

?>

<div class="responsive-dashboard-container">
    <!-- Desktop Dashboard - Visible only on large screens -->
    <div class="desktop-only">
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.dashboard-parts.desktop', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-1742443007-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    </div>

    <!-- Tablet Dashboard - Visible only on medium screens -->
    <div class="tablet-only">
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.dashboard-parts.tablet', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-1742443007-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    </div>

    <!-- Mobile Dashboard - Visible only on small screens -->
    <div class="mobile-only">
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.dashboard-parts.mobile', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-1742443007-2', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    </div>




    <script>
function copyToClipboard(text) {
    // Create a temporary textarea element
    const textarea = document.createElement('textarea');
    textarea.value = text;
    document.body.appendChild(textarea);

    // Select and copy the text
    textarea.select();
    textarea.setSelectionRange(0, 99999); // For mobile devices

    try {
        document.execCommand('copy');

        // Show success message
        showCopyMessage('✅ Copied to clipboard!', 'success');
    } catch (err) {
        // Fallback for modern browsers
        if (navigator.clipboard) {
            navigator.clipboard.writeText(text).then(() => {
                showCopyMessage('✅ Copied to clipboard!', 'success');
            }).catch(() => {
                showCopyMessage('❌ Failed to copy', 'error');
            });
        } else {
            showCopyMessage('❌ Copy not supported', 'error');
        }
    }

    // Remove the temporary element
    document.body.removeChild(textarea);
}

function showCopyMessage(message, type) {
    // Remove existing message if any
    const existingMessage = document.querySelector('.copy-message');
    if (existingMessage) {
        existingMessage.remove();
    }

    // Create message element
    const messageEl = document.createElement('div');
    messageEl.className = `copy-message copy-${type}`;
    messageEl.textContent = message;
    messageEl.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        background: ${type === 'success' ? 'linear-gradient(135deg, #22c55e, #16a34a)' : 'linear-gradient(135deg, #ef4444, #dc2626)'};
        color: white;
        padding: 12px 20px;
        border-radius: 12px;
        font-weight: 600;
        font-size: 14px;
        box-shadow: 0 8px 25px rgba(0,0,0,0.3);
        z-index: 10000;
        animation: slideIn 0.3s ease-out;
        border: 2px solid ${type === 'success' ? '#22c55e' : '#ef4444'};
    `;

    // Add keyframes for animation
    if (!document.querySelector('#copy-animation-styles')) {
        const style = document.createElement('style');
        style.id = 'copy-animation-styles';
        style.textContent = `
            @keyframes slideIn {
                from {
                    opacity: 0;
                    transform: translateX(100px);
                }
                to {
                    opacity: 1;
                    transform: translateX(0);
                }
            }
            @keyframes slideOut {
                from {
                    opacity: 1;
                    transform: translateX(0);
                }
                to {
                    opacity: 0;
                    transform: translateX(100px);
                }
            }
        `;
        document.head.appendChild(style);
    }

    // Add to page
    document.body.appendChild(messageEl);

    // Auto remove after 3 seconds
    setTimeout(() => {
        messageEl.style.animation = 'slideOut 0.3s ease-in';
        setTimeout(() => {
            if (messageEl.parentNode) {
                messageEl.remove();
            }
        }, 300);
    }, 3000);
}
</script>

</div><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/backend/dashboard.blade.php ENDPATH**/ ?>