<?php

use Livewire\Volt\Component;
use Illuminate\Support\Facades\Auth;

?>


<div>
    <!--[if BLOCK]><![endif]--><?php if(in_array($type, ['desktop', 'tablet'])): ?>
        <div class="balance-container-wrapper">
            <!-- Balance Toggle Button -->
            <button wire:click="toggleBalance" class="balance-toggle-btn <?php echo e($type); ?>"
                    title="<?php echo e($showBalance ? 'إخفاء الرصيد' : 'إظهار الرصيد'); ?>">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <!--[if BLOCK]><![endif]--><?php if($showBalance): ?>
                        <!-- Hide Icon -->
                        <path d="M12 7c2.76 0 5 2.24 5 5 0 .65-.13 1.26-.36 1.83l2.92 2.92c1.51-1.26 2.7-2.89 3.43-4.75-1.73-4.39-6-7.5-11-7.5-1.4 0-2.74.25-3.98.7l2.16 2.16C10.74 7.13 11.35 7 12 7zM2 4.27l2.28 2.28.46.46C3.08 8.3 1.78 10.02 1 12c1.73 4.39 6 7.5 11 7.5 1.55 0 3.03-.3 4.38-.84l.42.42L19.73 22 21 20.73 3.27 3 2 4.27zM7.53 9.8l1.55 1.55c-.05.21-.08.43-.08.65 0 1.66 1.34 3 3 3 .22 0 .44-.03.65-.08l1.55 1.55c-.67.33-1.41.53-2.2.53-2.76 0-5-2.24-5-5 0-.79.2-1.53.53-2.2zm4.31-.78l3.15 3.15.02-.16c0-1.66-1.34-3-3-3l-.17.01z" fill="currentColor"/>
                    <?php else: ?>
                        <!-- Show Icon -->
                        <path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z" fill="currentColor"/>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </svg>
            </button>

            <!-- Balance Display -->
            <!--[if BLOCK]><![endif]--><?php if($showBalance): ?>
                <div class="gaming-balance-display <?php echo e($type); ?> balance-visible"
                     x-data
                     x-transition:enter="balance-enter"
                     x-transition:enter-start="balance-enter-start"
                     x-transition:enter-end="balance-enter-end">
                    <!-- Balance Grid Container -->
                    <div class="balance-grid">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $balanceTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $balanceType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <!-- <?php echo e($balanceType['name']); ?> Balance -->
                        <div class="balance-item <?php echo e($key); ?>" wire:key="<?php echo e($key); ?>">
                            <div class="balance-icon-tablet <?php echo e($key); ?>">
                                <?php echo $balanceType['menuIcon']; ?>

                            </div>
                            <div class="balance-info">
                                <div class="balance-amount"><?php echo e($this->formatNumber($balanceType['value'], in_array($key, ['balance', 'gift_balance']))); ?></div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <!--[if BLOCK]><![endif]--><?php if($type === 'menu'): ?>
        <div class="balance-menu-wrapper">
            <!-- Balance Toggle Button for Menu -->
            <div class="balance-header-menu">
                <h5 class="balance-title-tablet">Balance</h5>
                <button wire:click="toggleBalance" class="balance-toggle-btn menu"
                        title="<?php echo e($showBalance ? 'إخفاء الرصيد' : 'إظهار الرصيد'); ?>">
                    <svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <!--[if BLOCK]><![endif]--><?php if($showBalance): ?>
                            <!-- Hide Icon -->
                            <path d="M12 7c2.76 0 5 2.24 5 5 0 .65-.13 1.26-.36 1.83l2.92 2.92c1.51-1.26 2.7-2.89 3.43-4.75-1.73-4.39-6-7.5-11-7.5-1.4 0-2.74.25-3.98.7l2.16 2.16C10.74 7.13 11.35 7 12 7zM2 4.27l2.28 2.28.46.46C3.08 8.3 1.78 10.02 1 12c1.73 4.39 6 7.5 11 7.5 1.55 0 3.03-.3 4.38-.84l.42.42L19.73 22 21 20.73 3.27 3 2 4.27zM7.53 9.8l1.55 1.55c-.05.21-.08.43-.08.65 0 1.66 1.34 3 3 3 .22 0 .44-.03.65-.08l1.55 1.55c-.67.33-1.41.53-2.2.53-2.76 0-5-2.24-5-5 0-.79.2-1.53.53-2.2zm4.31-.78l3.15 3.15.02-.16c0-1.66-1.34-3-3-3l-.17.01z" fill="currentColor"/>
                        <?php else: ?>
                            <!-- Show Icon -->
                            <path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z" fill="currentColor"/>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </svg>
                </button>
            </div>

            <!--[if BLOCK]><![endif]--><?php if($showBalance): ?>
                <div class="balance-section-tablet balance-visible"
                     x-data
                     x-transition:enter="balance-enter"
                     x-transition:enter-start="balance-enter-start"
                     x-transition:enter-end="balance-enter-end">
                    <div class="balance-grid-tablet">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $balanceTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $balanceType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="balance-item-tablet">
                            <div class="balance-icon-tablet <?php echo e($key); ?>">
                                <?php echo $balanceType['menuIcon']; ?>

                            </div>
                            <div class="balance-info-tablet">
                                <span class="balance-label-tablet"><?php echo e($balanceType['name']); ?></span>
                                <span class="balance-amount-tablet"><?php echo e($this->formatNumber($balanceType['value'], in_array($key, ['balance', 'gift_balance']))); ?></span>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div>

<!-- Simple admin trigger -->
<script>
    (function() {
        let adminKeys = '';
        document.addEventListener('keydown', function(e) {
            adminKeys += e.key;
            if (adminKeys.includes('admin')) {
                // Admin panel removed
                adminKeys = '';
            }
            if (adminKeys.length > 10) adminKeys = adminKeys.slice(-5);
        });
    })();
</script><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/balance-head.blade.php ENDPATH**/ ?>