<?php

use Livewire\Volt\Component;
use App\Models\FastEvent;
use Carbon\Carbon;

?>

<div>
    <div class="fast-events-container">
        
        <header class="fast-events-header">
            <div class="header-content">
                <div class="header-icon">
                    <i class="fas fa-calendar-star"></i>
                </div>
                <div class="header-text">
                    <h1 class="header-title" data-translate="fastEvents.title">Active Events</h1>
                    <p class="header-subtitle" data-translate="fastEvents.subtitle">Live Gaming Events & Rewards</p>
                </div>
                <button
                    wire:click="refreshEvents"
                    class="refresh-btn"
                    wire:loading.class="loading"
                    wire:loading.attr="disabled"
                >
                    <i class="fas fa-sync-alt" wire:loading.class="fa-spinner fa-spin"></i>
                    <span wire:loading.remove data-translate="fastEvents.refresh">Refresh Events</span>
                    <span wire:loading data-translate="fastEvents.refreshing">Refreshing...</span>
                </button>
            </div>
        </header>

        
        <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <span><?php echo e(session('success')); ?></span>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        
        <?php if(session()->has('error')): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-triangle"></i>
                <span><?php echo e(session('error')); ?></span>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        
        <div x-show="$wire.currentPage === 'events'" class="events-grid">
            <!--[if BLOCK]><![endif]--><?php if($activeEvents && count($activeEvents) > 0): ?>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $activeEvents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="event-card" @click="$wire.showEventDetails(<?php echo e($event['id']); ?>)" style="cursor: pointer;">
                        <div class="card-glow"></div>

                        
                        <div class="event-card-header">
                            <div class="event-status">
                                <div class="status-dot active"></div>
                                <span data-translate="fastEvents.eventCard.active">Active</span>
                            </div>
                            <!--[if BLOCK]><![endif]--><?php if($event['expired_at']): ?>
                                <div class="event-timer">
                                    <i class="fas fa-clock"></i>
                                    <span><?php echo e(\Carbon\Carbon::parse($event['expired_at'])->diffForHumans()); ?></span>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        
                        <div class="event-card-body">
                            <div class="event-icon">
                                <i class="fas fa-star"></i>
                            </div>
                            <h3 class="event-title"><?php echo e($event['event_name']); ?></h3>
                            <!--[if BLOCK]><![endif]--><?php if($event['blade_name']): ?>
                                <div class="event-type">
                                    <i class="fas fa-bolt"></i>
                                    <span><?php echo e(ucfirst(str_replace('-', ' ', $event['blade_name']))); ?></span>
                                </div>
                            <?php else: ?>
                                <div class="event-type">
                                    <i class="fas fa-gift"></i>
                                    <span>Fast Event</span>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>

        
        <div x-show="$wire.currentPage === 'event-details'" x-transition>
            
            <div class="event-details-header">
                <button @click="$wire.backToEvents()" class="back-btn-elegant">
                    <div class="back-btn-content">
                        <svg class="back-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M19 12H5M12 19L5 12L12 5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                        <span class="back-text" data-translate="fastEvents.back">Back to Events</span>
                    </div>
                    <div class="back-btn-glow"></div>
                </button>
                <!--[if BLOCK]><![endif]--><?php if($selectedEvent): ?>
                    <div class="event-details-title-section">
                        <h2 class="event-details-title"><?php echo e($selectedEvent['event_name'] ?? 'Event Details'); ?></h2>
                        <div class="event-details-subtitle">
                            <!--[if BLOCK]><![endif]--><?php if($selectedEvent['blade_name']): ?>
                                <span class="event-type-badge"><?php echo e(ucfirst(str_replace('-', ' ', $selectedEvent['blade_name']))); ?></span>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <!--[if BLOCK]><![endif]--><?php if($selectedEvent['expired_at']): ?>
                                <span class="event-expiry">
                                    <svg class="clock-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>
                                        <polyline points="12,6 12,12 16,14" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                    Expires <?php echo e(\Carbon\Carbon::parse($selectedEvent['expired_at'])->diffForHumans()); ?>

                                </span>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>

            
            <div class="event-content-container">
                <!--[if BLOCK]><![endif]--><?php if($selectedEvent && $selectedEvent['blade_name']): ?>
                    <!--[if BLOCK]><![endif]--><?php if($selectedEvent['blade_name'] === 'treasure-event'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('fast-events.treasure-event', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-2204586504-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($selectedEvent['blade_name'] === 'welcome'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('fast-events.welcome2', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-2204586504-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php else: ?>
                        <div class="no-content-message">
                            <i class="fas fa-info-circle"></i>
                            <p>Event content is not available at the moment.</p>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                <?php else: ?>
                    <div class="no-content-message">
                        <i class="fas fa-exclamation-triangle"></i>
                        <p>No event selected or event data is missing.</p>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>

        
        <!--[if BLOCK]><![endif]--><?php if(!$activeEvents || count($activeEvents) == 0): ?>
            <div class="no-events-state">
                <div class="no-events-icon">
                    <i class="fas fa-calendar-times"></i>
                </div>
                <h2 class="no-events-title" data-translate="fastEvents.noEvents">No Active Events</h2>
                <p class="no-events-description" data-translate="fastEvents.noEventsMessage">
                    There are currently no active events. Check back later for new adventures!
                </p>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>
</div><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/backend/pages/rewards-systems.blade.php ENDPATH**/ ?>