<!-- Desktop Header Content -->
<!-- Navigation data is loaded from resources/data/navigation.json via get_navigation_data() function -->

<?php
$navigation = get_navigation_data();
?>

<div class="header-desktop header-desktop-custom">
    <!-- Logo Section -->
    <div class="logo-section-desktop">
        <div class="logo-container-desktop">
            <div class="logo-wrapper-desktop">
                <div class="logo-inner-desktop">
                    <?php if($navigation['logo']['type'] === 'image'): ?>
                        <?php
                            $isRTL = in_array(app()->getLocale(), ['ar', 'he', 'fa', 'ur']); // Add more RTL languages as needed
                            $logoImage = $isRTL ? ($navigation['logo']['image_rtl'] ?? $navigation['logo']['image_ltr']) : $navigation['logo']['image_ltr'];
                        ?>
                        <a href="<?php echo e($navigation['logo']['is_route'] ? route($navigation['logo']['link']) : $navigation['logo']['link']); ?>">
                            <img src="<?php echo e($logoImage); ?>" alt="<?php echo e($navigation['logo']['alt']); ?>" />
                        </a>
                    <?php else: ?>
                        <?php
                            $isRTL = in_array(app()->getLocale(), ['ar', 'he', 'fa', 'ur']);
                            $logoText = $isRTL ? ($navigation['logo']['text_rtl'] ?? $navigation['logo']['text_ltr']) : $navigation['logo']['text_ltr'];
                        ?>
                        <a href="<?php echo e($navigation['logo']['is_route'] ? route($navigation['logo']['link']) : $navigation['logo']['link']); ?>" class="logo-text-link">
                            <span class="logo-title-desktop" data-translate="hero.title"><?php echo e($logoText); ?></span>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php if($navigation['logo']['type'] === 'image'): ?>
        <div class="logo-text-desktop">
            <span class="logo-title-desktop" data-translate="hero.title">4TresSro</span>
            <span class="logo-subtitle-desktop" data-translate="hero.subtitle">Epic RPG Adventure</span>
        </div>
        <?php endif; ?>
    </div>

    <!-- Desktop Navigation Menu -->
    <div class="nav-section-desktop">
        <div class="nav-links-container-desktop">
            <!-- Primary Navigation Items -->
            <?php $__currentLoopData = $navigation['navigation']['primary']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($item['visibility'] === 'all' || ($item['visibility'] === 'guest' && !Auth::check()) || ($item['visibility'] === 'auth' && Auth::check())): ?>
            <a href="<?php echo e(($item['is_route'] ?? false) ? route($item['route']) : $item['route']); ?>" class="nav-item-desktop primary <?php echo e(active_class($item['active'] ?: '')); ?>">
                <i class="<?php echo e($item['icon']); ?>"></i>
                <span data-translate="<?php echo e($item['label']); ?>"><?php echo e($item['title']); ?></span>
            </a>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <!-- Dropdown Menu for Other Items -->
            <div class="dropdown-desktop">
                <a href="#" class="nav-item-desktop dropdown-trigger-desktop <?php echo e(collect($navigation['navigation']['dropdown'])->contains(function ($item) { return active_class($item['active'] ?: ''); }) ? 'active' : ''); ?>">
                    <i class="fas fa-th-large"></i>
                    <span data-translate="nav.more">More</span>
                    <i class="fas fa-chevron-down dropdown-arrow-desktop"></i>
                </a>
                <div class="dropdown-content-desktop">
                    <?php $__currentLoopData = $navigation['navigation']['dropdown']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($item['visibility'] === 'all' || ($item['visibility'] === 'guest' && !Auth::check()) || ($item['visibility'] === 'auth' && Auth::check())): ?>
                    <a href="<?php echo e(($item['is_route'] ?? false) ? route($item['route']) : $item['route']); ?>" class="dropdown-item-desktop <?php echo e(active_class($item['active'] ?: '')); ?>">
                        <i class="<?php echo e($item['icon']); ?>"></i>
                        <span data-translate="<?php echo e($item['label']); ?>"><?php echo e($item['title']); ?></span>
                    </a>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Desktop Action Section -->
    <div class="action-section-desktop">
        <!-- Language Switcher - Will be populated by MultiLanguageManager -->
       <div class="language-switcher"></div>

        <!-- Elegant Divider -->
        <div class="action-divider-desktop"></div>

        <!-- Auth Buttons Group -->
        <div class="auth-buttons-group-desktop">
            <?php if(Auth::check()): ?>
                <!-- Notification Icons -->
                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('notifications', ['type' => 'desktop']);

$__html = app('livewire')->mount($__name, $__params, 'lw-3500491572-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

                <!-- User Dropdown Menu -->
                <div class="user-dropdown-container-desktop">
                    <button class="user-dropdown-trigger-desktop" aria-expanded="false" aria-haspopup="true" aria-label="User menu">
                        <div class="user-avatar-desktop">
                            <i class="fas fa-user-circle"></i>
                        </div>
                        <div class="user-info-desktop">
                            <span class="user-greeting-desktop" data-translate="user.welcome">Welcome</span>
                            <span class="user-name-desktop"><?php echo e(Auth::user()->username); ?></span>
                        </div>
                        <i class="fas fa-chevron-down dropdown-arrow-desktop"></i>
                    </button>

                    <div class="user-dropdown-menu-desktop" role="menu" aria-hidden="true">
                        <!-- User Header -->
                        <div class="user-dropdown-header-desktop">
                            <div class="user-avatar-large-desktop">
                                <i class="fas fa-user-circle"></i>
                            </div>
                            <div class="user-details-desktop">
                                <h4 class="user-fullname-desktop"><?php echo e(Auth::user()->username); ?></h4>
                                <p class="user-status-desktop">Premium Player</p>
                            </div>
                        </div>

                        <!-- Balance Section -->

                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('balance-head', ['type' => 'menu']);

$__html = app('livewire')->mount($__name, $__params, 'lw-3500491572-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                        <!-- Menu Items -->
                        <div class="dropdown-menu-items-desktop">
                            <a href="<?php echo e(route('dashboard')); ?>" class="dropdown-menu-item-desktop" role="menuitem" tabindex="0">
                                <i class="fas fa-tachometer-alt"></i>
                                <span data-translate="user.dashboard">Dashboard</span>
                            </a>

                            <?php if(Auth::user()->hasRoleLevel(3)): ?>
                                <a href="<?php echo e(route('team-dashboard')); ?>" class="dropdown-menu-item-desktop team-dashboard-link" role="menuitem" tabindex="0">
                                    <i class="fas fa-users-cog"></i>
                                    <span data-translate="team.dashboard.title">Team Dashboard</span>
                                </a>
                            <?php endif; ?>
                        </div>

                        <!-- Logout Section -->
                        <div class="dropdown-divider-desktop"></div>
                        <div class="dropdown-logout-form-desktop">
                            <button type="button" class="dropdown-menu-item-desktop logout-btn-desktop" role="menuitem" tabindex="0" onclick="document.getElementById('logout-form').submit();">
                                <i class="fas fa-sign-out-alt"></i>
                                <span data-translate="user.logout">Logout</span>
                            </button>
                            <form id="logout-form" method="POST" action="<?php echo e(route('logout')); ?>" style="display: none;">
                                <?php echo csrf_field(); ?>
                            </form>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('auth.register', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3500491572-2', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('auth.login', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3500491572-3', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php if(Auth::check()): ?>
<!-- Balance Display Section Below Header -->
<div class="balance-display-below-header">
    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('balance-head', ['type' => 'desktop']);

$__html = app('livewire')->mount($__name, $__params, 'lw-3500491572-4', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
</div>
<?php endif; ?>

<?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views/components/layouts/struct/partials/main/header-desktop.blade.php ENDPATH**/ ?>