<?php

use Livewire\Volt\Component;
use App\Models\SRO_VT_SHARD\_User;
use App\Models\SRO_VT_SHARD\Char;
use App\Models\SRO_VT_SHARD\Inventory;
use App\Models\SRO_VT_SHARD\Items;
use App\Models\FastEventsTreasure;
use App\Models\FastEventsDuo;
use Illuminate\Support\Facades\Auth;
use App\Models\SRO_VT_PROXY\_InstantCharReloadDelivery;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

?>

<div>
<div x-data="{
    showFacebookSection: <?php if ((object) ('showFacebookSection') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showFacebookSection'->value()); ?>')<?php echo e('showFacebookSection'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showFacebookSection'); ?>')<?php endif; ?>,
    showDuoSection: <?php if ((object) ('showDuoSection') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showDuoSection'->value()); ?>')<?php echo e('showDuoSection'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showDuoSection'); ?>')<?php endif; ?>,
    showPostHistory: <?php if ((object) ('showPostHistory') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showPostHistory'->value()); ?>')<?php echo e('showPostHistory'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showPostHistory'); ?>')<?php endif; ?>,
    showDuoHistory: <?php if ((object) ('showDuoHistory') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showDuoHistory'->value()); ?>')<?php echo e('showDuoHistory'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showDuoHistory'); ?>')<?php endif; ?>,
    animateReward: false,

    toggleSection() {
        this.showFacebookSection = !this.showFacebookSection;
        if (this.showFacebookSection) {
            this.$nextTick(() => {
                this.$refs.facebookSection.scrollIntoView({ behavior: 'smooth' });
            });
        }
    },

    toggleDuoSection() {
        this.showDuoSection = !this.showDuoSection;
        if (this.showDuoSection) {
            this.$nextTick(() => {
                this.$refs.duoSection.scrollIntoView({ behavior: 'smooth' });
            });
        }
    },

    toggleHistory() {
        this.showPostHistory = !this.showPostHistory;
    },

    toggleDuoHistory() {
        this.showDuoHistory = !this.showDuoHistory;
    },

    animateCounter() {
        this.animateReward = true;
        setTimeout(() => {
            this.animateReward = false;
        }, 500);
    }
}" class="treasure-event-container">

    <!-- Facebook Events Section -->
    <div class="facebook-events-section mb-8">
        <div class="facebook-intro-card">
            <div class="card-header">
                <div class="fb-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                    </svg>
                </div>
                <div class="header-content">
                    <h3 class="section-title" data-translate="treasureEvent.facebook.title">
                        Facebook Events Participation
                    </h3>
                    <p class="section-subtitle" data-translate="treasureEvent.facebook.subtitle">
                        Join our Facebook events and earn rewards for your engagement
                    </p>
                </div>
            </div>

            <div class="intro-button-container">
                <button
                    @click="toggleSection()"
                    class="facebook-subscribe-btn"
                    :class="{ 'active': showFacebookSection }"
                >
                    <span class="btn-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                        </svg>
                    </span>
                    <span class="btn-text" data-translate="treasureEvent.facebook.subscribeBtn">
                        I have subscribed to Facebook events
                    </span>
                    <span class="btn-arrow" :class="{ 'rotated': showFacebookSection }">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6-6-6 1.41-1.41z"/>
                        </svg>
                    </span>
                </button>
            </div>
        </div>

        <!-- Facebook Events Form -->
        <div
            x-show="showFacebookSection"
            x-transition:enter="transition ease-out duration-500"
            x-transition:enter-start="opacity-0 transform -translate-y-10"
            x-transition:enter-end="opacity-100 transform translate-y-0"
            x-transition:leave="transition ease-in duration-300"
            x-transition:leave-start="opacity-100 transform translate-y-0"
            x-transition:leave-end="opacity-0 transform -translate-y-10"
            x-ref="facebookSection"
            class="facebook-form-container"
        >
            <!-- Facebook Profile Link Check -->
            <!--[if BLOCK]><![endif]--><?php if(empty($this->userFacebookLink)): ?>
                <div class="facebook-setup-required">
                    <div class="setup-icon">
                        <svg width="48" height="48" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                        </svg>
                    </div>
                    <div class="setup-content">
                        <h4 data-translate="treasureEvent.facebook.setupRequired">Facebook Profile Required</h4>
                        <p data-translate="treasureEvent.facebook.setupDescription">
                            To participate in Facebook events and earn rewards, you need to add your Facebook profile link first. This helps us verify your posts and calculate your rewards accurately.
                        </p>

                        <div class="setup-steps">
                            <div class="step">
                                <span class="step-number">1</span>
                                <span class="step-text" data-translate="treasureEvent.facebook.step1">Go to your Facebook profile</span>
                            </div>
                            <div class="step">
                                <span class="step-number">2</span>
                                <span class="step-text" data-translate="treasureEvent.facebook.step2">Copy your profile URL</span>
                            </div>
                            <div class="step">
                                <span class="step-number">3</span>
                                <span class="step-text" data-translate="treasureEvent.facebook.step3">Paste it in the field below</span>
                            </div>
                        </div>

                        <div class="facebook-link-form" x-data="{ showForm: <?php if ((object) ('showFacebookLinkForm') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showFacebookLinkForm'->value()); ?>')<?php echo e('showFacebookLinkForm'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showFacebookLinkForm'); ?>')<?php endif; ?> }">
                            <button
                                @click="showForm = true"
                                x-show="!showForm"
                                class="setup-btn"
                            >
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"/>
                                </svg>
                                <span data-translate="treasureEvent.facebook.addProfile">Add Facebook Profile</span>
                            </button>

                            <div x-show="showForm" x-transition class="facebook-form">
                                <div class="form-group">
                                    <label data-translate="treasureEvent.facebook.profileUrl">Facebook Profile URL</label>
                                    <input
                                        type="url"
                                        wire:model="userFacebookLink"
                                        placeholder="https://facebook.com/your-profile"
                                        class="form-input"
                                    >
                                </div>
                                <div class="form-actions">
                                    <button
                                        wire:click="saveFacebookLink"
                                        class="save-btn"
                                        wire:loading.attr="disabled"
                                    >
                                        <span wire:loading.remove>
                                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                                <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                                            </svg>
                                            <span data-translate="general.save">Save</span>
                                        </span>
                                        <span wire:loading>
                                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" class="animate-spin">
                                                <path d="M12,4V2A10,10 0 0,0 2,12H4A8,8 0 0,1 12,4Z"/>
                                            </svg>
                                            <span data-translate="general.saving">Saving...</span>
                                        </span>
                                    </button>
                                    <button
                                        @click="showForm = false"
                                        class="cancel-btn"
                                    >
                                        <span data-translate="general.cancel">Cancel</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <!-- Facebook Profile Confirmed - Show Events Content -->
                <div class="facebook-profile-confirmed">
                    <div class="profile-info">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor" class="text-success">
                            <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                        </svg>
                        <span data-translate="treasureEvent.facebook.profileLinked">Facebook Profile Linked:</span>
                        <a href="<?php echo e($this->userFacebookLink); ?>" target="_blank" class="profile-link">
                            <?php echo e(Str::limit($this->userFacebookLink, 50)); ?>

                        </a>
                        <button
                            wire:click="$set('showFacebookLinkForm', true)"
                            class="edit-profile-btn"
                            title="Edit Profile Link"
                        >
                            <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"/>
                            </svg>
                        </button>
                    </div>

                    <!-- Edit Profile Form -->
                    <!--[if BLOCK]><![endif]--><?php if($this->showFacebookLinkForm): ?>
                    <div class="edit-profile-form" x-transition>
                        <div class="form-group">
                            <label data-translate="treasureEvent.facebook.profileUrl">Facebook Profile URL</label>
                            <input
                                type="url"
                                wire:model="userFacebookLink"
                                placeholder="https://facebook.com/your-profile"
                                class="form-input"
                            >
                        </div>
                        <div class="form-actions">
                            <button
                                wire:click="saveFacebookLink"
                                class="save-btn"
                                wire:loading.attr="disabled"
                            >
                                <span wire:loading.remove>
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                                    </svg>
                                    <span data-translate="general.save">Save</span>
                                </span>
                                <span wire:loading>
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" class="animate-spin">
                                        <path d="M12,4V2A10,10 0 0,0 2,12H4A8,8 0 0,1 12,4Z"/>
                                    </svg>
                                    <span data-translate="general.saving">Saving...</span>
                                </span>
                            </button>
                            <button
                                wire:click="$set('showFacebookLinkForm', false)"
                                class="cancel-btn"
                            >
                                <span data-translate="general.cancel">Cancel</span>
                            </button>
                        </div>
                    </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>

            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <!--[if BLOCK]><![endif]--><?php if(!empty($this->userFacebookLink)): ?>
            <!-- Warning Notice -->
            <div class="warning-notice">
                <div class="warning-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"/>
                    </svg>
                </div>
                <div class="warning-content">
                    <h5 data-translate="treasureEvent.facebook.warningTitle">Important Notice</h5>
                    <p data-translate="treasureEvent.facebook.warningText">
                        Rewards calculation applies only to posts starting from September 11, 2025
                    </p>
                </div>
            </div>

            <!-- Rewards Counter -->
            <div class="rewards-counter-card">
                <div class="counter-header">
                    <h4 data-translate="treasureEvent.facebook.rewardsCalculator">Rewards Calculator</h4>
                </div>
                <div class="counter-display">
                    <div class="counter-value" :class="{ 'animate-pulse': animateReward }">
                        <span class="value-number"><?php echo e($this->userStats['total_points'] ?? 0); ?></span>
                        <span class="value-label" data-translate="treasureEvent.facebook.points">Points</span>
                    </div>
                </div>
                <div class="points-breakdown">
                    <div class="point-item">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M2 20h2c.55 0 1-.45 1-1v-9c0-.55-.45-1-1-1H2v11zm19.83-7.12c.11-.25.17-.52.17-.8 0-.83-.67-1.5-1.5-1.5H14c.08-.7.33-1.42.55-2.13.28-.95.52-1.8.32-2.32-.25-.65-.89-1.13-1.58-1.13-.5 0-.93.28-1.2.7L10.8 8.6C10.3 9.5 10 10.5 10 11.5V19c0 .55.45 1 1 1h8.38c.5 0 .93-.31 1.1-.78L21.83 12.88z"/>
                        </svg>
                        <span data-translate="treasureEvent.facebook.like">Like</span>
                        <span class="points">5 pts</span>
                    </div>
                    <div class="point-item">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M21.99 4c0-1.1-.89-2-2-2H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h14l4 4-.01-18zM18 14H6v-2h12v2zm0-3H6V9h12v2zm0-3H6V6h12v2z"/>
                        </svg>
                        <span data-translate="treasureEvent.facebook.comment">Comment</span>
                        <span class="points">7 pts</span>
                    </div>
                    <div class="point-item">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z"/>
                        </svg>
                        <span data-translate="treasureEvent.facebook.share">Share</span>
                        <span class="points">13 pts</span>
                    </div>
                </div>
            </div>

            <!-- Statistics Section -->
            <div class="statistics-section">
                <div class="stats-header">
                    <h4 data-translate="treasureEvent.facebook.statistics">Your Statistics</h4>
                </div>
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon total">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M3 13h2v-2H3v2zm0 4h2v-2H3v2zm0-8h2V7H3v2zm4 4h14v-2H7v2zm0 4h14v-2H7v2zM7 7v2h14V7H7z"/>
                            </svg>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label" data-translate="general.total_posts">Total Posts</span>
                            <span class="stat-value"><?php echo e(count($this->facebookPosts)); ?></span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon collected">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                            </svg>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label" data-translate="general.collected_rewards">Collected</span>
                            <span class="stat-value text-success"><?php echo e($this->collectedCount ?? 0); ?></span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon pending">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"/>
                                <path d="M12.5 7H11v6l5.25 3.15.75-1.23-4.5-2.67z"/>
                            </svg>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label" data-translate="general.pending_rewards">Pending</span>
                            <span class="stat-value text-warning"><?php echo e($this->uncollectedCount ?? 0); ?></span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon accepted">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M2 20h2c.55 0 1-.45 1-1v-9c0-.55-.45-1-1-1H2v11zm19.83-7.12c.11-.25.17-.52.17-.8 0-.83-.67-1.5-1.5-1.5H14c.08-.7.33-1.42.55-2.13.28-.95.52-1.8.32-2.32-.25-.65-.89-1.13-1.58-1.13-.5 0-.93.28-1.2.7L10.8 8.6C10.3 9.5 10 10.5 10 11.5V19c0 .55.45 1 1 1h8.38c.5 0 .93-.31 1.1-.78L21.83 12.88z"/>
                            </svg>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label" data-translate="general.accepted_posts">Accepted</span>
                            <span class="stat-value text-info"><?php echo e($this->acceptedCount ?? 0); ?></span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon pending-approval">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M6 2v6h.01L6 8.01 10 12l-4 4 .01.01H6V22h12v-5.99h-.01L18 16l-4-4 4-3.99-.01-.01H18V2H6zm10 14.5V20H8v-3.5l4-4 4 4zm0-9V11l-4 4-4-4V7.5l4-4 4 4zM8 4h8v3.5L12 11.5 8 7.5V4z"/>
                            </svg>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label" data-translate="general.pending_approval">Pending Approval</span>
                            <span class="stat-value text-secondary"><?php echo e($this->pendingCount ?? 0); ?></span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon rejected">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <circle cx="12" cy="12" r="10"/>
                                <line x1="15" y1="9" x2="9" y2="15"/>
                                <line x1="9" y1="9" x2="15" y2="15"/>
                            </svg>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label" data-translate="general.rejected">Rejected</span>
                            <span class="stat-value text-danger"><?php echo e($this->rejectedCount ?? 0); ?></span>
                        </div>
                    </div>
                </div>

                <div class="points-grid">
                    <div class="points-card collected-points">
                        <div class="points-icon">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm4.64 6.8c-.15 1.58-.08 2.94-.56 4.1-.63 1.5-1.65 2.63-2.74 3.73-.84.84-1.73 1.64-2.57 2.51-.42.44-.85.87-1.31 1.27-.15.13-.3.26-.45.37-.08.06-.15.11-.23.17-.04.03-.08.05-.12.07-.02.01-.04.02-.05.03-.01 0-.02.01-.02.01-.01 0-.01 0-.02-.01-.01-.01-.02-.02-.04-.03-.04-.02-.08-.04-.12-.07-.08-.06-.15-.11-.23-.17-.15-.11-.3-.24-.45-.37-.46-.4-.89-.83-1.31-1.27-.84-.87-1.73-1.67-2.57-2.51-1.09-1.1-2.11-2.23-2.74-3.73-.48-1.16-.41-2.52-.56-4.1C6.35 7.8 6.8 6.9 7.12 6.2c.16-.35.3-.7.4-1.06.05-.18.08-.36.1-.54.01-.09.01-.18.01-.27 0-.04 0-.08-.01-.12 0-.02 0-.04-.01-.06 0-.01 0-.02 0-.02 0 0 0-.01.01-.02.01-.01.02-.02.04-.03.04-.02.08-.04.12-.07.08-.06.15-.11.23-.17.15-.11.3-.24.45-.37.46-.4.89-.83 1.31-1.27.84-.87 1.73-1.67 2.57-2.51 1.09-1.1 2.11-2.23 2.74-3.73.48-1.16.41-2.52.56-4.1.01-.09.03-.17.04-.26.02-.17.04-.34.08-.5.08-.32.19-.63.33-.93.28-.6.67-1.15 1.12-1.63.23-.24.48-.46.75-.66.14-.1.28-.19.43-.28.08-.05.15-.09.23-.13.04-.02.08-.04.12-.06.02-.01.04-.02.05-.02.01-.01.02-.01.03-.01.01 0 .02 0 .03.01.01 0 .03.01.05.02.04.02.08.04.12.06.08.04.15.08.23.13.15.09.29.18.43.28.27.2.52.42.75.66.45.48.84 1.03 1.12 1.63.14.3.25.61.33.93.04.16.06.33.08.5.01.09.03.17.04.26z"/>
                            </svg>
                        </div>
                        <div class="points-content">
                            <span class="points-label" data-translate="total_collected_points">Collected Points</span>
                            <span class="points-value"><?php echo e($this->collectedPoints ?? 0); ?></span>
                        </div>
                    </div>
                    <div class="points-card pending-points">
                        <div class="points-icon">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M6 2v6h.01L6 8.01 10 12l-4 4 .01.01H6V22h12v-5.99h-.01L18 16l-4-4 4-3.99-.01-.01H18V2H6zm10 14.5V20H8v-3.5l4-4 4 4zm0-9V11l-4 4-4-4V7.5l4-4 4 4zM8 4h8v3.5L12 11.5 8 7.5V4z"/>
                            </svg>
                        </div>
                        <div class="points-content">
                            <span class="points-label" data-translate="pending_points">Pending Points</span>
                            <span class="points-value"><?php echo e($this->uncollectedPoints ?? 0); ?></span>
                        </div>
                    </div>
                </div>

                <?php
                    $approvedUncollectedPoints = collect($this->facebookPosts)
                        ->where('status', 'approved')
                        ->sum('points');
                ?>

                <!--[if BLOCK]><![endif]--><?php if($approvedUncollectedPoints > 0): ?>
                <div class="collect-section">
                    <div class="collect-info">
                        <span>
                            You can collect <?php echo e($approvedUncollectedPoints); ?> points = <?php echo e($approvedUncollectedPoints); ?> Gift Balance
                        </span>
                    </div>
                    <button
                        wire:click="collectRewards"
                        class="collect-rewards-btn"
                        wire:loading.attr="disabled"
                        wire:loading.class="loading">
                        <span wire:loading.remove>
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M20 6h-2.18c.11-.31.18-.65.18-1a2.996 2.996 0 0 0-5.5-1.65l-.5.67-.5-.68C10.96 2.54 10.05 2 9 2 7.34 2 6 3.34 6 5c0 .35.07.69.18 1H4c-1.11 0-1.99.89-1.99 2L2 19c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2zm-5-2c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zM9 4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1z"/>
                            </svg>
                            <span data-translate="general.collect_rewards">Collect Rewards</span> <span > <?php echo e($approvedUncollectedPoints); ?> Gift Balance</span>
                        </span>
                        <span wire:loading>
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" class="animate-spin">
                                <path d="M12,4V2A10,10 0 0,0 2,12H4A8,8 0 0,1 12,4Z"/>
                            </svg>
                            <span data-translate="general.collecting">Collecting...</span>
                        </span>
                    </button>
                </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>

            <!-- Posts Management -->
            <div class="posts-management">
                <div class="section-header">
                    <h4 data-translate="treasureEvent.facebook.managePosts">Submit New Post</h4>
                </div>

                <!-- New Post Form -->
                <div class="new-post-form" x-data="{
                    postLink: <?php if ((object) ('newPostLink') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('newPostLink'->value()); ?>')<?php echo e('newPostLink'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('newPostLink'); ?>')<?php endif; ?>,
                    selectedActions: <?php if ((object) ('newPostActions') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('newPostActions'->value()); ?>')<?php echo e('newPostActions'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('newPostActions'); ?>')<?php endif; ?>,
                    calculatePoints() {
                        let points = 0;
                        if (this.selectedActions.includes('like')) points += 5;
                        if (this.selectedActions.includes('comment')) points += 7;
                        if (this.selectedActions.includes('share')) points += 13;
                        return points;
                    }
                }">
                    <div class="form-group">
                        <label data-translate="treasureEvent.facebook.postLink">Post Link</label>
                        <input
                            type="url"
                            x-model="postLink"
                            placeholder="https://facebook.com/..."
                            class="form-input"
                            required
                        >
                    </div>

                    <div class="form-group">
                        <label data-translate="treasureEvent.facebook.actionType">Select Actions (you can select multiple)</label>
                        <div class="action-buttons">
                            <button
                                @click="
                                    if (selectedActions.includes('like')) {
                                        selectedActions = selectedActions.filter(a => a !== 'like');
                                    } else {
                                        selectedActions.push('like');
                                    }
                                "
                                class="action-btn"
                                :class="{ 'active': selectedActions.includes('like') }"
                                type="button"
                            >
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M2 20h2c.55 0 1-.45 1-1v-9c0-.55-.45-1-1-1H2v11zm19.83-7.12c.11-.25.17-.52.17-.8 0-.83-.67-1.5-1.5-1.5H14c.08-.7.33-1.42.55-2.13.28-.95.52-1.8.32-2.32-.25-.65-.89-1.13-1.58-1.13-.5 0-.93.28-1.2.7L10.8 8.6C10.3 9.5 10 10.5 10 11.5V19c0 .55.45 1 1 1h8.38c.5 0 .93-.31 1.1-.78L21.83 12.88z"/>
                                </svg>
                                <span data-translate="treasureEvent.facebook.like">Like</span>
                                <span class="points">5</span>
                                <svg width="12" height="12" viewBox="0 0 24 24" fill="currentColor" class="action-check" x-show="selectedActions.includes('like')">
                                    <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                                </svg>
                            </button>

                            <button
                                @click="
                                    if (selectedActions.includes('comment')) {
                                        selectedActions = selectedActions.filter(a => a !== 'comment');
                                    } else {
                                        selectedActions.push('comment');
                                    }
                                "
                                class="action-btn"
                                :class="{ 'active': selectedActions.includes('comment') }"
                                type="button"
                            >
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M21.99 4c0-1.1-.89-2-2-2H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h14l4 4-.01-18zM18 14H6v-2h12v2zm0-3H6V9h12v2zm0-3H6V6h12v2z"/>
                                </svg>
                                <span data-translate="treasureEvent.facebook.comment">Comment</span>
                                <span class="points">7</span>
                                <svg width="12" height="12" viewBox="0 0 24 24" fill="currentColor" class="action-check" x-show="selectedActions.includes('comment')">
                                    <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                                </svg>
                            </button>

                            <button
                                @click="
                                    if (selectedActions.includes('share')) {
                                        selectedActions = selectedActions.filter(a => a !== 'share');
                                    } else {
                                        selectedActions.push('share');
                                    }
                                "
                                class="action-btn"
                                :class="{ 'active': selectedActions.includes('share') }"
                                type="button"
                            >
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z"/>
                                </svg>
                                <span data-translate="treasureEvent.facebook.share">Share</span>
                                <span class="points">13</span>
                                <svg width="12" height="12" viewBox="0 0 24 24" fill="currentColor" class="action-check" x-show="selectedActions.includes('share')">
                                    <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                                </svg>
                            </button>
                        </div>
                    </div>

                    <div class="post-points-preview">
                        <span class="points-display">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
                            </svg>
                            <span class="points-value" x-text="calculatePoints()"></span>
                            <span class="points-label" data-translate="treasureEvent.facebook.points">Points</span>
                        </span>
                    </div>

                    <div class="form-actions">
                        <button
                            wire:click="submitNewPost"
                            @click="animateCounter()"
                            class="submit-post-btn"
                            wire:loading.attr="disabled"
                            :disabled="!postLink || selectedActions.length === 0"
                        >
                            <span wire:loading.remove>
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"/>
                                </svg>
                                <span data-translate="treasureEvent.facebook.addPost">Add Post</span>
                            </span>
                            <span wire:loading>
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" class="animate-spin">
                                    <path d="M12,4V2A10,10 0 0,0 2,12H4A8,8 0 0,1 12,4Z"/>
                                </svg>
                                <span data-translate="general.adding">Adding...</span>
                            </span>
                        </button>
                    </div>
                </div>

                  <div class="history-header">
                        <h5 data-translate="treasureEvent.facebook.postHistory">Post History</h5>
                        <button @click="toggleHistory()" class="history-btn" :class="{ 'active': showPostHistory }">
                        <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor" class="history-icon" x-show="!showPostHistory">
                            <path d="M13 3a9 9 0 0 0-9 9H1l3.89 3.89.07.14L9 12H6c0-3.87 3.13-7 7-7s7 3.13 7 7-3.13 7-7 7c-1.93 0-3.68-.79-4.94-2.06l-1.42 1.42A8.954 8.954 0 0 0 13 21a9 9 0 0 0 0-18zm-1 5v5l4.25 2.52.77-1.28-3.52-2.09V8z"/>
                        </svg>
                        <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor" class="close-icon" x-show="showPostHistory">
                            <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11H7v-2h10v2z"/>
                        </svg>
                        <span class="btn-text">
                            <span x-show="!showPostHistory" data-translate="treasureEvent.facebook.showHistory">Show History</span>
                            <span x-show="showPostHistory" data-translate="treasureEvent.facebook.hideHistory">Hide History</span>
                        </span>
                        <span class="btn-arrow" :class="{ 'rotated': showPostHistory }">
                            <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6-6-6 1.41-1.41z"/>
                            </svg>
                        </span>
                    </button>
                        <button @click="toggleHistory()" class="close-history-btn">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/>
                            </svg>
                        </button>
                    </div>
                <!-- Post History Section -->
                <div
                    x-show="showPostHistory"
                    x-transition:enter="transition ease-out duration-300"
                    x-transition:enter-start="opacity-0 transform -translate-y-10"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition ease-in duration-200"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-10"
                    class="post-history-section"
                >
                    <div class="history-list">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $facebookPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="history-item">
                                <div class="history-header-item">
                                    <span class="post-number">#<?php echo e($index + 1); ?></span>
                                    <div class="post-status">
                                        <!--[if BLOCK]><![endif]--><?php if($post['status'] === 'collected'): ?>
                                            <span class="status-indicator collected" title="<?php echo e(__('treasureEvent.facebook.statusDescriptions.collected')); ?>">
                                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                                                </svg>
                                                <span data-translate="treasureEvent.facebook.status.collected">Collected</span>
                                            </span>
                                        <?php elseif($post['status'] === 'approved'): ?>
                                            <span class="status-indicator approved" title="<?php echo e(__('treasureEvent.facebook.statusDescriptions.approved')); ?>">
                                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M2 20h2c.55 0 1-.45 1-1v-9c0-.55-.45-1-1-1H2v11zm19.83-7.12c.11-.25.17-.52.17-.8 0-.83-.67-1.5-1.5-1.5H14c.08-.7.33-1.42.55-2.13.28-.95.52-1.8.32-2.32-.25-.65-.89-1.13-1.58-1.13-.5 0-.93.28-1.2.7L10.8 8.6C10.3 9.5 10 10.5 10 11.5V19c0 .55.45 1 1 1h8.38c.5 0 .93-.31 1.1-.78L21.83 12.88z"/>
                                                </svg>
                                                <span data-translate="treasureEvent.facebook.status.approved">Approved</span>
                                            </span>
                                        <?php elseif($post['status'] === 'rejected'): ?>
                                            <span class="status-indicator rejected" title="<?php echo e(__('treasureEvent.facebook.statusDescriptions.rejected')); ?>">
                                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                                    <circle cx="12" cy="12" r="10"/>
                                                    <line x1="15" y1="9" x2="9" y2="15"/>
                                                    <line x1="9" y1="9" x2="15" y2="15"/>
                                                </svg>
                                                <span data-translate="treasureEvent.facebook.status.rejected">Rejected</span>
                                            </span>
                                        <?php else: ?>
                                            <span class="status-indicator pending" title="<?php echo e(__('treasureEvent.facebook.statusDescriptions.pending')); ?>">
                                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"/>
                                                    <path d="M12.5 7H11v6l5.25 3.15.75-1.23-4.5-2.67z"/>
                                                </svg>
                                                <span data-translate="treasureEvent.facebook.status.pending">Under Review</span>
                                            </span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                    <!--[if BLOCK]><![endif]--><?php if($post['status'] === 'pending'): ?>
                                        <button
                                            wire:click="removeFacebookPost('<?php echo e($post['id']); ?>')"
                                            class="remove-btn"
                                            data-translate="treasureEvent.facebook.deletePost"
                                            title="<?php echo e(__('treasureEvent.facebook.deletePost')); ?>"
                                        >
                                            <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                                <path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"/>
                                            </svg>
                                        </button>
                                    <?php else: ?>
                                        <span class="accepted-badge" data-translate="treasureEvent.facebook.cannotDelete" title="<?php echo e(__('treasureEvent.facebook.cannotDelete')); ?>">
                                            <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                                <path d="M18,8A2,2 0 0,1 20,10V20A2,2 0 0,1 18,22H6A2,2 0 0,1 4,20V10A2,2 0 0,1 6,8H7V6A5,5 0 0,1 12,1A5,5 0 0,1 17,6V8H18M12,3A3,3 0 0,0 9,6V8H15V6A3,3 0 0,0 12,3Z"/>
                                            </svg>
                                        </span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <div class="history-content">
                                    <div class="post-link">
                                        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                            <path d="M3.9 12c0-1.71 1.39-3.1 3.1-3.1h4V7H6.5C3.56 7 1 9.56 1 12.5S3.56 18 6.5 18H11v-1.9H6.5c-1.71 0-3.1-1.39-3.1-3.1zM8 13h8v-2H8v2zm9.5-6H13v1.9h4.5c1.71 0 3.1 1.39 3.1 3.1s-1.39 3.1-3.1 3.1H13V18h4.5c2.94 0 5.5-2.56 5.5-5.5S20.44 7 17.5 7z"/>
                                        </svg>
                                        <a href="<?php echo e($post['link']); ?>" target="_blank" class="link-text">
                                            <?php echo e(Str::limit($post['link'], 60)); ?>

                                        </a>
                                    </div>

                                    <div class="post-actions-history">
                                        <!--[if BLOCK]><![endif]--><?php if($post['like']): ?>
                                            <span class="action-badge like">
                                                <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M2 20h2c.55 0 1-.45 1-1v-9c0-.55-.45-1-1-1H2v11zm19.83-7.12c.11-.25.17-.52.17-.8 0-.83-.67-1.5-1.5-1.5H14c.08-.7.33-1.42.55-2.13.28-.95.52-1.8.32-2.32-.25-.65-.89-1.13-1.58-1.13-.5 0-.93.28-1.2.7L10.8 8.6C10.3 9.5 10 10.5 10 11.5V19c0 .55.45 1 1 1h8.38c.5 0 .93-.31 1.1-.78L21.83 12.88z"/>
                                                </svg>
                                                <span>Like (5 pts)</span>
                                            </span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        <!--[if BLOCK]><![endif]--><?php if($post['comment']): ?>
                                            <span class="action-badge comment">
                                                <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M21.99 4c0-1.1-.89-2-2-2H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h14l4 4-.01-18zM18 14H6v-2h12v2zm0-3H6V9h12v2zm0-3H6V6h12v2z"/>
                                                </svg>
                                                <span>Comment (7 pts)</span>
                                            </span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        <!--[if BLOCK]><![endif]--><?php if($post['share']): ?>
                                            <span class="action-badge share">
                                                <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z"/>
                                                </svg>
                                                <span>Share (13 pts)</span>
                                            </span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>

                                    <!--[if BLOCK]><![endif]--><?php if($post['status'] === 'rejected' && !empty($post['rejection_reason'])): ?>
                                    <div class="rejection-reason">
                                        <div class="rejection-icon">
                                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                                <path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"/>
                                            </svg>
                                        </div>
                                        <div class="rejection-content">
                                            <span class="rejection-label" data-translate="treasureEvent.facebook.rejectionReason">Rejection Reason:</span>
                                            <span class="rejection-text"><?php echo e($post['rejection_reason']); ?></span>
                                        </div>
                                    </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                    <div class="post-meta">
                                        <span class="points-info">
                                            <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                                <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
                                            </svg>
                                            <?php echo e($post['points']); ?> Points
                                        </span>
                                        <!--[if BLOCK]><![endif]--><?php if($post['accepted_at']): ?>
                                            <span class="date-info">
                                                <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M19 3h-1V1h-2v2H8V1H6v2H5c-1.11 0-1.99.9-1.99 2L3 19c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V8h14v11zM7 10h5v5H7z"/>
                                                </svg>
                                                <?php echo e(\Carbon\Carbon::parse($post['accepted_at'])->format('M d, Y H:i')); ?>

                                            </span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="empty-history">
                                <div class="empty-icon">
                                    <svg width="48" height="48" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M13 3a9 9 0 0 0-9 9H1l3.89 3.89.07.14L9 12H6c0-3.87 3.13-7 7-7s7 3.13 7 7-3.13 7-7 7c-1.93 0-3.68-.79-4.94-2.06l-1.42 1.42A8.954 8.954 0 0 0 13 21a9 9 0 0 0 0-18zm-1 5v5l4.25 2.52.77-1.28-3.52-2.09V8z"/>
                                    </svg>
                                </div>
                                <p data-translate="treasureEvent.facebook.noHistory">No posts in history yet.</p>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>

    <!-- Duo Power Section -->
    <div class="duo-power-section mb-8">
        <div class="duo-intro-card">
            <div class="card-header">
                <div class="duo-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M16 4c0-1.11.89-2 2-2s2 .89 2 2-.89 2-2 2-2-.89-2-2zm4 18v-6h2.5l-2.54-7.63A3 3 0 0 0 17.1 7H16.9c-.8 0-1.54.5-1.85 1.26l-1.92 5.63L15.23 17H16v5h4zM12.5 11.5c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5S11 9.17 11 10s.67 1.5 1.5 1.5zM5.5 6c1.11 0 2-.89 2-2s-.89-2-2-2-2 .89-2 2 .89 2 2 2zm2.5 16v-7H6l3-9h3l3 9h-2v7h-2.5z"/>
                    </svg>
                </div>
                <div class="header-content">
                    <h3 class="section-title" data-translate="treasureEvent.duoPower.title">
                        ⚡ Duo Power ⚡
                    </h3>
                    <p class="section-subtitle" data-translate="treasureEvent.duoPower.subtitle">
                        Invite friends and earn powerful rewards together
                    </p>
                </div>
            </div>

            <div class="duo-rewards-info">
                <div class="reward-item sender-reward">
                    <div class="reward-icon">📨</div>
                    <div class="reward-content">
                        <span class="reward-text" data-translate="treasureEvent.duoPower.senderReward">Sender Reward = 🟢 50 4T$</span>
                        <span class="reward-desc" data-translate="treasureEvent.duoPower.senderRewardDesc">for each new invited friend</span>
                    </div>
                </div>
                <div class="reward-item receiver-reward">
                    <div class="reward-icon">🧑‍🤝‍🧑</div>
                    <div class="reward-content">
                        <span class="reward-text" data-translate="treasureEvent.duoPower.receiverReward">Receiver Reward = 🟢 20 4T$</span>
                        <span class="reward-desc" data-translate="treasureEvent.duoPower.receiverRewardDesc">welcome gift upon first login</span>
                    </div>
                </div>
            </div>

            <!-- Your Referrer ID -->
            <!--[if BLOCK]><![endif]--><?php if($this->userReferrerId): ?>
                <div class="user-referrer-info <?php echo e($this->showReferrerIdBox ? 'new-referrer' : ''); ?>">
                    <div class="referrer-icon">🎯</div>
                    <div class="referrer-content">
                        <div class="game-branding">
                            <span class="game-name">4TresSro</span>
                            <span class="referrer-label">Your Referrer ID</span>
                        </div>
                        <div class="referrer-code-container">
                            <span class="referrer-code"><?php echo e($this->userReferrerId); ?></span>
                            <button class="copy-btn" onclick="copyToClipboard('<?php echo e($this->userReferrerId); ?>')" title="Copy to clipboard">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/>
                                </svg>
                            </button>
                        </div>
                        <span class="referrer-desc">Share this ID with friends to earn rewards</span>
                        <!--[if BLOCK]><![endif]--><?php if($this->showReferrerIdBox): ?>
                            <div class="new-referrer-notice">
                                🎉 New Referrer ID Generated for 4TresSro! Share it with your friends.
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <div class="intro-button-container">
                <button
                    @click="toggleDuoSection()"
                    class="duo-subscribe-btn"
                    :class="{ 'active': showDuoSection }"
                >
                    <span class="btn-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M16 4c0-1.11.89-2 2-2s2 .89 2 2-.89 2-2 2-2-.89-2-2zm4 18v-6h2.5l-2.54-7.63A3 3 0 0 0 17.1 7H16.9c-.8 0-1.54.5-1.85 1.26l-1.92 5.63L15.23 17H16v5h4z"/>
                        </svg>
                    </span>
                    <span class="btn-text" data-translate="treasureEvent.duoPower.subscribeBtn">
                        I want to participate in Duo Power
                    </span>
                    <span class="btn-arrow" :class="{ 'rotated': showDuoSection }">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6-6-6 1.41-1.41z"/>
                        </svg>
                    </span>
                </button>
            </div>
        </div>

        <!-- Duo Power Form -->
        <div
            x-show="showDuoSection"
            x-transition:enter="transition ease-out duration-500"
            x-transition:enter-start="opacity-0 transform -translate-y-10"
            x-transition:enter-end="opacity-100 transform translate-y-0"
            x-transition:leave="transition ease-in duration-300"
            x-transition:leave-start="opacity-100 transform translate-y-0"
            x-transition:leave-end="opacity-0 transform -translate-y-10"
            x-ref="duoSection"
            class="duo-form-container"
        >
            <!-- Facebook Profile Link Check for Duo Power -->
            <!--[if BLOCK]><![endif]--><?php if(empty($this->userFacebookLink)): ?>
                <div class="duo-setup-required">
                    <div class="setup-icon">
                        <svg width="48" height="48" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                        </svg>
                    </div>
                    <div class="setup-content">
                        <h4 data-translate="treasureEvent.duoPower.setupRequired">Facebook Profile Required</h4>
                        <p data-translate="treasureEvent.duoPower.setupDescription">
                            To participate in Duo Power and earn rewards, you need to add your Facebook profile link first. This helps us verify your posts and calculate your rewards accurately.
                        </p>

                        <div class="setup-steps">
                            <div class="step">
                                <span class="step-number">1</span>
                                <span class="step-text" data-translate="treasureEvent.duoPower.step1">Go to your Facebook profile</span>
                            </div>
                            <div class="step">
                                <span class="step-number">2</span>
                                <span class="step-text" data-translate="treasureEvent.duoPower.step2">Copy your profile URL</span>
                            </div>
                            <div class="step">
                                <span class="step-number">3</span>
                                <span class="step-text" data-translate="treasureEvent.duoPower.step3">Paste it in the field below</span>
                            </div>
                        </div>

                        <div class="facebook-link-form" x-data="{ showForm: <?php if ((object) ('showFacebookLinkForm') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showFacebookLinkForm'->value()); ?>')<?php echo e('showFacebookLinkForm'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showFacebookLinkForm'); ?>')<?php endif; ?> }">
                            <button
                                @click="showForm = !showForm"
                                class="setup-btn duo-setup-btn"
                                data-translate="treasureEvent.duoPower.addProfile"
                            >
                                Add Facebook Profile
                            </button>

                            <div x-show="showForm" x-transition class="facebook-form">
                                <div class="form-group">
                                    <label data-translate="treasureEvent.duoPower.profileUrl">Facebook Profile URL</label>
                                    <input
                                        type="url"
                                        wire:model="userFacebookLink"
                                        placeholder="https://facebook.com/your-profile"
                                        class="form-input"
                                    >
                                </div>
                                <div class="form-actions">
                                    <button
                                        wire:click="saveFacebookLink"
                                        class="save-btn"
                                        wire:loading.attr="disabled"
                                        data-translate="common.save"
                                    >
                                        Save
                                    </button>
                                    <button
                                        @click="showForm = false"
                                        class="cancel-btn"
                                        data-translate="common.cancel"
                                    >
                                        Cancel
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <!-- Facebook Profile Confirmed for Duo Power -->
                <div class="duo-profile-confirmed">
                    <div class="profile-info">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor" class="text-success">
                            <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                        </svg>
                        <span data-translate="treasureEvent.duoPower.profileLinked">Facebook Profile Linked:</span>
                        <a href="<?php echo e($this->userFacebookLink); ?>" target="_blank" class="profile-link">
                            <?php echo e(Str::limit($this->userFacebookLink, 50)); ?>

                        </a>
                        <button
                            wire:click="$set('showFacebookLinkForm', true)"
                            class="edit-profile-btn"
                            title="Edit Profile Link"
                        >
                            <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"/>
                            </svg>
                        </button>
                    </div>

                    <!-- Edit Profile Form for Duo Power -->
                    <!--[if BLOCK]><![endif]--><?php if($this->showFacebookLinkForm): ?>
                    <div class="edit-profile-form" x-transition>
                        <div class="form-group">
                            <label data-translate="treasureEvent.duoPower.profileUrl">Facebook Profile URL</label>
                            <input
                                type="url"
                                wire:model="userFacebookLink"
                                placeholder="https://facebook.com/your-profile"
                                class="form-input"
                            >
                        </div>
                        <div class="form-actions">
                            <button
                                wire:click="saveFacebookLink"
                                class="save-btn"
                                wire:loading.attr="disabled"
                                data-translate="common.save"
                            >
                                Save
                            </button>
                            <button
                                wire:click="$set('showFacebookLinkForm', false)"
                                class="cancel-btn"
                                data-translate="common.cancel"
                            >
                                Cancel
                            </button>
                        </div>
                    </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <!--[if BLOCK]><![endif]--><?php if(!empty($this->userFacebookLink)): ?>
            <!-- Requirements Notice -->
            <div class="duo-requirements-notice">
                <div class="requirements-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                    </svg>
                </div>
                <div class="requirements-content">
                    <h5 data-translate="treasureEvent.duoPower.warningTitle">Important Requirements</h5>
                    <p data-translate="treasureEvent.duoPower.warningText">
                        Both partners must have completed like, comment, and share actions on 5 Facebook posts before the duo request can be approved.
                    </p>
                </div>
            </div>

            <!-- Statistics Section -->
            <div class="duo-statistics-section">
                <div class="stats-header">
                    <h4 data-translate="treasureEvent.duoPower.statistics">Your Duo Statistics</h4>
                </div>
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon">📊</div>
                        <div class="stat-content">
                            <span class="stat-value"><?php echo e($duoStats['total_requests'] ?? 0); ?></span>
                            <span class="stat-label" data-translate="treasureEvent.duoPower.totalRequests">Total Requests</span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">⏳</div>
                        <div class="stat-content">
                            <span class="stat-value"><?php echo e($duoStats['pending_requests'] ?? 0); ?></span>
                            <span class="stat-label" data-translate="treasureEvent.duoPower.pendingRequests">Pending</span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">✅</div>
                        <div class="stat-content">
                            <span class="stat-value"><?php echo e($duoStats['approved_requests'] ?? 0); ?></span>
                            <span class="stat-label" data-translate="treasureEvent.duoPower.approvedRequests">Approved</span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">❌</div>
                        <div class="stat-content">
                            <span class="stat-value"><?php echo e($duoStats['rejected_requests'] ?? 0); ?></span>
                            <span class="stat-label" data-translate="treasureEvent.duoPower.rejectedRequests">Rejected</span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">📨</div>
                        <div class="stat-content">
                            <span class="stat-value"><?php echo e($duoStats['sender_requests'] ?? 0); ?></span>
                            <span class="stat-label" data-translate="treasureEvent.duoPower.senderRequests">Sender</span>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">🧑‍🤝‍🧑</div>
                        <div class="stat-content">
                            <span class="stat-value"><?php echo e($duoStats['receiver_requests'] ?? 0); ?></span>
                            <span class="stat-label" data-translate="treasureEvent.duoPower.receiverRequests">Receiver</span>
                        </div>
                    </div>
                </div>

                <div class="points-grid">
                    <div class="points-card duo-collected-rewards">
                        <div class="points-icon">💎</div>
                        <div class="points-content">
                            <span class="points-value"><?php echo e($duoStats['collected_rewards'] ?? 0); ?></span>
                            <span class="points-label" data-translate="treasureEvent.duoPower.collectedRewards">Collected 4T$</span>
                        </div>
                    </div>
                    <div class="points-card duo-pending-rewards">
                        <div class="points-icon">⏳</div>
                        <div class="points-content">
                            <span class="points-value"><?php echo e($duoStats['uncollected_rewards'] ?? 0); ?></span>
                            <span class="points-label" data-translate="treasureEvent.duoPower.uncollectedRewards">Pending 4T$</span>
                        </div>
                    </div>
                </div>

                <?php
                    $acceptedUncollectedRewards = $duoStats['uncollected_rewards'] ?? 0;
                ?>

                <!--[if BLOCK]><![endif]--><?php if($acceptedUncollectedRewards > 0): ?>
                <div class="collect-section duo-collect-section">
                    <div class="collect-info">
                        <span data-translate="treasureEvent.duoPower.collectInfo">You can collect <?php echo e($acceptedUncollectedRewards); ?> 4T$ from Duo Power!</span>
                    </div>
                    <button
                        wire:click="collectDuoRewards"
                        class="collect-btn duo-collect-btn"
                        :disabled="collecting"
                        x-data="{ collecting: false }"
                        @click="collecting = true; setTimeout(() => collecting = false, 3000)"
                    >
                        <span x-show="!collecting" data-translate="treasureEvent.duoPower.collectRewards">Collect Rewards</span>
                        <span x-show="collecting" data-translate="treasureEvent.duoPower.collecting">Collecting...</span>
                    </button>
                </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>

            <!-- Duo Management -->
            <div class="duo-management">
                <div class="section-header">
                    <h4 data-translate="treasureEvent.duoPower.managePosts">Submit New Duo Request</h4>
                </div>

                <!-- New Duo Request Form -->
                <div class="new-duo-form" x-data="{
                    duoRole: <?php if ((object) ('duoRole') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('duoRole'->value()); ?>')<?php echo e('duoRole'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('duoRole'); ?>')<?php endif; ?>,
                    partnerReferrerId: <?php if ((object) ('partnerReferrerId') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('partnerReferrerId'->value()); ?>')<?php echo e('partnerReferrerId'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('partnerReferrerId'); ?>')<?php endif; ?>,
                    partnerFound: <?php if ((object) ('partnerUser') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('partnerUser'->value()); ?>')<?php echo e('partnerUser'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('partnerUser'); ?>')<?php endif; ?>,
                    duoFacebookLinks: <?php if ((object) ('duoFacebookLinks') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('duoFacebookLinks'->value()); ?>')<?php echo e('duoFacebookLinks'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('duoFacebookLinks'); ?>')<?php endif; ?>,
                    duoLinkActions: <?php if ((object) ('duoLinkActions') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('duoLinkActions'->value()); ?>')<?php echo e('duoLinkActions'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('duoLinkActions'); ?>')<?php endif; ?>,
                    searchStatus: 'idle', // idle, searching, found, not-found
                    init() {
                        // Watch for changes in partner referrer ID for basic status updates
                        this.$watch('partnerReferrerId', (value) => {
                            if (!value || value.length === 0) {
                                this.searchStatus = 'idle';
                            } else if (value.length < 3) {
                                this.searchStatus = 'idle';
                            } else if (value.length >= 3) {
                                this.searchStatus = 'searching';
                                // Livewire will handle the search and dispatch the completion event
                                // Don't change status here, let the event listener handle the result
                            }
                        });

                        // Initial status check
                        if (this.partnerReferrerId && this.partnerReferrerId.length >= 3) {
                            this.searchStatus = this.partnerFound ? 'found' : 'not-found';
                        }
                    },
                    calculateProgress() {
                        let totalLinks = 0;
                        let completedLinks = 0;
                        for (let i = 1; i <= 5; i++) {
                            if (this.duoFacebookLinks[i-1] && this.duoFacebookLinks[i-1].trim()) {
                                totalLinks++;
                                if (this.duoLinkActions[i].like && this.duoLinkActions[i].comment && this.duoLinkActions[i].share) {
                                    completedLinks++;
                                }
                            }
                        }
                        return { total: totalLinks, completed: completedLinks };
                    },
                    areLinksUnique() {
                        const links = this.duoFacebookLinks.filter(link => link && link.trim());
                        const uniqueLinks = [...new Set(links)];
                        return links.length === uniqueLinks.length;
                    },
                    isFormValid() {
                        // Check if role is selected
                        if (!this.duoRole) return false;

                        // Check if partner referrer ID is entered
                        if (!this.partnerReferrerId || this.partnerReferrerId.length < 3) return false;

                        // Check if we have 5 valid links
                        const validLinks = this.duoFacebookLinks.filter(link => link && link.trim() && this.isValidUrl(link));
                        if (validLinks.length < 5) return false;

                        // Check if all links are unique
                        if (!this.areLinksUnique()) return false;

                        // Check if all actions are completed for all 5 links
                        for (let i = 1; i <= 5; i++) {
                            if (!this.duoLinkActions[i].like || !this.duoLinkActions[i].comment || !this.duoLinkActions[i].share) {
                                return false;
                            }
                        }

                        return true;
                    },
                    isValidUrl(string) {
                        try {
                            new URL(string);
                            return true;
                        } catch (_) {
                            return false;
                        }
                    }
                }" @partner-search-completed.window="
                    const eventData = Array.isArray($event.detail) ? $event.detail[0] : $event.detail;

                    if (eventData.error) {
                        // Show error message for self-referrer ID
                        searchStatus = 'error';
                    } else {
                        searchStatus = eventData.found ? 'found' : 'not-found';
                    }
                ">                    <!-- Role Selection -->
                    <div class="form-group">
                        <label class="form-label" data-translate="treasureEvent.duoPower.roleSelection">Your Role</label>
                        <div class="role-selector">
                            <label class="role-option" :class="{ 'selected': duoRole === 'sender' }">
                                <input type="radio" x-model="duoRole" value="sender" class="role-input">
                                <div class="role-content">
                                    <div class="role-icon">📨</div>
                                    <div class="role-info">
                                        <span class="role-title" data-translate="treasureEvent.duoPower.senderRole">Sender (Inviter)</span>
                                        <span class="role-desc" data-translate="treasureEvent.duoPower.senderDesc">I am inviting a friend to join</span>
                                    </div>
                                </div>
                            </label>
                            <label class="role-option" :class="{ 'selected': duoRole === 'receiver' }">
                                <input type="radio" x-model="duoRole" value="receiver" class="role-input">
                                <div class="role-content">
                                    <div class="role-icon">🧑‍🤝‍🧑</div>
                                    <div class="role-info">
                                        <span class="role-title" data-translate="treasureEvent.duoPower.receiverRole">Receiver (Invited)</span>
                                        <span class="role-desc" data-translate="treasureEvent.duoPower.receiverDesc">I was invited by a friend</span>
                                    </div>
                                </div>
                            </label>
                        </div>
                    </div>

                    <!-- Partner Search -->
                    <div class="form-group">
                        <label class="form-label" data-translate="treasureEvent.duoPower.partnerReferrerId">Partner Referrer ID</label>
                        <div class="partner-search">
                            <input
                                type="text"
                                x-model="partnerReferrerId"
                                wire:model.live.debounce.500ms="partnerReferrerId"
                                placeholder="Enter partner referrer ID"
                                class="form-input"
                                style="text-transform: uppercase;"
                                maxlength="8"
                                @input="partnerReferrerId = $event.target.value.toUpperCase().trim()"
                            >
                            <div class="partner-status" x-show="partnerReferrerId.length > 0">
                                <!-- Debug info -->
                                <div x-show="false" x-text="'Current searchStatus: ' + searchStatus"></div>

                                <div x-show="searchStatus === 'found'" class="partner-found">
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                                    </svg>
                                    <span data-translate="treasureEvent.duoPower.partnerFound">Partner Found</span>
                                    <!--[if BLOCK]><![endif]--><?php if($this->partnerUser): ?>
                                        <div class="partner-info">
                                            <small><?php echo e($this->partnerUser->username); ?></small>
                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div x-show="searchStatus === 'not-found'" class="partner-not-found">
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 5h-2v6l5.25 3.15.75-1.23-4.5-2.67z"/>
                                    </svg>
                                    <span data-translate="treasureEvent.duoPower.partnerNotFound">Partner not found - You can still submit the request</span>
                                </div>
                                <div x-show="searchStatus === 'error'" class="partner-error">
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 5h-2v6l5.25 3.15.75-1.23-4.5-2.67z"/>
                                    </svg>
                                    <span style="color: #dc3545;">You cannot use your own referrer ID as partner</span>
                                </div>
                                <div x-show="searchStatus === 'searching'" class="partner-searching">
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" class="animate-spin">
                                        <path d="M12,4V2A10,10 0 0,0 2,12H4A8,8 0 0,1 12,4Z"/>
                                    </svg>
                                    <span>Searching for partner...</span>
                                </div>
                                <div x-show="searchStatus === 'idle'" class="partner-searching">
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"/>
                                    </svg>
                                    <span>Type at least 3 characters to search...</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Facebook Links -->
                    <div class="form-group">
                        <label class="form-label" data-translate="treasureEvent.duoPower.facebookLinks">Facebook Verification Links</label>
                        <p class="form-description" data-translate="treasureEvent.duoPower.facebookLinksDesc">
                            You must have like, comment, and share on at least 5 Facebook posts
                        </p>

                        <div class="facebook-links-list">
                            <template x-for="i in 5" :key="i">
                                <div class="link-group">
                                    <div class="link-header">
                                        <span class="link-number" x-text="'Link ' + i"></span>
                                        <div class="link-completion" :class="{
                                            'complete': duoFacebookLinks[i-1] && duoFacebookLinks[i-1].trim() && duoLinkActions[i].like && duoLinkActions[i].comment && duoLinkActions[i].share,
                                            'incomplete': duoFacebookLinks[i-1] && duoFacebookLinks[i-1].trim() && (!duoLinkActions[i].like || !duoLinkActions[i].comment || !duoLinkActions[i].share)
                                        }">
                                            <span x-show="duoFacebookLinks[i-1] && duoFacebookLinks[i-1].trim() && duoLinkActions[i].like && duoLinkActions[i].comment && duoLinkActions[i].share" class="complete-badge">✅ Complete</span>
                                            <span x-show="duoFacebookLinks[i-1] && duoFacebookLinks[i-1].trim() && (!duoLinkActions[i].like || !duoLinkActions[i].comment || !duoLinkActions[i].share)" class="incomplete-badge">⚠️ Incomplete</span>
                                        </div>
                                    </div>

                                    <input
                                        type="url"
                                        x-model="duoFacebookLinks[i-1]"
                                        :placeholder="'Enter Facebook post URL ' + i"
                                        class="form-input link-input"
                                    >

                                    <div class="actions-group" x-show="duoFacebookLinks[i-1] && duoFacebookLinks[i-1].trim()">
                                        <label class="action-checkbox" :class="{ 'checked': duoLinkActions[i].like }">
                                            <input type="checkbox" x-model="duoLinkActions[i].like">
                                            <span class="action-icon">❤️</span>
                                            <span class="action-text">Like</span>
                                        </label>
                                        <label class="action-checkbox" :class="{ 'checked': duoLinkActions[i].comment }">
                                            <input type="checkbox" x-model="duoLinkActions[i].comment">
                                            <span class="action-icon">💬</span>
                                            <span class="action-text">Comment</span>
                                        </label>
                                        <label class="action-checkbox" :class="{ 'checked': duoLinkActions[i].share }">
                                            <input type="checkbox" x-model="duoLinkActions[i].share">
                                            <span class="action-icon">🔄</span>
                                            <span class="action-text">Share</span>
                                        </label>
                                    </div>
                                </div>
                            </template>
                        </div>

                        <div class="links-progress">
                            <div class="progress-text">
                                <span>Progress: </span>
                                <span x-text="calculateProgress().completed + '/' + calculateProgress().total + ' links completed'"></span>
                            </div>
                            <div class="progress-bar">
                                <div class="progress-fill" :style="'width: ' + (calculateProgress().completed / 5 * 100) + '%'"></div>
                            </div>
                        </div>
                    </div>

                    <div class="form-actions">
                        <button
                            wire:click="submitDuoRequest"
                            class="submit-btn duo-submit-btn"
                            :disabled="!isFormValid()"
                            :class="{ 'disabled': !isFormValid() }"
                            x-data="{ submitting: false }"
                            @click="submitting = true; setTimeout(() => submitting = false, 3000)"
                        >
                            <span x-show="!submitting" data-translate="treasureEvent.duoPower.submitRequest">Submit Duo Request</span>
                            <span x-show="submitting" data-translate="treasureEvent.duoPower.submitting">Submitting...</span>
                        </button>

                        <!-- Validation Messages -->
                        <div class="validation-messages" x-show="!isFormValid()">
                            <div x-show="!duoRole" class="validation-error">
                                <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 5h-2v6l5.25 3.15.75-1.23-4.5-2.67z"/>
                                </svg>
                                <span>Please select your role (Sender or Receiver)</span>
                            </div>
                            <div x-show="!partnerReferrerId || partnerReferrerId.length < 3" class="validation-error">
                                <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 5h-2v6l5.25 3.15.75-1.23-4.5-2.67z"/>
                                </svg>
                                <span>Please enter partner referrer ID (minimum 3 characters)</span>
                            </div>
                            <div x-show="duoFacebookLinks.filter(link => link && link.trim() && isValidUrl(link)).length < 5" class="validation-error">
                                <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 5h-2v6l5.25 3.15.75-1.23-4.5-2.67z"/>
                                </svg>
                                <span>Please provide 5 valid Facebook links</span>
                            </div>
                            <div x-show="!areLinksUnique()" class="validation-error">
                                <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 5h-2v6l5.25 3.15.75-1.23-4.5-2.67z"/>
                                </svg>
                                <span style="color: #dc3545;">All Facebook links must be different from each other</span>
                            </div>
                            <div x-show="calculateProgress().completed < 5" class="validation-error">
                                <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 5h-2v6l5.25 3.15.75-1.23-4.5-2.67z"/>
                                </svg>
                                <span>Please complete all actions (like, comment, share) for all 5 links</span>
                            </div>
                        </div>

                        <style>
                        .validation-messages {
                            margin-top: 12px;
                            padding: 12px;
                            background: #fff3cd;
                            border: 1px solid #ffeaa7;
                            border-radius: 6px;
                        }

                        .validation-error {
                            display: flex;
                            align-items: center;
                            gap: 6px;
                            margin-bottom: 6px;
                            color: #d32f2f;
                            font-size: 14px;
                        }

                        .validation-error:last-child {
                            margin-bottom: 0;
                        }

                        .validation-error svg {
                            color: #f57c00;
                            flex-shrink: 0;
                        }

                        .submit-btn.duo-submit-btn.disabled {
                            opacity: 0.6;
                            cursor: not-allowed;
                            background: #e0e0e0 !important;
                            color: #9e9e9e !important;
                        }
                        </style>
                    </div>
                </div>

                <button @click="toggleDuoHistory()" class="history-btn duo-history-btn" :class="{ 'active': showDuoHistory }">
                        <span x-show="!showDuoHistory" class="btn-text">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M13 3c-4.97 0-9 4.03-9 9H1l3.89 3.89.07.14L9 12H6c0-3.87 3.13-7 7-7s7 3.13 7 7-3.13 7-7 7c-1.93 0-3.68-.79-4.94-2.06l-1.42 1.42C8.27 19.99 10.51 21 13 21c4.97 0 9-4.03 9-9s-4.03-9-9-9zm-1 5v5l4.28 2.54.72-1.21-3.5-2.08V8H12z"/>
                            </svg>
                            <span data-translate="treasureEvent.duoPower.history">History</span>
                        </span>
                        <span x-show="showDuoHistory" class="btn-text">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/>
                            </svg>
                            <span data-translate="treasureEvent.duoPower.hideHistory">Hide History</span>
                        </span>
                    </button>
                <!-- Duo History Section -->
                <div
                    x-show="showDuoHistory"
                    x-transition:enter="transition ease-out duration-300"
                    x-transition:enter-start="opacity-0 transform -translate-y-10"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition ease-in duration-200"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-10"
                    class="duo-history-section"
                >
                    <div class="history-header">
                        <h5 data-translate="treasureEvent.duoPower.duoHistory">Duo History</h5>
                        <button @click="toggleDuoHistory()" class="close-history-btn">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/>
                            </svg>
                        </button>
                    </div>

                    <div class="history-list">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $duoRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="history-item duo-history-item">
                                <div class="item-header">
                                    <div class="item-info">
                                        <span class="role-badge <?php echo e($request['role']); ?>">
                                            <!--[if BLOCK]><![endif]--><?php if($request['role'] === 'sender'): ?>
                                                📨 Sender
                                            <?php else: ?>
                                                🧑‍🤝‍🧑 Receiver
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </span>
                                        <span class="partner-info">Partner: <?php echo e($request['partner_referrer_id']); ?></span>
                                    </div>
                                    <div class="item-status">
                                        <!--[if BLOCK]><![endif]--><?php if($request['status'] === 'collected'): ?>
                                            <span class="status-indicator collected" title="<?php echo e(__('treasureEvent.duoPower.statusDescriptions.collected')); ?>">
                                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                                                </svg>
                                                <span data-translate="treasureEvent.duoPower.status.collected">Collected</span>
                                            </span>
                                        <?php elseif($request['status'] === 'approved'): ?>
                                            <span class="status-indicator approved" title="<?php echo e(__('treasureEvent.duoPower.statusDescriptions.approved')); ?>">
                                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M2 20h2c.55 0 1-.45 1-1v-9c0-.55-.45-1-1-1H2v11zm19.83-7.12c.11-.25.17-.52.17-.8 0-.83-.67-1.5-1.5-1.5H14c.08-.7.33-1.42.55-2.13.28-.95.52-1.8.32-2.32-.25-.65-.89-1.13-1.58-1.13-.5 0-.93.28-1.2.7L10.8 8.6C10.3 9.5 10 10.5 10 11.5V19c0 .55.45 1 1 1h8.38c.5 0 .93-.31 1.1-.78L21.83 12.88z"/>
                                                </svg>
                                                <span data-translate="treasureEvent.duoPower.status.approved">Approved</span>
                                            </span>
                                        <?php elseif($request['status'] === 'rejected'): ?>
                                            <span class="status-indicator rejected" title="<?php echo e(__('treasureEvent.duoPower.statusDescriptions.rejected')); ?>">
                                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                                    <circle cx="12" cy="12" r="10"/>
                                                    <line x1="15" y1="9" x2="9" y2="15"/>
                                                    <line x1="9" y1="9" x2="15" y2="15"/>
                                                </svg>
                                                <span data-translate="treasureEvent.duoPower.status.rejected">Rejected</span>
                                            </span>
                                        <?php else: ?>
                                            <span class="status-indicator pending" title="<?php echo e(__('treasureEvent.duoPower.statusDescriptions.pending')); ?>">
                                                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                                    <path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"/>
                                                    <path d="M12.5 7H11v6l5.25 3.15.75-1.23-4.5-2.67z"/>
                                                </svg>
                                                <span data-translate="treasureEvent.duoPower.status.pending">Under Review</span>
                                            </span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>

                                <div class="item-details">
                                    <div class="detail-row">
                                        <span class="detail-label">Reward Amount:</span>
                                        <span class="detail-value"><?php echo e($request['reward_amount']); ?> 4T$</span>
                                    </div>
                                    <div class="detail-row">
                                        <span class="detail-label">Total Points:</span>
                                        <span class="detail-value"><?php echo e($request['total_points']); ?></span>
                                    </div>
                                    <div class="detail-row">
                                        <span class="detail-label">Request Date:</span>
                                        <span class="detail-value"><?php echo e($request['created_at']->format('M d, Y')); ?></span>
                                    </div>
                                    <!--[if BLOCK]><![endif]--><?php if($request['reviewed_at']): ?>
                                    <div class="detail-row">
                                        <span class="detail-label">Review Date:</span>
                                        <span class="detail-value"><?php echo e($request['reviewed_at']->format('M d, Y')); ?></span>
                                    </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <div class="facebook-links-summary">
                                    <h6>Facebook Links Status:</h6>
                                    <div class="links-grid">
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $request['facebook_links']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $linkIndex => $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <!--[if BLOCK]><![endif]--><?php if(!empty($link)): ?>
                                                <div class="link-status-item">
                                                    <span class="link-number"><?php echo e($linkIndex + 1); ?></span>
                                                    <div class="actions-status">
                                                        <span class="action-indicator <?php echo e($request['link_actions'][$linkIndex + 1]['like'] ? 'completed' : 'pending'); ?>">❤️</span>
                                                        <span class="action-indicator <?php echo e($request['link_actions'][$linkIndex + 1]['comment'] ? 'completed' : 'pending'); ?>">💬</span>
                                                        <span class="action-indicator <?php echo e($request['link_actions'][$linkIndex + 1]['share'] ? 'completed' : 'pending'); ?>">🔄</span>
                                                    </div>
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="empty-history">
                                <div class="empty-icon">
                                    <svg width="48" height="48" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M16 4c0-1.11.89-2 2-2s2 .89 2 2-.89 2-2 2-2-.89-2-2zm4 18v-6h2.5l-2.54-7.63A3 3 0 0 0 17.1 7H16.9c-.8 0-1.54.5-1.85 1.26l-1.92 5.63L15.23 17H16v5h4z"/>
                                    </svg>
                                </div>
                                <h6 data-translate="treasureEvent.duoPower.noHistory">No duo requests yet.</h6>
                                <p>Submit your first duo request to start earning rewards!</p>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>

    <!-- Existing Treasure Section -->
    <div class="treasure-section"
         x-show="!showFacebookSection || (showFacebookSection && $refs.facebookSection)"
    >
        <!--[if BLOCK]><![endif]--><?php if($CharsTotalDollar > 0): ?>
            <div class="alert alert-success">
                <h4>Available Treasure: <?php echo e($CharsTotalDollar); ?> 4T Dollar (Gift)</h4>
                <p>You have <?php echo e(count($CharsHaveDollar)); ?> treasure items to claim.</p>
            </div>
        <?php else: ?>
            <div class="alert alert-info">
                <p>No treasure items available to claim at the moment.</p>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!--[if BLOCK]><![endif]--><?php if(!empty($CharsInfo)): ?>
            <div class="characters-list">
                <h5>Your Characters:</h5>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $CharsInfo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $char): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $charDollarItems = collect($CharsHaveDollar)->where('CharID', $char['CharID']);
                        $charDollarAmount = 0;
                        if ($charDollarItems->count() > 0) {
                            $charItemIds = $charDollarItems->pluck('ItemID')->toArray();
                            $charDollarAmount = App\Models\SRO_VT_SHARD\Items::whereIn('ID64', $charItemIds)->sum(
                                'Data',
                            );
                        }
                    ?>

                    <div class="character-card">
                        <h6><?php echo e($char['CharName16'] ?? 'Unknown'); ?></h6>
                        <p>Available Dollars: <?php echo e($charDollarAmount); ?></p>
                        <p>Available Gift Balance: <?php echo e(round($charDollarAmount / 250, 2)); ?></p>

                        <!--[if BLOCK]><![endif]--><?php if($charDollarAmount > 0): ?>
                            <button wire:click="claimReward(<?php echo e($char['CharID']); ?>)" class="btn btn-primary">
                                Claim <?php echo e($charDollarAmount); ?> Gift Balance
                            </button>
                        <?php else: ?>
                            <span class="text-muted">No dollars to claim</span>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>
</div>


</div><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/fast-events/treasure-event.blade.php ENDPATH**/ ?>