<?php

use Livewire\Volt\Component;
use App\Models\Z_Website\News;

?>

<div class="min-h-screen bg-gradient-to-br from-slate-900 via-purple-900 to-slate-900">

<!-- Latest News Section -->
<div class="container mx-auto px-6 py-16">
    <div class="text-center mb-12">
        <h1 class="text-5xl font-bold text-white mb-4" data-translate="news.allNews">All News & Updates</h1>
        <div class="w-24 h-1 bg-gradient-to-r from-purple-500 to-cyan-500 mx-auto"></div>
    </div>

    <!-- News Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12">
        <!--[if BLOCK]><![endif]--><?php if($this->news && $this->news->count() > 0): ?>
        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <!--[if BLOCK]><![endif]--><?php if($news && is_array($news)): ?>
        <article class="bg-gradient-to-br from-slate-800/50 to-purple-900/30 backdrop-blur-lg border border-purple-500/30 rounded-2xl overflow-hidden shadow-2xl hover:border-purple-400/50 transition-all duration-300 hover:scale-105">
            <!--[if BLOCK]><![endif]--><?php if($news['image']): ?>
            <div class="h-48 bg-cover bg-center relative" style="background-image: url('<?php echo e($news['image']); ?>')">
                <div class="absolute inset-0 bg-gradient-to-t from-purple-900/50 to-transparent"></div>
            </div>
            <?php else: ?>
            <div class="h-48 bg-gradient-to-br from-purple-600 to-blue-600 flex items-center justify-center relative">
                <div class="text-6xl">📰</div>
                <div class="absolute inset-0 bg-gradient-to-t from-purple-900/30 to-transparent"></div>
            </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <div class="p-6">
                <div class="flex items-center gap-2 text-purple-300 text-sm mb-3">
                    <span>📅</span>
                    <span><?php echo e($news['published_at'] ? \Carbon\Carbon::parse($news['published_at'])->format('M d, Y') : 'N/A'); ?></span>
                </div>

                <h3 class="text-xl font-bold text-white mb-3 line-clamp-2">
                    <?php echo e($news['title'] ?? 'Untitled News'); ?>

                </h3>

                <p class="text-purple-200 text-sm leading-relaxed mb-4 line-clamp-3">
                    <?php echo e($news['excerpt'] ?? 'No content available.'); ?>

                </p>

                <a href="<?php echo e(route('news', ['id' => $news['id']])); ?>" class="inline-flex items-center gap-2 px-4 py-2 bg-purple-600 hover:bg-purple-700 text-white rounded-lg transition-colors text-sm font-medium">
                    <span data-translate="news.readMore">Read More</span>
                    <span>→</span>
                </a>
            </div>
        </article>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
        <?php else: ?>
        <div class="col-span-full text-center py-12">
            <div class="text-6xl mb-4">📰</div>
            <h3 class="text-xl font-bold text-white mb-2" data-translate="news.noNews">No News Available</h3>
            <p class="text-purple-300" data-translate="news.checkBackLater">Please check back later for updates.</p>
        </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <!-- Back to Home Button -->
    <div class="text-center">
        <a href="<?php echo e(route('home')); ?>" class="px-8 py-4 bg-gradient-to-r from-purple-600 to-blue-600 hover:from-purple-700 hover:to-blue-700 text-white rounded-lg transition-all duration-300 font-medium text-lg shadow-lg hover:shadow-xl">
            ← <span data-translate="news.backToHome">Back to Home</span>
        </a>
    </div>
</div>


</div><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/news/index.blade.php ENDPATH**/ ?>