<?php

use Livewire\Volt\Component;
use Illuminate\Support\Facades\Auth;

?>

<div x-data="{
    sidebarOpen: <?php if ((object) ('sidebarOpen') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('sidebarOpen'->value()); ?>')<?php echo e('sidebarOpen'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('sidebarOpen'); ?>')<?php endif; ?>,
    currentPage: <?php if ((object) ('currentPage') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('currentPage'->value()); ?>')<?php echo e('currentPage'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('currentPage'); ?>')<?php endif; ?>,

    init() {
        // Load saved page from sessionStorage on init
        const savedPage = sessionStorage.getItem('dashboard_current_page');
        if (savedPage && savedPage !== this.currentPage) {
            this.currentPage = savedPage;
            $wire.setCurrentPage(savedPage);
        }

        // Watch for currentPage changes and save to sessionStorage
        this.$watch('currentPage', (newPage) => {
            sessionStorage.setItem('dashboard_current_page', newPage);
        });
    },

    setPage(page) {
        this.currentPage = page;
        $wire.setCurrentPage(page);
        sessionStorage.setItem('dashboard_current_page', page);
    }
}" x-cloak>
    <div class="desktop-dashboard-wrapper">

    <!-- Desktop Dashboard Container -->
    <div class="desktop-dashboard-container">
        <!-- Desktop Sidebar -->
        <div class="desktop-dashboard-sidebar desktop-dashboard-sidebar-glow lg:block hidden"
             x-show="true">


            <!-- Desktop Navigation Menu -->
            <nav class="desktop-dashboard-nav">
                <!-- Main Section -->
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->getMenuItemsBySection('main'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $menuData = $this->renderMenuItem($item); ?>
                    <button x-on:click="setPage('<?php echo e($item['key']); ?>')"
                            class="desktop-dashboard-menu-item <?php echo e($menuData['isActive'] ? 'active' : ''); ?> desktop-tooltip desktop-glow-effect"
                            data-tooltip="<?php echo e($item['subtitle']); ?>">
                        <div class="desktop-dashboard-menu-content">
                            <div class="desktop-dashboard-menu-icon <?php echo e($menuData['iconClass']); ?>">
                                <?php echo $item['icon']; ?>

                            </div>
                            <div class="desktop-dashboard-menu-text">
                                <span class="desktop-dashboard-menu-title" wire:ignore  data-translate="<?php echo e($item['translate']['title'] ?? 'menu.' . $item['key'] . '.title'); ?>"><?php echo e($item['title']); ?></span>
                                <p class="desktop-dashboard-menu-subtitle" wire:ignore  data-translate="<?php echo e($item['translate']['subtitle'] ?? 'menu.' . $item['key'] . '.subtitle'); ?>"><?php echo e($item['subtitle']); ?></p>
                            </div>
                            <svg class="desktop-dashboard-menu-arrow <?php echo e($menuData['arrowClass']); ?>" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M9 18l6-6-6-6"/>
                            </svg>
                        </div>
                    </button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

                <?php $__currentLoopData = ['shop', 'inventory', 'logs']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!--[if BLOCK]><![endif]--><?php if($this->getMenuItemsBySection($section)->count() > 0): ?>
                        <?php $sectionData = $this->renderSectionDivider($section); ?>
                        <!-- Desktop <?php echo e(ucfirst($section)); ?> Section Divider -->
                        <div class="desktop-dashboard-divider desktop-slide-up">
                            <div class="desktop-dashboard-divider-content">
                                <div class="desktop-dashboard-divider-line"></div>
                                <span class="desktop-dashboard-divider-text" wire:ignore  data-translate="<?php echo e($sectionData['translateKey']); ?>"><?php echo e($sectionData['title']); ?></span>
                                <div class="desktop-dashboard-divider-line"></div>
                            </div>
                        </div>

                        <!-- Desktop <?php echo e(ucfirst($section)); ?> Section -->
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->getMenuItemsBySection($section); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $menuData = $this->renderMenuItem($item); ?>
                            <button x-on:click="setPage('<?php echo e($item['key']); ?>')"
                                    class="desktop-dashboard-menu-item <?php echo e($menuData['isActive'] ? 'active' : ''); ?> desktop-tooltip desktop-glow-effect"
                                    data-tooltip="<?php echo e($item['subtitle']); ?>">
                                <div class="desktop-dashboard-menu-content">
                                    <div class="desktop-dashboard-menu-icon <?php echo e($menuData['iconClass']); ?>">
                                        <?php echo $item['icon']; ?>

                                    </div>
                                    <div class="desktop-dashboard-menu-text">
                                        <span class="desktop-dashboard-menu-title" wire:ignore  data-translate="<?php echo e($item['translate']['title'] ?? 'menu.' . $item['key'] . '.title'); ?>"><?php echo e($item['title']); ?></span>
                                        <p class="desktop-dashboard-menu-subtitle" wire:ignore  data-translate="<?php echo e($item['translate']['subtitle'] ?? 'menu.' . $item['key'] . '.subtitle'); ?>"><?php echo e($item['subtitle']); ?></p>
                                    </div>
                                    <svg class="desktop-dashboard-menu-arrow <?php echo e($menuData['arrowClass']); ?>" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M9 18l6-6-6-6"/>
                                    </svg>
                                </div>
                            </button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </nav>
        </div>


        <!-- Desktop Content Area -->
        <div class="desktop-dashboard-content dashboard-content-responsive">
            <!-- Desktop Top Bar -->
            <div class="hidden lg:block desktop-dashboard-topbar">
                <div class="desktop-dashboard-topbar-content">
                    <div class="desktop-dashboard-topbar-left">
                        <h1   data-translate="page.<?php echo e($this->currentPage); ?>.title"><?php echo e($this->getPageTitle()); ?></h1>
                        <p  data-translate="page.<?php echo e($this->currentPage); ?>.description"><?php echo e($this->getPageTitle()); ?> Management System</p>

                        
                        <small class="text-gray-400 text-xs">Current Page: <?php echo e($currentPage); ?> | Time: <?php echo e(now()->format('H:i:s')); ?></small>
                    </div>
                </div>
            </div>

            <!-- Desktop Page Content -->
            <div class="desktop-dashboard-page">
                <div class="max-w-7xl mx-auto">
                    <!-- Content will be loaded here based on selected page -->
                    <div class="desktop-dashboard-main-card"
                         wire:key="page-<?php echo e($currentPage); ?>"
                         x-show="true">
                        <?php
                            $currentPageData = $this->getCurrentPageData();
                        ?>

                        <!--[if BLOCK]><![endif]--><?php if($currentPageData): ?>
                            
                            <div wire:key="content-<?php echo e($currentPage); ?>">
                                <!--[if BLOCK]><![endif]--><?php if($currentPage === '4t-app'): ?>
                                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.4t-app', []);

$__html = app('livewire')->mount($__name, $__params, '4t-app-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                <?php elseif($currentPage === 'quests'): ?>
                                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.quests', []);

$__html = app('livewire')->mount($__name, $__params, 'quests-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                <?php elseif($currentPage === 'char-list'): ?>
                                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.char-list', []);

$__html = app('livewire')->mount($__name, $__params, 'char-list-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                <?php elseif($currentPage === 'shipping'): ?>
                                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.shipping', []);

$__html = app('livewire')->mount($__name, $__params, 'shipping-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                <?php elseif($currentPage === 'packages-shop'): ?>
                                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.packages-shop', []);

$__html = app('livewire')->mount($__name, $__params, 'packages-shop-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                <?php elseif($currentPage === 'item-shop'): ?>
                                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.item-shop', []);

$__html = app('livewire')->mount($__name, $__params, 'item-shop-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                <?php elseif($currentPage === 'gift-item-shop'): ?>
                                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.gift-item-shop', []);

$__html = app('livewire')->mount($__name, $__params, 'gift-item-shop-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                <?php elseif($currentPage === 'players-shop'): ?>
                                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.players-shop', []);

$__html = app('livewire')->mount($__name, $__params, 'players-shop-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                <?php elseif($currentPage === 'web-inventory'): ?>
                                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.web-inventory', []);

$__html = app('livewire')->mount($__name, $__params, 'web-inventory-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                <?php elseif($currentPage === 'market-inventory'): ?>
                                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.market-inventory', []);

$__html = app('livewire')->mount($__name, $__params, 'market-inventory-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                <?php elseif($currentPage === 'market-logs'): ?>
                                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.market-logs', []);

$__html = app('livewire')->mount($__name, $__params, 'market-logs-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                <?php elseif($currentPage === 'rewards-systems'): ?>
                                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.rewards-systems', []);

$__html = app('livewire')->mount($__name, $__params, 'rewards-systems-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                <?php else: ?>
                                    
                                    @try
                                        <?php echo $__env->make($currentPageData['include'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                    @catch(Exception $e)
                                        <div class="desktop-dashboard-error">
                                            <div class="desktop-dashboard-error-icon">
                                                <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                                                    <path d="M10.29 3.86L1.82 18a2 2 0 001.71 3h16.94a2 2 0 001.71-3L13.71 3.86a2 2 0 00-3.42 0z"/>
                                                    <line x1="12" y1="9" x2="12" y2="13"/>
                                                    <line x1="12" y1="17" x2="12.01" y2="17"/>
                                                </svg>
                                            </div>
                                            <h3 class="desktop-dashboard-error-title">Include Error</h3>
                                            <p class="desktop-dashboard-error-description"><?php echo e($currentPage); ?> template could not be loaded.</p>
                                        </div>
                                    @endtry
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php else: ?>
                            
                            <div class="desktop-dashboard-error">
                                <div class="desktop-dashboard-error-icon">
                                    <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                                        <path d="M10.29 3.86L1.82 18a2 2 0 001.71 3h16.94a2 2 0 001.71-3L13.71 3.86a2 2 0 00-3.42 0z"/>
                                        <line x1="12" y1="9" x2="12" y2="13"/>
                                        <line x1="12" y1="17" x2="12.01" y2="17"/>
                                    </svg>
                                </div>
                                <h3 class="desktop-dashboard-error-title" wire:ignore  data-translate="error.pageNotFound.title">Page Not Found</h3>
                                <p class="desktop-dashboard-error-description" wire:ignore  data-translate="error.pageNotFound.description">The requested page could not be loaded. Please try again.</p>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
</div><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/backend/dashboard-parts/desktop.blade.php ENDPATH**/ ?>