<?php

use Livewire\Volt\Component;
use Illuminate\Support\Facades\Auth;

?>

<div x-data="{
    activeTab: <?php if ((object) ('currentPage') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('currentPage'->value()); ?>')<?php echo e('currentPage'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('currentPage'); ?>')<?php endif; ?>,
    menuOpen: false,
    slideTransition: false,
    animationLoaded: false,

    init() {
        this.animationLoaded = true;
        // Load saved page from sessionStorage on init
        const savedPage = sessionStorage.getItem('dashboard_current_page');
        if (savedPage && savedPage !== this.activeTab) {
            this.activeTab = savedPage;
            $wire.setCurrentPage(savedPage);
        }
    },

    switchTab(tabKey) {
        if (this.activeTab !== tabKey) {
            this.slideTransition = true;
            setTimeout(() => {
                this.activeTab = tabKey;
                $wire.setCurrentPage(tabKey);
                sessionStorage.setItem('dashboard_current_page', tabKey);
                this.menuOpen = false;
                setTimeout(() => this.slideTransition = false, 100);
            }, 200);
        }
    },

    toggleMenu() {
        this.menuOpen = !this.menuOpen;
    }
}"
x-cloak
class="mobile-dashboard-wrapper"
:class="{ 'mobile-menu-open': menuOpen }">

    <!-- Mobile Dashboard Container -->
    <div class="mobile-dashboard-container" :class="{ 'mobile-fade-in': animationLoaded }">

        <!-- Mobile Header -->
        <div class="mobile-dashboard-header mobile-slide-down" x-data="{ headerAnimating: false }">
            <div class="mobile-dashboard-header-content">
                <div class="mobile-dashboard-header-left"
                     x-effect="if (slideTransition) { headerAnimating = true; setTimeout(() => headerAnimating = false, 300); }"
                     :class="{ 'mobile-header-fade': headerAnimating }">
                    <?php $currentPageData = $this->getCurrentPageData(); ?>
                    <h1 wire:ignore  data-translate="<?php echo e($currentPageData['translate']['title'] ?? 'menu.' . $currentPage . '.title'); ?>">
                        <?php echo e($currentPageData['title'] ?? 'Current Page'); ?>

                    </h1>
                    <p wire:ignore  data-translate="<?php echo e($currentPageData['translate']['description'] ?? 'menu.' . $currentPage . '.description'); ?>">
                        <?php echo e($currentPageData['subtitle'] ?? $this->getPageTitle()); ?>

                    </p>
                </div>

                <div class="mobile-dashboard-header-right">


                    <!-- Mobile Menu Toggle -->
                    <button @click="toggleMenu()" class="mobile-menu-toggle">
                        <span class="mobile-menu-hamburger">
                            <span></span>
                            <span></span>
                            <span></span>
                        </span>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile Navigation Menu Overlay -->
        <div class="mobile-dashboard-menu-overlay"
             x-show="menuOpen"
             x-transition:enter="mobile-overlay-enter"
             x-transition:enter-end="mobile-overlay-enter-end"
             x-transition:leave="mobile-overlay-leave-end"
             @click="menuOpen = false">
        </div>

        <!-- Mobile Navigation Menu -->
        <div class="mobile-dashboard-menu"
             x-show="menuOpen"
             x-transition:enter="mobile-menu-enter"
             x-transition:enter-end="mobile-menu-enter-end"
             x-transition:leave="mobile-menu-leave-end">

            <div class="mobile-dashboard-menu-header">
                <h3 wire:ignore  data-translate="menu.navigation.title">Navigation</h3>
                <button @click="menuOpen = false" class="mobile-menu-close">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="18" y1="6" x2="6" y2="18"/>
                        <line x1="6" y1="6" x2="18" y2="18"/>
                    </svg>
                </button>
            </div>

            <div class="mobile-dashboard-menu-content">
                
                <div class="mobile-menu-section">
                    <h4 wire:ignore  data-translate="section.main.title" class="mobile-menu-section-title">Main Management</h4>
                    <div class="mobile-menu-items">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->getMenuItemsBySection('main'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mobile-menu-item <?php echo e($currentPage === $item['key'] ? 'active' : ''); ?>"
                                 @click="switchTab('<?php echo e($item['key']); ?>')">
                                <div class="mobile-menu-item-icon">
                                    <?php echo $item['icon']; ?>

                                </div>
                                <div class="mobile-menu-item-content">
                                    <h5 wire:ignore  data-translate="<?php echo e($item['translate']['title'] ?? 'menu.' . $item['key'] . '.title'); ?>">
                                        <?php echo e($item['title']); ?>

                                    </h5>
                                    <p wire:ignore  data-translate="<?php echo e($item['translate']['description'] ?? 'menu.' . $item['key'] . '.description'); ?>">
                                        <?php echo e($item['subtitle'] ?? 'Mobile Application'); ?>

                                    </p>
                                </div>
                                <div class="mobile-menu-item-arrow">
                                    <svg width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M9 18l6-6-6-6"/>
                                    </svg>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>

                
                <div class="mobile-menu-section">
                    <h4 wire:ignore  data-translate="section.shop.title" class="mobile-menu-section-title">Shop Management</h4>
                    <div class="mobile-menu-items">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->getMenuItemsBySection('shop'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mobile-menu-item <?php echo e($currentPage === $item['key'] ? 'active' : ''); ?>"
                                 @click="switchTab('<?php echo e($item['key']); ?>')">
                                <div class="mobile-menu-item-icon">
                                    <?php echo $item['icon']; ?>

                                </div>
                                <div class="mobile-menu-item-content">
                                    <h5 wire:ignore  data-translate="<?php echo e($item['translate']['title'] ?? 'menu.' . $item['key'] . '.title'); ?>">
                                        <?php echo e($item['title']); ?>

                                    </h5>
                                    <p wire:ignore  data-translate="<?php echo e($item['translate']['description'] ?? 'menu.' . $item['key'] . '.description'); ?>">
                                        <?php echo e($item['subtitle'] ?? 'Mobile Application'); ?>

                                    </p>
                                </div>
                                <div class="mobile-menu-item-arrow">
                                    <svg width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M9 18l6-6-6-6"/>
                                    </svg>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>

                
                <div class="mobile-menu-section">
                    <h4 wire:ignore  data-translate="section.inventory.title" class="mobile-menu-section-title">Inventory</h4>
                    <div class="mobile-menu-items">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->getMenuItemsBySection('inventory'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mobile-menu-item <?php echo e($currentPage === $item['key'] ? 'active' : ''); ?>"
                                 @click="switchTab('<?php echo e($item['key']); ?>')">
                                <div class="mobile-menu-item-icon">
                                    <?php echo $item['icon']; ?>

                                </div>
                                <div class="mobile-menu-item-content">
                                    <h5 wire:ignore  data-translate="<?php echo e($item['translate']['title'] ?? 'menu.' . $item['key'] . '.title'); ?>">
                                        <?php echo e($item['title']); ?>

                                    </h5>
                                    <p wire:ignore  data-translate="<?php echo e($item['translate']['description'] ?? 'menu.' . $item['key'] . '.description'); ?>">
                                        <?php echo e($item['subtitle'] ?? 'Mobile Application'); ?>

                                    </p>
                                </div>
                                <div class="mobile-menu-item-arrow">
                                    <svg width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M9 18l6-6-6-6"/>
                                    </svg>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

                        <!-- Logs Section -->
                        <div class="mobile-menu-section">
                            <h4 class="mobile-menu-section-title">
                                <span wire:ignore  data-translate="section.logs.title">Logs & Analytics</span>
                            </h4>
                        </div>

                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->getMenuItemsBySection('logs'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mobile-menu-item <?php echo e($currentPage === $item['key'] ? 'active' : ''); ?>"
                                 @click="switchTab('<?php echo e($item['key']); ?>')">
                                <div class="mobile-menu-item-icon">
                                    <?php echo $item['icon']; ?>

                                </div>
                                <div class="mobile-menu-item-content">
                                    <h5 wire:ignore  data-translate="<?php echo e($item['translate']['title'] ?? 'menu.' . $item['key'] . '.title'); ?>">
                                        <?php echo e($item['title']); ?>

                                    </h5>
                                    <p wire:ignore  data-translate="<?php echo e($item['translate']['description'] ?? 'menu.' . $item['key'] . '.description'); ?>">
                                        <?php echo e($item['subtitle'] ?? 'Mobile Application'); ?>

                                    </p>
                                </div>
                                <div class="mobile-menu-item-arrow">
                                    <svg width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M9 18l6-6-6-6"/>
                                    </svg>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>

        <!-- Mobile Content Area -->
        <div class="mobile-dashboard-content">
            <div class="mobile-dashboard-content-inner"
                 x-show="!slideTransition"
                 wire:key="mobile-content-<?php echo e($currentPage); ?>">

                <?php $currentPageData = $this->getCurrentPageData(); ?>

                <!--[if BLOCK]><![endif]--><?php if($currentPageData): ?>
                    
                    <!--[if BLOCK]><![endif]--><?php if($currentPage === '4t-app'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.4t-app', []);

$__html = app('livewire')->mount($__name, $__params, 'mobile-4t-app-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'quests'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.quests', []);

$__html = app('livewire')->mount($__name, $__params, 'mobile-quests-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'char-list'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.char-list', []);

$__html = app('livewire')->mount($__name, $__params, 'mobile-char-list-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'shipping'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.shipping', []);

$__html = app('livewire')->mount($__name, $__params, 'mobile-shipping-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'packages-shop'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.packages-shop', []);

$__html = app('livewire')->mount($__name, $__params, 'mobile-packages-shop-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'item-shop'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.item-shop', []);

$__html = app('livewire')->mount($__name, $__params, 'mobile-item-shop-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'gift-item-shop'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.gift-item-shop', []);

$__html = app('livewire')->mount($__name, $__params, 'mobile-gift-item-shop-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'players-shop'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.players-shop', []);

$__html = app('livewire')->mount($__name, $__params, 'mobile-players-shop-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'web-inventory'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.web-inventory', []);

$__html = app('livewire')->mount($__name, $__params, 'mobile-web-inventory-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'market-inventory'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.market-inventory', []);

$__html = app('livewire')->mount($__name, $__params, 'mobile-market-inventory-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'market-logs'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.market-logs', []);

$__html = app('livewire')->mount($__name, $__params, 'mobile-market-logs-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'rewards-systems'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.rewards-systems', []);

$__html = app('livewire')->mount($__name, $__params, 'mobile-rewards-systems-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php else: ?>
                        
                        @try
                            <?php echo $__env->make($currentPageData['include'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        @catch(Exception $e)
                            <div class="mobile-dashboard-error">
                                <div class="mobile-dashboard-error-icon">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M10.29 3.86L1.82 18a2 2 0 001.71 3h16.94a2 2 0 001.71-3L13.71 3.86a2 2 0 00-3.42 0z"/>
                                        <line x1="12" y1="9" x2="12" y2="13"/>
                                        <line x1="12" y1="17" x2="12.01" y2="17"/>
                                    </svg>
                                </div>
                                <h3 class="mobile-dashboard-error-title" wire:ignore  data-translate="error.pageNotFound.title">
                                    Include Error
                                </h3>
                                <p class="mobile-dashboard-error-description" wire:ignore  data-translate="error.include.message">
                                    <?php echo e($currentPage); ?> template could not be loaded.
                                </p>
                            </div>
                        @endtry
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                <?php else: ?>
                    
                    <div class="mobile-dashboard-error">
                        <div class="mobile-dashboard-error-icon">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M10.29 3.86L1.82 18a2 2 0 001.71 3h16.94a2 2 0 001.71-3L13.71 3.86a2 2 0 00-3.42 0z"/>
                                <line x1="12" y1="9" x2="12" y2="13"/>
                                <line x1="12" y1="17" x2="12.01" y2="17"/>
                            </svg>
                        </div>
                        <h3 class="mobile-dashboard-error-title" wire:ignore  data-translate="error.pageNotFound.title">
                            Page Not Found
                        </h3>
                        <p class="mobile-dashboard-error-description" wire:ignore  data-translate="error.pageNotFound.description">
                            The requested page could not be loaded. Please try again.
                        </p>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>

            
            <div x-show="slideTransition" class="mobile-dashboard-content-loading">
                <div class="mobile-loading-container">
                    <div class="mobile-loading-icon">
                        <svg class="mobile-bounce" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <rect x="2" y="5" width="20" height="14" rx="2" ry="2"/>
                            <path d="M2 17h20"/>
                            <path d="M6 21h12"/>
                            <path d="M12 17v4"/>
                        </svg>
                    </div>
                    <h3 class="mobile-loading-title" wire:ignore  data-translate="common.loading">
                        Loading...
                    </h3>
                    <p class="mobile-loading-description" wire:ignore  data-translate="mobile.switching.page">
                        Switching to <?php echo e($currentPageData['title'] ?? 'Page'); ?>

                    </p>
                    <div class="mobile-loading-dots">
                        <span></span>
                        <span></span>
                        <span></span>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/backend/dashboard-parts/mobile.blade.php ENDPATH**/ ?>