<?php

use Livewire\Volt\Component;
use Illuminate\Support\Facades\Auth;
use App\Models\SRO_VT_SHARD\Char;
use App\Models\Z_Website\Quests\TaskUserVipStatus;
use App\Models\Z_Website\Quests\TaskUserProgress;
use App\Models\Z_Website\Quests\TaskUserDailyTask;
use App\Models\Z_Website\Quests\TaskDailyTask;
use App\Models\Z_Website\Quests\TaskRewardChain;
use App\Models\Z_Website\Quests\TasksUserReward;
use App\Models\Z_Website\Quests\TaskReward;
use App\Models\SRO_VT_SHARD\CharQuest;
use App\Models\SRO_VT_PROXY\_InstantCharReloadDelivery;
use Illuminate\Support\Facades\Log;

?>

<div>




    <div class="quest-container" x-data="{
        CurrentNewPage: 'welcome',
        showGetQuestModal: false,
        showVipModal: false,
        showInsufficientBalanceModal: false,
        selectedCharacter: null,
        isCompleting: false,
        isCompleted: false,
        isUpgrading: false,
        currentBalance: <?php echo e(Auth::user()->webUser->balance ?? 0); ?>,
        vipCost: 500,

        selectCharacter(characterId) {
            this.selectedCharacter = characterId;
        },

        confirmSelection() {
            if (this.selectedCharacter) {
                $wire.call('selectCharacter', this.selectedCharacter);
                this.CurrentNewPage = 'welcome';
                this.selectedCharacter = null;
            }
        },

        showCharacterSelection() {
            this.CurrentNewPage = 'selectChar';
        },

        backToWelcome() {
            this.CurrentNewPage = 'welcome';
            this.selectedCharacter = null;
        },

        openGetQuestModal() {
            this.showGetQuestModal = true;
        },

        closeGetQuestModal() {
            this.showGetQuestModal = false;
        },

        getNewQuest() {
            $wire.call('getNewTask');
            this.closeGetQuestModal();
        },

        async completeTask() {
            this.isCompleting = true;

            try {
                // Get QuestID and CharID from current task data if available
                const questId = <?php echo e($TaskDetails->QuestID ?? 'null'); ?>;
                const charId = <?php echo e($UserChar->CharID ?? 'null'); ?>;

                // Call the backend function with the IDs for better logging
                await $wire.call('completeTask');
                this.isCompleted = true;

                // Reset states after animation
                setTimeout(() => {
                    this.isCompleting = false;
                    this.isCompleted = false;
                }, 2000);

            } catch (error) {
                console.error('Error completing task:', error);
                this.isCompleting = false;
            }
        },

        openVipModal() {
            this.showVipModal = true;
        },

        closeVipModal() {
            this.showVipModal = false;
        },

        checkBalance() {
            return this.currentBalance >= this.vipCost;
        },

        async upgradeToVip() {
            if (!this.checkBalance()) {
                this.showVipModal = false;
                this.showInsufficientBalanceModal = true;
                return;
            }

            this.isUpgrading = true;

            try {
                // Call backend VIP upgrade function
                await $wire.call('upgradeToVip');

                // Show success animation
                this.showSuccessAnimation();

                // Update balance immediately in UI
                this.currentBalance -= this.vipCost;

                // Dispatch event to update header balance
                window.Livewire.dispatch('updateBalances');

                // Close modal after success
                setTimeout(() => {
                    this.showVipModal = false;
                    this.isUpgrading = false;
                }, 2000);

            } catch (error) {
                console.error('VIP upgrade error:', error);
                this.isUpgrading = false;
                // Show error message
            }
        },

        showSuccessAnimation() {
            // Add success animation logic here if needed
            console.log('VIP upgrade successful!');
        },

        closeInsufficientBalanceModal() {
            this.showInsufficientBalanceModal = false;
        }
    }">

<!--[if BLOCK]><![endif]--><?php if($hasChar && $ProgressInfo): ?>
    <?php
        $startDate = \Carbon\Carbon::parse($ProgressInfo->start_date);
        $endDate = $startDate->copy()->addDays(31);
    ?>
<?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        <!--[if BLOCK]><![endif]--><?php if(!$hasChar): ?>
            <!-- Welcome/Character Selection State Pages -->
            <div class="w-full max-w-4xl mx-auto">
                <!-- Welcome Card -->
                <div x-show="CurrentNewPage === 'welcome'"
                     x-transition:enter="transition duration-500 ease-out"
                     x-transition:enter-start="opacity-0 transform scale-95"
                     x-transition:enter-end="opacity-100 transform scale-100"
                     x-transition:leave="transition duration-300 ease-in"
                     x-transition:leave-start="opacity-100 transform scale-100"
                     x-transition:leave-end="opacity-0 transform scale-95"
                     class="bg-gradient-to-br from-purple-900 via-gray-900 to-purple-700 rounded-2xl shadow-2xl p-8 text-center border-4 border-purple-400">

                    <div class="text-6xl md:text-7xl mb-6 animate-bounce">🏆</div>

                    <h1 class="text-3xl md:text-4xl font-extrabold text-purple-300 mb-4"
                        wire:ignore  data-translate="page.quests.no_character_title">
                        Welcome to the Quest System!
                    </h1>

                    <p class="text-lg md:text-xl text-gray-200 mb-8 leading-relaxed max-w-2xl mx-auto"
                       wire:ignore  data-translate="page.quests.no_character_description">
                        Embark on an epic adventure and earn amazing rewards every day!
                        Complete quests, claim rewards, and become the ultimate champion.
                        Your journey to greatness starts here!
                    </p>

                    <button class="w-full md:w-auto bg-gradient-to-r from-green-400 to-purple-500 text-white font-bold text-lg py-4 px-8 rounded-xl shadow-lg hover:scale-105 transition flex items-center justify-center gap-3 mx-auto"
                            x-on:click="showCharacterSelection()">
                        <span class="text-2xl">🎮</span>
                        <span wire:ignore  data-translate="page.quests.epic_rewards_await">Choose Your Character & Start Adventure!</span>
                    </button>
                </div>

                <!-- Character Selection Page -->
                <div x-show="CurrentNewPage === 'selectChar'"
                     x-transition:enter="transition duration-500 ease-out"
                     x-transition:enter-start="opacity-0 transform translate-x-4"
                     x-transition:enter-end="opacity-100 transform translate-x-0"
                     x-transition:leave="transition duration-300 ease-in"
                     x-transition:leave-start="opacity-100 transform translate-x-0"
                     x-transition:leave-end="opacity-0 transform translate-x-4"
                     class="bg-gradient-to-br from-blue-900 via-gray-900 to-blue-700 rounded-2xl shadow-2xl p-8 border-4 border-blue-400">

                    <!-- Header -->
                    <div class="text-center mb-8">
                        <button x-on:click="backToWelcome()"
                                class="absolute top-4 left-4 bg-gray-700 hover:bg-gray-600 text-white rounded-full w-10 h-10 flex items-center justify-center transition">
                            ←
                        </button>

                        <div class="text-5xl mb-4">⚔️</div>
                        <h2 class="text-3xl font-extrabold text-blue-300 mb-2" wire:ignore data-translate="page.quests.character_selection.title">Choose Your Character</h2>
                        <p class="text-lg text-gray-300" wire:ignore data-translate="page.quests.character_selection.description">Select the character you want to use for quests</p>
                    </div>

                    <!-- Characters Grid -->
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4 mb-8">
                        <!--[if BLOCK]><![endif]--><?php if($availableChars && count($availableChars) > 0): ?>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $availableChars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $character): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="character-card bg-gray-800 rounded-xl p-4 border-2 cursor-pointer transition-all duration-300 hover:scale-105"
                                     x-on:click="selectCharacter('<?php echo e($character->CharID); ?>')"
                                     x-bind:class="selectedCharacter === '<?php echo e($character->CharID); ?>' ? 'border-blue-400 bg-blue-900' : 'border-gray-600 hover:border-blue-500'">

                                    <div class="character-avatar text-center mb-3">
                                        <?php
                                            $avatarUrl = Char::getCharAvatarGifByCharname($character->CharName16);
                                        ?>
                                        <!--[if BLOCK]><![endif]--><?php if($avatarUrl): ?>
                                            <img src="<?php echo e($avatarUrl); ?>" alt="<?php echo e($character->CharName16); ?>"
                                                 class="w-16 h-16 mx-auto rounded-lg object-cover border-2 border-gray-600">
                                        <?php else: ?>
                                            <div class="w-16 h-16 mx-auto bg-gray-700 rounded-lg flex items-center justify-center text-3xl">👤</div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>

                                    <div class="text-center">
                                        <div class="font-bold text-white mb-1"><?php echo e($character->CharName16); ?></div>
                                        <div class="text-sm text-gray-400">Level <?php echo e($character->CurLevel ?? 'Unknown'); ?></div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        <?php else: ?>
                            <div class="col-span-full text-center py-12 bg-gray-800 rounded-xl">
                                <div class="text-4xl mb-4">😔</div>
                                <h3 class="text-xl font-bold text-gray-300 mb-2" wire:ignore data-translate="page.quests.character_selection.no_characters">No Characters Available</h3>
                                <p class="text-gray-400">Please create a character in the game first, then come back to start your quest journey!</p>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!-- Actions -->
                    <div class="flex flex-col sm:flex-row gap-4 justify-center">
                        <button class="bg-gradient-to-r from-green-400 to-blue-500 text-white font-bold py-3 px-6 rounded-xl shadow-lg hover:scale-105 transition flex items-center justify-center gap-2"
                                x-bind:disabled="!selectedCharacter"
                                x-bind:class="{ 'opacity-50 cursor-not-allowed': !selectedCharacter }"
                                x-on:click="confirmSelection()">
                            <span>✅</span>
                            <span wire:ignore data-translate="common.confirm">Confirm Selection</span>
                        </button>

                        <button class="bg-gradient-to-r from-gray-600 to-gray-700 text-white font-bold py-3 px-6 rounded-xl shadow-lg hover:scale-105 transition flex items-center justify-center gap-2"
                                x-on:click="backToWelcome()">
                            <span>❌</span>
                            <span wire:ignore data-translate="common.cancel">Cancel</span>
                        </button>
                    </div>
                </div>
            </div>
            
        <?php elseif($endDate < now()): ?>
            <!-- Journey Complete Celebration -->
            <div class="journey-complete-container"
                 x-data="{
                    showFireworks: true,
                    showCelebration: true,
                    celebrationPhase: 'welcome', // welcome, achievements, celebration, new_journey
                    totalRewardsClaimed: <?php echo e($UserReward ? count(array_filter($UserReward, function($reward) { return $reward['is_claimed']; })) : 0); ?>,
                    totalDaysCompleted: <?php echo e($totalCompletedDays ?? 0); ?>,
                    isVipUser: <?php echo e($UserChar && $UserChar->isVip ? 'true' : 'false'); ?>,

                    init() {
                        this.startCelebrationSequence();
                        this.createFireworks();
                        setTimeout(() => this.celebrationPhase = 'achievements', 2000);
                        setTimeout(() => this.celebrationPhase = 'celebration', 5000);
                        setTimeout(() => this.celebrationPhase = 'new_journey', 8000);
                    },

                    createFireworks() {
                        for (let i = 0; i < 20; i++) {
                            setTimeout(() => {
                                this.addFirework();
                            }, i * 200);
                        }
                    },

                    addFirework() {
                        const container = document.querySelector('.fireworks-container');
                        if (!container) return;

                        const firework = document.createElement('div');
                        firework.className = 'firework firework-' + (Math.floor(Math.random() * 4) + 1);
                        firework.style.top = Math.random() * 80 + '%';
                        firework.style.left = Math.random() * 80 + '%';
                        container.appendChild(firework);

                        setTimeout(() => firework.remove(), 2000);
                    },

                    addConfetti() {
                        const container = document.querySelector('.fireworks-container');
                        if (!container) return;

                        for (let i = 0; i < 10; i++) {
                            const confetti = document.createElement('div');
                            confetti.className = 'confetti';
                            confetti.style.left = Math.random() * 100 + '%';
                            confetti.style.animationDelay = Math.random() * 2 + 's';
                            container.appendChild(confetti);

                            setTimeout(() => confetti.remove(), 3000);
                        }
                    },

                    startCelebrationSequence() {
                        setTimeout(() => this.addConfetti(), 1000);
                        setTimeout(() => this.addConfetti(), 3000);
                        setTimeout(() => this.addConfetti(), 5000);
                    },

                    restartJourney() {
                        // إعادة تعيين الرحلة
                        $wire.call('restartJourney').then(() => {
                            location.reload();
                        });
                    },

                    goToDashboard() {
                        window.location.href = '/dashboard';
                    }
                 }"
                 x-transition:enter="transition duration-1000 ease-out"
                 x-transition:enter-start="opacity-0 transform scale-50"
                 x-transition:enter-end="opacity-100 transform scale-100">

                <!-- Fireworks Background -->
                <div class="fireworks-container" x-show="showFireworks"></div>

                <!-- Welcome Phase -->
                <div x-show="celebrationPhase === 'welcome'"
                     x-transition:enter="transition duration-1000 ease-out"
                     x-transition:enter-start="opacity-0 transform translateY(50px)"
                     x-transition:enter-end="opacity-100 transform translateY(0)">

                    <h1 class="celebration-title" wire:ignore  data-translate="page.quests.journey_complete.title">
                        🎊 Journey Complete! 🎊
                    </h1>

                    <h2 class="celebration-subtitle" wire:ignore  data-translate="page.quests.journey_complete.subtitle">
                        Epic Quest Adventure Finished!
                    </h2>

                    <p class="celebration-message" wire:ignore  data-translate="page.quests.journey_complete.welcome_message">
                        Congratulations, legendary hero! You have successfully completed your 31-day quest journey.
                        Your dedication, courage, and perseverance have led you to this incredible achievement!
                    </p>
                </div>

                <!-- Achievements Phase -->
                <div x-show="celebrationPhase === 'achievements'"
                     x-transition:enter="transition duration-800 ease-out"
                     x-transition:enter-start="opacity-0 transform scale-90"
                     x-transition:enter-end="opacity-100 transform scale-100">

                    <h2 class="celebration-subtitle" wire:ignore  data-translate="page.quests.journey_complete.achievements.title">
                        🏆 Your Epic Achievements 🏆
                    </h2>

                    <div class="achievements-grid">
                        <div class="achievement-card">
                            <div class="achievement-icon">📅</div>
                            <span class="achievement-number" x-text="totalDaysCompleted"><?php echo e($totalCompletedDays ?? 0); ?></span>
                            <span class="achievement-label" wire:ignore  data-translate="page.quests.journey_complete.achievements.days_completed">
                                Days Completed
                            </span>
                        </div>

                        <div class="achievement-card">
                            <div class="achievement-icon">🎁</div>
                            <span class="achievement-number" x-text="totalRewardsClaimed"><?php echo e($UserReward ? count(array_filter($UserReward, function($reward) { return $reward['is_claimed']; })) : 0); ?></span>
                            <span class="achievement-label" wire:ignore  data-translate="page.quests.journey_complete.achievements.rewards_claimed">
                                Rewards Claimed
                            </span>
                        </div>

                        <div class="achievement-card">
                            <div class="achievement-icon" x-text="isVipUser ? '👑' : '⭐'"></div>
                            <span class="achievement-number"><?php echo e($UserChar && $UserChar->isVip ? '👑' : '1'); ?></span>
                            <span class="achievement-label" x-text="isVipUser ? 'VIP Champion' : 'Hero Status'"
                                  wire:ignore  data-translate="<?php echo e($UserChar && $UserChar->isVip ? 'page.quests.journey_complete.achievements.vip_champion' : 'page.quests.journey_complete.achievements.hero_status'); ?>">
                                <?php echo e($UserChar && $UserChar->isVip ? 'VIP Champion' : 'Hero Status'); ?>

                            </span>
                        </div>
                    </div>
                </div>

                <!-- Celebration Phase -->
                <div x-show="celebrationPhase === 'celebration'"
                     x-transition:enter="transition duration-1000 ease-out"
                     x-transition:enter-start="opacity-0 transform rotateY(180deg)"
                     x-transition:enter-end="opacity-100 transform rotateY(0deg)">

                    <div class="legendary-message" wire:ignore  data-translate="page.quests.journey_complete.celebration.legendary_message">
                        🌟 You are now a LEGENDARY QUEST MASTER! 🌟<br>
                        Your name will be remembered in the halls of heroes!
                    </div>

                    <p class="celebration-message" wire:ignore  data-translate="page.quests.journey_complete.celebration.final_message">
                        Through 31 days of challenges, battles, and victories, you have proven yourself worthy of greatness.
                        Your journey may be complete, but your legend lives on forever!
                    </p>

                    <!-- Fireworks Text -->
                    <div class="text-center my-6">
                        <span class="text-6xl animate-pulse">🎆🎇✨🎊🎉✨🎇🎆</span>
                    </div>
                </div>

                <!-- New Journey Phase -->
                <div x-show="celebrationPhase === 'new_journey'"
                     x-transition:enter="transition duration-800 ease-out"
                     x-transition:enter-start="opacity-0 transform translateY(-50px)"
                     x-transition:enter-end="opacity-100 transform translateY(0)">

                    <div class="new-journey-section">
                        <h3 class="new-journey-title" wire:ignore  data-translate="page.quests.journey_complete.new_journey.title">
                            🚀 Ready for Another Adventure? 🚀
                        </h3>

                        <p class="new-journey-description" wire:ignore  data-translate="page.quests.journey_complete.new_journey.description">
                            The world needs heroes like you! Start a new 31-day quest journey and continue your path to becoming
                            the ultimate champion. New challenges, new rewards, and new legends await!
                        </p>

                        <div class="journey-action-buttons">
                            <button class="journey-btn journey-btn-primary"
                                    x-on:click="restartJourney()"
                                    wire:ignore  data-translate="page.quests.journey_complete.new_journey.start_new">
                                🌟 Start New Journey 🌟
                            </button>

                            <button class="journey-btn journey-btn-secondary"
                                    x-on:click="goToDashboard()"
                                    wire:ignore  data-translate="page.quests.journey_complete.new_journey.back_to_dashboard">
                                🏠 Back to Dashboard
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="quest-dashboard">
                <div class="quest-header">
                    <h1 class="quest-title">Quest Progress for <?php echo e($UserChar->CharName16); ?></h1>

                    <!-- Quest Main Info Container -->
                    <!--[if BLOCK]><![endif]--><?php if($ProgressInfo && $ProgressInfo->start_date): ?>
                        <div class="quest-main-container">
                            <!-- Left Side: Duration, Progress Bar, Stats -->
                            <div class="quest-left-section">
                                <!-- Quest Progress Bar with Duration -->
                                <?php
                                    $currentDate = \Carbon\Carbon::now();
                                    $totalDays = $startDate->diffInDays($endDate);
                                    $daysPassed = $startDate->diffInDays($currentDate);
                                    $progressPercentage = min(100, max(0, ($daysPassed / $totalDays) * 100));
                                    $daysRemaining = max(0, $endDate->diffInDays($currentDate));
                                ?>

                                <div class="quest-progress-bar">
                                    <!-- Duration Info Header -->
                                    <div class="quest-duration">
                                        <div class="duration-card">
                                            <div class="duration-icon">🚀</div>
                                            <div class="duration-info">
                                                <span class="duration-label" wire:ignore data-translate="page.quests.status.started">Quest Started</span>
                                                <span class="duration-value"><?php echo e($startDate->format('M d, Y')); ?></span>
                                            </div>
                                        </div>

                                        <div class="duration-separator">
                                            <div class="separator-line"></div>
                                            <div class="separator-icon">⏱️</div>
                                            <div class="separator-line"></div>
                                        </div>

                                        <div class="duration-card">
                                            <div class="duration-icon">🏆</div>
                                            <div class="duration-info">
                                                <span class="duration-label">Quest Ends</span>
                                                <span class="duration-value"><?php echo e($endDate->format('M d, Y')); ?></span>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Progress Info -->
                                    <div class="progress-header">
                                        <div class="progress-info">
                                            <span class="progress-label">Quest Timeline Progress</span>
                                            <span
                                                class="progress-percentage"><?php echo e(round($progressPercentage, 1)); ?>%</span>
                                        </div>
                                        <div class="days-remaining">
                                            <!--[if BLOCK]><![endif]--><?php if($daysRemaining > 0): ?>
                                                <span class="remaining-text"><?php echo e($daysRemaining); ?> days remaining</span>
                                            <?php else: ?>
                                                <span class="remaining-text completed">Quest Completed!</span>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>

                                    <!-- Progress Bar -->
                                    <div class="progress-track">
                                        <div class="progress-fill" style="width: <?php echo e($progressPercentage); ?>%">
                                            <div class="progress-glow"></div>
                                        </div>
                                        <div class="progress-marker" style="left: <?php echo e($progressPercentage); ?>%">
                                            <div class="marker-dot"></div>
                                            <div class="marker-label">Today</div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Quest Stats -->
                                <div class="quest-stats">
                                    <div class="stat-card">
                                        <div class="stat-icon">📊</div>
                                        <div class="stat-info">
                                            <span class="stat-label">Current Day</span>
                                            <span class="stat-value"><?php echo e($currentDay); ?>/31</span>
                                        </div>
                                    </div>
                                    <div class="stat-card">
                                        <div class="stat-icon">✅</div>
                                        <div class="stat-info">
                                            <span class="stat-label">Completed Days</span>
                                            <span class="stat-value"><?php echo e($totalCompletedDays); ?></span>
                                        </div>
                                    </div>
                                    <div class="stat-card">
                                        <div class="stat-icon">🔥</div>
                                        <div class="stat-info">
                                            <span class="stat-label">Progress</span>
                                            <span
                                                class="stat-value"><?php echo e($ProgressInfo ? round(($totalCompletedDays / 31) * 100, 1) : 0); ?>%</span>
                                        </div>
                                    </div>
                                    
                                    <!--[if BLOCK]><![endif]--><?php if($UserChar && !$UserChar->isVip): ?>
                                        <div class="stat-card vip-upgrade" x-on:click="showVipModal = true">
                                            <div class="vip-upgrade-content">
                                                <div class="vip-icon">👑</div>
                                                <div class="vip-text-container">
                                                    <span class="vip-title"
                                                        wire:ignore  data-translate="page.quests.vip.upgrade_title">Upgrade to
                                                        VIP</span>
                                                    <span class="vip-cost"
                                                        wire:ignore  data-translate="page.quests.vip.cost_diamonds">500 💎</span>
                                                    <span class="vip-balance-check"
                                                        wire:ignore  data-translate="page.quests.vip.duration">1 Month</span>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>

                            <!-- Right Side: Daily Progress Grid -->
                            <div class="quest-right-section">
                                <div class="progress-section">
                                    <h3 class="section-title">31-Day Challenge Progress</h3>
                                    <div class="progress-grid">
                                        <!--[if BLOCK]><![endif]--><?php for($day = 1; $day <= 31; $day++): ?>
                                            <?php
                                                $dayStatus = $ProgressInfo->isDayCompleted($day);
                                                $statusClass = $dayStatus
                                                    ? 'completed'
                                                    : ($day <= $currentDay
                                                        ? 'current'
                                                        : 'upcoming');
                                                $isToday = $day == $currentDay;
                                            ?>

                                            <div class="day-box <?php echo e($statusClass); ?> <?php echo e($isToday ? 'today' : ''); ?>">
                                                <span class="day-number"><?php echo e($day); ?></span>
                                                <span class="day-status">
                                                    <!--[if BLOCK]><![endif]--><?php if($dayStatus): ?>
                                                        ✓
                                                    <?php elseif($isToday): ?>
                                                        🔄
                                                    <?php else: ?>
                                                        ○
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </span>
                                                <!--[if BLOCK]><![endif]--><?php if($isToday): ?>
                                                    <span class="today-label">Today</span>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                        <?php endfor; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <!-- No Progress Info - Show Stats Only -->
                        <div class="quest-stats">
                            <div class="stat-card">
                                <div class="stat-icon">📊</div>
                                <div class="stat-info">
                                    <span class="stat-label">Current Day</span>
                                    <span class="stat-value"><?php echo e($currentDay); ?>/31</span>
                                </div>
                            </div>
                            <div class="stat-card">
                                <div class="stat-icon">✅</div>
                                <div class="stat-info">
                                    <span class="stat-label">Completed Days</span>
                                    <span class="stat-value"><?php echo e($totalCompletedDays); ?></span>
                                </div>
                            </div>
                            <div class="stat-card">
                                <div class="stat-icon">🔥</div>
                                <div class="stat-info">
                                    <span class="stat-label">Progress</span>
                                    <span class="stat-value">0%</span>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>

            <!-- Daily Task Section -->
            <!--[if BLOCK]><![endif]--><?php if($hasChar): ?>
                <div class="daily-task-section">
                    <!--[if BLOCK]><![endif]--><?php if($ProgressInfo && $ProgressInfo->isDayCompleted($currentDay)): ?>
                        <!-- Congratulations Card -->
                        <div class="w-full max-w-4xl mx-auto bg-gradient-to-br from-green-900 via-purple-900 to-green-700 rounded-2xl shadow-2xl p-8 mb-8 border-4 border-green-400"
                             x-transition:enter="transition duration-500 ease-out"
                             x-transition:enter-start="opacity-0 transform scale-95"
                             x-transition:enter-end="opacity-100 transform scale-100">

                            <!-- Success Animation -->
                            <div class="flex justify-center items-center mb-6">
                                <div class="relative">
                                    <div class="text-6xl md:text-7xl animate-bounce">🎉</div>
                                    <div class="absolute inset-0 animate-pulse">
                                        <div class="w-20 h-20 md:w-24 md:h-24 border-4 border-green-400 rounded-full animate-ping"></div>
                                        <div class="w-16 h-16 md:w-20 md:h-20 border-2 border-yellow-400 rounded-full animate-ping" style="animation-delay: 0.5s;"></div>
                                        <div class="w-12 h-12 md:w-16 md:h-16 border border-purple-400 rounded-full animate-ping" style="animation-delay: 1s;"></div>
                                    </div>
                                </div>
                            </div>

                            <div class="text-center text-white">
                                <h2 class="text-3xl md:text-4xl font-extrabold text-green-300 mb-4"
                                    wire:ignore  data-translate="page.quests.congratulations.daily_complete_title">
                                    Daily Quest Completed!
                                </h2>

                                <p class="text-lg md:text-xl text-gray-200 mb-8 leading-relaxed max-w-2xl mx-auto"
                                    wire:ignore  data-translate="page.quests.congratulations.daily_complete_message">
                                    Amazing work, hero! You've successfully completed today's quest and earned your
                                    rewards. Your dedication brings you one step closer to greatness!
                                </p>

                                <!-- Quest Summary -->
                                <div class="bg-black bg-opacity-30 rounded-xl p-6 mb-8">
                                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                        <div class="flex flex-col items-center p-4 bg-gradient-to-br from-purple-700 to-green-600 rounded-lg">
                                            <span class="text-3xl mb-2">🎯</span>
                                            <span class="text-sm text-gray-300 mb-1">Quest:</span>
                                            <span class="text-white font-bold text-center"><?php echo e($TaskDetails->task_name ?? 'Daily Quest'); ?></span>
                                        </div>
                                        <div class="flex flex-col items-center p-4 bg-gradient-to-br from-green-700 to-purple-600 rounded-lg">
                                            <span class="text-3xl mb-2">📊</span>
                                            <span class="text-sm text-gray-300 mb-1">Progress:</span>
                                            <span class="text-white font-bold">Day <?php echo e($currentDay); ?>/31 Complete</span>
                                        </div>
                                        <div class="flex flex-col items-center p-4 bg-gradient-to-br from-purple-700 to-green-600 rounded-lg">
                                            <span class="text-3xl mb-2">🏆</span>
                                            <span class="text-sm text-gray-300 mb-1">Total Days:</span>
                                            <span class="text-white font-bold"><?php echo e($totalCompletedDays); ?> Days</span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Tomorrow Message -->
                                <div class="bg-gradient-to-r from-purple-800 to-green-800 rounded-xl p-6 mb-6">
                                    <h3 class="text-2xl font-bold text-yellow-300 mb-3"
                                        wire:ignore  data-translate="page.quests.congratulations.come_back_tomorrow">
                                        Come Back Tomorrow
                                    </h3>
                                    <p class="text-gray-200 text-lg leading-relaxed"
                                        wire:ignore  data-translate="page.quests.congratulations.tomorrow_message">
                                        A new adventure awaits you tomorrow with fresh quests and exciting rewards. See
                                        you tomorrow, champion!
                                    </p>
                                </div>

                                <!-- Streak Reminder -->
                                <div class="flex items-center justify-center space-x-3 bg-gradient-to-r from-orange-600 to-red-600 rounded-full py-3 px-6">
                                    <span class="text-2xl animate-pulse">🔥</span>
                                    <span class="text-white font-bold text-lg"
                                        wire:ignore  data-translate="page.quests.congratulations.keep_streak">Keep Your Streak Going!</span>
                                </div>
                            </div>
                        </div>
                    <?php elseif($UserTask): ?>
                        <!-- Task Available -->
                        <div class="task-card active">

                            <div class="w-full flex justify-center items-center my-4">
                                <!--[if BLOCK]><![endif]--><?php if($TaskDetails && $TaskDetails->task_image): ?>
                                    <div class="relative w-full max-w-lg md:max-w-xl lg:max-w-2xl">
                                        <img src="<?php echo e($TaskDetails->task_image); ?>"
                                            alt="<?php echo e($TaskDetails->task_name ?? 'Task Image'); ?>"
                                            class="w-full h-auto rounded-2xl shadow-xl object-cover">
                                        <div class="absolute inset-0 pointer-events-none"></div>
                                        <div class="absolute -inset-2 rounded-2xl border-4 border-purple-400 shadow-lg"></div>
                                    </div>
                                <?php else: ?>
                                    <div class="task-icon-placeholder text-6xl md:text-7xl lg:text-8xl">🎯</div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>


                            <div class="task-content">
                                <h3 class="task-title"><?php echo e($TaskDetails->task_name ?? 'Unknown Task'); ?></h3>
                            </div>

                            <div class="task-action">
                                <div
                                    class="task-status-badge <?php echo e(!empty($GameQuests) && isset($GameQuests['QuestData2']) && $GameQuests['QuestData2'] == 1 ? 'completed' : 'active'); ?>">
                                    <!--[if BLOCK]><![endif]--><?php if(!empty($GameQuests) && isset($GameQuests['QuestData2']) && $GameQuests['QuestData2'] == 1): ?>
                                        <span wire:ignore  data-translate="page.quests.task_modal.quest_completed">Quest
                                            Completed!</span>
                                    <?php else: ?>
                                        <span wire:ignore  data-translate="page.quests.task_modal.quest_in_progress">Quest in
                                            Progress</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="task-progress-ring">
                                    <!--[if BLOCK]><![endif]--><?php if(!empty($GameQuests) && isset($GameQuests['QuestData2']) && $GameQuests['QuestData2'] == 1): ?>
                                        <div class="progress-check">✅</div>
                                    <?php else: ?>
                                        <div class="progress-spinner"></div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <!-- Complete Quest Button -->
                                <button class="task-complete-btn" x-on:click="completeTask()"
                                    x-bind:class="{
                                        'completing': isCompleting,
                                        'completed': isCompleted
                                    }"
                                    x-bind:disabled="isCompleting ||
                                        <?php echo e(empty($GameQuests) || !isset($GameQuests['QuestData2']) || $GameQuests['QuestData2'] != 1 ? 'true' : 'false'); ?>"
                                    x-transition:enter="transition ease-out duration-300"
                                    x-transition:enter-start="opacity-0 transform scale-90"
                                    x-transition:enter-end="opacity-100 transform scale-100">

                                    <span class="complete-icon" x-show="!isCompleting && !isCompleted">🎯</span>
                                    <span class="complete-icon" x-show="isCompleting">⏳</span>
                                    <span class="complete-icon" x-show="isCompleted">✅</span>

                                    <span x-show="!isCompleting && !isCompleted"
                                        wire:ignore  data-translate="page.quests.task_modal.complete_quest_btn">
                                        Complete Quest Day
                                    </span>
                                    <span x-show="isCompleting"
                                        wire:ignore  data-translate="page.quests.task_modal.completing_quest">
                                        Completing Quest...
                                    </span>
                                    <span x-show="isCompleted"
                                        wire:ignore  data-translate="page.quests.task_modal.quest_completed">
                                        Quest Completed!
                                    </span>
                                </button>
                            </div>
                        </div>
                    <?php else: ?>
                        <!-- No Task Available Page -->
                        <div x-data="{ CurrentQuestPage: 'NoTask' }" class="w-full flex flex-col items-center justify-center py-12">
                            <div class="max-w-md w-full bg-gradient-to-br from-purple-900 via-gray-900 to-purple-700 rounded-2xl shadow-xl p-8 text-center">
                                <div class="mb-4 text-5xl">📋</div>
                                <h3 class="text-2xl font-bold text-purple-300 mb-2">No Quest Available</h3>
                                <p class="text-lg text-gray-300 mb-6">Start your daily adventure by getting a new quest
                                </p>
                                <button class="quest-btn-primary w-full py-3 rounded-lg bg-gradient-to-r from-green-400 to-purple-500 text-white font-bold text-lg shadow-lg hover:scale-105 transition flex items-center justify-center gap-2"
                                    x-on:click="CurrentQuestPage = 'GetQuestPage'; $wire.call('getNewTask')">
                                    <span>🚀</span>
                                    <span>Get My Quest!</span>
                                </button>
                            </div>
                            <template x-if="CurrentQuestPage === 'GetQuestPage'">
                                <div class="mt-8 max-w-md w-full bg-gradient-to-br from-green-900 via-purple-900 to-gray-800 rounded-2xl shadow-xl p-8 text-center animate__animated animate__fadeIn">
                                    <div class="mb-4 text-5xl">🎯</div>
                                    <h3 class="text-2xl font-bold text-green-300 mb-2">Your New Quest Is Ready!</h3>
                                    <p class="text-lg text-gray-300 mb-6">Check your quest details and start your adventure
                                        now.</p>
                                    <button class="quest-btn-secondary w-full py-3 rounded-lg bg-gradient-to-r from-purple-400 to-green-500 text-white font-bold text-lg shadow-lg hover:scale-105 transition flex items-center justify-center gap-2"
                                        x-on:click="CurrentQuestPage = 'NoTask'">
                                        <span>❌</span>
                                        <span>Close</span>
                                    </button>
                                </div>
                            </template>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!-- Rewards Showcase Section -->
        <div class="quest-rewards-section w-full py-10 px-2 md:px-8 lg:px-16 bg-gradient-to-br from-purple-900 via-gray-900 to-purple-700 rounded-2xl shadow-xl mt-8 mb-8"
             x-data="{
            claimingReward: null,
            CurrentGiftPage: 'rewards',
            claimedRewardName: '',
            claimedRewardType: '',
            claimedRewardIcon: '',
            claimedRewardCount: '',
            totalCompletedDays: <?php echo e($totalCompletedDays ?? 0); ?>,
            userRewards: <?php echo \Illuminate\Support\Js::from($UserReward ?? [])->toHtml() ?>,
            async claimReward(type, rewardChainId, rewardName, rewardIcon, rewardCount) {
                console.log('Claiming reward:', { type, rewardChainId, rewardName });
                this.claimingReward = type + '_' + rewardChainId;
                try {
                    if (type === 'normal') {
                        console.log('Calling claimNormalReward with ID:', rewardChainId);
                        await $wire.call('claimNormalReward', rewardChainId);
                    } else if (type === 'vip') {
                        console.log('Calling claimVipReward with ID:', rewardChainId);
                        await $wire.call('claimVipReward', rewardChainId);
                    }
                    console.log('Reward claim successful for type:', type);

                    // Store reward details for success page
                    this.claimedRewardName = rewardName;
                    this.claimedRewardType = type;
                    this.claimedRewardIcon = rewardIcon;
                    this.claimedRewardCount = rewardCount;

                    // Show success page
                    this.CurrentGiftPage = 'success';

                    // Return to rewards page after 4 seconds
                    setTimeout(() => {
                        this.CurrentGiftPage = 'rewards';
                        this.claimingReward = null;
                    }, 4000);
                } catch (error) {
                    console.error('Error claiming reward:', error);
                    console.error('Error details:', {
                        type: type,
                        rewardChainId: rewardChainId,
                        rewardName: rewardName,
                        errorMessage: error.message,
                        errorStack: error.stack
                    });
                    alert('خطأ في استلام المكافأة: ' + (error.message || 'مشكلة غير محددة'));
                    this.claimingReward = null;
                }
            },
            isClaimable(requiredDays) {
                return this.totalCompletedDays >= requiredDays;
            },
            isRewardClaimed(rewardId, rewardType) {
                if (!this.userRewards || !Array.isArray(this.userRewards)) return false;
                return this.userRewards.some(reward =>
                    reward.reward_id == rewardId &&
                    reward.reward_type == rewardType &&
                    reward.is_claimed == 1
                );
            },
            getClaimButtonText(type, rewardChainId) {
                const claimId = type + '_' + rewardChainId;
                if (this.claimingReward === claimId) return '⏳ Claiming...';
                return '🎁 Claim ' + (type === 'normal' ? 'Normal' : 'VIP') + ' Reward';
            },
            isClaimingSpecific(type, rewardChainId) {
                return this.claimingReward === type + '_' + rewardChainId;
            }
        }">

            <!-- Rewards List Page -->
            <div x-show="CurrentGiftPage === 'rewards'"
                 x-transition:enter="transition ease-out duration-500"
                 x-transition:enter-start="opacity-0 transform scale-95"
                 x-transition:enter-end="opacity-100 transform scale-100"
                 x-transition:leave="transition ease-in duration-300"
                 x-transition:leave-start="opacity-100 transform scale-100"
                 x-transition:leave-end="opacity-0 transform scale-95">

                <div class="rewards-header text-center mb-8">
                    <h2 class="rewards-title text-4xl md:text-5xl font-extrabold bg-gradient-to-r from-purple-400 via-pink-400 to-purple-600 bg-clip-text text-transparent mb-2 drop-shadow-lg">
                        Epic Rewards Chain
                    </h2>
                    <p class="rewards-description text-lg md:text-xl text-gray-300 max-w-2xl mx-auto mb-2">
                        Complete daily quests to unlock incredible treasures and exclusive rewards
                    </p>
                </div>
            <div class="rewards-chain-grid grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6 md:gap-8">
                <!--[if BLOCK]><![endif]--><?php if($RewardsChain && count($RewardsChain) > 0): ?>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $RewardsChain; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rewardChain): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $isClaimable = $totalCompletedDays >= $rewardChain['days_required'];
                            $normalReward = $rewardChain['normal_reward'] ?? null;
                            $vipReward = $rewardChain['vip_reward'] ?? null;
                            $normalClaimed = false;
                            $vipClaimed = false;
                            if ($UserReward && is_array($UserReward) && $normalReward) {
                                foreach ($UserReward as $userReward) {
                                    if (isset($normalReward['id']) && $userReward['reward_id'] == $normalReward['id'] && $userReward['reward_type'] == 'Normal' && $userReward['is_claimed']) {
                                        $normalClaimed = true;
                                        break;
                                    }
                                }
                            }
                            if ($UserReward && is_array($UserReward) && $vipReward) {
                                foreach ($UserReward as $userReward) {
                                    if (isset($vipReward['id']) && $userReward['reward_id'] == $vipReward['id'] && $userReward['reward_type'] == 'VIP' && $userReward['is_claimed']) {
                                        $vipClaimed = true;
                                        break;
                                    }
                                }
                            }
                        ?>
                        <div class="reward-chain-card relative rounded-xl shadow-lg border-2 transition-all duration-300 bg-gradient-to-br from-gray-900 via-purple-900 to-gray-800 p-4 flex flex-col justify-between
                            <?php echo e($isClaimable ? 'border-purple-400' : 'border-gray-700'); ?>

                            <?php echo e(($normalClaimed && $vipClaimed) ? 'opacity-70 border-green-400' : ''); ?>">
                            <div class="reward-card-header relative pb-2 mb-2 border-b border-gray-700">
                                <div class="reward-day-badge absolute top-0 right-0 bg-gradient-to-r from-purple-500 to-pink-400 text-white px-4 py-1 rounded-full font-bold shadow-md text-xs">
                                    Day <?php echo e($rewardChain['days_required']); ?>

                                </div>
                                <h3 class="reward-title text-xl font-bold text-purple-200 mb-1">
                                    Day <?php echo e($rewardChain['days_required']); ?> Reward
                                </h3>
                                <p class="reward-description text-gray-400 text-sm">
                                    <?php echo e($rewardChain['reward_description']); ?>

                                </p>
                            </div>
                            <div class="reward-card-body flex-1 flex flex-col gap-4">
                                <div class="rewards-split grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <!-- Normal Reward -->
                                    <!--[if BLOCK]><![endif]--><?php if($normalReward && is_array($normalReward)): ?>
                                        <div class="reward-item normal relative rounded-lg border-2 p-4 flex flex-col items-center justify-center bg-gray-900
                                            <?php echo e($normalClaimed ? 'border-green-400 opacity-80' : 'border-green-600'); ?>">
                                            <!--[if BLOCK]><![endif]--><?php if($normalClaimed): ?>
                                                <div class="reward-claimed-overlay absolute inset-0 bg-green-700 bg-opacity-80 flex items-center justify-center text-white font-bold text-lg rounded-lg">
                                                    <span>✅ Claimed</span>
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            <div class="reward-header mb-2">
                                                <span class="reward-type-badge normal bg-gradient-to-r from-green-400 to-green-600 text-white px-2 py-1 rounded text-xs font-semibold">
                                                    Standard Reward
                                                </span>
                                            </div>
                                            <div class="reward-content flex flex-col items-center gap-2">
                                                <div class="reward-icon w-16 h-16 rounded-lg overflow-hidden border-2 border-green-400 bg-gray-800 flex items-center justify-center">
                                                    <img src="<?php echo e(asset($normalReward['reward_icon'])); ?>" alt="<?php echo e($normalReward['reward_name']); ?>" class="w-full h-full object-cover" onerror="this.src='<?php echo e(asset('images/default-reward.svg')); ?>'">
                                                </div>
                                                <div class="reward-details text-center">
                                                    <h4 class="reward-name text-base font-bold text-white mb-1"><?php echo e($normalReward['reward_name']); ?></h4>
                                                    <p class="reward-type-info text-green-300 text-xs mb-1"><?php echo e(ucfirst($normalReward['reward_type'])); ?></p>
                                                    <span class="reward-count bg-green-700 text-white px-2 py-1 rounded-full text-xs font-semibold">x<?php echo e($normalReward['reward_count']); ?></span>
                                                </div>
                                            </div>
                                            <div class="reward-action w-full mt-2 flex justify-center">
                                                <!--[if BLOCK]><![endif]--><?php if($normalClaimed): ?>
                                                    <button class="reward-btn collected w-full py-2 rounded bg-gray-700 text-gray-300 font-bold cursor-not-allowed flex items-center justify-center gap-2" disabled>
                                                        <span class="reward-btn-icon">✅</span>
                                                        <span>Claimed</span>
                                                    </button>
                                                <?php elseif($isClaimable): ?>
                                                    <button class="reward-btn collect w-full py-2 rounded bg-gradient-to-r from-green-400 to-green-600 text-white font-bold flex items-center justify-center gap-2 shadow-lg hover:scale-105 transition"
                                                        x-bind:class="{ 'opacity-60': claimingReward === 'normal_<?php echo e($rewardChain['id']); ?>' }"
                                                        x-on:click="claimReward('normal', <?php echo e($rewardChain['id']); ?>, '<?php echo e(addslashes($normalReward['reward_name'])); ?>', '<?php echo e(asset($normalReward['reward_icon'])); ?>', '<?php echo e($normalReward['reward_count']); ?>')"
                                                        :disabled="claimingReward === 'normal_<?php echo e($rewardChain['id']); ?>'">
                                                        <span class="reward-btn-icon">🎁</span>
                                                        <span>Collect Standard</span>
                                                    </button>
                                                <?php else: ?>
                                                    <button class="reward-btn locked w-full py-2 rounded bg-gray-800 text-gray-400 font-bold cursor-not-allowed flex items-center justify-center gap-2" disabled>
                                                        <span class="reward-btn-icon">🔒</span>
                                                        <span>Locked</span>
                                                    </button>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <!-- VIP Reward -->
                                    <!--[if BLOCK]><![endif]--><?php if($vipReward && is_array($vipReward)): ?>
                                        <div class="reward-item vip relative rounded-lg border-2 p-4 flex flex-col items-center justify-center bg-gray-900
                                            <?php echo e($vipClaimed ? 'border-yellow-400 opacity-80' : 'border-yellow-600'); ?>">
                                            <!--[if BLOCK]><![endif]--><?php if(!$UserChar || !$UserChar->isVip): ?>
                                                <div class="vip-required absolute top-2 left-2 bg-gradient-to-r from-yellow-400 to-yellow-600 text-white px-2 py-1 rounded text-xs font-semibold shadow">
                                                    VIP Required
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            <!--[if BLOCK]><![endif]--><?php if($vipClaimed): ?>
                                                <div class="reward-claimed-overlay absolute inset-0 bg-yellow-700 bg-opacity-80 flex items-center justify-center text-white font-bold text-lg rounded-lg">
                                                    <span>✅ Claimed</span>
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            <div class="reward-header mb-2">
                                                <span class="reward-type-badge vip bg-gradient-to-r from-yellow-400 to-yellow-600 text-white px-2 py-1 rounded text-xs font-semibold">
                                                    VIP Premium Reward
                                                </span>
                                            </div>
                                            <div class="reward-content flex flex-col items-center gap-2">
                                                <div class="reward-icon w-16 h-16 rounded-lg overflow-hidden border-2 border-yellow-400 bg-gray-800 flex items-center justify-center">
                                                    <img src="<?php echo e(asset($vipReward['reward_icon'])); ?>" alt="<?php echo e($vipReward['reward_name']); ?>" class="w-full h-full object-cover" onerror="this.src='<?php echo e(asset('images/default-reward.svg')); ?>'">
                                                </div>
                                                <div class="reward-details text-center">
                                                    <h4 class="reward-name text-base font-bold text-white mb-1"><?php echo e($vipReward['reward_name']); ?></h4>
                                                    <p class="reward-type-info text-yellow-300 text-xs mb-1"><?php echo e(ucfirst($vipReward['reward_type'])); ?></p>
                                                    <span class="reward-count bg-yellow-700 text-white px-2 py-1 rounded-full text-xs font-semibold">x<?php echo e($vipReward['reward_count']); ?></span>
                                                </div>
                                            </div>
                                            <div class="reward-action w-full mt-2 flex justify-center">
                                                <!--[if BLOCK]><![endif]--><?php if($vipClaimed): ?>
                                                    <button class="reward-btn collected w-full py-2 rounded bg-gray-700 text-gray-300 font-bold cursor-not-allowed flex items-center justify-center gap-2" disabled>
                                                        <span class="reward-btn-icon">✅</span>
                                                        <span>Claimed</span>
                                                    </button>
                                                <?php elseif($isClaimable && ($UserChar && $UserChar->isVip)): ?>
                                                    <button class="reward-btn collect w-full py-2 rounded bg-gradient-to-r from-yellow-400 to-yellow-600 text-white font-bold flex items-center justify-center gap-2 shadow-lg hover:scale-105 transition"
                                                        x-bind:class="{ 'opacity-60': claimingReward === 'vip_<?php echo e($rewardChain['id']); ?>' }"
                                                        x-on:click="claimReward('vip', <?php echo e($rewardChain['id']); ?>, '<?php echo e(addslashes($vipReward['reward_name'])); ?>', '<?php echo e(asset($vipReward['reward_icon'])); ?>', '<?php echo e($vipReward['reward_count']); ?>')"
                                                        :disabled="claimingReward === 'vip_<?php echo e($rewardChain['id']); ?>'">
                                                        <span class="reward-btn-icon">👑</span>
                                                        <span>Collect VIP</span>
                                                    </button>
                                                <?php elseif(!$UserChar || !$UserChar->isVip): ?>
                                                    <button class="reward-btn locked w-full py-2 rounded bg-gray-800 text-yellow-400 font-bold cursor-not-allowed flex items-center justify-center gap-2" disabled>
                                                        <span class="reward-btn-icon">👑</span>
                                                        <span>Upgrade for VIP</span>
                                                    </button>
                                                <?php else: ?>
                                                    <button class="reward-btn locked w-full py-2 rounded bg-gray-800 text-gray-400 font-bold cursor-not-allowed flex items-center justify-center gap-2" disabled>
                                                        <span class="reward-btn-icon">🔒</span>
                                                        <span>Locked</span>
                                                    </button>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <!-- Progress Bar -->
                                <!--[if BLOCK]><![endif]--><?php if($isClaimable && !($normalClaimed && $vipClaimed)): ?>
                                    <div class="reward-progress w-full h-2 bg-purple-900 rounded-full mt-4">
                                        <div class="reward-progress-fill h-2 bg-gradient-to-r from-green-400 via-purple-400 to-yellow-400 rounded-full transition-all duration-500" style="width: 100%"></div>
                                    </div>
                                <?php elseif(!$isClaimable): ?>
                                    <div class="reward-progress w-full h-2 bg-gray-800 rounded-full mt-4">
                                        <div class="reward-progress-fill h-2 bg-gradient-to-r from-gray-400 to-purple-400 rounded-full transition-all duration-500" style="width: <?php echo e(min(100, ($totalCompletedDays / $rewardChain['days_required']) * 100)); ?>%"></div>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                <?php else: ?>
                    <div class="no-rewards-message col-span-full text-center py-8">
                        <h3 class="text-2xl font-bold text-purple-300 mb-2">No Rewards Available</h3>
                        <p class="text-lg text-gray-400">Rewards will be available soon. Check back later!</p>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            </div>

            <!-- Success Page -->
            <div x-show="CurrentGiftPage === 'success'"
                 x-transition:enter="transition ease-out duration-600"
                 x-transition:enter-start="opacity-0 transform scale-90"
                 x-transition:enter-end="opacity-100 transform scale-100"
                 x-transition:leave="transition ease-in duration-400"
                 x-transition:leave-start="opacity-100 transform scale-100"
                 x-transition:leave-end="opacity-0 transform scale-90">

                <div class="success-page-container w-full max-w-2xl mx-auto bg-gradient-to-br from-green-900 via-purple-900 to-green-700 rounded-2xl shadow-2xl p-8 text-center border-4 border-green-400">

                    <!-- Success Animation -->
                    <div class="success-animation mb-6">
                        <div class="relative inline-block">
                            <div class="text-8xl animate-bounce">🎉</div>
                            <div class="absolute inset-0 animate-pulse">
                                <div class="w-24 h-24 border-4 border-green-400 rounded-full animate-ping"></div>
                                <div class="w-20 h-20 border-2 border-yellow-400 rounded-full animate-ping" style="animation-delay: 0.5s;"></div>
                                <div class="w-16 h-16 border border-purple-400 rounded-full animate-ping" style="animation-delay: 1s;"></div>
                            </div>
                        </div>
                    </div>

                    <!-- Success Title -->
                    <h2 class="text-4xl md:text-5xl font-extrabold text-green-300 mb-6">
                        🎁 Reward Claimed Successfully!
                    </h2>

                    <!-- Reward Display Card -->
                    <div class="reward-display-card bg-black bg-opacity-40 rounded-xl p-6 mb-6">
                        <div class="reward-icon-large mb-4">
                            <img x-bind:src="claimedRewardIcon" x-bind:alt="claimedRewardName"
                                 class="w-24 h-24 mx-auto rounded-lg border-4 border-yellow-400 shadow-lg"
                                 onerror="this.src='<?php echo e(asset('images/default-reward.svg')); ?>'">
                        </div>

                        <div class="reward-info">
                            <h3 class="text-2xl font-bold text-white mb-2" x-text="claimedRewardName">Reward Name</h3>
                            <div class="reward-type-badge inline-block px-4 py-2 rounded-full font-semibold text-sm mb-3"
                                 x-bind:class="{
                                    'bg-gradient-to-r from-green-400 to-green-600 text-white': claimedRewardType === 'normal',
                                    'bg-gradient-to-r from-yellow-400 to-yellow-600 text-white': claimedRewardType === 'vip'
                                 }">
                                <span x-show="claimedRewardType === 'normal'">✨ Standard Reward</span>
                                <span x-show="claimedRewardType === 'vip'">👑 VIP Premium Reward</span>
                            </div>

                            <div class="reward-count text-3xl font-bold text-yellow-300 mb-2">
                                x<span x-text="claimedRewardCount">1</span>
                            </div>

                            <p class="text-lg text-gray-200">
                                has been added to your inventory!
                            </p>
                        </div>
                    </div>

                    <!-- Success Message -->
                    <div class="success-message bg-gradient-to-r from-green-700 to-purple-700 rounded-xl p-6 mb-6">
                        <h4 class="text-xl font-bold text-yellow-300 mb-2">🏆 Amazing Work, Champion!</h4>
                        <p class="text-gray-200 text-lg leading-relaxed">
                            Your dedication to completing daily quests has been rewarded. Keep up the excellent work and continue your journey to greatness!
                        </p>
                    </div>

                    <!-- Auto Return Message -->
                    <div class="auto-return-message flex items-center justify-center space-x-3 bg-gradient-to-r from-blue-600 to-purple-600 rounded-full py-3 px-6 text-white">
                        <span class="text-2xl animate-spin">⏰</span>
                        <span class="font-semibold">Returning to rewards in a few seconds...</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Get Quest Modal -->
        <div class="character-modal-overlay" x-show="showGetQuestModal" x-cloak
            x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-200"
            x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
            x-on:click.outside="closeGetQuestModal()">

            <div class="get-quest-modal-content" x-on:click.stop
                x-transition:enter="transition ease-out duration-300 delay-100"
                x-transition:enter-start="opacity-0 transform scale-90"
                x-transition:enter-end="opacity-100 transform scale-100"
                x-transition:leave="transition ease-in duration-200"
                x-transition:leave-start="opacity-100 transform scale-100"
                x-transition:leave-end="opacity-0 transform scale-90">

                <!-- Close Button -->
                <button x-on:click="closeGetQuestModal()" class="modal-close-btn">
                    ×
                </button>

                <!-- Quest Illustration -->
                <div class="quest-illustration">
                    <div class="quest-scroll">📜</div>
                    <div class="quest-sparkles">✨</div>
                </div>

                <!-- Quest Content -->
                <div class="quest-content">
                    <h2 class="quest-title">Ready for Adventure?</h2>
                    <p class="quest-description">
                        Embark on an epic daily quest and earn amazing rewards!
                        Each quest is carefully designed to provide exciting challenges and valuable treasures.
                    </p>

                    <div class="quest-features">
                        <div class="quest-feature">
                            <div class="quest-feature-icon">🎯</div>
                            <div class="quest-feature-text">Daily Challenges</div>
                        </div>
                        <div class="quest-feature">
                            <div class="quest-feature-icon">💎</div>
                            <div class="quest-feature-text">Epic Rewards</div>
                        </div>
                        <div class="quest-feature">
                            <div class="quest-feature-icon">⏱️</div>
                            <div class="quest-feature-text">Timed Objectives</div>
                        </div>
                        <div class="quest-feature">
                            <div class="quest-feature-icon">🏆</div>
                            <div class="quest-feature-text">Progress Tracking</div>
                        </div>
                    </div>
                </div>

                <!-- Modal Actions -->
                <div class="get-quest-actions">
                    <button class="quest-btn_primary" x-on:click="getNewQuest()">
                        <span>🚀</span>
                        Get My Quest!
                    </button>

                    <button class="quest-btn_secondary" x-on:click="closeGetQuestModal()">
                        <span>❌</span>
                        Maybe Later
                    </button>
                </div>
            </div>
        </div>

        <!-- VIP Upgrade Modal -->
        <div class="vip-modal-overlay" x-show="showVipModal" x-cloak
            x-transition:enter="transition ease-out duration-500" x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-300"
            x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
            x-on:click.outside="closeVipModal()">

            <div class="vip-modal-content" x-on:click.stop
                x-transition:enter="transition ease-out duration-600 delay-100"
                x-transition:enter-start="opacity-0 transform scale-80"
                x-transition:enter-end="opacity-100 transform scale-100"
                x-transition:leave="transition ease-in duration-300"
                x-transition:leave-start="opacity-100 transform scale-100"
                x-transition:leave-end="opacity-0 transform scale-80" x-bind:class="{ 'vip-upgrading': isUpgrading }">

                <!-- Modal Header -->
                <div class="vip-modal-header">
                    <button x-on:click="closeVipModal()" class="vip-modal-close">×</button>

                    <div class="vip-modal-icon">👑</div>
                    <h2 class="vip-modal-title" wire:ignore  data-translate="page.quests.vip.upgrade_title">Upgrade to VIP</h2>
                    <p class="vip-modal-subtitle" wire:ignore  data-translate="page.quests.vip.upgrade_subtitle">Unlock Premium
                        Benefits</p>
                    <p class="vip-modal-description" wire:ignore  data-translate="page.quests.vip.upgrade_description">Upgrade to
                        VIP for 500 💎 Balance for this month</p>
                </div>

                <!-- Modal Body -->
                <div class="vip-modal-body">
                    <!-- Pricing Card -->
                    <div class="vip-pricing-card">
                        <div class="vip-price" x-text="vipCost + ' 💎'"></div>
                        <div class="vip-duration" wire:ignore  data-translate="page.quests.vip.duration">1 Month</div>
                    </div>

                    <!-- Balance Info -->
                    <div class="vip-balance-info">
                        <div class="balance-item">
                            <div class="balance-label" wire:ignore  data-translate="page.quests.vip.current_balance">Current
                                Balance</div>
                            <div class="balance-value" x-text="currentBalance + ' 💎'"
                                x-bind:class="{ 'insufficient': !checkBalance() }"></div>
                        </div>
                        <div class="balance-item">
                            <div class="balance-label">Required</div>
                            <div class="balance-value" x-text="vipCost + ' 💎'"></div>
                        </div>
                    </div>

                    <!-- VIP Benefits -->
                    <div class="vip-benefits">
                        <h3 class="vip-benefits-title" wire:ignore  data-translate="page.quests.vip.benefits.title">VIP Benefits
                        </h3>
                        <div class="vip-benefits-grid">
                            <div class="vip-benefit">
                                <div class="vip-benefit-icon">🎁</div>
                                <div class="vip-benefit-text"
                                    wire:ignore  data-translate="page.quests.vip.benefits.exclusive_rewards">Exclusive VIP Rewards
                                </div>
                            </div>
                            <div class="vip-benefit">
                                <div class="vip-benefit-icon">⚡</div>
                                <div class="vip-benefit-text"
                                    wire:ignore  data-translate="page.quests.vip.benefits.double_rewards">Double Daily Rewards</div>
                            </div>
                            <div class="vip-benefit">
                                <div class="vip-benefit-icon">🛡️</div>
                                <div class="vip-benefit-text"
                                    wire:ignore  data-translate="page.quests.vip.benefits.priority_support">Priority Support</div>
                            </div>
                            <div class="vip-benefit">
                                <div class="vip-benefit-icon">🌟</div>
                                <div class="vip-benefit-text"
                                    wire:ignore  data-translate="page.quests.vip.benefits.special_events">Special VIP Events</div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Modal Actions -->
                <div class="vip-modal-actions">
                    <button class="vip-upgrade-btn" x-on:click="upgradeToVip()"
                        x-bind:disabled="!checkBalance() || isUpgrading"
                        x-bind:class="{ 'vip-upgrading': isUpgrading }">
                        <span x-show="!isUpgrading" wire:ignore  data-translate="page.quests.vip.upgrade_now">👑 Upgrade Now</span>
                        <span x-show="isUpgrading" wire:ignore  data-translate="page.quests.vip.upgrading">⏳ Upgrading...</span>
                    </button>

                    <button class="vip-cancel-btn" x-on:click="closeVipModal()">
                        <span wire:ignore  data-translate="page.quests.vip.insufficient_dialog.close">❌ Close</span>
                    </button>
                </div>
            </div>
        </div>

        <!-- Insufficient Balance Modal -->
        <div class="vip-modal-overlay" x-show="showInsufficientBalanceModal" x-cloak
            x-transition:enter="transition ease-out duration-500" x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-300"
            x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
            x-on:click.outside="closeInsufficientBalanceModal()">

            <div class="vip-modal-content insufficient-balance-modal" x-on:click.stop
                x-transition:enter="transition ease-out duration-600 delay-100"
                x-transition:enter-start="opacity-0 transform scale-80"
                x-transition:enter-end="opacity-100 transform scale-100">

                <div class="vip-modal-header">
                    <button x-on:click="closeInsufficientBalanceModal()" class="vip-modal-close">×</button>

                    <div class="insufficient-balance-icon">💸</div>
                    <h2 class="insufficient-title" wire:ignore  data-translate="page.quests.vip.insufficient_dialog.title">
                        Insufficient Balance</h2>
                </div>

                <div class="vip-modal-body">
                    <p class="insufficient-message" wire:ignore  data-translate="page.quests.vip.insufficient_dialog.message"
                        x-text="'You need 500 💎 Balance to upgrade to VIP. Your current balance is ' + currentBalance + ' 💎.'">
                        You need 500 💎 Balance to upgrade to VIP. Your current balance is 0 💎.
                    </p>
                </div>

                <div class="vip-modal-actions">
                    <button class="vip-upgrade-btn" x-on:click="closeInsufficientBalanceModal()">
                        <span wire:ignore  data-translate="page.quests.vip.insufficient_dialog.add_balance">💎 Add Balance</span>
                    </button>

                    <button class="vip-cancel-btn" x-on:click="closeInsufficientBalanceModal()">
                        <span wire:ignore  data-translate="page.quests.vip.insufficient_dialog.close">❌ Close</span>
                    </button>
                </div>
            </div>
        </div>

    </div>
</div><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/backend/pages/quests.blade.php ENDPATH**/ ?>