<?php

use Livewire\Volt\Component;
use Illuminate\Support\Facades\Auth;

?>

<div x-data="{
    activeTab: <?php if ((object) ('currentPage') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('currentPage'->value()); ?>')<?php echo e('currentPage'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('currentPage'); ?>')<?php endif; ?>,
    tabTransition: false,

    init() {
        // Load saved page from sessionStorage on init
        const savedPage = sessionStorage.getItem('dashboard_current_page');
        if (savedPage && savedPage !== this.activeTab) {
            this.activeTab = savedPage;
            $wire.setCurrentPage(savedPage);
        }
    },

    switchTab(tabKey) {
        if (this.activeTab !== tabKey) {
            this.tabTransition = true;
            setTimeout(() => {
                this.activeTab = tabKey;
                $wire.setCurrentPage(tabKey);
                sessionStorage.setItem('dashboard_current_page', tabKey);
                setTimeout(() => this.tabTransition = false, 50);
            }, 150);
        }
    }
}" x-cloak class="tablet-dashboard-wrapper">

    <!-- Tablet Dashboard Container -->
    <div class="tablet-dashboard-container tablet-fade-in">



        <!-- Tablet Navigation Tabs -->
        <div class="tablet-dashboard-tabs tablet-slide-up">
            <div class="tablet-dashboard-tabs-container">

                <!-- All Tabs in One Container -->
                <div class="tablet-dashboard-tabs-nav">
                    
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->getMenuItemsBySection('main'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="tablet-dashboard-tab <?php echo e($currentPage === $item['key'] ? 'active' : ''); ?>"
                             x-on:click="switchTab('<?php echo e($item['key']); ?>')">

                            <div class="tablet-dashboard-tab-icon">
                                <?php echo $item['icon']; ?>

                            </div>

                            <div class="tablet-dashboard-tab-content">
                                <h3 wire:ignore  data-translate="<?php echo e($item['translate']['title'] ?? 'menu.' . $item['key'] . '.title'); ?>">
                                    <?php echo e($item['title']); ?>

                                </h3>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

                    
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->getMenuItemsBySection('shop'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="tablet-dashboard-tab <?php echo e($currentPage === $item['key'] ? 'active' : ''); ?>"
                             x-on:click="switchTab('<?php echo e($item['key']); ?>')">

                            <div class="tablet-dashboard-tab-icon">
                                <?php echo $item['icon']; ?>

                            </div>

                            <div class="tablet-dashboard-tab-content">
                                <h3 wire:ignore  data-translate="<?php echo e($item['translate']['title'] ?? 'menu.' . $item['key'] . '.title'); ?>">
                                    <?php echo e($item['title']); ?>

                                </h3>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

                    
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->getMenuItemsBySection('inventory'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="tablet-dashboard-tab <?php echo e($currentPage === $item['key'] ? 'active' : ''); ?>"
                             x-on:click="switchTab('<?php echo e($item['key']); ?>')">

                            <div class="tablet-dashboard-tab-icon">
                                <?php echo $item['icon']; ?>

                            </div>

                            <div class="tablet-dashboard-tab-content">
                                <h3 wire:ignore  data-translate="<?php echo e($item['translate']['title'] ?? 'menu.' . $item['key'] . '.title'); ?>">
                                    <?php echo e($item['title']); ?>

                                </h3>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

                    <!-- Logs Section -->
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->getMenuItemsBySection('logs'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="tablet-dashboard-tab <?php echo e($currentPage === $item['key'] ? 'active' : ''); ?>"
                             x-on:click="switchTab('<?php echo e($item['key']); ?>')">

                            <div class="tablet-dashboard-tab-icon">
                                <?php echo $item['icon']; ?>

                            </div>

                            <div class="tablet-dashboard-tab-content">
                                <h3 wire:ignore  data-translate="<?php echo e($item['translate']['title'] ?? 'menu.' . $item['key'] . '.title'); ?>">
                                    <?php echo e($item['title']); ?>

                                </h3>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>

            </div>
        </div>

        <!-- Tablet Content Area -->
        <div class="tablet-dashboard-content">
            <div class="tablet-dashboard-content-inner"
                 x-show="!tabTransition"
                 wire:key="tablet-content-<?php echo e($currentPage); ?>">

                <?php $currentPageData = $this->getCurrentPageData(); ?>

                <!--[if BLOCK]><![endif]--><?php if($currentPageData): ?>
                    
                    <!--[if BLOCK]><![endif]--><?php if($currentPage === '4t-app'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.4t-app', []);

$__html = app('livewire')->mount($__name, $__params, 'tablet-4t-app-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'quests'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.quests', []);

$__html = app('livewire')->mount($__name, $__params, 'tablet-quests-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'char-list'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.char-list', []);

$__html = app('livewire')->mount($__name, $__params, 'tablet-char-list-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'shipping'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.shipping', []);

$__html = app('livewire')->mount($__name, $__params, 'tablet-shipping-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'packages-shop'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.packages-shop', []);

$__html = app('livewire')->mount($__name, $__params, 'tablet-packages-shop-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'item-shop'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.item-shop', []);

$__html = app('livewire')->mount($__name, $__params, 'tablet-item-shop-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'gift-item-shop'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.gift-item-shop', []);

$__html = app('livewire')->mount($__name, $__params, 'tablet-gift-item-shop-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'players-shop'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.players-shop', []);

$__html = app('livewire')->mount($__name, $__params, 'tablet-players-shop-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'web-inventory'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.web-inventory', []);

$__html = app('livewire')->mount($__name, $__params, 'tablet-web-inventory-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'market-inventory'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.market-inventory', []);

$__html = app('livewire')->mount($__name, $__params, 'tablet-market-inventory-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'market-logs'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.market-logs', []);

$__html = app('livewire')->mount($__name, $__params, 'tablet-market-logs-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php elseif($currentPage === 'rewards-systems'): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('backend.pages.rewards-systems', []);

$__html = app('livewire')->mount($__name, $__params, 'tablet-rewards-systems-component', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php else: ?>
                        
                        @try
                            <?php echo $__env->make($currentPageData['include'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        @catch(Exception $e)
                            <div class="tablet-dashboard-error">
                                <div class="tablet-dashboard-error-icon">
                                    <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                                        <path d="M10.29 3.86L1.82 18a2 2 0 001.71 3h16.94a2 2 0 001.71-3L13.71 3.86a2 2 0 00-3.42 0z"/>
                                        <line x1="12" y1="9" x2="12" y2="13"/>
                                        <line x1="12" y1="17" x2="12.01" y2="17"/>
                                    </svg>
                                </div>
                                <h3 class="tablet-dashboard-error-title" wire:ignore  data-translate="error.pageNotFound.title">
                                    Include Error
                                </h3>
                                <p class="tablet-dashboard-error-description">
                                    <?php echo e($currentPage); ?> template could not be loaded.
                                </p>
                            </div>
                        @endtry
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                <?php else: ?>
                    
                    <div class="tablet-dashboard-error">
                        <div class="tablet-dashboard-error-icon">
                            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                                <path d="M10.29 3.86L1.82 18a2 2 0 001.71 3h16.94a2 2 0 001.71-3L13.71 3.86a2 2 0 00-3.42 0z"/>
                                <line x1="12" y1="9" x2="12" y2="13"/>
                                <line x1="12" y1="17" x2="12.01" y2="17"/>
                            </svg>
                        </div>
                        <h3 class="tablet-dashboard-error-title" wire:ignore  data-translate="error.pageNotFound.title">
                            Page Not Found
                        </h3>
                        <p class="tablet-dashboard-error-description" wire:ignore  data-translate="error.pageNotFound.description">
                            The requested page could not be loaded. Please try again.
                        </p>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>

            
            <div x-show="tabTransition"
                 class="tablet-dashboard-content-inner">
                <div class="tablet-dashboard-error">
                    <div class="tablet-dashboard-error-icon">
                        <svg class="animate-spin" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-purple-400">
                            <path d="M21 12a9 9 0 11-6.219-8.56"/>
                        </svg>
                    </div>
                    <h3 class="tablet-dashboard-error-title" wire:ignore  data-translate="common.loading">
                        Loading...
                    </h3>
                    <p class="tablet-dashboard-error-description">
                        Switching to <?php echo e($currentPageData['title'] ?? 'Page'); ?>

                    </p>
                </div>
            </div>
        </div>

    </div>
</div><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/backend/dashboard-parts/tablet.blade.php ENDPATH**/ ?>