<!-- Mobile Header Content -->
<!-- Navigation data is loaded from resources/data/navigation.json via get_navigation_data() function -->

<?php
    $navigation = get_navigation_data();
?>
<div class="header-mobile">
    <!-- Fixed Mobile Header Bar -->
    <div class="mobile-header-fixed">
        <!-- Mobile Logo -->
        <div class="mobile-header-logo">
            <?php if($navigation['logo']['type'] === 'image'): ?>
                <?php
                    $isRTL = in_array(app()->getLocale(), ['ar', 'he', 'fa', 'ur']);
                    $logoImage = $isRTL ? ($navigation['logo']['image_rtl'] ?? $navigation['logo']['image_ltr']) : $navigation['logo']['image_ltr'];
                ?>
                <a href="<?php echo e($navigation['logo']['is_route'] ? route($navigation['logo']['link']) : $navigation['logo']['link']); ?>">
                    <img src="<?php echo e($logoImage); ?>" alt="<?php echo e($navigation['logo']['alt']); ?>" />
                </a>
            <?php else: ?>
                <?php
                    $isRTL = in_array(app()->getLocale(), ['ar', 'he', 'fa', 'ur']);
                    $logoText = $isRTL ? ($navigation['logo']['text_rtl'] ?? $navigation['logo']['text_ltr']) : $navigation['logo']['text_ltr'];
                ?>
                <a href="<?php echo e($navigation['logo']['is_route'] ? route($navigation['logo']['link']) : $navigation['logo']['link']); ?>" class="mobile-logo-text-link">
                    <span class="mobile-header-title"><?php echo e($logoText); ?></span>
                </a>
            <?php endif; ?>
            <?php if($navigation['logo']['type'] === 'image'): ?>
                <span class="mobile-header-title">4TresSro</span>
            <?php endif; ?>
        </div>

        <!-- Mobile Header Actions -->
        <div class="mobile-header-actions">
            <?php if(Auth::check()): ?>
                <!-- Mobile Header Notification Icons -->
               <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('notifications', ['type' => 'mobile']);

$__html = app('livewire')->mount($__name, $__params, 'lw-1054489148-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
            <?php endif; ?>

            <!-- Mobile Auth Buttons (when not logged in) -->
            <?php if(!Auth::check()): ?>
                <div class="mobile-header-auth-buttons">
                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('auth.register', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-1054489148-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('auth.login', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-1054489148-2', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                </div>
            <?php endif; ?>

            <!-- Mobile Menu Button -->
            <button class="mobile-menu-btn" id="mobileMenuBtn">
                <svg class="mobile-menu-icon" width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path class="hamburger-lines" d="M3 12H21M3 6H21M3 18H21" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    <path class="close-x" d="M18 6L6 18M6 6L18 18" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" opacity="0"/>
                </svg>
            </button>
        </div>
    </div>

    <!-- Mobile Menu Overlay -->
    <div class="mobile-menu-overlay" id="mobileMenuOverlay"></div>

    <!-- Mobile Menu -->
    <div class="mobile-menu" id="mobileMenu">
        <div class="mobile-menu-content">
            <!-- Mobile Menu Header -->
            <div class="mobile-menu-header">
                <div class="mobile-menu-logo">
                    <img src="/assets/logo.svg" alt="4TresSro Logo" />
                    <h3>4TresSro</h3>
                </div>
                <button class="mobile-menu-close" id="mobileMenuClose">
                    <svg class="mobile-close-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M18 6L6 18M6 6L18 18" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </button>
            </div>

            <!-- Mobile Auth Section -->
            <div class="mobile-auth-section">
                <div class="mobile-auth-buttons">
                    <?php if(Auth::check()): ?>

                        <!-- Mobile User Accordion Menu -->
                        <div class="mobile-user-accordion-container">
                            <button class="mobile-user-accordion-trigger" id="mobileUserTrigger">
                                <div class="mobile-user-avatar">
                                    <i class="fas fa-user-circle"></i>
                                </div>
                                <div class="mobile-user-info">
                                    <span class="mobile-user-greeting" data-translate="user.welcome">Welcome</span>
                                    <span class="mobile-user-name"><?php echo e(Auth::user()->username); ?></span>
                                </div>
                                <i class="fas fa-chevron-down mobile-accordion-arrow"></i>
                            </button>

                            <div class="mobile-user-accordion-content" id="mobileUserAccordion">
                                <!-- Mobile User Header -->
                                <div class="mobile-user-accordion-header">
                                    <div class="mobile-user-avatar-large">
                                        <i class="fas fa-user-circle"></i>
                                    </div>
                                    <div class="mobile-user-details">
                                        <h4 class="mobile-user-fullname"><?php echo e(Auth::user()->username); ?></h4>
                                        <p class="mobile-user-status">Premium Player</p>
                                    </div>
                                </div>

                                <!-- Mobile Balance Section -->
                                <!-- Balance Section -->
                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('balance-head', ['type' => 'menu']);

$__html = app('livewire')->mount($__name, $__params, 'lw-1054489148-3', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>


                                <!-- Mobile Menu Items -->
                                <div class="mobile-accordion-menu-items">
                                    <?php $__currentLoopData = $navigation['navigation']['user_menu']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e(route($item['route'])); ?>" class="mobile-accordion-menu-item <?php echo e(active_class($item['route'])); ?>">
                                        <i class="<?php echo e($item['icon']); ?>"></i>
                                        <span data-translate="<?php echo e($item['label']); ?>"><?php echo e($item['title']); ?></span>
                                    </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php if(Auth::user()->hasRoleLevel(3)): ?>
                                        <a href="<?php echo e(route('team-dashboard')); ?>" class="mobile-accordion-menu-item team-dashboard-link">
                                            <i class="fas fa-users-cog"></i>
                                            <span data-translate="team.dashboard.title">Team Dashboard</span>
                                        </a>
                                    <?php endif; ?>
                                </div>

                                <!-- Mobile Logout Section -->
                                <div class="mobile-accordion-divider"></div>
                                <form method="POST" action="<?php echo e(route('logout')); ?>" class="mobile-accordion-logout-form">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="mobile-accordion-menu-item mobile-accordion-logout-btn">
                                        <i class="fas fa-sign-out-alt"></i>
                                        <span data-translate="user.logout">Logout</span>
                                    </button>
                                </form>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <!-- Mobile Language Switcher -->
                <div class="language-switcher-mobile mt-4-mobile"></div>
            </div>

            <!-- Primary Navigation - SVG Enhanced -->
            <div class="mobile-nav-section">
                <?php $__currentLoopData = $navigation['navigation']['primary']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($item['visibility'] === 'all' || ($item['visibility'] === 'guest' && !Auth::check()) || ($item['visibility'] === 'auth' && Auth::check())): ?>
                <a href="<?php echo e(($item['is_route'] ?? false) ? route($item['route']) : $item['route']); ?>" class="mobile-menu-item primary <?php echo e(active_class($item['active'] ?: '')); ?>" data-index="<?php echo e($index); ?>">
                    <svg class="mobile-menu-svg-icon" width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <?php if($item['icon'] == 'fas fa-home'): ?>
                        <path d="M3 12L5 10M5 10L12 3L19 10M5 10V20C5 20.5523 5.44772 21 6 21H9M19 10L21 12M19 10V20C19 20.5523 18.5523 21 18 21H15M9 21V15C9 14.4477 9.44772 14 10 14H14C14.5523 14 15 14.4477 15 15V21M9 21H15" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <?php elseif($item['icon'] == 'fas fa-download'): ?>
                        <path d="M12 10V16M12 16L9 13M12 16L15 13M3 17V19C3 19.5523 3.44772 20 4 20H20C20.5523 20 21 19.5523 21 19V17" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <?php elseif($item['icon'] == 'fas fa-trophy'): ?>
                        <path d="M9 12L11 14L15 10M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M7 3H17M12 3V7" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <?php endif; ?>
                    </svg>
                    <span data-translate="<?php echo e($item['label']); ?>"><?php echo e($item['title']); ?></span>
                    <?php if(active_class($item['active'] ?: '')): ?>
                    <svg class="mobile-active-indicator" width="8" height="8" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="12" cy="12" r="10" fill="#00ffff" opacity="0.3"/>
                        <circle cx="12" cy="12" r="6" fill="#00ffff" opacity="0.6"/>
                        <circle cx="12" cy="12" r="3" fill="#00ffff"/>
                    </svg>
                    <?php endif; ?>
                </a>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Secondary Navigation - SVG Enhanced -->
            <div class="mobile-dropdown-section">
                <div class="mobile-dropdown-title">
                    <svg class="mobile-dropdown-title-icon" width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M11.5 5.5C11.5 4.67157 12.1716 4 13 4C13.8284 4 14.5 4.67157 14.5 5.5C14.5 6.32843 13.8284 7 13 7C12.1716 7 11.5 6.32843 11.5 5.5Z" fill="currentColor"/>
                        <path d="M13 9V12M13 15V18M9 13H6M20 13H17M15.5 9.5L17.5 7.5M8.5 18.5L10.5 16.5M15.5 16.5L17.5 18.5M8.5 7.5L10.5 9.5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <circle cx="13" cy="13" r="9" stroke="currentColor" stroke-width="2"/>
                    </svg>
                    <span data-translate="<?php echo e($navigation['mobile']['dropdown_title']['label']); ?>"><?php echo e($navigation['mobile']['dropdown_title']['title']); ?></span>
                </div>
                <?php $__currentLoopData = $navigation['navigation']['dropdown']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($item['visibility'] === 'all' || ($item['visibility'] === 'guest' && !Auth::check()) || ($item['visibility'] === 'auth' && Auth::check())): ?>
                <a href="<?php echo e(($item['is_route'] ?? false) ? route($item['route']) : $item['route']); ?>" class="mobile-menu-item mobile-dropdown-item <?php echo e(active_class($item['active'] ?: '')); ?>" data-index="<?php echo e($index); ?>">
                    <div class="item-content">
                        <div class="item-icon" style="background: <?php echo e($item['gradient']); ?>;">
                            <svg class="mobile-dropdown-svg-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <?php if($item['icon'] == 'fas fa-book'): ?>
                                <path d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.746 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <?php elseif($item['icon'] == 'fas fa-newspaper'): ?>
                                <path d="M19 20H5C3.89543 20 3 19.1046 3 18V6C3 4.89543 3.89543 4 5 4H15C16.1046 4 17 4.89543 17 6V7M19 20C20.1046 20 21 19.1046 21 18V9C21 7.89543 20.1046 7 19 7M19 20V7M9 7H15M9 11H15M9 15H11" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <?php elseif($item['icon'] == 'fas fa-store'): ?>
                                <path d="M3 7V5C3 4.44772 3.44772 4 4 4H20C20.5523 4 21 4.44772 21 5V7M3 7V19C3 19.5523 3.44772 20 4 20H20C20.5523 20 21 19.5523 21 19V7M3 7L5 9M21 7L19 9" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <circle cx="9" cy="12" r="1" fill="currentColor"/>
                                <circle cx="15" cy="12" r="1" fill="currentColor"/>
                                <?php elseif($item['icon'] == 'fas fa-users'): ?>
                                <path d="M17 20H22V18C22 16.3431 20.6569 15 19 15H20C21.1046 15 22 14.1046 22 13V11C22 9.89543 21.1046 9 20 9H19C17.3431 9 16 7.65685 16 6V4C16 2.89543 15.1046 2 14 2H10C8.89543 2 8 2.89543 8 4V6C8 7.65685 6.65685 9 5 9H4C2.89543 9 2 9.89543 2 11V13C2 14.1046 2.89543 15 4 15H5C3.34315 15 2 16.3431 2 18V20H7" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <?php elseif($item['icon'] == 'fas fa-headset'): ?>
                                <path d="M3 11V10C3 7.23858 5.23858 5 8 5H16C18.7614 5 21 7.23858 21 10V11M3 11C3 13.7614 5.23858 16 8 16H16C18.7614 16 21 13.7614 21 11M3 11V13C3 15.7614 5.23858 18 8 18H16C18.7614 18 21 15.7614 21 13V11" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <circle cx="9" cy="12" r="1" fill="currentColor"/>
                                <circle cx="15" cy="12" r="1" fill="currentColor"/>
                                <?php elseif($item['icon'] == 'fas fa-book-open'): ?>
                                <path d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.746 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <?php elseif($item['icon'] == 'fas fa-images'): ?>
                                <rect x="3" y="3" width="18" height="18" rx="2" ry="2" stroke="currentColor" stroke-width="2"/>
                                <circle cx="9" cy="9" r="2" stroke="currentColor" stroke-width="2"/>
                                <path d="M21 15L16 10L5 21" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <?php endif; ?>
                            </svg>
                        </div>
                        <div class="item-text">
                            <div class="item-title" data-translate="<?php echo e($item['label']); ?>"><?php echo e($item['title']); ?></div>
                            <div class="item-description" data-translate="<?php echo e($item['description'] ?? ''); ?>"><?php echo e($item['desc_text']); ?></div>
                        </div>
                        <?php if(active_class($item['active'] ?: '')): ?>
                        <svg class="mobile-dropdown-active-indicator" width="12" height="12" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M9 12L11 14L15 10" stroke="#00ffff" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
                            <circle cx="12" cy="12" r="9" stroke="#00ffff" stroke-width="2" opacity="0.3"/>
                        </svg>
                        <?php endif; ?>
                    </div>
                </a>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Mobile Menu Close Button (Bottom) -->
            <div class="mobile-menu-footer">
                <button class="mobile-menu-close-bottom" id="mobileMenuCloseBottom">
                    <svg class="mobile-close-bottom-icon" width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M18 6L6 18M6 6L18 18" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                    <span data-translate="nav.close">Close Menu</span>
                </button>
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views/components/layouts/struct/partials/main/header-mobile.blade.php ENDPATH**/ ?>