<?php

use Livewire\Volt\Component;
use App\Models\Z_Website\SiteSettings;
use App\Models\Z_Website\News;
use App\Models\SRO_VT_PROXY\_Players;
use Illuminate\Support\Facades\Cache;

?>

<div class="min-h-screen bg-gradient-to-br from-slate-900 via-purple-900 to-slate-900">



    <!-- Server Information Section -->
    <div class="container mx-auto px-6 py-16">
        <div class="text-center mb-12">
            <h2 class="text-4xl font-bold text-white mb-4" data-translate="welcome.serverInformation">Server Information</h2>
            <div class="w-24 h-1 bg-gradient-to-r from-purple-500 to-cyan-500 mx-auto"></div>
        </div>

        <!-- Server Status Card -->
        <div class="bg-gradient-to-br from-slate-800/50 to-purple-900/30 backdrop-blur-lg border border-purple-500/30 rounded-2xl p-8 mb-8 shadow-2xl">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-4">
                    <div class="w-4 h-4 rounded-full <?php echo e($isServerOnline ? 'bg-green-400' : 'bg-red-400'); ?> animate-pulse"></div>
                    <h3 class="text-2xl font-bold text-white"><span data-translate="welcome.serverStatus">Server Status</span>: <span data-translate="<?php echo e($this->serverStatus); ?>"><?php echo e($this->serverStatus); ?></span></h3>
                </div>
                <button wire:click="refreshData" class="px-4 py-2 bg-purple-600 hover:bg-purple-700 text-white rounded-lg transition-colors">
                    🔄 <span data-translate="welcome.refresh">Refresh</span>
                </button>
            </div>

            <!-- Server Stats Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = [
                    ['key' => 'levelCap', 'label' => 'Level Cap', 'value' => $serverStats['level_cap'] ?? 'N/A', 'icon' => '⭐'],
                    ['key' => 'expRate', 'label' => 'EXP Rate', 'value' => ($serverStats['exp_rate'] ?? 'N/A') . 'x', 'icon' => '⚡'],
                    ['key' => 'goldRate', 'label' => 'Gold Rate', 'value' => ($serverStats['gold_rate'] ?? 'N/A') . 'x', 'icon' => '💰'],
                    ['key' => 'dropRate', 'label' => 'Drop Rate', 'value' => ($serverStats['drop_rate'] ?? 'N/A') . 'x', 'icon' => '🎁'],
                    ['key' => 'jobRate', 'label' => 'Job Rate', 'value' => ($serverStats['job_rate'] ?? 'N/A') . 'x', 'icon' => '🔨'],
                    ['key' => 'partyRate', 'label' => 'Party Rate', 'value' => ($serverStats['party_rate'] ?? 'N/A') . 'x', 'icon' => '🤝'],
                    ['key' => 'ipLimit', 'label' => 'IP Limit', 'value' => $serverStats['ip_limit'] ?? 'N/A', 'icon' => '🌐'],
                    ['key' => 'hwidLimit', 'label' => 'HWID Limit', 'value' => $serverStats['hwid_limit'] ?? 'N/A', 'icon' => '💻']
                ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-slate-700/50 rounded-xl p-4 border border-purple-500/20 hover:border-purple-400/40 transition-colors">
                        <div class="text-2xl mb-2"><?php echo e($stat['icon']); ?></div>
                        <div class="text-purple-300 text-sm mb-1" data-translate="welcome.<?php echo e($stat['key']); ?>"><?php echo e($stat['label']); ?></div>
                        <div class="text-white text-xl font-bold"><?php echo e($stat['value']); ?></div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>

        <!-- Server Features -->
        <!--[if BLOCK]><![endif]--><?php if(!empty($serverSettings)): ?>
        <div class="bg-gradient-to-br from-slate-800/50 to-blue-900/30 backdrop-blur-lg border border-blue-500/30 rounded-2xl p-8 mb-8 shadow-2xl">
            <h3 class="text-2xl font-bold text-white mb-6 flex items-center gap-3">
                ⚔️ <span data-translate="welcome.serverFeatures">Server Features</span>
            </h3>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = [
                    ['key' => 'jangan_fortress', 'translateKey' => 'welcome.fortress.jangan', 'label' => 'Jangan Fortress', 'icon' => '🏰'],
                    ['key' => 'bandit_fortress', 'translateKey' => 'welcome.fortress.bandit', 'label' => 'Bandit Fortress', 'icon' => '🗡️'],
                    ['key' => 'hotan_fortress', 'translateKey' => 'welcome.fortress.hotan', 'label' => 'Hotan Fortress', 'icon' => '🏛️'],
                    ['key' => 'constantinople_fortress', 'translateKey' => 'welcome.fortress.constantinople', 'label' => 'Constantinople Fortress', 'icon' => '🛡️'],
                    ['key' => 'char_ranking', 'translateKey' => 'welcome.rankings.character', 'label' => 'Character Ranking', 'icon' => '🏆'],
                    ['key' => 'guild_ranking', 'translateKey' => 'welcome.rankings.guild', 'label' => 'Guild Ranking', 'icon' => '👑'],
                    ['key' => 'job_ranking', 'translateKey' => 'welcome.rankings.jobRanking', 'label' => 'Job Ranking', 'icon' => '🔧'],
                    ['key' => 'trader_ranking', 'translateKey' => 'welcome.rankings.trader', 'label' => 'Trader Ranking', 'icon' => '💼'],
                    ['key' => 'hunter_ranking', 'translateKey' => 'welcome.rankings.hunter', 'label' => 'Hunter Ranking', 'icon' => '🏹'],
                    ['key' => 'thief_ranking', 'translateKey' => 'welcome.rankings.thief', 'label' => 'Thief Ranking', 'icon' => '🗡️'],
                    ['key' => 'unique_ranking', 'translateKey' => 'welcome.rankings.unique', 'label' => 'Unique Ranking', 'icon' => '💎'],
                    ['key' => 'free_pvp_ranking', 'translateKey' => 'welcome.rankings.freePvp', 'label' => 'Free PvP Ranking', 'icon' => '⚔️'],
                    ['key' => 'job_pvp_ranking', 'translateKey' => 'welcome.rankings.jobRankingPvp', 'label' => 'Job PvP Ranking', 'icon' => '🥊']
                ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $isEnabled = !($serverSettings[$feature['key']] ?? true); ?>
                    <div class="flex items-center gap-3 p-3 rounded-lg <?php echo e($isEnabled ? 'bg-green-600/20 border border-green-500/30' : 'bg-red-600/20 border border-red-500/30'); ?>">
                        <span class="text-xl"><?php echo e($feature['icon']); ?></span>
                        <span class="text-white font-medium" data-translate="<?php echo e($feature['translateKey']); ?>"><?php echo e($feature['label']); ?></span>
                        <span class="ml-auto text-sm <?php echo e($isEnabled ? 'text-green-400' : 'text-red-400'); ?>">
                            <?php echo e($isEnabled ? '✅' : '❌'); ?> <span data-translate="welcome.<?php echo e($isEnabled ? 'enabled' : 'disabled'); ?>"><?php echo e($isEnabled ? 'Enabled' : 'Disabled'); ?></span>
                        </span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!-- Currency Systems Section -->
        <div class="bg-gradient-to-br from-slate-800/50 to-green-900/30 backdrop-blur-lg border border-green-500/30 rounded-2xl p-8 shadow-2xl">
            <h3 class="text-2xl font-bold text-white mb-6 flex items-center gap-3">
                💰 <span data-translate="welcome.currencySystems">Currency Systems</span>
            </h3>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                <!-- Game Currency System -->
                <div>
                    <h4 class="text-xl font-bold text-green-400 mb-4 flex items-center gap-2">
                        🎮 <span data-translate="welcome.gameCurrencies">Game Currencies</span>
                    </h4>
                    <div class="space-y-3">
                        <div class="bg-slate-700/50 rounded-xl p-4 border border-green-500/20">
                            <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
                                <div class="text-center">
                                    <div class="text-2xl mb-1">🥇</div>
                                    <h5 class="text-base font-bold text-yellow-400" data-translate="welcome.gold">Gold</h5>
                                    <p class="text-white text-xs" data-translate="welcome.mainCurrency">Main Currency</p>
                                </div>
                                <div class="text-center">
                                    <div class="text-2xl mb-1">🪙</div>
                                    <h5 class="text-base font-bold text-blue-400" data-translate="welcome.fourTCoin">4T Coin</h5>
                                    <p class="text-white text-xs" data-translate="welcome.premium">Premium</p>
                                </div>
                                <div class="text-center">
                                    <div class="text-2xl mb-1">💎</div>
                                    <h5 class="text-base font-bold text-purple-400" data-translate="welcome.mCoin">M Coin</h5>
                                    <p class="text-white text-xs" data-translate="welcome.market">Market</p>
                                </div>
                            </div>
                        </div>

                        <div class="bg-slate-700/50 rounded-xl p-4 border border-green-500/20">
                            <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
                                <div class="text-center">
                                    <div class="text-2xl mb-1">🔰</div>
                                    <h5 class="text-base font-bold text-cyan-400" data-translate="welcome.silk">Silk</h5>
                                    <p class="text-white text-xs" data-translate="welcome.standard">Standard</p>
                                </div>
                                
                                <div class="text-center">
                                    <div class="text-2xl mb-1">🎯</div>
                                    <h5 class="text-base font-bold text-red-400" data-translate="welcome.silkPoint">Silk Point</h5>
                                    <p class="text-white text-xs" data-translate="welcome.achievement">Achievement</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Website Currency System -->
                <div>
                    <h4 class="text-xl font-bold text-yellow-400 mb-4 flex items-center gap-2">
                        🌐 <span data-translate="welcome.websiteCurrencies">Website Currencies</span>
                    </h4>
                    <div class="space-y-3">
                        <div class="bg-slate-700/50 rounded-xl p-5 border border-yellow-500/20">
                            <div class="text-center">
                                <div class="text-3xl mb-2">🏅</div>
                                <h5 class="text-lg font-bold text-yellow-400 mb-1" data-translate="welcome.giftBalance">Gift Balance</h5>
                                <p class="text-white text-sm" data-translate="welcome.eventRewards">Event Rewards</p>
                                <p class="text-yellow-300 text-xs mt-1" data-translate="welcome.rewardFromBigEvents">Reward From Big Events</p>
                            </div>
                        </div>

                        <div class="bg-slate-700/50 rounded-xl p-5 border border-yellow-500/20">
                            <div class="text-center">
                                <div class="text-3xl mb-2">💰</div>
                                <h5 class="text-lg font-bold text-yellow-400 mb-1" data-translate="welcome.balance">Balance</h5>
                                <p class="text-white text-sm" data-translate="welcome.donationCredits">Donation Credits</p>
                                <p class="text-yellow-300 text-xs mt-1" data-translate="welcome.donatesCanBackToMoney">Donates Can Back to Money</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- Latest News Section -->
    <!--[if BLOCK]><![endif]--><?php if(count($latestNews) > 0): ?>
    <div class="container mx-auto px-6 py-16">
        <div class="text-center mb-12">
            <h2 class="text-4xl font-bold text-white mb-4" data-translate="welcome.latestNews">Latest News & Updates</h2>
            <div class="w-24 h-1 bg-gradient-to-r from-purple-500 to-cyan-500 mx-auto"></div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $latestNews->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <article class="bg-gradient-to-br from-slate-800/50 to-purple-900/30 backdrop-blur-lg border border-purple-500/30 rounded-2xl overflow-hidden shadow-2xl hover:border-purple-400/50 transition-all duration-300 hover:scale-105">
                <!--[if BLOCK]><![endif]--><?php if($news['image']): ?>
                <div class="h-48 bg-cover bg-center relative" style="background-image: url('<?php echo e($news['image']); ?>')">
                    <div class="absolute inset-0 bg-gradient-to-t from-purple-900/50 to-transparent"></div>
                </div>
                <?php else: ?>
                <div class="h-48 bg-gradient-to-br from-purple-600 to-blue-600 flex items-center justify-center relative">
                    <div class="text-6xl">📰</div>
                    <div class="absolute inset-0 bg-gradient-to-t from-purple-900/30 to-transparent"></div>
                </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                <div class="p-6">
                    <div class="flex items-center gap-2 text-purple-300 text-sm mb-3">
                        <span>📅</span>
                        <span><?php echo e(\Carbon\Carbon::parse($news['published_at'])->format('M d, Y')); ?></span>
                    </div>

                    <h3 class="text-xl font-bold text-white mb-3 line-clamp-2">
                        <?php echo e($news['title']); ?>

                    </h3>

                    <p class="text-purple-200 text-sm leading-relaxed mb-4 line-clamp-3">
                        <?php echo e($news['excerpt']); ?>

                    </p>

                    <button class="inline-flex items-center gap-2 px-4 py-2 bg-purple-600 hover:bg-purple-700 text-white rounded-lg transition-colors text-sm font-medium">
                        <span data-translate="welcome.readMore">Read More</span>
                        <span>→</span>
                    </button>
                </div>
            </article>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
        </div>

        <!-- View All News Button -->
        <div class="text-center mt-12">
            <a href="<?php echo e(route('news')); ?>" class="px-8 py-4 bg-gradient-to-r from-purple-600 to-blue-600 hover:from-purple-700 hover:to-blue-700 text-white rounded-lg transition-all duration-300 font-medium text-lg shadow-lg hover:shadow-xl" data-translate="welcome.viewAllNews">
                View All News & Updates
            </a>
        </div>
    </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!-- Contact & Social Media Section -->
    <!--[if BLOCK]><![endif]--><?php if(isset($serverSettings['contact_email']) || isset($serverSettings['discord_id']) || isset($serverSettings['facebook_url']) || isset($serverSettings['youtube_url'])): ?>
    <div class="container mx-auto px-6 py-16">
        <div class="bg-gradient-to-br from-slate-800/50 to-indigo-900/30 backdrop-blur-lg border border-indigo-500/30 rounded-2xl p-8 shadow-2xl">
            <h3 class="text-2xl font-bold text-white mb-6 text-center" data-translate="welcome.connectWithUs">Connect With Us</h3>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <?php if(isset($serverSettings['contact_email'])): ?>
                <a href="mailto:<?php echo e($serverSettings['contact_email']); ?>" class="flex items-center gap-3 p-4 bg-slate-700/50 rounded-xl border border-indigo-500/20 hover:border-indigo-400/40 transition-colors">
                    <span class="text-2xl">📧</span>
                    <div>
                        <div class="text-indigo-300 text-sm" data-translate="welcome.email">Email</div>
                        <div class="text-white font-medium text-sm" data-translate="welcome.contactSupport">Contact Support</div>
                    </div>
                </a>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                <!--[if BLOCK]><![endif]--><?php if(isset($serverSettings['discord_id'])): ?>
                <a href="https://discord.gg/<?php echo e($serverSettings['discord_id']); ?>" target="_blank" class="flex items-center gap-3 p-4 bg-slate-700/50 rounded-xl border border-indigo-500/20 hover:border-indigo-400/40 transition-colors">
                    <span class="text-2xl">💬</span>
                    <div>
                        <div class="text-indigo-300 text-sm" data-translate="welcome.discord">Discord</div>
                        <div class="text-white font-medium text-sm" data-translate="welcome.joinCommunity">Join Community</div>
                    </div>
                </a>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                <!--[if BLOCK]><![endif]--><?php if(isset($serverSettings['facebook_url'])): ?>
                <a href="<?php echo e($serverSettings['facebook_url']); ?>" target="_blank" class="flex items-center gap-3 p-4 bg-slate-700/50 rounded-xl border border-indigo-500/20 hover:border-indigo-400/40 transition-colors">
                    <span class="text-2xl">📘</span>
                    <div>
                        <div class="text-indigo-300 text-sm" data-translate="welcome.facebook">Facebook</div>
                        <div class="text-white font-medium text-sm" data-translate="welcome.followPage">Follow Page</div>
                    </div>
                </a>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                <!--[if BLOCK]><![endif]--><?php if(isset($serverSettings['youtube_url'])): ?>
                <a href="<?php echo e($serverSettings['youtube_url']); ?>" target="_blank" class="flex items-center gap-3 p-4 bg-slate-700/50 rounded-xl border border-indigo-500/20 hover:border-indigo-400/40 transition-colors">
                    <span class="text-2xl">📺</span>
                    <div>
                        <div class="text-indigo-300 text-sm" data-translate="welcome.youtube">YouTube</div>
                        <div class="text-white font-medium text-sm" data-translate="welcome.subscribe">Subscribe</div>
                    </div>
                </a>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>
    </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!-- Call to Action Section -->
    <div class="container mx-auto px-6 py-16">
        <div class="text-center">
            <h2 class="text-4xl font-bold text-white mb-6" data-translate="welcome.readyToJoin">Ready to Join the Adventure?</h2>
            <p class="text-xl text-purple-200 mb-8 max-w-2xl mx-auto" data-translate="welcome.createAccountDescription">
                Create your account now and become part of our growing community of heroes and legends
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="<?php echo e(route('register')); ?>" class="px-8 py-4 bg-gradient-to-r from-purple-600 to-pink-600 hover:from-purple-700 hover:to-pink-700 text-white rounded-lg transition-all duration-300 font-medium text-lg shadow-lg hover:shadow-xl" data-translate="welcome.createAccount">
                    Create Account
                </a>
                <a href="#" class="px-8 py-4 bg-gradient-to-r from-blue-600 to-cyan-600 hover:from-blue-700 hover:to-cyan-700 text-white rounded-lg transition-all duration-300 font-medium text-lg shadow-lg hover:shadow-xl" data-translate="welcome.downloadClient">
                    Download Client
                </a>
            </div>
        </div>
    </div>


<style>
    .line-clamp-2 {
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }

    .line-clamp-3 {
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }

    /* Language switcher loading states */
    .lang-loading {
        opacity: 0.6;
        pointer-events: none;
    }

    .lang-success {
        transform: scale(1.05);
        transition: transform 0.3s ease;
    }

    /* Direction transition */
    .direction-transition {
        transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
    }

    /* RTL support */
    [dir="rtl"] {
        text-align: right;
    }

    [dir="rtl"] .flex {
        flex-direction: row-reverse;
    }

    [dir="rtl"] .justify-between {
        flex-direction: row-reverse;
    }
</style>

</div><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/frontend/welcome.blade.php ENDPATH**/ ?>