<?php

use Livewire\Volt\Component;
use App\Models\RechargeSettings;
use App\Models\RechargeTransaction;
use App\Models\RechargeRewardsSetting;
use App\Models\RechargeReward;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;

?>

<div class="shipping-container" x-data="{
    shippingPage: <?php if ((object) ('shippingPage') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('shippingPage'->value()); ?>')<?php echo e('shippingPage'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('shippingPage'); ?>')<?php endif; ?>,
    selectedPayment: <?php if ((object) ('selectedPayment') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('selectedPayment'->value()); ?>')<?php echo e('selectedPayment'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('selectedPayment'); ?>')<?php endif; ?>,
    rechargeAmount: <?php if ((object) ('rechargeAmount') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('rechargeAmount'->value()); ?>')<?php echo e('rechargeAmount'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('rechargeAmount'); ?>')<?php endif; ?>,
    userEmail: <?php if ((object) ('userEmail') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('userEmail'->value()); ?>')<?php echo e('userEmail'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('userEmail'); ?>')<?php endif; ?>,
    userPhone: <?php if ((object) ('userPhone') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('userPhone'->value()); ?>')<?php echo e('userPhone'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('userPhone'); ?>')<?php endif; ?>,
    userName: <?php if ((object) ('userName') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('userName'->value()); ?>')<?php echo e('userName'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('userName'); ?>')<?php endif; ?>,
    transactionId: <?php if ((object) ('transactionId') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('transactionId'->value()); ?>')<?php echo e('transactionId'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('transactionId'); ?>')<?php endif; ?>,
    note: <?php if ((object) ('note') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('note'->value()); ?>')<?php echo e('note'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('note'); ?>')<?php endif; ?>,
    isLoading: <?php if ((object) ('isLoading') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('isLoading'->value()); ?>')<?php echo e('isLoading'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('isLoading'); ?>')<?php endif; ?>,
    showPaymentDetails: <?php if ((object) ('showPaymentDetails') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showPaymentDetails'->value()); ?>')<?php echo e('showPaymentDetails'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showPaymentDetails'); ?>')<?php endif; ?>,
    showTransactionFields: <?php if ((object) ('showTransactionFields') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showTransactionFields'->value()); ?>')<?php echo e('showTransactionFields'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showTransactionFields'); ?>')<?php endif; ?>,
    calculation: <?php if ((object) ('calculation') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('calculation'->value()); ?>')<?php echo e('calculation'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('calculation'); ?>')<?php endif; ?>,

    // Real data from backend (fresh on each page load)
    rewardTiers: <?php echo \Illuminate\Support\Js::from($this->getRewardTiers())->toHtml() ?>,
    currentUserTier: <?php echo \Illuminate\Support\Js::from($this->getUserCurrentTier())->toHtml() ?>,
    nextUserTier: <?php echo \Illuminate\Support\Js::from($this->getUserNextTier())->toHtml() ?>,
    userTotalRecharge: <?php echo \Illuminate\Support\Js::from((float) $this->getUserTotalRecharge())->toHtml() ?>,
    progressToNextTier: <?php echo \Illuminate\Support\Js::from((float) $this->getProgressToNextTier())->toHtml() ?>,
    userTransactionHistory: <?php echo \Illuminate\Support\Js::from($this->getUserTransactionHistory())->toHtml() ?>,
    pendingRewards: <?php echo \Illuminate\Support\Js::from($this->getUserPendingRewards())->toHtml() ?>,

    init() {
        // Initialize animations and ensure data is properly formatted
        this.$nextTick(() => {
            // Ensure userTotalRecharge is always a number
            if (this.userTotalRecharge === null || this.userTotalRecharge === undefined) {
                this.userTotalRecharge = 0.0;
            }
            if (this.progressToNextTier === null || this.progressToNextTier === undefined) {
                this.progressToNextTier = 0.0;
            }

            // Ensure userTransactionHistory is always an array
            if (!Array.isArray(this.userTransactionHistory)) {
                this.userTransactionHistory = [];
            }

            // Ensure pendingRewards is always an array
            if (!Array.isArray(this.pendingRewards)) {
                this.pendingRewards = [];
            }

            this.animateCounters();
        });
    },

    animateCounters() {
        // Animate progress bars and counters
        const progressBars = document.querySelectorAll('.progress-bar');
        progressBars.forEach(bar => {
            const width = bar.dataset.width || '0';
            bar.style.width = width + '%';
        });
    },

    formatCurrency(amount, currency = 'USD') {
        const numericAmount = parseFloat(amount || 0);
        return new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: currency
        }).format(numericAmount);
    },

    formatNumber(number) {
        const numericValue = parseFloat(number || 0);
        return new Intl.NumberFormat().format(numericValue);
    },

    safeCurrencyDisplay(amount) {
        const numericAmount = parseFloat(amount || 0);
        return `$${numericAmount.toFixed(2)}`;
    },

    convertCurrency(amount, fromCurrency, toCurrency) {
        const numericAmount = parseFloat(amount || 0);

        if (fromCurrency === toCurrency) {
            return numericAmount;
        }

        if (fromCurrency === 'EGP' && toCurrency === 'USD') {
            return numericAmount / 50; // EGP to USD
        }

        if (fromCurrency === 'USD' && toCurrency === 'EGP') {
            return numericAmount * 50; // USD to EGP
        }

        return numericAmount;
    },

    formatCurrencyWithSymbol(amount, currency) {
        const numericAmount = parseFloat(amount || 0);

        if (currency === 'USD') {
            return `$${numericAmount.toFixed(2)}`;
        } else if (currency === 'EGP') {
            return `${numericAmount.toFixed(0)} EGP`;
        }

        return `${numericAmount.toFixed(2)} ${currency}`;
    },

    selectPayment(method) {
        this.selectedPayment = method;
        this.shippingPage = 'payment-form';
        $wire.selectPayment(method);
    },

    setPage(page) {
        this.shippingPage = page;
        $wire.setshippingPage(page);
    },

    proceedToPayment() {
        $wire.proceedToPayment();
    },

    showTransactionForm() {
        $wire.showTransactionForm();
    },

    getPayPalUrl() {
        if (!this.rechargeAmount || !this.selectedPayment) return '#';
        // Use entangled calculation data
        if (!this.calculation || typeof this.calculation.total === 'undefined') {
            return '#';
        }
        return `https://www.paypal.com/paypalme/4TresSro/${this.calculation.total.toFixed(2)}`;
    },

    getVodafoneUrl() {
        if (!this.rechargeAmount || !this.selectedPayment) return '#';
        // Use entangled calculation data
        if (!this.calculation || typeof this.calculation.total === 'undefined') {
            return '#';
        }
        const total = Math.round(this.calculation.total);
        return `tel:*9*7*01095161434*${total}%23`;
    },

    isMobile() {
        return window.innerWidth <= 768;
    },

    canProceed() {
        if (!this.rechargeAmount || !this.selectedPayment) {
            return false;
        }

        const amount = parseFloat(this.rechargeAmount);
        return $wire.canProceedToPayment();
    },

    handleVodafonePayment() {
        if (this.isMobile()) {
            // For mobile: Open dialer directly
            window.location.href = this.getVodafoneUrl();
        } else {
            // For desktop: Show payment details card
            $wire.proceedToPayment();
        }
    },

    getButtonState() {
        if (!this.rechargeAmount || !this.selectedPayment) {
            return 'disabled-gray';
        }

        const amount = parseFloat(this.rechargeAmount);
        const minimums = {
            'paypal': <?php echo e($paypalSettings ? $paypalSettings->minimum_amount : 5); ?>,
            'vodafone': <?php echo e($vodafoneSettings ? $vodafoneSettings->minimum_amount : 50); ?>,
            'instapay': <?php echo e($instapaySettings ? $instapaySettings->minimum_amount : 20); ?>

        };

        const minimum = minimums[this.selectedPayment] || 1;

        if (amount < minimum) {
            return 'disabled-gray'; // Amount too low
        }

        // Check if Livewire validation passes (this handles maximum and other validations)
        if (!$wire.canProceedToPayment()) {
            return 'disabled-red'; // Other validation errors (like maximum exceeded)
        }

        return 'enabled'; // All good
    },

    getButtonClass(paymentType) {
        const state = this.getButtonState();

        if (state === 'enabled') {
            switch (paymentType) {
                case 'paypal':
                    return 'bg-blue-600 hover:bg-blue-700';
                case 'vodafone':
                    return 'bg-red-600 hover:bg-red-700';
                case 'instapay':
                    return 'bg-orange-600 hover:bg-orange-700';
                default:
                    return 'bg-blue-600 hover:bg-blue-700';
            }
        } else if (state === 'disabled-gray') {
            return 'bg-gray-500 cursor-not-allowed';
        } else if (state === 'disabled-red') {
            return 'bg-red-800 cursor-not-allowed';
        }

        return 'bg-gray-500 cursor-not-allowed';
    },

    getButtonText(paymentType, amount) {
        const state = this.getButtonState();

        if (state === 'enabled') {
            switch (paymentType) {
                case 'paypal':
                    return `Pay with PayPal - $${amount}`;
                case 'vodafone':
                    return this.isMobile() ?
                        `📱 Open Vodafone Dialer - ${amount} EGP` :
                        `📞 Send Money - ${amount} EGP`;
                case 'instapay':
                    return `Send Money - ${amount} EGP`;
                default:
                    return 'Process Payment';
            }
        } else if (state === 'disabled-gray') {
            return 'Enter amount above minimum';
        } else if (state === 'disabled-red') {
            return 'Amount exceeds maximum limit';
        }

        return 'Enter valid amount';
    },

    getMinimumForPayment() {
        const minimums = {
            'paypal': <?php echo e($paypalSettings ? $paypalSettings->minimum_amount : 5); ?>,
            'vodafone': <?php echo e($vodafoneSettings ? $vodafoneSettings->minimum_amount : 50); ?>,
            'instapay': <?php echo e($instapaySettings ? $instapaySettings->minimum_amount : 20); ?>

        };
        return minimums[this.selectedPayment] || 1;
    }
}">

    <!-- Loading Overlay -->
    <div x-show="isLoading" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0"
        x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-200"
        x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
        class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
        <div class="bg-gradient-to-br from-purple-600 to-blue-600 rounded-2xl p-8 text-center">
            <div class="animate-spin rounded-full h-16 w-16 border-b-2 border-white mx-auto mb-4"></div>
            <p class="text-white font-semibold" wire:ignore data-translate="page.shipping.recharge_form.processing">
                Processing...</p>
        </div>
    </div>

    <div class="shipping-content">

        <!-- Header Section -->
        <div class="shipping-header">
            <div class="shipping-icon">
                <svg viewBox="0 0 24 24" fill="currentColor">
                    <path
                        d="M12 2C13.1 2 14 2.9 14 4C14 5.1 13.1 6 12 6C10.9 6 10 5.1 10 4C10 2.9 10.9 2 12 2ZM21 9V7L15 1H5C3.9 1 3 1.9 3 3V17C3 18.1 3.9 19 5 19H11V21C11 21.6 11.4 22 12 22S13 21.6 13 21V19H19C20.1 19 21 18.1 21 17V9ZM15 15H13V17H15V15ZM15 13H13V11H15V13ZM11 15H9V17H11V15ZM11 13H9V11H11V13ZM7 15H5V17H7V15ZM7 13H5V11H7V13Z" />
                </svg>
            </div>
            <h1 class="shipping-title" data-translate="page.shipping.title" wire:ignore>💎 Premium Recharge Center</h1>
            <p class="shipping-subtitle" wire:ignore data-translate="page.shipping.description">Secure and fast diamond
                recharge system with exclusive bonuses and rewards</p>
        </div>

        <!-- Welcome Section -->
        <div class="welcome-section" x-show="shippingPage === 'overview'">
            <div class="welcome-content">
                <h2 class="welcome-title" wire:ignore data-translate="page.shipping.welcome_title">⚡ Power Up Your
                    Adventure!</h2>
                <p class="welcome-subtitle text-lg mb-4" wire:ignore data-translate="page.shipping.welcome_subtitle">
                    Unlock Premium Features & Exclusive Content</p>
                <p class="text-gray-300 mb-4" wire:ignore data-translate="page.shipping.motivational_message">Don't let
                    your journey end here! Recharge your diamonds and unlock unlimited power, exclusive items, and epic
                    adventures that will make you the ultimate champion!</p>
                <div
                    class="bg-gradient-to-r from-yellow-500/20 to-orange-500/20 border border-yellow-500/30 rounded-lg p-4">
                    <p class="text-yellow-200 font-semibold" wire:ignore
                        data-translate="page.shipping.financial_policy">💰 Smart Investment Policy: Every diamond you
                        purchase is an investment in your gaming supremacy. Join thousands of players who have already
                        discovered the power of premium gaming!</p>
                </div>
            </div>
        </div>

        <!-- Main Content Area -->
        <div class="space-y-6">

            <!-- Navigation Cards -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6" x-show="shippingPage === 'overview'"
                x-transition:enter="transition ease-out duration-600 delay-300"
                x-transition:enter-start="opacity-0 transform scale-95"
                x-transition:enter-end="opacity-100 transform scale-100">

                <!-- Purchase Guide Card -->
                <div class="premium-nav-card purchase-card group" @click="setPage('purchase-guide')"
                    x-data="{ isHovered: false }" @mouseenter="isHovered = true" @mouseleave="isHovered = false"
                    x-transition:enter="transition ease-out duration-500"
                    x-transition:enter-start="opacity-0 transform translate-y-8"
                    x-transition:enter-end="opacity-100 transform translate-y-0">

                    <!-- Floating Particles Background -->
                    <div class="card-particles absolute inset-0 overflow-hidden rounded-2xl">
                        <div class="particle particle-1"></div>
                        <div class="particle particle-2"></div>
                        <div class="particle particle-3"></div>
                    </div>

                    <!-- Animated Border Glow -->
                    <div
                        class="card-glow-border absolute inset-0 rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                    </div>

                    <div class="card-content relative z-10 p-6">
                        <div class="card-header flex items-center mb-4">
                            <div class="card-icon-container relative">
                                <div
                                    class="card-icon-bg absolute inset-0 rounded-xl transform transition-transform duration-500 group-hover:rotate-12 group-hover:scale-110">
                                </div>
                                <div class="card-icon relative flex items-center justify-center w-14 h-14 rounded-xl transition-all duration-500"
                                    :class="isHovered ? 'animate-pulse' : ''">
                                    <svg viewBox="0 0 24 24" fill="currentColor"
                                        class="w-7 h-7 text-white transform transition-transform duration-500 group-hover:scale-110">
                                        <path
                                            d="M12,2A3,3 0 0,1 15,5V11A3,3 0 0,1 12,14A3,3 0 0,1 9,11V5A3,3 0 0,1 12,2M19,11C19,14.53 16.39,17.44 13,17.93V21H11V17.93C7.61,17.44 5,14.53 5,11H7A5,5 0 0,0 12,16A5,5 0 0,0 17,11H19Z" />
                                    </svg>
                                </div>
                            </div>
                            <div class="floating-emoji absolute top-2 right-2 text-2xl animate-bounce">🛒</div>
                        </div>

                        <h3 class="card-title text-lg font-bold mb-3 transform transition-all duration-500 group-hover:translate-x-1"
                            wire:ignore data-translate="page.shipping.purchase_guide.title">How to Purchase Diamonds
                        </h3>

                        <p class="card-description text-sm text-gray-400 leading-relaxed transform transition-all duration-500 group-hover:text-gray-300"
                            wire:ignore data-translate="page.shipping.purchase_guide.description">Follow our simple
                            step-by-step guide to securely recharge your account with premium diamonds</p>

                        <!-- Progress Indicator -->
                        <div
                            class="card-progress mt-4 h-1 bg-gradient-to-r from-blue-500/20 to-purple-500/20 rounded-full overflow-hidden">
                            <div
                                class="progress-fill h-full bg-gradient-to-r from-blue-500 to-purple-500 rounded-full transform -translate-x-full transition-transform duration-700 group-hover:translate-x-0">
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Usage Guide Card -->
                <div class="premium-nav-card usage-card group" @click="setPage('usage-guide')" x-data="{ isHovered: false }"
                    @mouseenter="isHovered = true" @mouseleave="isHovered = false"
                    x-transition:enter="transition ease-out duration-500 delay-100"
                    x-transition:enter-start="opacity-0 transform translate-y-8"
                    x-transition:enter-end="opacity-100 transform translate-y-0">

                    <!-- Floating Particles Background -->
                    <div class="card-particles absolute inset-0 overflow-hidden rounded-2xl">
                        <div class="particle particle-1"></div>
                        <div class="particle particle-2"></div>
                        <div class="particle particle-3"></div>
                    </div>

                    <!-- Animated Border Glow -->
                    <div
                        class="card-glow-border absolute inset-0 rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                    </div>

                    <div class="card-content relative z-10 p-6">
                        <div class="card-header flex items-center mb-4">
                            <div class="card-icon-container relative">
                                <div
                                    class="card-icon-bg absolute inset-0 rounded-xl transform transition-transform duration-500 group-hover:rotate-12 group-hover:scale-110">
                                </div>
                                <div class="card-icon relative flex items-center justify-center w-14 h-14 rounded-xl transition-all duration-500"
                                    :class="isHovered ? 'animate-spin' : ''">
                                    <svg viewBox="0 0 24 24" fill="currentColor"
                                        class="w-7 h-7 text-white transform transition-transform duration-500 group-hover:scale-110">
                                        <path
                                            d="M17,8C8,10 5.9,16.17 3.82,21.34L5.71,22L6.66,19.7C7.14,19.87 7.64,20 8,20C19,20 22,3 22,3C21,5 14,5.25 9,6.25C4,7.25 2,11.5 2,13.5C2,15.5 3.75,17.25 3.75,17.25C7,8 17,8 17,8Z" />
                                    </svg>
                                </div>
                            </div>
                            <div class="floating-emoji absolute top-2 right-2 text-2xl animate-bounce delay-150">💳
                            </div>
                        </div>

                        <h3 class="card-title text-lg font-bold mb-3 transform transition-all duration-500 group-hover:translate-x-1"
                            wire:ignore data-translate="page.shipping.usage_guide.title">How to Use Your Balance</h3>

                        <p class="card-description text-sm text-gray-400 leading-relaxed transform transition-all duration-500 group-hover:text-gray-300"
                            wire:ignore data-translate="page.shipping.usage_guide.description">Learn how to effectively
                            use your diamond balance for maximum gaming advantage</p>

                        <!-- Progress Indicator -->
                        <div
                            class="card-progress mt-4 h-1 bg-gradient-to-r from-emerald-500/20 to-teal-500/20 rounded-full overflow-hidden">
                            <div
                                class="progress-fill h-full bg-gradient-to-r from-emerald-500 to-teal-500 rounded-full transform -translate-x-full transition-transform duration-700 group-hover:translate-x-0">
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Payment Methods Card -->
                <div class="premium-nav-card payment-card group" @click="setPage('payment-methods')"
                    x-data="{ isHovered: false }" @mouseenter="isHovered = true" @mouseleave="isHovered = false"
                    x-transition:enter="transition ease-out duration-500 delay-200"
                    x-transition:enter-start="opacity-0 transform translate-y-8"
                    x-transition:enter-end="opacity-100 transform translate-y-0">

                    <!-- Floating Particles Background -->
                    <div class="card-particles absolute inset-0 overflow-hidden rounded-2xl">
                        <div class="particle particle-1"></div>
                        <div class="particle particle-2"></div>
                        <div class="particle particle-3"></div>
                    </div>

                    <!-- Animated Border Glow -->
                    <div
                        class="card-glow-border absolute inset-0 rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                    </div>

                    <div class="card-content relative z-10 p-6">
                        <div class="card-header flex items-center mb-4">
                            <div class="card-icon-container relative">
                                <div
                                    class="card-icon-bg absolute inset-0 rounded-xl transform transition-transform duration-500 group-hover:rotate-12 group-hover:scale-110">
                                </div>
                                <div class="card-icon relative flex items-center justify-center w-14 h-14 rounded-xl transition-all duration-500"
                                    :class="isHovered ? 'animate-pulse' : ''">
                                    <svg viewBox="0 0 24 24" fill="currentColor"
                                        class="w-7 h-7 text-white transform transition-transform duration-500 group-hover:scale-110">
                                        <path
                                            d="M20,8H4V6H20M20,18H4V12H20M20,4H4C2.89,4 2,4.89 2,6V18A2,2 0 0,0 4,20H20A2,2 0 0,0 22,18V6C22,4.89 21.1,4 20,4Z" />
                                    </svg>
                                </div>
                            </div>
                            <div class="floating-emoji absolute top-2 right-2 text-2xl animate-bounce delay-300">🏦
                            </div>
                        </div>

                        <h3 class="card-title text-lg font-bold mb-3 transform transition-all duration-500 group-hover:translate-x-1"
                            wire:ignore data-translate="page.shipping.payment_methods.title">Payment Methods</h3>

                        <p class="card-description text-sm text-gray-400 leading-relaxed transform transition-all duration-500 group-hover:text-gray-300"
                            wire:ignore data-translate="page.shipping.payment_methods.subtitle">Choose Your Preferred
                            Payment Option</p>

                        <!-- Progress Indicator -->
                        <div
                            class="card-progress mt-4 h-1 bg-gradient-to-r from-orange-500/20 to-red-500/20 rounded-full overflow-hidden">
                            <div
                                class="progress-fill h-full bg-gradient-to-r from-orange-500 to-red-500 rounded-full transform -translate-x-full transition-transform duration-700 group-hover:translate-x-0">
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Progress & History Card -->
                <div class="premium-nav-card rewards-card group" @click="setPage('progress-history')"
                    x-data="{ isHovered: false }" @mouseenter="isHovered = true" @mouseleave="isHovered = false"
                    x-transition:enter="transition ease-out duration-500 delay-300"
                    x-transition:enter-start="opacity-0 transform translate-y-8"
                    x-transition:enter-end="opacity-100 transform translate-y-0">

                    <!-- Floating Particles Background -->
                    <div class="card-particles absolute inset-0 overflow-hidden rounded-2xl">
                        <div class="particle particle-1"></div>
                        <div class="particle particle-2"></div>
                        <div class="particle particle-3"></div>
                    </div>

                    <!-- Animated Border Glow -->
                    <div
                        class="card-glow-border absolute inset-0 rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                    </div>

                    <div class="card-content relative z-10 p-6">
                        <div class="card-header flex items-center mb-4">
                            <div class="card-icon-container relative">
                                <div
                                    class="card-icon-bg absolute inset-0 rounded-xl transform transition-transform duration-500 group-hover:rotate-12 group-hover:scale-110">
                                </div>
                                <div class="card-icon relative flex items-center justify-center w-14 h-14 rounded-xl transition-all duration-500"
                                    :class="isHovered ? 'animate-bounce' : ''">
                                    <svg viewBox="0 0 24 24" fill="currentColor"
                                        class="w-7 h-7 text-white transform transition-transform duration-500 group-hover:scale-110">
                                        <path
                                            d="M16,6L18.29,8.29L13.41,13.17L9.41,9.17L2,16.59L3.41,18L9.41,12L13.41,16L19.71,9.71L22,12V6H16Z" />
                                    </svg>
                                </div>
                            </div>
                            <div class="floating-emoji absolute top-2 right-2 text-2xl animate-bounce delay-450">🎁
                            </div>
                        </div>

                        <h3 class="card-title text-lg font-bold mb-3 transform transition-all duration-500 group-hover:translate-x-1"
                            wire:ignore data-translate="page.shipping.progress_rewards.title">Rewards & History</h3>

                        <p class="card-description text-sm text-gray-400 leading-relaxed transform transition-all duration-500 group-hover:text-gray-300"
                            wire:ignore data-translate="page.shipping.transaction_history.subtitle">Track Your Recharge
                            History</p>

                        <!-- Progress Indicator -->
                        <div
                            class="card-progress mt-4 h-1 bg-gradient-to-r from-pink-500/20 to-violet-500/20 rounded-full overflow-hidden">
                            <div
                                class="progress-fill h-full bg-gradient-to-r from-pink-500 to-violet-500 rounded-full transform -translate-x-full transition-transform duration-700 group-hover:translate-x-0">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Purchase Guide Page -->
            <div x-show="shippingPage === 'purchase-guide'" class="gaming-card">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-2xl font-bold text-purple-400" wire:ignore
                        data-translate="page.shipping.purchase_guide.title">🛒 How to Purchase Diamonds</h2>
                    <button @click="setPage('overview')"
                        class="px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-500 transition-colors">
                        <span wire:ignore data-translate="common.back">Back</span>
                    </button>
                </div>
                <div class="space-y-4">
                    <div
                        class="flex items-start space-x-4 p-4 bg-gradient-to-r from-purple-500/10 to-blue-500/10 rounded-lg">
                        <div
                            class="w-8 h-8 bg-purple-500 text-white rounded-full flex items-center justify-center font-bold">
                            1</div>
                        <div>
                            <h3 class="text-purple-300 font-semibold" wire:ignore
                                data-translate="page.shipping.purchase_guide.steps.step1">Choose your preferred payment
                                method</h3>
                            <p class="text-gray-400">Select between PayPal for international payments or Vodafone Cash
                                for local Egyptian transactions.</p>
                        </div>
                    </div>
                    <div
                        class="flex items-start space-x-4 p-4 bg-gradient-to-r from-purple-500/10 to-blue-500/10 rounded-lg">
                        <div
                            class="w-8 h-8 bg-purple-500 text-white rounded-full flex items-center justify-center font-bold">
                            2</div>
                        <div>
                            <h3 class="text-purple-300 font-semibold" wire:ignore
                                data-translate="page.shipping.purchase_guide.steps.step2">Enter the recharge amount
                            </h3>
                            <p class="text-gray-400">Specify how much you want to recharge. The system will
                                automatically calculate fees and diamonds received.</p>
                        </div>
                    </div>
                    <div
                        class="flex items-start space-x-4 p-4 bg-gradient-to-r from-purple-500/10 to-blue-500/10 rounded-lg">
                        <div
                            class="w-8 h-8 bg-purple-500 text-white rounded-full flex items-center justify-center font-bold">
                            3</div>
                        <div>
                            <h3 class="text-purple-300 font-semibold" wire:ignore
                                data-translate="page.shipping.purchase_guide.steps.step3">Complete secure payment
                                process</h3>
                            <p class="text-gray-400">Follow the secure payment gateway instructions to complete your
                                transaction safely.</p>
                        </div>
                    </div>
                    <div
                        class="flex items-start space-x-4 p-4 bg-gradient-to-r from-purple-500/10 to-blue-500/10 rounded-lg">
                        <div
                            class="w-8 h-8 bg-green-500 text-white rounded-full flex items-center justify-center font-bold">
                            4</div>
                        <div>
                            <h3 class="text-green-300 font-semibold" wire:ignore
                                data-translate="page.shipping.purchase_guide.steps.step4">Receive diamonds instantly!
                            </h3>
                            <p class="text-gray-400">Your diamonds will be added to your account automatically upon
                                successful payment completion.</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Usage Guide Page -->
            <div x-show="shippingPage === 'usage-guide'" class="gaming-card">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-2xl font-bold text-purple-400" wire:ignore
                        data-translate="page.shipping.usage_guide.title">💳 How to Use Your Balance</h2>
                    <button @click="setPage('overview')"
                        class="px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-500 transition-colors">
                        <span wire:ignore data-translate="common.back">Back</span>
                    </button>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="space-y-4">
                        <div class="p-4 bg-gradient-to-r from-green-500/10 to-blue-500/10 rounded-lg">
                            <h3 class="text-green-300 font-semibold mb-2" wire:ignore
                                data-translate="page.shipping.usage_guide.benefits.premium_items">Purchase exclusive
                                premium items</h3>
                            <p class="text-gray-400">Access rare weapons, armor, and accessories only available through
                                diamond purchases.</p>
                        </div>
                        <div class="p-4 bg-gradient-to-r from-yellow-500/10 to-orange-500/10 rounded-lg">
                            <h3 class="text-yellow-300 font-semibold mb-2" wire:ignore
                                data-translate="page.shipping.usage_guide.benefits.special_packages">Unlock
                                limited-time packages</h3>
                            <p class="text-gray-400">Get special bundle deals and seasonal packages with massive
                                savings.</p>
                        </div>
                    </div>
                    <div class="space-y-4">
                        <div class="p-4 bg-gradient-to-r from-purple-500/10 to-pink-500/10 rounded-lg">
                            <h3 class="text-purple-300 font-semibold mb-2" wire:ignore
                                data-translate="page.shipping.usage_guide.benefits.vip_benefits">Access VIP membership
                                benefits</h3>
                            <p class="text-gray-400">Enjoy exclusive perks, faster progression, and premium customer
                                support.</p>
                        </div>
                        <div class="p-4 bg-gradient-to-r from-cyan-500/10 to-blue-500/10 rounded-lg">
                            <h3 class="text-cyan-300 font-semibold mb-2" wire:ignore
                                data-translate="page.shipping.usage_guide.benefits.event_participation">Participate in
                                premium events</h3>
                            <p class="text-gray-400">Enter exclusive tournaments and events with amazing rewards.</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Payment Methods Page -->
            <div x-show="shippingPage === 'payment-methods'" class="space-y-6">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-2xl font-bold text-purple-400" wire:ignore
                        data-translate="page.shipping.payment_methods.title">🏦 Payment Methods</h2>
                    <button @click="setPage('overview')"
                        class="px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-500 transition-colors">
                        <span wire:ignore data-translate="common.back">Back</span>
                    </button>
                </div>

                <div class="payment-methods">
                    <!-- PayPal Card -->
                    <div class="payment-card paypal-card" @click="selectPayment('paypal')">
                        <div class="payment-header">
                            <div class="payment-logo paypal-logo">
                                <img src="/assets/images/payments/Paypal.png" alt="PayPal Logo"
                                    class="payment-logo-img">
                            </div>
                            <div class="payment-badge paypal-badge" wire:ignore data-translate="shipping.ui.global">
                                Global</div>
                        </div>
                        <h3 class="text-xl font-semibold text-white mb-2" wire:ignore
                            data-translate="page.shipping.payment_methods.paypal.title">PayPal</h3>
                        <p class="text-gray-300 mb-2" wire:ignore
                            data-translate="page.shipping.payment_methods.paypal.subtitle">International Payment
                            Gateway</p>
                        <p class="text-sm text-gray-400 mb-3" wire:ignore
                            data-translate="page.shipping.payment_methods.paypal.description">Secure worldwide payments
                            with PayPal protection</p>
                        <div class="space-y-1">
                            <p class="text-sm text-yellow-300">Processing Fee:
                                <?php echo e($paypalSettings ? number_format($paypalSettings->fee_percentage, 1) . '%' : '3.5%'); ?>

                            </p>
                            <p class="text-sm text-green-300">Minimum:
                                $<?php echo e($paypalSettings ? number_format($paypalSettings->minimum_amount, 0) : '5'); ?> USD</p>
                        </div>
                    </div>

                    <!-- Vodafone Cash Card -->
                    <div class="payment-card vodafone-card" @click="selectPayment('vodafone')">
                        <div class="payment-header">
                            <div class="payment-logo vodafone-logo">
                                <img src="/assets/images/payments/Vodafone.png" alt="Vodafone Logo"
                                    class="payment-logo-img">
                            </div>
                            <div class="payment-badge vodafone-badge" wire:ignore data-translate="shipping.ui.local">
                                Local</div>
                        </div>
                        <h3 class="text-xl font-semibold text-white mb-2" wire:ignore
                            data-translate="page.shipping.payment_methods.vodafone.title">Vodafone Cash</h3>
                        <p class="text-gray-300 mb-2" wire:ignore
                            data-translate="page.shipping.payment_methods.vodafone.subtitle">Egyptian Mobile Payment
                        </p>
                        <p class="text-sm text-gray-400 mb-3" wire:ignore
                            data-translate="page.shipping.payment_methods.vodafone.description">Fast local payment
                            method for Egyptian players</p>
                        <div class="space-y-1">
                            <p class="text-sm text-yellow-300">Processing Fee:
                                <?php echo e($vodafoneSettings ? number_format($vodafoneSettings->fee_percentage, 1) . '%' : '2%'); ?>

                            </p>
                            <p class="text-sm text-green-300">Minimum:
                                <?php echo e($vodafoneSettings ? number_format($vodafoneSettings->minimum_amount, 0) : '50'); ?> EGP
                            </p>
                        </div>
                    </div>

                    <!-- InstaPay Card -->
                    <div class="payment-card instapay-card" @click="selectPayment('instapay')">
                        <div class="payment-header">
                            <div class="payment-logo instapay-logo">
                                <img src="/assets/images/payments/InstaPay.png" alt="InstaPay Logo"
                                    class="payment-logo-img">
                            </div>
                            <div class="payment-badge instapay-badge" wire:ignore data-translate="shipping.ui.fast">
                                Fast</div>
                        </div>
                        <h3 class="text-xl font-semibold text-white mb-2" wire:ignore
                            data-translate="page.shipping.payment_methods.instapay.title">InstaPay</h3>
                        <p class="text-gray-300 mb-2" wire:ignore
                            data-translate="page.shipping.payment_methods.instapay.subtitle">Instant Bank Transfer</p>
                        <p class="text-sm text-gray-400 mb-3" wire:ignore
                            data-translate="page.shipping.payment_methods.instapay.description">Quick and secure
                            instant bank transfer for Egyptian users</p>
                        <div class="space-y-1">
                            <p class="text-sm text-yellow-300">Processing Fee:
                                <?php echo e($instapaySettings ? number_format($instapaySettings->fee_percentage, 1) . '%' : '1.5%'); ?>

                            </p>
                            <p class="text-sm text-green-300">Minimum:
                                <?php echo e($instapaySettings ? number_format($instapaySettings->minimum_amount, 0) : '20'); ?>

                                EGP</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Payment Form Page -->
            <div x-show="shippingPage === 'payment-form'" class="space-y-6">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-2xl font-bold text-purple-400">
                        <span
                            x-text="selectedPayment === 'paypal' ? 'PayPal Recharge' :
                                     selectedPayment === 'vodafone' ? 'Vodafone Cash Recharge' :
                                     'InstaPay Recharge'"></span>
                    </h2>
                    <div class="space-x-2">
                        <button @click="setPage('payment-methods')"
                            class="px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-500 transition-colors">
                            <span wire:ignore data-translate="common.back">Back</span>
                        </button>
                    </div>
                </div>

                <form wire:submit.prevent="startRecharge" class="recharge-form">
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                        <div class="space-y-4">
                            <!-- Name Field -->
                            <div class="form-group">
                                <label class="form-label" wire:ignore data-translate="shipping.ui.full_name">Full
                                    Name</label>
                                <input type="text" wire:model="userName" class="form-input"
                                    placeholder="Enter your full name" required>
                            </div>

                            <!-- Email Field -->
                            <div class="form-group">
                                <label class="form-label" wire:ignore
                                    data-translate="page.shipping.recharge_form.email">Email Address</label>
                                <input type="email" wire:model="userEmail" class="form-input"
                                    placeholder="your.email@example.com" required>
                            </div>

                            <!-- Phone Number Field (for Vodafone and InstaPay) -->
                            <div class="form-group"
                                x-show="selectedPayment === 'vodafone' || selectedPayment === 'instapay'">
                                <label class="form-label" wire:ignore
                                    data-translate="page.shipping.recharge_form.phone">Phone Number</label>
                                <input type="tel" wire:model="userPhone" class="form-input"
                                    :placeholder="selectedPayment === 'vodafone' ? '01xxxxxxxxx' : '01xxxxxxxxx'"
                                    :required="selectedPayment === 'vodafone' || selectedPayment === 'instapay'">
                            </div>

                            <!-- Recharge Amount -->
                            <div class="form-group">
                                <label class="form-label" wire:ignore
                                    data-translate="page.shipping.recharge_form.amount">Recharge Amount</label>
                                <input type="number" wire:model.live="rechargeAmount" class="form-input"
                                    :placeholder="selectedPayment === 'paypal' ? 'Enter amount in USD' : 'Enter amount in EGP'"
                                    min="1" step="0.01" required>
                                <p class="text-xs text-gray-400 mt-1">
                                    <span x-show="selectedPayment === 'paypal'">Minimum:
                                        $<?php echo e($paypalSettings ? number_format($paypalSettings->minimum_amount, 2) : '5.00'); ?>

                                        USD</span>
                                    <span x-show="selectedPayment === 'vodafone'">Minimum:
                                        <?php echo e($vodafoneSettings ? number_format($vodafoneSettings->minimum_amount, 2) : '50.00'); ?>

                                        EGP</span>
                                    <span x-show="selectedPayment === 'instapay'">Minimum:
                                        <?php echo e($instapaySettings ? number_format($instapaySettings->minimum_amount, 2) : '20.00'); ?>

                                        EGP</span>
                                </p>
                            </div>

                            <!-- Payment Action Button -->
                            <div class="form-group">
                                <?php $calculation = $this->calculateTotal(); ?>

                                <!-- PayPal Button -->
                                <div x-show="selectedPayment === 'paypal'">
                                    <button type="button"
                                        @click="getButtonState() === 'enabled' ? (window.open(getPayPalUrl(), '_blank') && showTransactionForm()) : null"
                                        :disabled="getButtonState() !== 'enabled'" :class="getButtonClass('paypal')"
                                        class="w-full py-3 px-4 rounded-lg text-white font-semibold transition-colors">
                                        <span
                                            x-text="getButtonText('paypal', '<?php echo e(number_format($calculation['total'], 2)); ?>')"></span>
                                    </button>
                                </div>

                                <!-- Vodafone Cash Button -->
                                <div x-show="selectedPayment === 'vodafone'">
                                    <button type="button"
                                        @click="getButtonState() === 'enabled' ? handleVodafonePayment() : null"
                                        :disabled="getButtonState() !== 'enabled'"
                                        :class="getButtonClass('vodafone')"
                                        class="w-full py-3 px-4 rounded-lg text-white font-semibold transition-colors">
                                        <span
                                            x-text="getButtonText('vodafone', '<?php echo e(number_format($calculation['total'], 2)); ?>')"></span>
                                    </button>
                                </div>

                                <!-- InstaPay Button -->
                                <div x-show="selectedPayment === 'instapay'">
                                    <button type="button"
                                        @click="getButtonState() === 'enabled' ? proceedToPayment() : null"
                                        :disabled="getButtonState() !== 'enabled'"
                                        :class="getButtonClass('instapay')"
                                        class="w-full py-3 px-4 rounded-lg text-white font-semibold transition-colors">
                                        <span
                                            x-text="getButtonText('instapay', '<?php echo e(number_format($calculation['total'], 2)); ?>')"></span>
                                    </button>
                                </div>
                            </div>

                            <!-- Payment Details Card (for Vodafone/InstaPay on non-mobile) -->
                            <div x-show="showPaymentDetails && (selectedPayment === 'vodafone' || selectedPayment === 'instapay')"
                                class="bg-gradient-to-br from-gray-800 to-gray-900 rounded-lg p-6 border border-gray-700">

                                <!-- Vodafone Cash Details -->
                                <div x-show="selectedPayment === 'vodafone'">
                                    <h3 class="text-lg font-semibold text-red-400 mb-4 flex items-center">
                                        <svg class="w-6 h-6 mr-2" fill="currentColor" viewBox="0 0 24 24">
                                            <path
                                                d="M12 2C13.1 2 14 2.9 14 4C14 5.1 13.1 6 12 6C10.9 6 10 5.1 10 4C10 2.9 10.9 2 12 2ZM19 11C19 14.53 16.39 17.44 13 17.93V21H11V17.93C7.61 17.44 5 14.53 5 11H7A5 5 0 0 0 12 16A5 5 0 0 0 17 11H19Z" />
                                        </svg>
                                        Vodafone Cash Payment Details
                                    </h3>
                                    <div class="space-y-4">
                                        <div class="bg-red-500/10 border border-red-500/30 rounded-lg p-4">
                                            <div class="flex justify-between items-center mb-2">
                                                <span class="text-gray-300 font-medium">Transfer To:</span>
                                                <span class="text-white font-bold text-lg">01095161434</span>
                                            </div>
                                            <div class="flex justify-between items-center">
                                                <span class="text-gray-300 font-medium">Amount to Send:</span>
                                                <span
                                                    class="text-green-400 font-bold text-xl"><?php echo e(number_format($calculation['total'], 2)); ?>

                                                    EGP</span>
                                            </div>
                                        </div>

                                        <!-- Vodafone Cash Code -->
                                        <div
                                            class="bg-gradient-to-r from-red-500/20 to-orange-500/20 border border-red-500/40 rounded-lg p-4">
                                            <h4 class="text-red-300 font-semibold mb-2">📱 Quick Dial Code:</h4>
                                            <div class="bg-black/30 rounded p-3 font-mono text-center" dir="ltr"
                                                style="direction: ltr; text-align: center;">
                                                <span class="text-green-400 text-lg font-bold">*9*7*01095161434*<span
                                                        x-text="Math.round(<?php echo e($calculation['total']); ?>)"></span>#</span>
                                            </div>
                                            <p class="text-xs text-gray-400 mt-2" wire:ignore
                                                data-translate="shipping.ui.copy_code_dial">Copy this code and dial it
                                                from your Vodafone number</p>
                                        </div>

                                        <div
                                            class="text-sm text-gray-400 bg-yellow-500/10 p-3 rounded border border-yellow-500/30">
                                            <p class="text-yellow-400 font-semibold mb-1">📋 Payment Instructions:</p>
                                            <ol class="list-decimal list-inside space-y-1 text-gray-300">
                                                <li wire:ignore data-translate="shipping.ui.dial_code">Dial the code
                                                    above from your Vodafone number</li>
                                                <li wire:ignore data-translate="shipping.ui.follow_prompts">Follow the
                                                    prompts to complete the transfer</li>
                                                <li wire:ignore data-translate="shipping.ui.save_transaction_id">Save
                                                    the transaction ID you receive</li>
                                                <li wire:ignore data-translate="shipping.ui.click_completed_payment">
                                                    Click "I've Completed the Payment" below</li>
                                            </ol>
                                        </div>

                                        <button type="button" @click="showTransactionForm()"
                                            class="w-full bg-red-600 hover:bg-red-700 text-white py-3 px-4 rounded-lg transition-colors font-semibold">
                                            ✅ I've Completed the Payment
                                        </button>
                                    </div>
                                </div>

                                <!-- InstaPay Details -->
                                <div x-show="selectedPayment === 'instapay'">
                                    <h3 class="text-lg font-semibold text-orange-400 mb-4 flex items-center">
                                        <svg class="w-6 h-6 mr-2" fill="currentColor" viewBox="0 0 24 24">
                                            <path
                                                d="M20,8H4V6H20M20,18H4V12H20M20,4H4C2.89,4 2,4.89 2,6V18A2,2 0 0,0 4,20H20A2,2 0 0,0 22,18V6C22,4.89 21.1,4 20,4Z" />
                                        </svg>
                                        InstaPay Payment Details
                                    </h3>
                                    <div class="space-y-4">
                                        <div class="bg-orange-500/10 border border-orange-500/30 rounded-lg p-4">
                                            <div class="flex justify-between items-center mb-3">
                                                <span class="text-gray-300 font-medium">Phone Number:</span>
                                                <span class="text-white font-bold text-lg">01095161434</span>
                                            </div>
                                            <div class="flex justify-between items-center mb-3">
                                                <span class="text-gray-300 font-medium">Bank Account:</span>
                                                <span class="text-white font-bold text-lg">01095161434</span>
                                            </div>
                                            <div class="flex justify-between items-center">
                                                <span class="text-gray-300 font-medium">Total Amount:</span>
                                                <span
                                                    class="text-green-400 font-bold text-xl"><?php echo e(number_format($calculation['total'], 2)); ?>

                                                    EGP</span>
                                            </div>
                                        </div>

                                        <div
                                            class="text-sm text-gray-400 bg-yellow-500/10 p-3 rounded border border-yellow-500/30">
                                            <p class="text-yellow-400 font-semibold mb-1">📋 Payment Instructions:</p>
                                            <ol class="list-decimal list-inside space-y-1 text-gray-300">
                                                <li wire:ignore data-translate="shipping.ui.open_banking_app">Open your
                                                    banking app or visit any bank</li>
                                                <li wire:ignore data-translate="shipping.ui.choose_instapay">Choose
                                                    InstaPay transfer option</li>
                                                <li>Send exactly <?php echo e(number_format($calculation['total'], 2)); ?> EGP to
                                                    account: 01095161434</li>
                                                <li wire:ignore data-translate="shipping.ui.save_transaction_id">Save
                                                    the transaction ID you receive</li>
                                                <li wire:ignore data-translate="shipping.ui.click_completed_payment">
                                                    Click "I've Completed the Payment" below</li>
                                            </ol>
                                        </div>

                                        <button type="button" @click="showTransactionForm()"
                                            class="w-full bg-orange-600 hover:bg-orange-700 text-white py-3 px-4 rounded-lg transition-colors font-semibold">
                                            ✅ I've Completed the Payment
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <!-- Transaction Fields -->
                            <div x-show="showTransactionFields"
                                class="space-y-4 bg-gradient-to-br from-green-500/10 to-blue-500/10 rounded-lg p-6 border border-green-500/30">
                                <h3 class="text-lg font-semibold text-green-400 mb-4" wire:ignore
                                    data-translate="shipping.ui.complete_transaction">Complete Your Transaction</h3>

                                <div class="form-group">
                                    <label class="form-label" wire:ignore
                                        data-translate="shipping.ui.transaction_id">Transaction ID</label>
                                    <input type="text" wire:model="transactionId" class="form-input"
                                        placeholder="Enter the transaction ID from your payment" required>
                                    <p class="text-xs text-gray-400 mt-1" wire:ignore
                                        data-translate="shipping.ui.required_verify">This is required to verify your
                                        payment</p>
                                </div>

                                <div class="form-group">
                                    <label class="form-label">Note (Optional)</label>
                                    <textarea wire:model="note" class="form-input" rows="3" placeholder="Any additional information or comments"></textarea>
                                </div>
                            </div>
                        </div>

                        <!-- Calculation Summary -->
                        <div class="calculation-display">
                            <h3 class="text-lg font-semibold text-purple-300 mb-4" wire:ignore
                                data-translate="shipping.ui.calculation_summary">Calculation Summary</h3>

                            <div class="calc-row">
                                <span class="calc-label" wire:ignore
                                    data-translate="page.shipping.recharge_form.amount">Recharge Amount</span>
                                <span class="calc-value"><?php echo e(number_format($calculation['amount'], 2)); ?>

                                    <?php echo e($calculation['currency'] ?? 'USD'); ?></span>
                            </div>
                            <div class="calc-row">
                                <span class="calc-label" wire:ignore
                                    data-translate="page.shipping.recharge_form.processing_fee">Processing Fee</span>
                                <span class="calc-value"><?php echo e(number_format($calculation['fee'], 2)); ?>

                                    <?php echo e($calculation['currency'] ?? 'USD'); ?></span>
                            </div>
                            <div class="calc-row">
                                <span class="calc-label" wire:ignore
                                    data-translate="page.shipping.recharge_form.total_amount">Total Amount</span>
                                <span class="calc-value"><?php echo e(number_format($calculation['total'], 2)); ?>

                                    <?php echo e($calculation['currency'] ?? 'USD'); ?></span>
                            </div>
                            <div class="calc-row">
                                <span class="calc-label" wire:ignore
                                    data-translate="page.shipping.recharge_form.diamonds_received">Diamonds You'll
                                    Receive</span>
                                <span class="diamonds-value">
                                    💎 <?php echo e(number_format($calculation['diamonds'])); ?>

                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Submit Button (only show when transaction fields are visible) -->
                    <div class="flex justify-center mt-6" x-show="showTransactionFields">
                        <button type="submit" class="action-button"
                            :disabled="!rechargeAmount || !userEmail || !userName || !transactionId ||
                                ((selectedPayment === 'vodafone' || selectedPayment === 'instapay') && !userPhone)">
                            <span x-show="!isLoading">Complete Recharge Request</span>
                            <span x-show="isLoading">Processing...</span>
                        </button>
                    </div>
                </form>
            </div>

            <!-- Progress & History Page -->
            <div x-show="shippingPage === 'progress-history'" class="space-y-8">
                <div class="flex items-center justify-between mb-8">
                    <h2 class="text-3xl font-bold text-purple-400" wire:ignore
                        data-translate="page.shipping.progress_rewards.title">🎁 Rewards & Transaction Center</h2>
                    <button @click="setPage('overview')"
                        class="px-6 py-3 bg-gradient-to-r from-gray-600 to-gray-700 text-white rounded-xl hover:from-gray-500 hover:to-gray-600 transition-all duration-300 shadow-lg">
                        <span wire:ignore data-translate="common.back">← Back to Overview</span>
                    </button>
                </div>

                <!-- Current Tier & Progress Section -->
                <div
                    class="bg-gradient-to-br from-purple-900/40 to-blue-900/40 rounded-2xl border border-purple-500/30 backdrop-blur-sm overflow-hidden">
                    <div class="p-8">
                        <div class="flex items-center justify-between mb-6">
                            <div class="flex items-center space-x-4">
                                <div class="text-4xl" x-text="currentUserTier?.tier_icon || '🥉'"></div>
                                <div>
                                    <h3 class="text-2xl font-bold text-white"
                                        x-text="currentUserTier?.tier_name || 'Bronze Explorer'"></h3>
                                    <p class="text-purple-300"
                                        x-text="currentUserTier?.description || 'Welcome to your journey!'"></p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="text-gray-300">Total Recharged</p>
                                <p class="text-2xl font-bold text-green-400">
                                    $<?php echo e(number_format($this->getUserTotalRecharge(), 2)); ?> USD</p>
                                <?php
                                    $currencyBreakdown = $this->getUserTotalRechargeByCurrency();
                                ?>
                                <!--[if BLOCK]><![endif]--><?php if($currencyBreakdown['usd_total'] > 0 || $currencyBreakdown['egp_total'] > 0): ?>
                                    <div class="text-xs text-gray-400 mt-1">
                                        <!--[if BLOCK]><![endif]--><?php if($currencyBreakdown['usd_total'] > 0): ?>
                                            <div>$<?php echo e(number_format($currencyBreakdown['usd_total'], 2)); ?> USD</div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        <!--[if BLOCK]><![endif]--><?php if($currencyBreakdown['egp_total'] > 0): ?>
                                            <div><?php echo e(number_format($currencyBreakdown['egp_total'], 0)); ?> EGP</div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        <div class="text-blue-300 text-xs mt-1">Rate: 1 USD = 50 EGP</div>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>

                        <!-- Progress Bar -->
                        <div class="space-y-3">
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-300">Progress to Next Tier</span>
                                <span class="text-white font-semibold"
                                    x-text="nextUserTier ? nextUserTier.tier_name : 'Max Level Reached'"></span>
                            </div>
                            <div class="w-full bg-gray-700 rounded-full h-4 overflow-hidden">
                                <div class="bg-gradient-to-r from-purple-500 to-blue-500 h-4 rounded-full transition-all duration-1000 ease-out"
                                    :style="`width: ${progressToNextTier || 0}%`">
                                </div>
                            </div>
                            <div class="flex justify-between text-xs text-gray-400">
                                <span x-text="`Current: $${currentUserTier?.minimum_amount || 0}`"></span>
                                <span
                                    x-text="nextUserTier ? `Next: $${nextUserTier.minimum_amount}` : 'Maximum Reached!'"></span>
                            </div>
                        </div>

                        <!-- Next Tier Requirements -->
                        <div x-show="nextUserTier"
                            class="mt-6 p-4 bg-gradient-to-r from-blue-500/10 to-purple-500/10 rounded-xl border border-blue-500/20">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center space-x-3">
                                    <span class="text-2xl" x-text="nextUserTier?.tier_icon"></span>
                                    <div>
                                        <p class="text-white font-semibold" wire:ignore
                                            data-translate="shipping.ui.next_level_benefits">Next Level Benefits</p>
                                        <p class="text-sm text-gray-300" x-text="nextUserTier?.description"></p>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <p class="text-sm text-gray-400" wire:ignore data-translate="shipping.ui.needed">
                                        Needed</p>
                                    <p class="text-lg font-bold text-orange-400"
                                        x-text="nextUserTier ? safeCurrencyDisplay(Math.max(0, nextUserTier.minimum_amount - parseFloat(userTotalRecharge || 0))) : '$0.00'">
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tier Rewards System -->
                <div class="space-y-6">
                    <h3 class="text-2xl font-bold text-white mb-4" wire:ignore
                        data-translate="shipping.ui.all_reward_tiers">🏆 All Reward Tiers</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <template x-for="tier in rewardTiers" :key="tier.id">
                            <div class="reward-tier-card relative overflow-hidden"
                                :class="currentUserTier?.id === tier.id ? 'current-tier' :
                                    (parseFloat(userTotalRecharge || 0) >= tier.minimum_amount) ? 'unlocked-tier' :
                                    'locked-tier'">

                                <!-- Card Background -->
                                <div class="absolute inset-0 opacity-10"
                                    :style="`background: linear-gradient(135deg, ${tier.tier_color}40, ${tier.tier_color}20)`">
                                </div>

                                <!-- Card Content -->
                                <div class="relative p-6">
                                    <!-- Tier Header -->
                                    <div class="flex items-center justify-between mb-4">
                                        <div class="flex items-center space-x-3">
                                            <span class="text-3xl" x-text="tier.tier_icon"></span>
                                            <div>
                                                <h4 class="font-bold text-white" x-text="tier.tier_name"></h4>
                                                <p class="text-sm text-gray-400" x-text="`$${tier.minimum_amount}+`">
                                                </p>
                                            </div>
                                        </div>
                                        <!-- Status Badge -->
                                        <div class="status-badge"
                                            :class="currentUserTier?.id === tier.id ? 'current' :
                                                (parseFloat(userTotalRecharge || 0) >= tier.minimum_amount) ?
                                                'unlocked' : 'locked'">
                                            <span
                                                x-text="currentUserTier?.id === tier.id ? $translate('shipping.ui.current') :
                                                         (parseFloat(userTotalRecharge || 0) >= tier.minimum_amount) ? $translate('shipping.ui.unlocked') : $translate('shipping.ui.locked')"></span>
                                        </div>
                                    </div>

                                    <!-- Tier Description -->
                                    <p class="text-gray-300 text-sm mb-4" x-text="tier.description"></p>

                                    <!-- Rewards List -->
                                    <div class="space-y-2">
                                        <p class="text-purple-300 font-semibold text-sm" wire:ignore
                                            data-translate="shipping.ui.rewards">Rewards:</p>
                                        <template x-for="reward in tier.rewards" :key="reward.name">
                                            <div class="flex items-center space-x-2 text-sm">
                                                <span class="reward-icon"
                                                    x-text="reward.type === 'diamonds' ? '💎' :
                                                             reward.type === 'vip_days' ? '👑' :
                                                             reward.type === 'bonus_percentage' ? '⚡' :
                                                             reward.type === 'item' ? '🎁' : '✨'"></span>
                                                <span class="text-gray-300" x-text="reward.name"></span>
                                                <span class="text-green-400 font-semibold"
                                                    x-text="reward.type === 'diamonds' ? `+${reward.value.toLocaleString()}` :
                                                             reward.type === 'vip_days' ? `${reward.value} days` :
                                                             reward.type === 'bonus_percentage' ? `+${reward.value}%` :
                                                             reward.type === 'item' ? `x${reward.value}` : reward.value"></span>
                                            </div>
                                        </template>
                                    </div>
                                </div>
                            </div>
                        </template>
                    </div>
                </div>

                <!-- Pending Rewards Section -->
                <div x-show="pendingRewards.length > 0" class="space-y-4">
                    <h3 class="text-2xl font-bold text-yellow-400" wire:ignore
                        data-translate="shipping.ui.pending_rewards">🎁 Pending Rewards</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                        <template x-for="reward in pendingRewards" :key="reward.id">
                            <div
                                class="bg-gradient-to-br from-yellow-900/40 to-orange-900/40 rounded-xl border border-yellow-500/30 p-6">
                                <div class="flex items-center justify-between mb-3">
                                    <span class="text-2xl"
                                        x-text="reward.reward_type === 'diamonds' ? '💎' :
                                                                   reward.reward_type === 'vip_days' ? '👑' :
                                                                   reward.reward_type === 'bonus_percentage' ? '⚡' : '🎁'"></span>
                                    <span class="text-xs text-yellow-400 bg-yellow-500/20 px-2 py-1 rounded-full"
                                        wire:ignore data-translate="shipping.ui.pending">PENDING</span>
                                </div>
                                <h4 class="font-bold text-white mb-2" x-text="reward.reward_name"></h4>
                                <p class="text-sm text-gray-300" x-text="reward.reward_description"></p>
                                <div class="mt-3 pt-3 border-t border-yellow-500/20">
                                    <p class="text-lg font-bold text-yellow-400" x-text="reward.formatted_reward"></p>
                                </div>
                            </div>
                        </template>
                    </div>
                </div>

                <!-- Transaction History -->
                <div class="space-y-6">
                    <h3 class="text-2xl font-bold text-white" wire:ignore
                        data-translate="shipping.ui.transaction_history">📊 Transaction History</h3>

                    <div
                        class="bg-gradient-to-br from-gray-900/40 to-blue-900/40 rounded-2xl border border-gray-700/50 overflow-hidden">
                        <template x-if="!userTransactionHistory || userTransactionHistory.length === 0">
                            <div class="text-center py-12 text-gray-400">
                                <div class="text-6xl mb-4">💳</div>
                                <h4 class="text-xl font-semibold text-gray-300 mb-2" wire:ignore
                                    data-translate="shipping.ui.no_transactions_yet">No transactions yet</h4>
                                <p class="text-gray-400" wire:ignore
                                    data-translate="shipping.ui.start_recharging_history">Start recharging to unlock
                                    rewards and see your history here</p>
                            </div>
                        </template>

                        <template x-if="userTransactionHistory && userTransactionHistory.length > 0">
                            <div class="overflow-x-auto">
                                <table class="w-full">
                                    <thead class="bg-gray-800/50">
                                        <tr>
                                            <th class="px-6 py-4 text-left text-xs font-medium text-gray-400 uppercase tracking-wider"
                                                wire:ignore data-translate="shipping.ui.date">Date</th>
                                            <th class="px-6 py-4 text-left text-xs font-medium text-gray-400 uppercase tracking-wider"
                                                wire:ignore data-translate="shipping.ui.method">Method</th>
                                            <th class="px-6 py-4 text-left text-xs font-medium text-gray-400 uppercase tracking-wider"
                                                wire:ignore data-translate="shipping.ui.amount">Amount</th>
                                            <th class="px-6 py-4 text-left text-xs font-medium text-gray-400 uppercase tracking-wider"
                                                wire:ignore data-translate="shipping.ui.status">Status</th>
                                            <th class="px-6 py-4 text-left text-xs font-medium text-gray-400 uppercase tracking-wider"
                                                wire:ignore data-translate="shipping.ui.diamonds">Diamonds</th>
                                            <th class="px-6 py-4 text-left text-xs font-medium text-gray-400 uppercase tracking-wider"
                                                wire:ignore data-translate="shipping.ui.rewards">Rewards</th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-gray-700/50">
                                        <template x-for="transaction in userTransactionHistory"
                                            :key="transaction.id">
                                            <tr class="hover:bg-gray-800/30 transition-colors">
                                                <td class="px-6 py-4 whitespace-nowrap">
                                                    <div class="text-sm text-white font-medium"
                                                        x-text="new Date(transaction.created_at).toLocaleDateString()">
                                                    </div>
                                                    <div class="text-xs text-gray-400"
                                                        x-text="new Date(transaction.created_at).toLocaleTimeString()">
                                                    </div>
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap">
                                                    <div class="flex items-center space-x-2">
                                                        <span class="payment-icon"
                                                            x-text="transaction.payment_method === 'paypal' ? '💳' :
                                                                     transaction.payment_method === 'vodafone' ? '📱' :
                                                                     transaction.payment_method === 'instapay' ? '🏦' : '💰'"></span>
                                                        <span class="text-sm text-white capitalize"
                                                            x-text="transaction.payment_method"></span>
                                                    </div>
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap">
                                                    <div class="text-sm font-medium text-white">
                                                        <span
                                                            x-text="transaction.currency === 'USD' ?
                                                            `$${parseFloat(transaction.amount).toFixed(2)}` :
                                                            `${parseFloat(transaction.amount).toFixed(0)} EGP`"></span>
                                                    </div>
                                                    <div class="text-xs text-gray-400">
                                                        <span
                                                            x-text="transaction.currency === 'EGP' ?
                                                            `≈ $${(parseFloat(transaction.amount) / 50).toFixed(2)} USD` :
                                                            ''"></span>
                                                    </div>
                                                    <div class="text-xs text-gray-400"
                                                        x-text="`+${transaction.currency === 'USD' ? '$' : ''}${parseFloat(transaction.fee).toFixed(2)}${transaction.currency === 'EGP' ? ' EGP' : ''} ` + $translate('shipping.ui.fee_suffix')">
                                                    </div>
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap">
                                                    <span
                                                        class="inline-flex px-2 py-1 text-xs font-semibold rounded-full"
                                                        :class="transaction.status === 'completed' ?
                                                            'bg-green-100 text-green-800' :
                                                            transaction.status === 'pending' ?
                                                            'bg-yellow-100 text-yellow-800' :
                                                            'bg-red-100 text-red-800'"
                                                        x-text="transaction.status.toUpperCase()"></span>
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap">
                                                    <div class="flex items-center space-x-1">
                                                        <span class="text-lg">💎</span>
                                                        <span class="text-sm font-medium text-blue-400"
                                                            x-text="parseInt(transaction.diamonds_purchased).toLocaleString()"></span>
                                                    </div>
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap">
                                                    <template
                                                        x-if="transaction.rewards && transaction.rewards.length > 0">
                                                        <div class="flex flex-wrap gap-1">
                                                            <template x-for="reward in transaction.rewards"
                                                                :key="reward.id">
                                                                <span
                                                                    class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800"
                                                                    x-text="reward.reward_name"></span>
                                                            </template>
                                                        </div>
                                                    </template>
                                                    <template
                                                        x-if="!transaction.rewards || transaction.rewards.length === 0">
                                                        <span class="text-xs text-gray-500" wire:ignore
                                                            data-translate="shipping.ui.no_rewards">No rewards</span>
                                                    </template>
                                                </td>
                                            </tr>
                                        </template>
                                    </tbody>
                                </table>
                            </div>
                        </template>
                    </div>
                </div>
            </div>

        </div>

        <!-- Final Message -->
        <div class="final-message">
            <p class="final-text" wire:ignore data-translate="page.shipping.final_message">✨ We make all of this for
                you - Your satisfaction is our ultimate goal! ✨</p>
        </div>

    </div>

    <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
        <div class="fixed top-4 right-4 bg-green-600 text-white px-6 py-3 rounded-lg shadow-lg z-50"
            x-data="{ show: true }" x-show="show" x-transition:enter="transition ease-out duration-300"
            x-transition:enter-start="opacity-0 transform translate-x-full"
            x-transition:enter-end="opacity-100 transform translate-x-0"
            x-transition:leave="transition ease-in duration-300"
            x-transition:leave-start="opacity-100 transform translate-x-0"
            x-transition:leave-end="opacity-0 transform translate-x-full" x-init="setTimeout(() => show = false, 5000)">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!-- JavaScript for handling redirects and mobile detection -->
    <script>
        document.addEventListener('livewire:initialized', () => {
            // Listen for redirect events
            Livewire.on('redirect-to-url', (event) => {
                window.location.href = event.url;
            });
        });
    </script>

</div><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/backend/pages/shipping.blade.php ENDPATH**/ ?>