<?php

use Livewire\Volt\Component;
use Livewire\WithPagination;
use App\Models\Z_Website\Market\MarketTransaction;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

?>

<div>
    <div class="space-y-8" x-data="{
        showDetailsModal: false,
        chartData: <?php echo \Illuminate\Support\Js::from($this->chartData)->toHtml() ?>
    }" <?php echo $__env->yieldSection(); ?>-transaction-modal.window="showDetailsModal = true">

        <!-- Page Header -->
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between mb-8">
            <div>
                <h1 class="text-4xl font-bold text-white mb-3 dashboard-gaming-text">
                    <i class="fas fa-history mr-3 text-purple-400"></i>
                    <span wire:ignore  data-translate="marketLogs.title">My Transaction History</span>
                </h1>
                <p class="text-xl text-purple-300" wire:ignore  data-translate="marketLogs.subtitle">
                    View your market purchase history and transaction details
                </p>
            </div>
            <div class="flex flex-col sm:flex-row gap-3 mt-4 lg:mt-0">
                <button wire:click="loadStats" class="btn-secondary">
                    <i class="fas fa-sync mr-2"></i>
                    <span wire:ignore  data-translate="marketLogs.refreshStats">Refresh Stats</span>
                </button>
                <button wire:click="exportTransactions" class="btn-primary">
                    <i class="fas fa-download mr-2"></i>
                    <span wire:ignore  data-translate="marketLogs.exportData">Export Data</span>
                </button>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-5 gap-4 mb-8">
            <!-- Total Transactions -->
            <div class="bg-gradient-to-br from-blue-900/50 to-blue-800/30 rounded-xl p-4 border border-blue-500/30">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-blue-300 text-sm" wire:ignore  data-translate="marketLogs.stats.myTransactions">My Transactions</p>
                        <p class="text-white text-2xl font-bold"><?php echo e(number_format($stats['total_transactions'])); ?></p>
                    </div>
                    <i class="fas fa-exchange-alt text-blue-400 text-2xl"></i>
                </div>
            </div>

            <!-- Successful -->
            <div class="bg-gradient-to-br from-green-900/50 to-green-800/30 rounded-xl p-4 border border-green-500/30">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-green-300 text-sm" wire:ignore  data-translate="marketLogs.stats.successful">Successful</p>
                        <p class="text-white text-2xl font-bold"><?php echo e(number_format($stats['successful_transactions'])); ?></p>
                    </div>
                    <i class="fas fa-check-circle text-green-400 text-2xl"></i>
                </div>
            </div>

            <!-- Failed -->
            <div class="bg-gradient-to-br from-red-900/50 to-red-800/30 rounded-xl p-4 border border-red-500/30">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-red-300 text-sm" wire:ignore  data-translate="marketLogs.stats.failed">Failed</p>
                        <p class="text-white text-2xl font-bold"><?php echo e(number_format($stats['failed_transactions'])); ?></p>
                    </div>
                    <i class="fas fa-times-circle text-red-400 text-2xl"></i>
                </div>
            </div>

            <!-- Today -->
            <div class="bg-gradient-to-br from-purple-900/50 to-purple-800/30 rounded-xl p-4 border border-purple-500/30">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-purple-300 text-sm" wire:ignore  data-translate="marketLogs.stats.today">Today</p>
                        <p class="text-white text-2xl font-bold"><?php echo e(number_format($stats['today_transactions'])); ?></p>
                    </div>
                    <i class="fas fa-calendar-day text-purple-400 text-2xl"></i>
                </div>
            </div>

            <!-- Total Spent -->
            <div class="bg-gradient-to-br from-yellow-900/50 to-yellow-800/30 rounded-xl p-4 border border-yellow-500/30">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-yellow-300 text-sm" wire:ignore  data-translate="marketLogs.stats.totalSpent">Total Spent</p>
                        <p class="text-white text-xl font-bold"><?php echo e(number_format($stats['total_spent'], 0)); ?></p>
                    </div>
                    <i class="fas fa-coins text-yellow-400 text-2xl"></i>
                </div>
            </div>
        </div>

        <!-- Chart Section -->
        <div class="bg-gradient-to-br from-gray-900 to-gray-800 rounded-2xl p-6 border border-purple-500/30 mb-8">
            <h3 class="text-xl font-bold text-white mb-4">
                <i class="fas fa-chart-area mr-2 text-cyan-400"></i>
                <span wire:ignore  data-translate="marketLogs.chart.title">My Last 7 Days Activity</span>
            </h3>
            <div class="h-64 flex items-end justify-between space-x-2">
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $chartData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex-1 flex flex-col items-center">
                        <div class="w-full bg-gradient-to-t from-cyan-600 to-cyan-400 rounded-t-lg relative group cursor-pointer"
                             style="height: <?php echo e($day['transactions'] > 0 ? max(20, ($day['transactions'] / max(array_column($chartData, 'transactions'))) * 200) : 4); ?>px;"
                             title="Transactions: <?php echo e($day['transactions']); ?>, Spent: <?php echo e(number_format($day['spent'])); ?>">
                            <div class="absolute -top-8 left-1/2 transform -translate-x-1/2 bg-gray-800 text-white text-xs px-2 py-1 rounded opacity-0 group-hover:opacity-100 transition-opacity whitespace-nowrap">
                                <?php echo e($day['transactions']); ?> <span wire:ignore  data-translate="marketLogs.chart.transactions">txns</span><br>
                                <?php echo e(number_format($day['spent'])); ?> <span wire:ignore  data-translate="marketLogs.chart.spent">spent</span>
                            </div>
                        </div>
                        <p class="text-gray-400 text-xs mt-2 text-center"><?php echo e($day['date']); ?></p>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>

        <!-- Filters Section -->
        <div class="bg-gradient-to-br from-gray-900 to-gray-800 rounded-2xl p-6 border border-purple-500/30 mb-8">
            <h3 class="text-lg font-bold text-white mb-4">
                <i class="fas fa-filter mr-2 text-purple-400"></i>
                <span wire:ignore  data-translate="marketLogs.filters.title">Filters</span>
            </h3>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-4">
                <!-- Search -->
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2" wire:ignore  data-translate="marketLogs.filters.search">Search</label>
                    <input type="text" wire:model.live="search"
                           class="w-full bg-gray-800 border border-gray-600 rounded-lg px-3 py-2 text-white focus:border-purple-500 focus:ring-1 focus:ring-purple-500"
                           placeholder="Transaction ID, item..." wire:ignore  data-translate-placeholder="marketLogs.filters.searchPlaceholder">
                </div>

                <!-- Transaction Type -->
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2" wire:ignore  data-translate="marketLogs.filters.transactionType">Transaction Type</label>
                    <select wire:model.live="transactionType"
                            class="w-full bg-gray-800 border border-gray-600 rounded-lg px-3 py-2 text-white focus:border-purple-500 focus:ring-1 focus:ring-purple-500">
                        <option value="all" wire:ignore  data-translate="marketLogs.filters.allTypes">All Types</option>
                        <option value="package" wire:ignore  data-translate="marketLogs.filters.packages">Packages</option>
                        <option value="item" wire:ignore  data-translate="marketLogs.filters.items">Items</option>
                    </select>
                </div>

                <!-- Currency Type -->
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2" wire:ignore  data-translate="marketLogs.filters.currency">Currency</label>
                    <select wire:model.live="currencyType"
                            class="w-full bg-gray-800 border border-gray-600 rounded-lg px-3 py-2 text-white focus:border-purple-500 focus:ring-1 focus:ring-purple-500">
                        <option value="all" wire:ignore  data-translate="marketLogs.filters.allCurrencies">All Currencies</option>
                        <option value="balance" wire:ignore  data-translate="marketLogs.filters.balance">💎 Balance</option>
                        <option value="gift_balance" wire:ignore  data-translate="marketLogs.filters.giftBalance">⭐ Gift Balance</option>
                        <option value="silk" wire:ignore  data-translate="marketLogs.filters.silk">✨ Silk</option>
                        <option value="donate" wire:ignore  data-translate="marketLogs.filters.donate">💖 Donate</option>
                    </select>
                </div>

                <!-- Status -->
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2" wire:ignore  data-translate="marketLogs.filters.status">Status</label>
                    <select wire:model.live="status"
                            class="w-full bg-gray-800 border border-gray-600 rounded-lg px-3 py-2 text-white focus:border-purple-500 focus:ring-1 focus:ring-purple-500">
                        <option value="all" wire:ignore  data-translate="marketLogs.filters.allStatus">All Status</option>
                        <option value="success" wire:ignore  data-translate="marketLogs.filters.success">✅ Success</option>
                        <option value="failed" wire:ignore  data-translate="marketLogs.filters.failed">❌ Failed</option>
                        <option value="pending" wire:ignore  data-translate="marketLogs.filters.pending">⏳ Pending</option>
                    </select>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <!-- Date Filter -->
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Date Range</label>
                    <select wire:model.live="dateFilter"
                            class="w-full bg-gray-800 border border-gray-600 rounded-lg px-3 py-2 text-white focus:border-purple-500 focus:ring-1 focus:ring-purple-500">
                        <option value="all">All Time</option>
                        <option value="today">Today</option>
                        <option value="week">This Week</option>
                        <option value="month">This Month</option>
                        <option value="custom">Custom Range</option>
                    </select>
                </div>

                <!--[if BLOCK]><![endif]--><?php if($dateFilter === 'custom'): ?>
                    <!-- From Date -->
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">From Date</label>
                        <input type="date" wire:model.live="customDateFrom"
                               class="w-full bg-gray-800 border border-gray-600 rounded-lg px-3 py-2 text-white focus:border-purple-500 focus:ring-1 focus:ring-purple-500">
                    </div>

                    <!-- To Date -->
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">To Date</label>
                        <input type="date" wire:model.live="customDateTo"
                               class="w-full bg-gray-800 border border-gray-600 rounded-lg px-3 py-2 text-white focus:border-purple-500 focus:ring-1 focus:ring-purple-500">
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                <!-- Reset Button -->
                <div class="flex items-end">
                    <button wire:click="resetFilters"
                            class="w-full bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded-lg transition-colors">
                        <i class="fas fa-undo mr-2"></i>
                        Reset Filters
                    </button>
                </div>
            </div>
        </div>

        <!-- Transactions Table -->
        <div class="bg-gradient-to-br from-gray-900 to-gray-800 rounded-2xl border border-purple-500/30 overflow-hidden">
            <div class="p-6 border-b border-gray-700">
                <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
                    <h3 class="text-lg font-bold text-white">
                        <i class="fas fa-list mr-2 text-cyan-400"></i>
                        <span wire:ignore  data-translate="marketLogs.table.title">My Transaction History</span>
                    </h3>
                    <div class="flex items-center space-x-4 mt-4 sm:mt-0">
                        <span class="text-gray-400 text-sm">
                            <span wire:ignore  data-translate="marketLogs.table.showing">Showing</span> <?php echo e($this->transactions->count()); ?> <span wire:ignore  data-translate="marketLogs.table.of">of</span> <?php echo e($this->transactions->total()); ?> <span wire:ignore  data-translate="marketLogs.table.transactions">transactions</span>
                        </span>
                        <select wire:model.live="perPage"
                                class="bg-gray-800 border border-gray-600 rounded px-3 py-1 text-white text-sm">
                            <option value="10">10 <span wire:ignore  data-translate="marketLogs.table.perPage">per page</span></option>
                            <option value="25">25 <span wire:ignore  data-translate="marketLogs.table.perPage">per page</span></option>
                            <option value="50">50 <span wire:ignore  data-translate="marketLogs.table.perPage">per page</span></option>
                            <option value="100">100 <span wire:ignore  data-translate="marketLogs.table.perPage">per page</span></option>
                        </select>
                    </div>
                </div>
            </div>

            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-800">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider" wire:ignore  data-translate="marketLogs.table.transaction">Transaction</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider" wire:ignore  data-translate="marketLogs.table.itemPackage">Item/Package</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider" wire:ignore  data-translate="marketLogs.table.amount">Amount</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider" wire:ignore  data-translate="marketLogs.table.status">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider" wire:ignore  data-translate="marketLogs.table.date">Date</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider" wire:ignore  data-translate="marketLogs.table.actions">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-700">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $this->transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray-800/50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex flex-col">
                                        <div class="text-sm font-bold text-white"><?php echo e($transaction->transaction_id); ?></div>
                                        <div class="text-xs text-purple-300">
                                            <i class="fas <?php echo e($transaction->transaction_type === 'package' ? 'fa-box' : 'fa-gem'); ?> mr-1"></i>
                                            <?php echo e(ucfirst($transaction->transaction_type)); ?>

                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="flex flex-col">
                                        <div class="text-sm font-medium text-white truncate max-w-32"><?php echo e($transaction->item_name); ?></div>
                                        <div class="text-xs text-cyan-300"><span wire:ignore  data-translate="marketLogs.table.qty">Qty</span>: <?php echo e($transaction->quantity); ?></div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex flex-col">
                                        <div class="text-sm font-bold text-yellow-400">
                                            <?php echo e($transaction->currency_symbol); ?> <?php echo e(number_format($transaction->total_price)); ?>

                                        </div>
                                        <div class="text-xs text-gray-400">
                                            <?php echo e(number_format($transaction->unit_price)); ?> <span wire:ignore  data-translate="marketLogs.table.each">each</span>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full <?php echo e($transaction->status_badge); ?> text-white">
                                        <?php echo e(ucfirst($transaction->status)); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-300"><?php echo e($transaction->created_at->format('M d, Y')); ?></div>
                                    <div class="text-xs text-gray-500"><?php echo e($transaction->created_at->format('H:i:s')); ?></div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <button wire:click="viewTransactionDetails(<?php echo e($transaction->id); ?>)"
                                            class="text-cyan-400 hover:text-cyan-300 transition-colors"
                                            >
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="px-6 py-8 text-center text-gray-400">
                                    <i class="fas fa-inbox text-4xl mb-4"></i>
                                    <p class="text-lg" wire:ignore  data-translate="marketLogs.table.noTransactions">No transactions found</p>
                                    <p class="text-sm" wire:ignore  data-translate="marketLogs.table.noTransactionsDesc">You haven't made any purchases yet</p>
                                </td>
                            </tr>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <!--[if BLOCK]><![endif]--><?php if($this->transactions->hasPages()): ?>
                <div class="px-6 py-4 border-t border-gray-700">
                    <?php echo e($this->transactions->links()); ?>

                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>

        <!-- Transaction Details Modal -->
        <div x-show="showDetailsModal"
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition ease-in duration-200"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0"
             class="fixed inset-0 bg-black/80 backdrop-blur-sm z-50 flex items-center justify-center p-4"
             @click.self="showDetailsModal = false">

            <div class="bg-gradient-to-br from-gray-900 to-gray-800 rounded-2xl max-w-2xl w-full max-h-[80vh] overflow-hidden border border-purple-500/30"
                 x-transition:enter="transition ease-out duration-300 transform"
                 x-transition:enter-start="scale-95 opacity-0"
                 x-transition:enter-end="scale-100 opacity-100"
                 x-transition:leave="transition ease-in duration-200 transform"
                 x-transition:leave-start="scale-100 opacity-100"
                 x-transition:leave-end="scale-95 opacity-0">

                <div class="p-6 border-b border-gray-700">
                    <div class="flex items-center justify-between">
                        <h3 class="text-xl font-bold text-white">
                            <i class="fas fa-receipt mr-2 text-cyan-400"></i>
                            <span  wire:ignore  data-translate="marketLogs.modal.title">Transaction Details</span>
                        </h3>
                        <button @click="showDetailsModal = false"
                                class="text-gray-400 hover:text-white transition-colors"
                                >
                            <i class="fas fa-times text-xl"></i>
                        </button>
                    </div>
                </div>

                <!--[if BLOCK]><![endif]--><?php if($selectedTransaction): ?>
                <div class="p-6 overflow-y-auto max-h-[60vh]">
                    <div class="space-y-4">
                        <!-- Basic Info -->
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-400 mb-1" wire:ignore  data-translate="marketLogs.modal.transactionId">Transaction ID</label>
                                <p class="text-white font-mono"><?php echo e($selectedTransaction->transaction_id); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-400 mb-1" wire:ignore  data-translate="marketLogs.modal.status">Status</label>
                                <span class="px-2 py-1 text-xs font-semibold rounded-full <?php echo e($selectedTransaction->status_badge); ?>">
                                    <?php echo e(ucfirst($selectedTransaction->status)); ?>

                                </span>
                            </div>
                        </div>

                        <!-- Transaction Info -->
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-400 mb-1" wire:ignore  data-translate="marketLogs.modal.type">Type</label>
                                <p class="text-white capitalize"><?php echo e($selectedTransaction->transaction_type); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-400 mb-1" wire:ignore  data-translate="marketLogs.modal.currency">Currency</label>
                                <p class="text-white capitalize"><?php echo e(str_replace('_', ' ', $selectedTransaction->currency_type)); ?></p>
                            </div>
                        </div>

                        <!-- Item Info -->
                        <div>
                            <label class="block text-sm font-medium text-gray-400 mb-1" wire:ignore  data-translate="marketLogs.modal.itemPackageName">Item/Package Name</label>
                            <p class="text-white"><?php echo e($selectedTransaction->item_name); ?></p>
                        </div>

                        <!-- Price Info -->
                        <div class="grid grid-cols-3 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-400 mb-1" wire:ignore  data-translate="marketLogs.modal.quantity">Quantity</label>
                                <p class="text-white"><?php echo e($selectedTransaction->quantity); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-400 mb-1" wire:ignore  data-translate="marketLogs.modal.unitPrice">Unit Price</label>
                                <p class="text-yellow-400"><?php echo e(number_format($selectedTransaction->unit_price)); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-400 mb-1" wire:ignore  data-translate="marketLogs.modal.totalPrice">Total Price</label>
                                <p class="text-yellow-400 font-bold"><?php echo e(number_format($selectedTransaction->total_price)); ?></p>
                            </div>
                        </div>

                        <!-- Balance Info -->
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-400 mb-1" wire:ignore  data-translate="marketLogs.modal.balanceBefore">Balance Before</label>
                                <p class="text-cyan-400"><?php echo e(number_format($selectedTransaction->balance_before)); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-400 mb-1" wire:ignore  data-translate="marketLogs.modal.balanceAfter">Balance After</label>
                                <p class="text-cyan-400"><?php echo e(number_format($selectedTransaction->balance_after)); ?></p>
                            </div>
                        </div>

                        <!-- Technical Info -->
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-400 mb-1" wire:ignore  data-translate="marketLogs.modal.ipAddress">IP Address</label>
                                <p class="text-white font-mono text-sm"><?php echo e($selectedTransaction->ip_address ?? 'N/A'); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-400 mb-1" wire:ignore  data-translate="marketLogs.modal.date">Date</label>
                                <p class="text-white text-sm"><?php echo e($selectedTransaction->created_at->format('M d, Y H:i:s')); ?></p>
                            </div>
                        </div>

                        <!-- Error Message (if any) -->
                        <!--[if BLOCK]><![endif]--><?php if($selectedTransaction->error_message): ?>
                            <div>
                                <label class="block text-sm font-medium text-gray-400 mb-1" wire:ignore  data-translate="marketLogs.modal.errorMessage">Error Message</label>
                                <p class="text-red-400 bg-red-900/20 p-3 rounded-lg text-sm"><?php echo e($selectedTransaction->error_message); ?></p>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>
    </div>
</div><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/backend/pages/market-logs.blade.php ENDPATH**/ ?>