<?php

use Livewire\Volt\Component;
use Illuminate\Support\Facades\Auth;

?>

<div>
    <!--[if BLOCK]><![endif]--><?php if($type === 'desktop'): ?>
        <div class="notification-icons-desktop">
            <!-- Notifications -->
            <div class="notification-icon-container-desktop">
                <button class="notification-btn-desktop notifications" id="notificationsBtn">
                    <svg class="notification-icon-desktop-svg" width="16" height="16" viewBox="0 0 24 24"
                        fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M12 2C10.896 2 10 2.896 10 4V5.586L7.707 8.293C7.512 8.488 7.256 8.584 7 8.584V10H17V8.584C16.744 8.584 16.488 8.488 16.293 8.293L14 5.586V4C14 2.896 13.104 2 12 2Z"
                            fill="currentColor" />
                        <path
                            d="M18 11V12C18 15.314 15.314 18 12 18C8.686 18 6 15.314 6 12V11H4V12C4 16.418 7.582 20 12 20C16.418 20 20 16.418 20 12V11H18Z"
                            fill="currentColor" />
                        <circle cx="17" cy="4" r="3" fill="#ff4757" />
                    </svg>
                    <span class="notification-badge-desktop" id="notificationsBadge"
                        style="display: <?php echo e($unreadCount > 0 ? 'block' : 'none'); ?>;"><?php echo e($unreadCount > 99 ? '99+' : $unreadCount); ?></span>
                </button>
                <div class="notification-dropdown-desktop notifications" id="notificationsDropdown">
                    <div class="notification-header-desktop">
                        <h4 data-translate="notifications.title">Notifications</h4>
                    </div>
                    <div class="notification-list-desktop" id="notificationsList" >
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div  class="notification-item-desktop <?php echo e($notification->isRead ? 'read' : 'unread'); ?>"
                                wire:click="markAsRead(<?php echo e($notification->id); ?>)" style="cursor: pointer;">
                                <div class="notification-icon-desktop">
                                    <i
                                        class="fas fa-bell <?php echo e($notification->isRead ? 'text-muted' : 'text-warning'); ?>"></i>
                                </div>
                                <div class="notification-content-desktop">
                                    <p class="notification-text-desktop">
                                        <strong><?php echo e($notification->translatedHead); ?></strong><br>
                                        <?php echo $notification->translatedMessage; ?>

                                        <!--[if BLOCK]><![endif]--><?php if($notification->link): ?>
                                            <br><small><a href="<?php echo e($notification->link); ?>" class="text-primary">View
                                                    More</a></small>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </p>
                                    <span class="notification-time-desktop">
                                        <?php echo e($notification->created_at->diffForHumans()); ?>

                                        <!--[if BLOCK]><![endif]--><?php if($notification->expires_at): ?>
                                            (Expires: <?php echo e($notification->expires_at->diffForHumans()); ?>)
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </span>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php if(!$notification->isRead): ?>
                                    <div class="notification-unread-indicator"></div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="notification-item-desktop">
                                <div class="notification-content-desktop">
                                    <p class="notification-text-desktop text-center text-muted">
                                        No new notifications
                                    </p>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>

            <!-- Admin Messages -->
            <div class="notification-icon-container-desktop">
                <button class="notification-btn-desktop admin-messages" id="adminMessagesBtn">
                    <svg class="notification-icon-desktop-svg" width="16" height="16" viewBox="0 0 24 24"
                        fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M20 4H4C2.896 4 2 4.896 2 6V18C2 19.104 2.896 20 4 20H20C21.104 20 22 19.104 22 18V6C22 4.896 21.104 4 20 4Z"
                            fill="currentColor" />
                        <path d="M22 6L12 13L2 6" stroke="currentColor" stroke-width="1.5" fill="none" />
                        <circle cx="19" cy="5" r="2.5" fill="#007bff" />
                        <path d="M19 3.5L20.5 5L19 6.5L17.5 5L19 3.5Z" fill="white" />
                    </svg>
                    <span class="notification-badge-desktop" id="adminMessagesBadge" style="display: <?php echo e($adminMessagesUnreadCount > 0 ? 'block' : 'none'); ?>;"><?php echo e($adminMessagesUnreadCount > 99 ? '99+' : $adminMessagesUnreadCount); ?></span>
                </button>
                <div class="notification-dropdown-desktop admin-messages" id="adminMessagesDropdown">
                    <div class="notification-header-desktop">
                        <h4 data-translate="adminMessages.title">Admin Messages</h4>
                    </div>
                    <div class="notification-list-desktop" id="adminMessagesList">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $adminMessages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div  class="notification-item-desktop <?php echo e($notification->isRead ? 'read' : 'unread'); ?>"
                                wire:click="markAsRead(<?php echo e($notification->id); ?>)" style="cursor: pointer;">
                                <div class="notification-icon-desktop">
                                    <i class="fas fa-shield-alt <?php echo e($notification->isRead ? 'text-muted' : 'text-info'); ?>"></i>
                                </div>
                                <div class="notification-content-desktop">
                                    <p class="notification-text-desktop">
                                        <strong><?php echo e($notification->translatedHead); ?></strong><br>
                                        <?php echo $notification->translatedMessage; ?>

                                        <!--[if BLOCK]><![endif]--><?php if($notification->link): ?>
                                            <br><small><a href="<?php echo e($notification->link); ?>" class="text-primary">View
                                                    More</a></small>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </p>
                                    <span class="notification-time-desktop">
                                        <?php echo e($notification->created_at->diffForHumans()); ?>

                                        <!--[if BLOCK]><![endif]--><?php if($notification->expires_at): ?>
                                            (Expires: <?php echo e($notification->expires_at->diffForHumans()); ?>)
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </span>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php if(!$notification->isRead): ?>
                                    <div class="notification-unread-indicator"></div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="notification-item-desktop">
                                <div class="notification-content-desktop">
                                    <p class="notification-text-desktop text-center text-muted">
                                        No admin messages
                                    </p>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>

            <!-- Charges/Purchases -->
            <div class="notification-icon-container-desktop">
                <button class="notification-btn-desktop charges" id="chargesBtn">
                    <svg class="notification-icon-desktop-svg" width="16" height="16" viewBox="0 0 24 24"
                        fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M7 4V2C7 1.448 7.448 1 8 1H16C16.552 1 17 1.448 17 2V4H20C20.552 4 21 4.448 21 5S20.552 6 20 6H19V19C19 20.104 18.104 21 17 21H7C5.896 21 5 20.104 5 19V6H4C3.448 6 3 5.552 3 5S3.448 4 4 4H7Z"
                            fill="currentColor" />
                        <path d="M9 9H11V17H9V9Z" fill="currentColor" />
                        <path d="M13 9H15V17H13V9Z" fill="currentColor" />
                        <circle cx="19" cy="4" r="2.5" fill="#2ed573" />
                        <path d="M17.5 2.5L18.5 3.5L20.5 1.5" stroke="white" stroke-width="1.5" fill="none" />
                    </svg>
                    <span class="notification-badge-desktop" id="chargesBadge" style="display: <?php echo e($chargesUnreadCount > 0 ? 'block' : 'none'); ?>;"><?php echo e($chargesUnreadCount > 99 ? '99+' : $chargesUnreadCount); ?></span>
                </button>
                <div class="notification-dropdown-desktop charges" id="chargesDropdown">
                    <div class="notification-header-desktop">
                        <h4 data-translate="charges.title">Recent Purchases</h4>
                    </div>
                    <div class="notification-list-desktop" id="chargesList">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div  class="notification-item-desktop <?php echo e($notification->isRead ? 'read' : 'unread'); ?>"
                                wire:click="markAsRead(<?php echo e($notification->id); ?>)" style="cursor: pointer;">
                                <div class="notification-icon-desktop">
                                    <i class="fas fa-credit-card <?php echo e($notification->isRead ? 'text-muted' : 'text-success'); ?>"></i>
                                </div>
                                <div class="notification-content-desktop">
                                    <p class="notification-text-desktop">
                                        <strong><?php echo e($notification->translatedHead); ?></strong><br>
                                        <?php echo $notification->translatedMessage; ?>

                                        <!--[if BLOCK]><![endif]--><?php if($notification->link): ?>
                                            <br><small><a href="<?php echo e($notification->link); ?>" class="text-primary">View
                                                    More</a></small>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </p>
                                    <span class="notification-time-desktop">
                                        <?php echo e($notification->created_at->diffForHumans()); ?>

                                        <!--[if BLOCK]><![endif]--><?php if($notification->expires_at): ?>
                                            (Expires: <?php echo e($notification->expires_at->diffForHumans()); ?>)
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </span>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php if(!$notification->isRead): ?>
                                    <div class="notification-unread-indicator"></div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="notification-item-desktop">
                                <div class="notification-content-desktop">
                                    <p class="notification-text-desktop text-center text-muted">
                                        No recent purchases
                                    </p>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!--[if BLOCK]><![endif]--><?php if($type === 'tablet'): ?>
        <div class="notification-icons-tablet">
            <!-- Notifications -->
            <div class="notification-icon-container-tablet">
                <button class="notification-btn-tablet notifications" id="tabletNotificationsBtn">
                    <svg class="notification-icon-tablet-svg" width="16" height="16" viewBox="0 0 24 24"
                        fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M12 2C10.896 2 10 2.896 10 4V5.586L7.707 8.293C7.512 8.488 7.256 8.584 7 8.584V10H17V8.584C16.744 8.584 16.488 8.488 16.293 8.293L14 5.586V4C14 2.896 13.104 2 12 2Z"
                            fill="currentColor" />
                        <path
                            d="M18 11V12C18 15.314 15.314 18 12 18C8.686 18 6 15.314 6 12V11H4V12C4 16.418 7.582 20 12 20C16.418 20 20 16.418 20 12V11H18Z"
                            fill="currentColor" />
                        <circle cx="17" cy="4" r="3" fill="#ff4757" />
                    </svg>
                    <span class="notification-badge-tablet" id="tabletNotificationsBadge"
                        style="display: <?php echo e($unreadCount > 0 ? 'block' : 'none'); ?>;"><?php echo e($unreadCount > 99 ? '99+' : $unreadCount); ?></span>
                </button>
                <div class="notification-dropdown-tablet notifications" id="tabletNotificationsDropdown">
                    <div class="notification-header-tablet">
                        <h4 data-translate="notifications.title">Notifications</h4>
                    </div>
                    <div class="notification-list-tablet" id="tabletNotificationsList">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="notification-item-tablet <?php echo e($notification->isRead ? 'read' : 'unread'); ?>"
                                wire:click="markAsRead(<?php echo e($notification->id); ?>)" style="cursor: pointer;">
                                <div class="notification-icon-tablet">
                                    <i
                                        class="fas fa-bell <?php echo e($notification->isRead ? 'text-muted' : ($notification->type === 'admin_message' ? 'text-info' : ($notification->type === 'charge' ? 'text-success' : 'text-warning'))); ?>"></i>
                                </div>
                                <div class="notification-content-tablet">
                                    <p class="notification-text-tablet">
                                        <strong><?php echo e($notification->translatedHead); ?></strong><br>
                                        <?php echo $notification->translatedMessage; ?>

                                        <!--[if BLOCK]><![endif]--><?php if($notification->link): ?>
                                            <br><small><a href="<?php echo e($notification->link); ?>" class="text-primary">View
                                                    More</a></small>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </p>
                                    <span class="notification-time-tablet">
                                        <?php echo e($notification->created_at->diffForHumans()); ?>

                                        <!--[if BLOCK]><![endif]--><?php if($notification->expires_at): ?>
                                            (Expires: <?php echo e($notification->expires_at->diffForHumans()); ?>)
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </span>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php if(!$notification->isRead): ?>
                                    <div class="notification-unread-indicator"></div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="notification-item-tablet">
                                <div class="notification-content-tablet">
                                    <p class="notification-text-tablet text-center text-muted">
                                        No new notifications
                                    </p>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>

            <!-- Admin Messages -->
            <div class="notification-icon-container-tablet">
                <button class="notification-btn-tablet admin-messages" id="tabletAdminMessagesBtn">
                    <svg class="notification-icon-tablet-svg" width="16" height="16" viewBox="0 0 24 24"
                        fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M20 4H4C2.896 4 2 4.896 2 6V18C2 19.104 2.896 20 4 20H20C21.104 20 22 19.104 22 18V6C22 4.896 21.104 4 20 4Z"
                            fill="currentColor" />
                        <path d="M22 6L12 13L2 6" stroke="currentColor" stroke-width="1.5" fill="none" />
                        <circle cx="19" cy="5" r="2.5" fill="#007bff" />
                        <path d="M19 3.5L20.5 5L19 6.5L17.5 5L19 3.5Z" fill="white" />
                    </svg>
                    <span class="notification-badge-tablet" id="tabletAdminMessagesBadge"
                        style="display: <?php echo e($adminMessagesUnreadCount > 0 ? 'block' : 'none'); ?>;"><?php echo e($adminMessagesUnreadCount > 99 ? '99+' : $adminMessagesUnreadCount); ?></span>
                </button>
                <div class="notification-dropdown-tablet admin-messages" id="tabletAdminMessagesDropdown">
                    <div class="notification-header-tablet">
                        <h4 data-translate="adminMessages.title">Admin Messages</h4>
                    </div>
                    <div class="notification-list-tablet" id="tabletAdminMessagesList">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $adminMessages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="notification-item-tablet <?php echo e($notification->isRead ? 'read' : 'unread'); ?>"
                                wire:click="markAsRead(<?php echo e($notification->id); ?>)" style="cursor: pointer;">
                                <div class="notification-icon-tablet">
                                    <i class="fas fa-shield-alt <?php echo e($notification->isRead ? 'text-muted' : 'text-info'); ?>"></i>
                                </div>
                                <div class="notification-content-tablet">
                                    <p class="notification-text-tablet">
                                        <strong><?php echo e($notification->translatedHead); ?></strong><br>
                                        <?php echo $notification->translatedMessage; ?>

                                        <!--[if BLOCK]><![endif]--><?php if($notification->link): ?>
                                            <br><small><a href="<?php echo e($notification->link); ?>" class="text-primary">View
                                                    More</a></small>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </p>
                                    <span class="notification-time-tablet">
                                        <?php echo e($notification->created_at->diffForHumans()); ?>

                                        <!--[if BLOCK]><![endif]--><?php if($notification->expires_at): ?>
                                            (Expires: <?php echo e($notification->expires_at->diffForHumans()); ?>)
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </span>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php if(!$notification->isRead): ?>
                                    <div class="notification-unread-indicator"></div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="notification-item-tablet">
                                <div class="notification-content-tablet">
                                    <p class="notification-text-tablet text-center text-muted">
                                        No admin messages
                                    </p>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>

            <!-- Charges/Purchases -->
            <div class="notification-icon-container-tablet">
                <button class="notification-btn-tablet charges" id="tabletChargesBtn">
                    <svg class="notification-icon-tablet-svg" width="16" height="16" viewBox="0 0 24 24"
                        fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M7 4V2C7 1.448 7.448 1 8 1H16C16.552 1 17 1.448 17 2V4H20C20.552 4 21 4.448 21 5S20.552 6 20 6H19V19C19 20.104 18.104 21 17 21H7C5.896 21 5 20.104 5 19V6H4C3.448 6 3 5.552 3 5S3.448 4 4 4H7Z"
                            fill="currentColor" />
                        <path d="M9 9H11V17H9V9Z" fill="currentColor" />
                        <path d="M13 9H15V17H13V9Z" fill="currentColor" />
                        <circle cx="19" cy="4" r="2.5" fill="#2ed573" />
                        <path d="M17.5 2.5L18.5 3.5L20.5 1.5" stroke="white" stroke-width="1.5" fill="none" />
                    </svg>
                    <span class="notification-badge-tablet" id="tabletChargesBadge" style="display: <?php echo e($chargesUnreadCount > 0 ? 'block' : 'none'); ?>;"><?php echo e($chargesUnreadCount > 99 ? '99+' : $chargesUnreadCount); ?></span>
                </button>
                <div class="notification-dropdown-tablet charges" id="tabletChargesDropdown">
                    <div class="notification-header-tablet">
                        <h4 data-translate="charges.title">Recent Purchases</h4>
                    </div>
                    <div class="notification-list-tablet" id="tabletChargesList">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="notification-item-tablet <?php echo e($notification->isRead ? 'read' : 'unread'); ?>"
                                wire:click="markAsRead(<?php echo e($notification->id); ?>)" style="cursor: pointer;">
                                <div class="notification-icon-tablet">
                                    <i class="fas fa-credit-card <?php echo e($notification->isRead ? 'text-muted' : 'text-success'); ?>"></i>
                                </div>
                                <div class="notification-content-tablet">
                                    <p class="notification-text-tablet">Purchase of 1000 Silk completed
                                        successfully.</p>
                                    <span class="notification-time-tablet">3 days ago</span>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="notification-item-tablet">
                                <div class="notification-content-tablet">
                                    <p class="notification-text-tablet text-center text-muted">
                                        No recent purchases
                                    </p>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!--[if BLOCK]><![endif]--><?php if($type === 'mobile'): ?>
        <div class="mobile-header-notification-icons">
            <!-- Mobile Header Notifications -->
            <div class="mobile-header-notification-icon-container">
                <button class="mobile-header-notification-btn notifications" id="mobileHeaderNotificationsBtn">
                    <svg class="mobile-notification-icon" width="16" height="16" viewBox="0 0 24 24"
                        fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M12 2C10.896 2 10 2.896 10 4V5.586L7.707 8.293C7.512 8.488 7.256 8.584 7 8.584V10H17V8.584C16.744 8.584 16.488 8.488 16.293 8.293L14 5.586V4C14 2.896 13.104 2 12 2Z"
                            fill="currentColor" />
                        <path
                            d="M18 11V12C18 15.314 15.314 18 12 18C8.686 18 6 15.314 6 12V11H4V12C4 16.418 7.582 20 12 20C16.418 20 20 16.418 20 12V11H18Z"
                            fill="currentColor" />
                        <circle cx="17" cy="4" r="3" fill="#ff4757" />
                    </svg>
                    <span class="mobile-header-notification-badge" id="mobileHeaderNotificationsBadge"
                        style="display: <?php echo e($unreadCount > 0 ? 'block' : 'none'); ?>;"><?php echo e($unreadCount > 99 ? '99+' : $unreadCount); ?></span>
                </button>
                <!-- Mobile Header Notifications Dropdown -->
                <div class="mobile-header-notification-dropdown notifications" id="mobileHeaderNotificationsDropdown">
                    <div class="mobile-header-notification-header">
                        <h4 data-translate="notifications.title">Notifications</h4>
                    </div>
                    <div class="mobile-header-notification-list" id="mobileHeaderNotificationsList">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="mobile-header-notification-item <?php echo e($notification->isRead ? 'read' : 'unread'); ?>"
                                wire:click="markAsRead(<?php echo e($notification->id); ?>)" style="cursor: pointer;">
                                <div class="mobile-header-notification-icon">
                                    <i
                                        class="fas fa-bell <?php echo e($notification->isRead ? 'text-muted' : ($notification->type === 'admin_message' ? 'text-info' : ($notification->type === 'charge' ? 'text-success' : 'text-warning'))); ?>"></i>
                                </div>
                                <div class="mobile-header-notification-content">
                                    <p class="mobile-header-notification-text">
                                        <strong><?php echo e($notification->translatedHead); ?></strong><br>
                                        <?php echo $notification->translatedMessage; ?>

                                        <!--[if BLOCK]><![endif]--><?php if($notification->link): ?>
                                            <br><small><a href="<?php echo e($notification->link); ?>" class="text-primary">View
                                                    More</a></small>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </p>
                                    <span class="mobile-header-notification-time">
                                        <?php echo e($notification->created_at->diffForHumans()); ?>

                                        <!--[if BLOCK]><![endif]--><?php if($notification->expires_at): ?>
                                            (Expires: <?php echo e($notification->expires_at->diffForHumans()); ?>)
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </span>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php if(!$notification->isRead): ?>
                                    <div class="notification-unread-indicator"></div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="mobile-header-notification-item">
                                <div class="mobile-header-notification-content">
                                    <p class="mobile-header-notification-text text-center text-muted">
                                        No new notifications
                                    </p>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>

            <!-- Mobile Header Admin Messages -->
            <div class="mobile-header-notification-icon-container">
                <button class="mobile-header-notification-btn admin-messages" id="mobileHeaderAdminMessagesBtn">
                    <svg class="mobile-notification-icon" width="16" height="16" viewBox="0 0 24 24"
                        fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M20 4H4C2.896 4 2 4.896 2 6V18C2 19.104 2.896 20 4 20H20C21.104 20 22 19.104 22 18V6C22 4.896 21.104 4 20 4Z"
                            fill="currentColor" />
                        <path d="M22 6L12 13L2 6" stroke="currentColor" stroke-width="1.5" fill="none" />
                        <circle cx="19" cy="5" r="2.5" fill="#007bff" />
                        <path d="M19 3.5L20.5 5L19 6.5L17.5 5L19 3.5Z" fill="white" />
                    </svg>
                    <span class="mobile-header-notification-badge" id="mobileHeaderAdminMessagesBadge"
                        style="display: <?php echo e($adminMessagesUnreadCount > 0 ? 'block' : 'none'); ?>;"><?php echo e($adminMessagesUnreadCount > 99 ? '99+' : $adminMessagesUnreadCount); ?></span>
                </button>
                <!-- Mobile Header Admin Messages Dropdown -->
                <div class="mobile-header-notification-dropdown admin-messages"
                    id="mobileHeaderAdminMessagesDropdown">
                    <div class="mobile-header-notification-header">
                        <h4 data-translate="adminMessages.title">Admin Messages</h4>
                    </div>
                    <div class="mobile-header-notification-list" id="mobileHeaderAdminMessagesList">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $adminMessages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="mobile-header-notification-item <?php echo e($notification->isRead ? 'read' : 'unread'); ?>"
                                wire:click="markAsRead(<?php echo e($notification->id); ?>)" style="cursor: pointer;">
                                <div class="mobile-header-notification-icon">
                                    <i class="fas fa-shield-alt <?php echo e($notification->isRead ? 'text-muted' : 'text-info'); ?>"></i>
                                </div>
                                <div class="mobile-header-notification-content">
                                    <p class="mobile-header-notification-text">
                                        <strong><?php echo e($notification->translatedHead); ?></strong><br>
                                        <?php echo $notification->translatedMessage; ?>

                                        <!--[if BLOCK]><![endif]--><?php if($notification->link): ?>
                                            <br><small><a href="<?php echo e($notification->link); ?>" class="text-primary">View
                                                    More</a></small>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </p>
                                    <span class="mobile-header-notification-time">
                                        <?php echo e($notification->created_at->diffForHumans()); ?>

                                        <!--[if BLOCK]><![endif]--><?php if($notification->expires_at): ?>
                                            (Expires: <?php echo e($notification->expires_at->diffForHumans()); ?>)
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </span>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php if(!$notification->isRead): ?>
                                    <div class="notification-unread-indicator"></div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="mobile-header-notification-item">
                                <div class="mobile-header-notification-content">
                                    <p class="mobile-header-notification-text text-center text-muted">
                                        No admin messages
                                    </p>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>

            <!-- Mobile Header Charges -->
            <div class="mobile-header-notification-icon-container">
                <button class="mobile-header-notification-btn charges" id="mobileHeaderChargesBtn">
                    <svg class="mobile-notification-icon" width="16" height="16" viewBox="0 0 24 24"
                        fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M7 4V2C7 1.448 7.448 1 8 1H16C16.552 1 17 1.448 17 2V4H20C20.552 4 21 4.448 21 5S20.552 6 20 6H19V19C19 20.104 18.104 21 17 21H7C5.896 21 5 20.104 5 19V6H4C3.448 6 3 5.552 3 5S3.448 4 4 4H7Z"
                            fill="currentColor" />
                        <path d="M9 9H11V17H9V9Z" fill="currentColor" />
                        <path d="M13 9H15V17H13V9Z" fill="currentColor" />
                        <circle cx="19" cy="4" r="2.5" fill="#2ed573" />
                        <path d="M17.5 2.5L18.5 3.5L20.5 1.5" stroke="white" stroke-width="1.5" fill="none" />
                    </svg>
                    <span class="mobile-header-notification-badge" id="mobileHeaderChargesBadge"
                        style="display: <?php echo e($chargesUnreadCount > 0 ? 'block' : 'none'); ?>;"><?php echo e($chargesUnreadCount > 99 ? '99+' : $chargesUnreadCount); ?></span>
                </button>
                <!-- Mobile Header Charges Dropdown -->
                <div class="mobile-header-notification-dropdown charges" id="mobileHeaderChargesDropdown">
                    <div class="mobile-header-notification-header">
                        <h4 data-translate="charges.title">Recent Purchases</h4>
                    </div>
                    <div class="mobile-header-notification-list" id="mobileHeaderChargesList">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="mobile-header-notification-item <?php echo e($notification->isRead ? 'read' : 'unread'); ?>"
                                wire:click="markAsRead(<?php echo e($notification->id); ?>)" style="cursor: pointer;">
                                <div class="mobile-header-notification-icon">
                                    <i class="fas fa-shopping-cart <?php echo e($notification->isRead ? 'text-muted' : 'text-success'); ?>"></i>
                                </div>
                                <div class="mobile-header-notification-content">
                                    <p class="mobile-header-notification-text">
                                        <strong><?php echo e($notification->translatedHead); ?></strong><br>
                                        <?php echo $notification->translatedMessage; ?>

                                        <!--[if BLOCK]><![endif]--><?php if($notification->link): ?>
                                            <br><small><a href="<?php echo e($notification->link); ?>" class="text-primary">View
                                                    More</a></small>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </p>
                                    <span class="mobile-header-notification-time">
                                        <?php echo e($notification->created_at->diffForHumans()); ?>

                                        <!--[if BLOCK]><![endif]--><?php if($notification->expires_at): ?>
                                            (Expires: <?php echo e($notification->expires_at->diffForHumans()); ?>)
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </span>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php if(!$notification->isRead): ?>
                                    <div class="notification-unread-indicator"></div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="mobile-header-notification-item">
                                <div class="mobile-header-notification-content">
                                    <p class="mobile-header-notification-text text-center text-muted">
                                        No recent purchases
                                    </p>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div>

<script>
    // استقبال أحداث التحديث من Livewire
    document.addEventListener('livewire:initialized', function () {
        // التحديث التلقائي كل 30 ثانية للإشعارات الجديدة
        setInterval(function() {
            if (typeof window.Livewire.find('<?php echo e($_instance->getId()); ?>') !== 'undefined') {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').refresh();
            }
        }, 30000);

        // استقبال الأحداث المخصصة للتحديث
        Livewire.on('refresh-notifications', function() {
            if (typeof window.Livewire.find('<?php echo e($_instance->getId()); ?>') !== 'undefined') {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').refresh();
            }
        });
    });

    // استقبال الأحداث من الخارج (من الـ Model)
    window.addEventListener('livewire:refresh-notifications', function(event) {
        if (typeof Livewire !== 'undefined') {
            Livewire.dispatch('refresh-notifications');
        }
    });
</script><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/notifications.blade.php ENDPATH**/ ?>