<?php

use Livewire\Volt\Component;
use Livewire\Attributes\On;
use App\Helpers\InventoryHelper;
use App\Models\SRO_VT_SHARD\Char;

?>

<div>
    <!-- Player Details Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showPlayerModal && $selectedPlayer): ?>
        <div class="fixed inset-0 z-50 overflow-y-auto" x-data="{ show: <?php if ((object) ('showPlayerModal') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showPlayerModal'->value()); ?>')<?php echo e('showPlayerModal'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('showPlayerModal'); ?>')<?php endif; ?> }" x-show="show"
            x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100" x-transition:leave="ease-in duration-200"
            x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
            @keydown.escape="$wire.closePlayerModal()">

            <!-- Background overlay -->
            <div class="fixed inset-0 player-modal-overlay" wire:click="closePlayerModal"></div>

            <!-- Modal content -->
            <div class="flex items-start justify-center min-h-screen p-2 sm:p-4 pt-4 sm:pt-8">
                <div class="relative player-modal-content rounded-2xl shadow-2xl w-full max-w-4xl mx-auto"
                    x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 transform scale-95"
                    x-transition:enter-end="opacity-100 transform scale-100" x-transition:leave="ease-in duration-200"
                    x-transition:leave-start="opacity-100 transform scale-100"
                    x-transition:leave-end="opacity-0 transform scale-95">

                    <!-- Close button with RTL/LTR support -->
                    <?php if (isset($component)) { $__componentOriginal20ddd7594db95ee6d54a34bf8dc9c000 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal20ddd7594db95ee6d54a34bf8dc9c000 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modal-close-button','data' => ['action' => 'closePlayerModal']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal-close-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['action' => 'closePlayerModal']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal20ddd7594db95ee6d54a34bf8dc9c000)): ?>
<?php $attributes = $__attributesOriginal20ddd7594db95ee6d54a34bf8dc9c000; ?>
<?php unset($__attributesOriginal20ddd7594db95ee6d54a34bf8dc9c000); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal20ddd7594db95ee6d54a34bf8dc9c000)): ?>
<?php $component = $__componentOriginal20ddd7594db95ee6d54a34bf8dc9c000; ?>
<?php unset($__componentOriginal20ddd7594db95ee6d54a34bf8dc9c000); ?>
<?php endif; ?>

                    <!-- Modal header -->
                    <div class="p-4 sm:p-6 border-b border-purple-500/30">
                        <h3 class="text-xl sm:text-2xl font-bold text-white text-center">
                            <i class="fas fa-user text-purple-400 mr-2"></i>
                            <span data-translate="rankings.playerDetails" wire:ignore>Player Details</span>
                        </h3>
                    </div>

                    <!-- Modal body with responsive layout -->
                    <div class="flex flex-col lg:flex-row min-h-[500px]">
                        <!-- Left Panel - Player Info (طولي على الموبايل، يسار على الديسكتوب) -->
                        <div class="w-full lg:w-2/5 p-4 sm:p-6 border-b lg:border-b-0 lg:border-r border-purple-500/30">
                            <!-- Player Avatar Section -->
                            <div class="text-center mb-6">
                                <div class="relative inline-block mb-4">
                                    <img src="<?php echo e($selectedPlayer['avatar'] ?? '/assets/images/avatars/default.gif'); ?>"
                                        alt="<?php echo e($selectedPlayer['charName'] ?? 'Unknown'); ?>"
                                        class="w-20 h-20 sm:w-24 sm:h-24 lg:w-28 lg:h-28 mx-auto rounded-full player-modal-avatar">

                                    <!-- Rank badge overlay -->
                                    <!--[if BLOCK]><![endif]--><?php if(isset($selectedPlayer['rank']) && $selectedPlayer['rank'] <= 3): ?>
                                        <div
                                            class="absolute -top-2 -right-2 w-6 h-6 sm:w-8 sm:h-8 rounded-full flex items-center justify-center text-xs font-bold
                                        <?php echo e($selectedPlayer['rank'] == 1 ? 'bg-gradient-to-r from-yellow-400 to-yellow-600 text-yellow-900' : ''); ?>

                                        <?php echo e($selectedPlayer['rank'] == 2 ? 'bg-gradient-to-r from-gray-300 to-gray-500 text-gray-900' : ''); ?>

                                        <?php echo e($selectedPlayer['rank'] == 3 ? 'bg-gradient-to-r from-amber-600 to-amber-800 text-amber-100' : ''); ?>">
                                            <?php echo e($selectedPlayer['rank']); ?>

                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <!-- Player Name -->
                                <h4 class="text-xl sm:text-2xl font-bold text-white mb-3">
                                    <?php echo e($selectedPlayer['charName'] ?? ($selectedPlayer['name'] ?? 'Unknown')); ?>

                                    <!--[if BLOCK]><![endif]--><?php if($selectedPlayer['is_owned'] ?? false): ?>
                                        <i class="fas fa-crown text-amber-400 ml-2"></i>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </h4>

                                <!-- Player Rank Badge -->
                                <?php if(isset($selectedPlayer['rank'])): ?>
                                    <div
                                        class="inline-flex items-center px-3 py-2 sm:px-4 sm:py-2 bg-gradient-to-r from-purple-600 to-blue-600 rounded-full text-white font-semibold mb-4 text-sm sm:text-base">
                                        <i class="fas fa-trophy mr-2"></i>
                                        <span data-translate="rankings.rank" wire:ignore>Rank</span>:
                                        #<?php echo e($selectedPlayer['rank']); ?>

                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                <!-- Ownership Badge -->
                                <!--[if BLOCK]><![endif]--><?php if($selectedPlayer['is_owned'] ?? false): ?>
                                    <div
                                        class="inline-flex items-center px-2 py-1 sm:px-3 sm:py-1 bg-gradient-to-r from-amber-500 to-yellow-500 rounded-full text-black font-semibold text-xs sm:text-sm mb-4">
                                        <i class="fas fa-user-check mr-1"></i>
                                        <span data-translate="rankings.yourCharacter" wire:ignore>Your Character</span>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>

                            <!-- Player Stats Grid -->
                            <div class="grid grid-cols-2 gap-2 sm:gap-3 lg:gap-4 mb-6">
                                <!-- Points -->
                                <!--[if BLOCK]><![endif]--><?php if(isset($selectedPlayer['points'])): ?>
                                    <div
                                        class="bg-gradient-to-r from-blue-600/20 to-purple-600/20 rounded-lg sm:rounded-xl p-2 sm:p-3 lg:p-4 border border-blue-500/30">
                                        <div class="text-lg sm:text-xl lg:text-2xl font-bold text-blue-400 mb-1">
                                            <?php echo e(number_format($selectedPlayer['points'])); ?>

                                        </div>
                                        <div class="text-blue-200 text-xs sm:text-sm" data-translate="rankings.points" wire:ignore>
                                            Points
                                        </div>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                <!-- Kills -->
                                <!--[if BLOCK]><![endif]--><?php if(isset($selectedPlayer['kills'])): ?>
                                    <div
                                        class="bg-gradient-to-r from-green-600/20 to-emerald-600/20 rounded-lg sm:rounded-xl p-2 sm:p-3 lg:p-4 border border-green-500/30">
                                        <div class="text-lg sm:text-xl lg:text-2xl font-bold text-green-400 mb-1">
                                            <?php echo e(number_format($selectedPlayer['kills'])); ?>

                                        </div>
                                        <div class="text-green-200 text-xs sm:text-sm" data-translate="rankings.kills" wire:ignore>
                                            Kills
                                        </div>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                <!-- Deaths -->
                                <!--[if BLOCK]><![endif]--><?php if(isset($selectedPlayer['deaths'])): ?>
                                    <div
                                        class="bg-gradient-to-r from-red-600/20 to-rose-600/20 rounded-lg sm:rounded-xl p-2 sm:p-3 lg:p-4 border border-red-500/30">
                                        <div class="text-lg sm:text-xl lg:text-2xl font-bold text-red-400 mb-1">
                                            <?php echo e(number_format($selectedPlayer['deaths'])); ?>

                                        </div>
                                        <div class="text-red-200 text-xs sm:text-sm" data-translate="rankings.deaths" wire:ignore>
                                            Deaths
                                        </div>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                <!-- K/D Ratio -->
                                <?php if(isset($selectedPlayer['kills']) && isset($selectedPlayer['deaths'])): ?>
                                    <div
                                        class="bg-gradient-to-r from-cyan-600/20 to-blue-600/20 rounded-lg sm:rounded-xl p-2 sm:p-3 lg:p-4 border border-cyan-500/30">
                                        <div class="text-lg sm:text-xl lg:text-2xl font-bold text-cyan-400 mb-1">
                                            <?php echo e($this->calculateKDRatio($selectedPlayer['kills'], $selectedPlayer['deaths'])); ?>

                                        </div>
                                        <div class="text-cyan-200 text-xs sm:text-sm" data-translate="rankings.kdRatio"
                                            wire:ignore>
                                            K/D Ratio
                                        </div>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>

                            <!-- Character Info -->
                            <!--[if BLOCK]><![endif]--><?php if(isset($selectedPlayer['job_type']) || isset($selectedPlayer['refObjID'])): ?>
                                <div class="bg-slate-800/50 rounded-lg border border-slate-600/30 p-3 sm:p-4">
                                    <h5 class="text-base sm:text-lg font-semibold text-white mb-3">
                                        <i class="fas fa-info-circle text-slate-400 mr-2"></i>
                                        <span data-translate="rankings.characterInfo" wire:ignore>Character Info</span>
                                    </h5>

                                    <div class="grid grid-cols-1 gap-2 sm:gap-3 text-xs sm:text-sm">
                                        <?php if(isset($selectedPlayer['job_type'])): ?>
                                            <div class="flex justify-between items-center">
                                                <span class="text-slate-400" data-translate="rankings.job"
                                                    wire:ignore>Job:</span>
                                                <div class="job-badge-with-icon <?php echo e($this->getJobBadgeClasses($selectedPlayer['job_type'])); ?>">
                                                    <i class="<?php echo e($this->getJobIcon($selectedPlayer['job_type'])); ?>"></i>
                                                    <?php echo e($this->getPlayerJobType($selectedPlayer['job_type'])); ?>

                                                </div>
                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                        <!--[if BLOCK]><![endif]--><?php if(isset($selectedPlayer['refObjID'])): ?>
                                            <div class="flex justify-between items-center">
                                                <span class="text-slate-400" data-translate="rankings.race"
                                                    wire:ignore>Race:</span>
                                                <span
                                                    class="text-white font-medium"><?php echo e($this->getPlayerRace($selectedPlayer['refObjID'])); ?></span>
                                            </div>

                                            <div class="flex justify-between items-center">
                                                <span class="text-slate-400" data-translate="rankings.gender"
                                                    wire:ignore>Gender:</span>
                                                <span
                                                    class="text-white font-medium"><?php echo e($this->getPlayerGender($selectedPlayer['refObjID'])); ?></span>
                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Right Panel - Inventory Grid (أسفل على الموبايل، يمين على الديسكتوب) -->
                        <div class="w-full lg:w-3/5 p-4 sm:p-6">
                            <h5 class="text-base sm:text-lg font-semibold text-white mb-4 text-center lg:text-left">
                                <i class="fas fa-boxes text-purple-400 mr-2"></i>
                                <span data-translate="rankings.playerInventory" wire:ignore>Player Equipment</span>
                            </h5>

                            <!-- Silkroad Online Style Inventory Component -->
                            <?php if (isset($component)) { $__componentOriginal7c9ff8acf4e9d823e286bee7f0b0bbd7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7c9ff8acf4e9d823e286bee7f0b0bbd7 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.silkroad-inventory','data' => ['charId' => $selectedPlayer['charName'] ?? null,'items' => $playerEquipment]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('silkroad-inventory'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['char-id' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($selectedPlayer['charName'] ?? null),'items' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($playerEquipment)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7c9ff8acf4e9d823e286bee7f0b0bbd7)): ?>
<?php $attributes = $__attributesOriginal7c9ff8acf4e9d823e286bee7f0b0bbd7; ?>
<?php unset($__attributesOriginal7c9ff8acf4e9d823e286bee7f0b0bbd7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7c9ff8acf4e9d823e286bee7f0b0bbd7)): ?>
<?php $component = $__componentOriginal7c9ff8acf4e9d823e286bee7f0b0bbd7; ?>
<?php unset($__componentOriginal7c9ff8acf4e9d823e286bee7f0b0bbd7); ?>
<?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/frontend/event-rankings/player-modal.blade.php ENDPATH**/ ?>