<!-- Floating Social Media Button -->
<div class="social-float-container">
    <!-- Main floating button -->
    <button class="social-float-btn" id="socialFloatBtn" aria-label="Social Media">
        <svg class="social-main-icon" id="socialIcon" width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
            <path d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92s2.92-1.31 2.92-2.92S19.61 16.08 18 16.08z"/>
        </svg>
        <div class="chat-indicator">💬</div>
    </button>

    <!-- Social media menu -->
    <div class="social-menu" id="socialMenu">
        <h3 data-translate="social.followUs">تابعنا على</h3>
        <div class="social-links">
            <!-- Facebook Chat -->
            <a href="javascript:void(0)" onclick="openFacebookChat()" class="social-link facebook">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M12 0C5.374 0 0 4.975 0 11.111c0 3.498 1.744 6.614 4.469 8.654V24l4.088-2.242c1.092.301 2.246.464 3.443.464 6.626 0 12-4.975 12-11.111C24 4.975 18.626 0 12 0zm1.191 14.963l-3.055-3.26-5.963 3.26L10.732 8l3.128 3.26L19.732 8l-6.541 6.963z"/>
                </svg>
                <span data-translate="social.facebookChat">شات فيسبوك</span>
            </a>

            <!-- Facebook Page -->
            <a href="https://facebook.com/4TresSro" target="_blank" class="social-link facebook">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                </svg>
                <span data-translate="social.facebook">صفحة فيسبوك</span>
            </a>

            <!-- Facebook Group -->
            <a href="https://web.facebook.com/groups/4tressro/" target="_blank" class="social-link facebook">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M16 4c0-1.11.89-2 2-2s2 .89 2 2-.89 2-2 2-2-.89-2-2zM4 4c0-1.11.89-2 2-2s2 .89 2 2-.89 2-2 2-2-.89-2-2zm5 4c0-1.11.89-2 2-2s2 .89 2 2-.89 2-2 2-2-.89-2-2zM2 18v-3c0-1.1.9-2 2-2h2.5l1.5-1.5c.4-.4 1-.4 1.4 0L11 13l1.6-1.6c.4-.4 1-.4 1.4 0L15.5 13H18c1.1 0 2 .9 2 2v3c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2z"/>
                </svg>
                <span data-translate="social.facebookGroup">فيسبوك جروب</span>
            </a>

            <!-- Discord -->
            <a href="https://discord.com/invite/hQNdpz8QXq" target="_blank" class="social-link discord">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M20.317 4.37a19.791 19.791 0 0 0-4.885-1.515.074.074 0 0 0-.079.037c-.21.375-.444.864-.608 1.25a18.27 18.27 0 0 0-5.487 0 12.64 12.64 0 0 0-.617-1.25.077.077 0 0 0-.079-.037A19.736 19.736 0 0 0 3.677 4.37a.07.07 0 0 0-.032.027C.533 9.046-.32 13.58.099 18.057a.082.082 0 0 0 .031.057 19.9 19.9 0 0 0 5.993 3.03.078.078 0 0 0 .084-.028 14.09 14.09 0 0 0 1.226-1.994.076.076 0 0 0-.041-.106 13.107 13.107 0 0 1-1.872-.892.077.077 0 0 1-.008-.128 10.2 10.2 0 0 0 .372-.292.074.074 0 0 1 .077-.01c3.928 1.793 8.18 1.793 12.062 0a.074.074 0 0 1 .078.01c.12.098.246.198.373.292a.077.077 0 0 1-.006.127 12.299 12.299 0 0 1-1.873.892.077.077 0 0 0-.041.107c.36.698.772 1.362 1.225 1.993a.076.076 0 0 0 .084.028 19.839 19.839 0 0 0 6.002-3.03.077.077 0 0 0 .032-.054c.5-5.177-.838-9.674-3.549-13.66a.061.061 0 0 0-.031-.03zM8.02 15.33c-1.183 0-2.157-1.085-2.157-2.419 0-1.333.956-2.419 2.157-2.419 1.21 0 2.176 1.096 2.157 2.42 0 1.333-.956 2.418-2.157 2.418zm7.975 0c-1.183 0-2.157-1.085-2.157-2.419 0-1.333.955-2.419 2.157-2.419 1.21 0 2.176 1.096 2.157 2.42 0 1.333-.946 2.418-2.157 2.418z"/>
                </svg>
                <span data-translate="social.discord">ديسكورد</span>
            </a>

            <!-- YouTube -->
            <a href="https://youtube.com/@4TresSro" target="_blank" class="social-link youtube">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>
                </svg>
                <span data-translate="social.youtube">يوتيوب</span>
            </a>

            <!-- Instagram -->
            <a href="https://www.instagram.com/4tressro_online" target="_blank" class="social-link instagram">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                </svg>
                <span data-translate="social.instagram">انستجرام</span>
            </a>
        </div>
    </div>
</div>

<script>
// Social Media Float Button Functionality
document.addEventListener('DOMContentLoaded', function() {
    const floatBtn = document.getElementById('socialFloatBtn');
    const socialMenu = document.getElementById('socialMenu');
    const socialIcon = document.getElementById('socialIcon');
    let isMenuOpen = false;
    let isMobile = window.innerWidth <= 767;

    // Update mobile detection on resize
    window.addEventListener('resize', function() {
        isMobile = window.innerWidth <= 767;
        if (!isMobile && isMenuOpen) {
            // Reset mobile-specific styles when switching to desktop
            socialMenu.style.position = '';
            socialMenu.style.bottom = '';
            socialMenu.style.left = '';
            socialMenu.style.right = '';
        }
    });

    // Toggle menu
    floatBtn.addEventListener('click', function(e) {
        e.stopPropagation();
        toggleSocialMenu();
    });

    // Close menu when clicking outside (desktop) or on backdrop (mobile)
    document.addEventListener('click', function(e) {
        if (!e.target.closest('.social-float-container')) {
            closeSocialMenu();
        }
    });

    // Handle mobile backdrop click
    socialMenu.addEventListener('click', function(e) {
        if (isMobile && e.target === socialMenu) {
            closeSocialMenu();
        } else if (!isMobile) {
            e.stopPropagation();
        }
    });

    // Prevent menu from closing when clicking inside (desktop only)
    if (!isMobile) {
        socialMenu.addEventListener('click', function(e) {
            e.stopPropagation();
        });
    }

    function toggleSocialMenu() {
        if (isMenuOpen) {
            closeSocialMenu();
        } else {
            openSocialMenu();
        }
    }

    function openSocialMenu() {
        socialMenu.classList.add('active');
        floatBtn.classList.add('active');

        // Change SVG to close icon
        socialIcon.innerHTML = `
            <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/>
        `;
        isMenuOpen = true;

        // Add entrance animation to menu items with stagger effect
        const menuItems = socialMenu.querySelectorAll('.social-link');
        menuItems.forEach((item, index) => {
            item.style.opacity = '0';

            if (isMobile) {
                item.style.transform = 'translateY(30px) scale(0.9)';
                item.style.transition = `all 0.5s cubic-bezier(0.68, -0.55, 0.265, 1.55) ${index * 0.05}s`;
            } else {
                item.style.transform = 'translateY(20px) scale(0.8)';
                item.style.transition = `all 0.4s cubic-bezier(0.68, -0.55, 0.265, 1.55) ${index * 0.1}s`;
            }

            setTimeout(() => {
                item.style.opacity = '1';
                item.style.transform = 'translateY(0) scale(1)';
            }, isMobile ? index * 50 + 100 : index * 100 + 100);
        });

        // Prevent body scroll on mobile when menu is open
        if (isMobile) {
            document.body.style.overflow = 'hidden';
        }
    }

    function closeSocialMenu() {
        socialMenu.classList.remove('active');
        floatBtn.classList.remove('active');

        // Change SVG back to share icon
        socialIcon.innerHTML = `
            <path d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92s2.92-1.31 2.92-2.92S19.61 16.08 18 16.08z"/>
        `;
        isMenuOpen = false;

        // Reset menu items styles
        const menuItems = socialMenu.querySelectorAll('.social-link');
        menuItems.forEach((item) => {
            item.style.opacity = '';
            item.style.transform = '';
            item.style.transition = '';
        });

        // Restore body scroll on mobile
        if (isMobile) {
            document.body.style.overflow = '';
        }
    }

    // Enhanced keyboard accessibility
    floatBtn.addEventListener('keydown', function(e) {
        if (e.key === 'Enter' || e.key === ' ') {
            e.preventDefault();
            toggleSocialMenu();
        }
        if (e.key === 'Escape') {
            closeSocialMenu();
        }
    });

    // Close menu on escape key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape' && isMenuOpen) {
            closeSocialMenu();
        }
    });

    // Touch events for better mobile interaction
    let touchStartY = 0;
    let touchEndY = 0;

    if (isMobile) {
        socialMenu.addEventListener('touchstart', function(e) {
            touchStartY = e.changedTouches[0].screenY;
        });

        socialMenu.addEventListener('touchend', function(e) {
            touchEndY = e.changedTouches[0].screenY;

            // Close menu if swiped down significantly
            if (touchStartY < touchEndY && (touchEndY - touchStartY) > 50) {
                closeSocialMenu();
            }
        });
    }
});

// Facebook Chat Function
function openFacebookChat() {
    // Replace 'YourPageID' with your actual Facebook Page ID
    const pageId = '110029828480368'; // Change this to your actual page ID
    const chatUrl = `https://m.me/${pageId}`;

    // Try to open in a popup window first
    const popup = window.open(
        chatUrl,
        'facebookChat',
        'width=400,height=600,scrollbars=yes,resizable=yes,toolbar=no,location=no,directories=no,status=no,menubar=no'
    );

    // If popup is blocked, redirect to the chat URL
    if (!popup || popup.closed || typeof popup.closed === 'undefined') {
        window.open(chatUrl, '_blank');
    }
}

// Add ripple effect to social links
document.addEventListener('DOMContentLoaded', function() {
    const socialLinks = document.querySelectorAll('.social-link');

    socialLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            // Create ripple effect
            const ripple = document.createElement('span');
            const rect = this.getBoundingClientRect();
            const size = Math.max(rect.width, rect.height);
            const x = e.clientX - rect.left - size / 2;
            const y = e.clientY - rect.top - size / 2;

            ripple.style.cssText = `
                position: absolute;
                width: ${size}px;
                height: ${size}px;
                left: ${x}px;
                top: ${y}px;
                background: rgba(255, 255, 255, 0.3);
                border-radius: 50%;
                transform: scale(0);
                animation: ripple 0.6s linear;
                pointer-events: none;
            `;

            this.appendChild(ripple);

            setTimeout(() => {
                ripple.remove();
            }, 600);
        });
    });
});

// Add CSS for ripple animation and SVG styling
const style = document.createElement('style');
style.textContent = `
    @keyframes ripple {
        to {
            transform: scale(4);
            opacity: 0;
        }
    }

    .social-link {
        position: relative;
        overflow: hidden;
    }

    .social-main-icon {
        transition: all 0.3s ease;
        width: 20px;
        height: 20px;
    }

    .social-link svg {
        transition: all 0.3s ease;
        width: 20px;
        height: 20px;
        flex-shrink: 0;
    }

    .social-float-btn.active .social-main-icon {
        transform: rotate(45deg);
    }

    .social-link:hover svg {
        transform: scale(1.1);
    }

    /* Platform specific colors for SVGs */
    .social-link.facebook svg {
        color: #1877f2;
    }

    .social-link.discord svg {
        color: #5865f2;
    }

    .social-link.youtube svg {
        color: #ff0000;
    }

    .social-link.instagram svg {
        color: #e4405f;
    }

    /* Responsive Design */

    /* Desktop (1200px and up) */
    @media (min-width: 1200px) {
        .social-float-container {
            position: fixed;
            bottom: 20px;
            right: 20px;
            z-index: 1000;
        }

        .social-float-btn {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 8px 25px rgba(0,0,0,0.3);
            transition: all 0.3s ease;
            position: relative;
            overflow: visible;
        }

        .social-float-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 35px rgba(0,0,0,0.4);
        }

        .social-menu {
            position: absolute;
            bottom: 75px;
            right: 0;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 15px;
            padding: 20px;
            min-width: 280px;
            opacity: 0;
            visibility: hidden;
            transform: translateY(20px) scale(0.9);
            transition: all 0.3s ease;
            box-shadow: 0 15px 35px rgba(0,0,0,0.2);
        }

        .social-menu.active {
            opacity: 1;
            visibility: visible;
            transform: translateY(0) scale(1);
        }

        .social-links {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .social-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 15px;
            text-decoration: none;
            color: #333;
            border-radius: 10px;
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.7);
        }

        .social-link:hover {
            background: rgba(255, 255, 255, 1);
            transform: translateX(5px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }

        .chat-indicator {
            position: absolute;
            top: -5px;
            right: -5px;
            background: #ff4757;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 10px;
            animation: bounce 2s infinite;
        }
    }

    /* Tablet (768px to 1199px) */
    @media (min-width: 768px) and (max-width: 1199px) {
        .social-float-container {
            position: fixed;
            bottom: 15px;
            right: 15px;
            z-index: 1000;
        }

        .social-float-btn {
            width: 55px;
            height: 55px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 6px 20px rgba(0,0,0,0.3);
            transition: all 0.3s ease;
            position: relative;
        }

        .social-menu {
            position: absolute;
            bottom: 70px;
            right: 0;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 12px;
            padding: 16px;
            min-width: 250px;
            opacity: 0;
            visibility: hidden;
            transform: translateY(20px) scale(0.9);
            transition: all 0.3s ease;
            box-shadow: 0 12px 30px rgba(0,0,0,0.2);
        }

        .social-menu.active {
            opacity: 1;
            visibility: visible;
            transform: translateY(0) scale(1);
        }

        .social-links {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }

        .social-link {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 10px 12px;
            text-decoration: none;
            color: #333;
            border-radius: 8px;
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.7);
            font-size: 14px;
        }

        .social-link svg {
            width: 18px;
            height: 18px;
        }

        .chat-indicator {
            position: absolute;
            top: -3px;
            right: -3px;
            background: #ff4757;
            border-radius: 50%;
            width: 18px;
            height: 18px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 9px;
            animation: bounce 2s infinite;
        }
    }

    /* Mobile (767px and below) */
    @media (max-width: 767px) {
        .social-float-container {
            position: fixed;
            bottom: 10px;
            right: 10px;
            z-index: 1000;
        }

        .social-float-btn {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 15px rgba(0,0,0,0.3);
            transition: all 0.3s ease;
            position: relative;
        }

        .social-main-icon {
            width: 18px !important;
            height: 18px !important;
        }

        .social-menu {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(15px);
            border-radius: 20px 20px 0 0;
            padding: 20px 15px 25px;
            opacity: 0;
            visibility: hidden;
            transform: translateY(100%);
            transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            box-shadow: 0 -10px 30px rgba(0,0,0,0.2);
            max-height: 50vh;
            overflow-y: auto;
        }

        .social-menu.active {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        .social-menu h3 {
            text-align: center;
            margin-bottom: 20px;
            color: #333;
            font-size: 18px;
            font-weight: 600;
        }

        .social-links {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
        }

        .social-link {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 8px;
            padding: 15px 10px;
            text-decoration: none;
            color: #333;
            border-radius: 12px;
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.8);
            border: 1px solid rgba(0,0,0,0.1);
            text-align: center;
            font-size: 13px;
        }

        .social-link:hover, .social-link:active {
            background: rgba(255, 255, 255, 1);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }

        .social-link svg {
            width: 24px;
            height: 24px;
        }

        .chat-indicator {
            position: absolute;
            top: -2px;
            right: -2px;
            background: #ff4757;
            border-radius: 50%;
            width: 16px;
            height: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 8px;
            animation: bounce 2s infinite;
        }

        /* Add backdrop overlay for mobile */
        .social-menu.active::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.3);
            z-index: -1;
        }
    }

    /* Very small mobile (480px and below) */
    @media (max-width: 480px) {
        .social-float-btn {
            width: 45px;
            height: 45px;
        }

        .social-main-icon {
            width: 16px !important;
            height: 16px !important;
        }

        .social-links {
            grid-template-columns: 1fr;
            gap: 10px;
        }

        .social-link {
            flex-direction: row;
            justify-content: flex-start;
            gap: 12px;
            padding: 12px 15px;
        }

        .social-link svg {
            width: 20px;
            height: 20px;
        }

        .chat-indicator {
            width: 14px;
            height: 14px;
            font-size: 7px;
        }
    }

    @keyframes bounce {
        0%, 20%, 50%, 80%, 100% {
            transform: translateY(0);
        }
        40% {
            transform: translateY(-3px);
        }
        60% {
            transform: translateY(-2px);
        }
    }

    /* Dark mode support */
    @media (prefers-color-scheme: dark) {
        .social-menu {
            background: rgba(30, 30, 30, 0.95);
            color: #fff;
        }

        .social-menu h3 {
            color: #fff;
        }

        .social-link {
            background: rgba(50, 50, 50, 0.8);
            color: #fff;
            border-color: rgba(255,255,255,0.1);
        }

        .social-link:hover {
            background: rgba(70, 70, 70, 1);
        }
    }

    /* RTL Support */
    [dir="rtl"] .social-float-container {
        right: auto;
        left: 20px;
    }

    @media (max-width: 767px) {
        [dir="rtl"] .social-float-container {
            left: 10px;
            right: auto;
        }
    }

    @media (min-width: 768px) {
        [dir="rtl"] .social-menu {
            right: auto;
            left: 0;
        }

        [dir="rtl"] .social-link:hover {
            transform: translateX(-5px);
        }
    }
`;
document.head.appendChild(style);
</script>
<?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views/components/layouts/struct/partials/social-media-float.blade.php ENDPATH**/ ?>