<?php

use Livewire\Volt\Component;
use Livewire\Attributes\Validate;
use Illuminate\Support\Facades\Hash;
use Illuminate\Auth\Events\Registered;
use App\Models\SRO_VT_ACCOUNT\SkSilk;
use App\Models\SRO_VT_ACCOUNT\TbUser;
use App\Models\Z_Website\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Helpers\LanguageHelper;

?>

<div>
    <!-- Register Modal Trigger Button -->
    <button class="auth-btn auth-btn-register hover:scale-105 transform transition-all duration-300 w-full lg:w-auto"
        wire:click="openRegisterModal">
        <i class="fas fa-user-plus mr-2 rtl:mr-0 rtl:ml-2"></i>
        <span wire:ignore data-translate="authentication.register">Register</span>
    </button>

    <!-- Register Modal -->
    <!--[if BLOCK]><![endif]--><?php if($activeModal === 'register'): ?>
        <div x-data="{
            show: true,
            switching: false,
            preventDoubleSwitch() {
                if (this.switching) return false;
                this.switching = true;
                setTimeout(() => { this.switching = false; }, 1000);
                return true;
            },
            init() {
                // Preserve language after Alpine component initialization
                this.$nextTick(() => {
                    if (window.languageManager) {
                        setTimeout(() => {
                            window.languageManager.applyTranslations();
                        }, 100);
                    }
                });
            }
        }" x-show="show"
             x-transition:enter="transition ease-out duration-500"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition ease-in duration-300"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0"
             @click.away="$wire.closeModal()"
             class="modal-overlay register-modal"
             wire:ignore.self>

            <!-- Animated Glass Background -->
            <div class="absolute inset-0 overflow-hidden pointer-events-none">
                <div class="glass-orb glass-orb-1"></div>
                <div class="glass-orb glass-orb-2"></div>
                <div class="glass-orb glass-orb-3"></div>
            </div>

            <div x-transition:enter="transition ease-out duration-500 delay-150"
                 x-transition:enter-start="opacity-0 scale-75 rotate-3"
                 x-transition:enter-end="opacity-100 scale-100 rotate-0"
                 x-transition:leave="transition ease-in duration-200"
                 x-transition:leave-start="opacity-100 scale-100 rotate-0"
                 x-transition:leave-end="opacity-0 scale-90 rotate-1"
                 class="modal-container"
                 onclick="event.stopPropagation()">

                <!-- Close Button -->
                <button @click="show = false; $wire.closeModal()"
                    class="modal-close">
                    <i class="fas fa-times"></i>
                    <!-- Fallback if FontAwesome doesn't load -->
                    <span class="close-fallback">×</span>
                </button>


                <!-- Modal Header -->
                <div class="modal-header">
                    <div class="modal-icon">
                        <i class="fas fa-user-plus"></i>
                    </div>
                    <h2 class="modal-title" wire:ignore data-translate="authentication.joinAdventure">
                        Join the Adventure!
                    </h2>
                    <p class="modal-subtitle" wire:ignore data-translate="authentication.createAccountLegend">
                        Create your account and become a legend
                    </p>
                </div>

                <!-- Registration Form -->
               <form wire:submit="register" class="space-y-6"
                     x-data="{
                         init() {
                             // Listen for Livewire updates and reapply translations
                             this.$wire.on('*', () => {
                                 this.$nextTick(() => {
                                     if (window.languageManager) {
                                         setTimeout(() => {
                                             window.languageManager.applyTranslations();
                                         }, 50);
                                     }
                                 });
                             });

                             // Force language preservation on form interactions
                             this.$el.addEventListener('input', () => {
                                 if (window.languageManager) {
                                     window.languageManager.debounceApplyTranslations();
                                 }
                             });
                         }
                     }">
                    <!-- Hidden field to capture current page language -->
                    <input type="hidden" wire:model.defer="lang" id="livewire-register-lang" />

                    <script>
                        (function() {
                            // savedLang priority: localStorage preferred-language -> server-provided languageConfig -> fallback 'en'
                            function setInitialLang() {
                                const savedLang = localStorage.getItem('preferred-language') || (window.languageConfig && window.languageConfig.currentLanguage) || 'en';
                                const el = document.getElementById('livewire-register-lang');
                                if (el) el.value = savedLang;

                                try {
                                    if (window.Livewire && el) {
                                        const compEl = el.closest('[wire\\:id]');
                                        if (compEl) {
                                            const lw = Livewire.find(compEl.getAttribute('wire:id'));
                                            lw && lw.set && lw.set('lang', savedLang);
                                        }
                                    }
                                } catch (err) {
                                    // ignore
                                }
                            }

                            document.addEventListener('DOMContentLoaded', () => setInitialLang());
                        })();
                    </script>
                    <!-- Username Field -->
                    <div class="form-group">
                        <label class="form-label" wire:ignore data-translate="authentication.gameUsername">Game Username</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 ltr:left-0 rtl:right-0 ltr:pl-3 rtl:pr-3 flex items-center pointer-events-none">
                                <i class="fas fa-gamepad text-gray-400"></i>
                            </div>
                            <input wire:model="StrUserID" type="text" autocomplete="username"
                                class="glass-input w-full ltr:pl-10 rtl:pr-10 ltr:pr-4 rtl:pl-4 <?php $__errorArgs = ['StrUserID'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                wire:ignore data-translate="authentication.enterGameUsername"
                                placeholder="Enter your game username (6-16 characters)"
                                required />
                        </div>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['StrUserID'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-red-500 text-sm mt-1"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!-- Email Field -->
                    <div class="form-group">
                        <label class="form-label" wire:ignore data-translate="authentication.emailAddress">Email Address</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 ltr:left-0 rtl:right-0 ltr:pl-3 rtl:pr-3 flex items-center pointer-events-none">
                                <i class="fas fa-envelope text-gray-400"></i>
                            </div>
                            <input wire:model="email" type="email" autocomplete="email"
                                class="glass-input w-full ltr:pl-10 rtl:pr-10 ltr:pr-4 rtl:pl-4 <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                wire:ignore data-translate="authentication.enterEmailAddress"
                                placeholder="Enter your email address"
                                required />
                        </div>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-red-500 text-sm mt-1"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!-- Password Field -->
                    <div class="form-group">
                        <label class="form-label" wire:ignore data-translate="authentication.gamePassword">Game Password</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 ltr:left-0 rtl:right-0 ltr:pl-3 rtl:pr-3 flex items-center pointer-events-none">
                                <i class="fas fa-lock text-gray-400"></i>
                            </div>
                            <input wire:model="sro_password" type="password" autocomplete="new-password"
                                class="glass-input w-full ltr:pl-10 rtl:pr-10 ltr:pr-4 rtl:pl-4 <?php $__errorArgs = ['sro_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                wire:ignore data-translate="authentication.enterGamePassword"
                                placeholder="Enter your game password (minimum 6 characters)"
                                required />
                        </div>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['sro_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-red-500 text-sm mt-1"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!-- Confirm Password Field -->
                    <div class="form-group">
                        <label class="form-label" wire:ignore data-translate="authentication.confirmPassword">Confirm Password</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 ltr:left-0 rtl:right-0 ltr:pl-3 rtl:pr-3 flex items-center pointer-events-none">
                                <i class="fas fa-lock text-gray-400"></i>
                            </div>
                            <input wire:model="sro_password_confirmation" type="password" autocomplete="new-password"
                                class="glass-input w-full ltr:pl-10 rtl:pr-10 ltr:pr-4 rtl:pl-4 <?php $__errorArgs = ['sro_password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                wire:ignore data-translate="authentication.confirmYourPassword"
                                placeholder="Confirm your password"
                                required />
                        </div>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['sro_password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-red-500 text-sm mt-1"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!-- Terms and Conditions -->
                    <div class="form-group">
                        <div class="flex items-center text-sm">
                            <input wire:model="terms" type="checkbox" class="mr-2 rtl:mr-0 rtl:ml-2" required />
                            <span class="text-gray-300">
                                <span wire:ignore data-translate="authentication.agreeToTerms">I agree to the</span>
                                <a href="#" class="text-purple-400 hover:text-blue-400 underline" wire:ignore data-translate="authentication.termsAndConditions">Terms and Conditions</a>
                            </span>
                        </div>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['terms'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-red-500 text-sm mt-1"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!-- Submit Button -->
                    <button type="submit" wire:loading.attr="disabled"
                        class="glass-button">
                        <span wire:loading.remove class="flex items-center space-x-2 rtl:space-x-reverse">
                            <i class="fas fa-user-plus"></i>
                            <span wire:ignore data-translate="authentication.createAccount">Create Account</span>
                        </span>
                        <span wire:loading class="flex items-center justify-center space-x-2 rtl:space-x-reverse">
                            <i class="fas fa-spinner fa-spin"></i>
                            <span wire:ignore data-translate="authentication.creating">Creating...</span>
                        </span>
                    </button>
                </form>



                <!-- Footer -->
                <div class="form-footer">
                    <span class="inline-flex items-center space-x-1 rtl:space-x-reverse">
                        <span wire:ignore data-translate="authentication.alreadyHaveAccount">
                            Already have an account?
                        </span>
                        <button type="button"
                            @click="if(preventDoubleSwitch()) $wire.switchToLogin()"
                            :disabled="switching"
                            class="text-purple-400 hover:text-blue-400 ltr:ml-1 rtl:mr-1 transition-all duration-200 bg-transparent border-none cursor-pointer disabled:opacity-50 font-medium hover:underline transform hover:scale-105"
                            data-en="Sign in" data-ar="تسجيل الدخول" data-translate="authentication.signIn">
                            <span x-text="switching ? (window.getTranslation ? window.getTranslation('authentication.switching') : 'Switching...') : (window.getTranslation ? window.getTranslation('authentication.signIn') : 'Sign in')"
                                x-bind:data-switching-text="switching ? (window.getTranslation ? window.getTranslation('authentication.switching') : 'Switching...') : ''"
                                data-translate="authentication.switching"></span>
                        </button>
                    </span>
                </div>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('livewire:init', () => {
    // Before submit ensure Livewire lang is set from savedLang (localStorage or server-provided)
    document.addEventListener('submit', (e) => {
        const form = e.target.closest('form[wire\\:submit]');
        if (form) {
            const savedLang = localStorage.getItem('preferred-language') || (window.languageConfig && window.languageConfig.currentLanguage) || 'en';
            try {
                const el = form.querySelector('#livewire-register-lang');
                if (el) el.value = savedLang;
                if (window.Livewire && el) {
                    const compEl = el.closest('[wire\\:id]');
                    if (compEl) {
                        const lw = Livewire.find(compEl.getAttribute('wire:id'));
                        lw && lw.set && lw.set('lang', savedLang);
                    }
                }
            } catch (err) {}
        }
    });

    // Handle notification translation using languageManager as fallback; keep UI notifications
    Livewire.on('show-notification', (event) => {
        const data = event.detail || event;
        let message = data.message || '';
        if (message && window.languageManager) {
            try {
                if (message.includes('.')) {
                    message = window.languageManager.getTranslation(message);
                    if (data.params) {
                        Object.entries(data.params).forEach(([k, v]) => {
                            message = message.replace(`[${k}]`, v);
                        });
                    }
                }
            } catch (err) {}
        }

        showNotification(data.type, message, data.duration || 5000);
    });
});

// Notification function (unchanged)
function showNotification(type, message, duration = 5000) {
    const notification = document.createElement('div');
    notification.className = `fixed top-4 right-4 p-4 rounded-lg shadow-lg z-50 max-w-sm ${
        type === 'error' ? 'bg-red-600' : 'bg-green-600'
    } text-white transform translate-x-full transition-transform duration-300`;

    notification.innerHTML = `
        <div class="flex justify-between items-start">
            <div>
                <p class="text-sm">${message}</p>
            </div>
            <button onclick="this.parentElement.parentElement.remove()" class="ml-2 text-white hover:text-gray-200">
                <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                </svg>
            </button>
        </div>
    `;

    document.body.appendChild(notification);

    // Animate in
    setTimeout(() => {
        notification.classList.remove('translate-x-full');
    }, 100);

    // Auto remove
    setTimeout(() => {
        notification.classList.add('translate-x-full');
        setTimeout(() => {
            if (notification.parentElement) {
                notification.remove();
            }
        }, 300);
    }, duration);
}

// Backup: nothing relying on languageManager in this file anymore
</script>
<?php $__env->stopPush(); ?><?php /**PATH C:\laragon\www\4TresSro-PVE\resources\views\livewire/auth/register.blade.php ENDPATH**/ ?>