<?php

use Illuminate\Support\Facades\Route;
use Livewire\Volt\Volt;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\Api\ItemDetailsController;
use App\Http\Controllers\PostbackController;
use Illuminate\Support\Facades\Auth;

Route::get('/', function () {
    return view('pages.frontend.welcome');
})->name('home');

Route::get('news/{id?}', function ($id = null) {
    return view('pages.frontend.news');
})->name('news');

Route::get('download', function () {
    return view('pages.frontend.download');
})->name('download');

Route::get('game-info', function () {
    return view('pages.frontend.game-info');
})->name('game-info');

Route::get('about-game', function () {
    return view('pages.frontend.about-game');
})->name('about-game');

Route::get('rank', function () {
    return view('pages.frontend.rank');
})->name('rank');



// Inventory Routes
Route::prefix('inventory')->name('inventory.')->group(function () {
    Route::get('/character/{charId}', [InventoryController::class, 'show'])->name('show');
    Route::get('/api/equipment/{charId}', [InventoryController::class, 'getEquipment'])->name('api.equipment');
    Route::get('/api/inventory/{charId}', [InventoryController::class, 'getInventory'])->name('api.inventory');
});

// Test Routes
Route::prefix('test')->name('test.')->group(function () {
    Route::get('/inventory', [\App\Http\Controllers\TestInventoryController::class, 'test'])->name('inventory');
    Route::get('/inventory/api/{charId?}', [\App\Http\Controllers\TestInventoryController::class, 'testApi'])->name('inventory.api');
});

// Item Details API Routes (temporary in web.php for testing)
Route::get('/api/item-details/{itemId}', [ItemDetailsController::class, 'getItemDetails'])->name('api.item-details');
Route::get('/api/item/details/{itemId}', [ItemDetailsController::class, 'getItemDetails'])->name('api.item.details');
Route::get('/api/item/details-json/{itemId}', [ItemDetailsController::class, 'getItemDetailsJson'])->name('api.item.details.json');

// Debug route to test database connection
Route::get('/api/debug-item/{itemId}', function ($itemId) {
    try {
        $item = \App\Models\SRO_VT_SHARD\RefObjCommon::find($itemId);
        if ($item) {
            return response()->json([
                'found' => true,
                'id' => $item->ID,
                'name' => $item->ObjName128,
                'code_name' => $item->CodeName128
            ]);
        } else {
            return response()->json(['found' => false, 'message' => 'Item not found']);
        }
    } catch (\Exception $e) {
        return response()->json(['error' => $e->getMessage()], 500);
    }
})->name('api.debug-item');

Route::get('about', function () {
    return view('welcome'); // Temporary view for testing
})->name('about');

Route::get('shop', function () {
    return view('welcome'); // Temporary view for testing
})->name('shop');

Route::get('community', function () {
    return view('welcome'); // Temporary view for testing
})->name('community');

Route::get('support', function () {
    return view('welcome'); // Temporary view for testing
})->name('support');

Route::get('guides', function () {
    return view('welcome'); // Temporary view for testing
})->name('guides');

Route::get('gallery', function () {
    return view('welcome'); // Temporary view for testing
})->name('gallery');

Route::get('test-active-styles', function () {
    return view('test-active-styles');
})->name('test.active.styles');

Route::get('debug-active', function () {
    return view('debug-active');
})->name('debug.active');

Route::post('/logout', function () {
    session()->forget('user');
    session()->regenerate();
    return redirect()->route('home');
})->name('logout');

Route::view('dashboard', 'pages.backend.dashboard')
    ->middleware([App\Http\Middleware\EnsureUserIsAuthenticated::class])
    ->name('dashboard');

Route::middleware([App\Http\Middleware\EnsureUserIsAuthenticated::class])->group(function () {
    Route::redirect('settings', 'settings/profile');

    Volt::route('settings/profile', 'settings.profile')->name('settings.profile');
    Volt::route('settings/password', 'settings.password')->name('settings.password');
    Volt::route('settings/appearance', 'settings.appearance')->name('settings.appearance');

    // 4T-App System Route
    Volt::route('4t-app', 'backend.pages.4t-app')->name('4t-app');

    // Market Logs Route
    Volt::route('market-logs', 'backend.pages.market-logs')->name('market-logs');

    // Rewards Systems Route (for testing)
    Volt::route('rewards-systems', 'backend.pages.rewards-systems')->name('rewards-systems');

    // Welcome Event Route
    Volt::route('welcome-event', 'welcome')->name('welcome-event');

    // Team Dashboard Route (Role Level 3+)
    Route::get('team-dashboard', function () {
        $user = Auth::user();

        // Check if user has required role level (3 or higher)
        if (!$user || !$user->hasRoleLevel(3)) {
            return redirect()->route('home')->with('error', 'Access denied. Insufficient privileges.');
        }

        return view('pages.backend.team.team-dashboard');
    })->name('team-dashboard');

    // Fast Event Welcome Management Route (Role Level 3+)
    Route::get('team-fast-event-welcome', function () {
        $user = Auth::user();

        // Check if user has required role level (3 or higher)
        if (!$user || !$user->hasRoleLevel(3)) {
            return redirect()->route('home')->with('error', 'Access denied. Insufficient privileges.');
        }

        return view('pages.backend.team.team-fast-event-welcome');
    })->name('team-fast-event-welcome');

    // Fast Event Treasure Management Route (Role Level 3+)
    Route::get('team-fast-event-treasure', function () {
        $user = Auth::user();

        // Check if user has required role level (3 or higher)
        if (!$user || !$user->hasRoleLevel(3)) {
            return redirect()->route('home')->with('error', 'Access denied. Insufficient privileges.');
        }

        return view('pages.backend.team.team-fast-event-treasure');
    })->name('team-fast-event-treasure');

    // Fast Event Duo Management Route (Role Level 3+)
    Route::get('team-fast-event-duo', function () {
        $user = Auth::user();

        // Check if user has required role level (3 or higher)
        if (!$user || !$user->hasRoleLevel(3)) {
            return redirect()->route('home')->with('error', 'Access denied. Insufficient privileges.');
        }

        return view('pages.backend.team.team-fast-event-duo');
    })->name('team-fast-event-duo');
});



// Language update endpoint served via web middleware so session/auth are available
Route::post('/api/language/update', [\App\Http\Controllers\Api\LanguageController::class, 'updateLanguage'])
    ->name('api.language.update');

// Vote postback handler - accepts both GET and POST from voting sites
Route::match(['get', 'post'], '/postback-handler/{website}/{username?}', [PostbackController::class, 'handlePostback'])
    ->name('vote.postback');

require __DIR__ . '/auth.php';
