<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\LanguageController;
use App\Http\Controllers\Api\ItemDetailsController;
use App\Http\Controllers\Api\InventoryTooltipController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Language Management Routes
Route::prefix('language')->group(function () {
    Route::get('/data', [LanguageController::class, 'getLanguageData'])->name('api.language.data');
    Route::post('/update', [LanguageController::class, 'updateLanguage'])->name('api.language.update');
});

// Item Details Routes
Route::prefix('item')->group(function () {
    Route::get('/details/{itemId}', [ItemDetailsController::class, 'getItemDetails'])->name('api.item.details');
    Route::get('/details-json/{itemId}', [ItemDetailsController::class, 'getItemDetailsJson'])->name('api.item.details.json');
    Route::get('/search', [ItemDetailsController::class, 'searchItems'])->name('api.item.search');
});

// Alternative route for direct access
Route::get('/item-details/{itemId}', [ItemDetailsController::class, 'getItemDetails'])->name('api.item-details');

// Enhanced Inventory Tooltip Routes (Using InventoryService)
Route::prefix('inventory')->group(function () {
    Route::get('/tooltip/{itemId}', [InventoryTooltipController::class, 'getItemDetails'])->name('api.inventory.tooltip');
    Route::get('/item-serial/{serial64}', [InventoryTooltipController::class, 'getItemBySerial'])->name('api.inventory.serial');
});


