<x-layouts.struct.struct :title="__('backend.department_name') . ' | Game Info & Guides'" :maxWidth="'7xl'">

<livewire:frontend.about-game />

@push('scripts')
    <script src="{{ asset('js/game-info-videos.js') }}"></script>
    <script>
        // Initialize video monitoring for about game page
        document.addEventListener('DOMContentLoaded', function() {
            if (typeof monitorYouTubeIframes === 'function') {
                monitorYouTubeIframes();
            }
        });

        // Notification system
        document.addEventListener('livewire:initialized', () => {
            Livewire.on('notify', (message) => {
                // Create notification element
                const notification = document.createElement('div');
                notification.className = 'fixed top-4 right-4 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg z-50 transform translate-x-full transition-transform duration-300';
                notification.textContent = message;
                document.body.appendChild(notification);

                // Show notification
                setTimeout(() => {
                    notification.classList.remove('translate-x-full');
                }, 100);

                // Hide and remove notification
                setTimeout(() => {
                    notification.classList.add('translate-x-full');
                    setTimeout(() => {
                        document.body.removeChild(notification);
                    }, 300);
                }, 3000);
            });
        });

        // Image lightbox functionality
        document.addEventListener('click', function(e) {
            if (e.target.closest('.about-game-image-overlay')) {
                const img = e.target.closest('.about-game-image-container').querySelector('.about-game-image');
                if (img) {
                    const lightbox = document.createElement('div');
                    lightbox.className = 'fixed inset-0 bg-black/80 flex items-center justify-center z-50 cursor-pointer';
                    lightbox.innerHTML = `
                        <div class="max-w-4xl max-h-full p-4">
                            <img src="${img.src}" alt="${img.alt}" class="max-w-full max-h-full object-contain rounded-lg shadow-2xl">
                        </div>
                        <button class="absolute top-4 right-4 text-white text-2xl hover:text-gray-300">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <line x1="18" y1="6" x2="6" y2="18"/>
                                <line x1="6" y1="6" x2="18" y2="18"/>
                            </svg>
                        </button>
                    `;

                    lightbox.addEventListener('click', function() {
                        document.body.removeChild(lightbox);
                    });

                    document.body.appendChild(lightbox);
                }
            }
        });
    </script>
@endpush


</x-layouts.struct.struct>


